var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailType } from '../../../../core/enums/global-enum';
import { BasketItemDto } from '../../../../core/models/basket/basket-itemDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
let TicketAttachToEmailComponent = class TicketAttachToEmailComponent extends BaseDialogComponent {
    constructor(cacheManager, dialogManager, sessionManager, documentService, downloadService, data, translateService, dialogRef) {
        super();
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.documentService = documentService;
        this.downloadService = downloadService;
        this.data = data;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.selectedDocument = null;
        this.contactMomentState = null;
        this.relatedResultList = [];
        this.title = this.translateService.instant("LBL_ATTACH_TO_EMAIL").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET").toLowerCase());
        this.subs = new SubSink();
        this.relatedResultFound = this.relatedResultFound.bind(this);
        this.downloadFileDocumentReponse = this.downloadFileDocumentReponse.bind(this);
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 300);
        this.relatedResultList["TICKET"] = [];
        this.relatedResultList["TICKET"].push(jQuery.extend(true, {}, this.sessionManager.selectedEntity));
        if (this.cacheManager.relatedResultList["CONTACTMOMENT"] != null)
            this.relatedResultList["CONTACTMOMENT"] = jQuery.extend(true, {}, this.cacheManager.relatedResultList["CONTACTMOMENT"]);
        if (this.cacheManager.relatedResultList["DOCUMENT"] != null)
            this.relatedResultList["DOCUMENT"] = jQuery.extend(true, {}, this.cacheManager.relatedResultList["DOCUMENT"]);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    process() {
        let basketItems = [];
        if (this.relatedResultList["TICKET"] != null) {
            this.relatedResultList["TICKET"].forEach(ticket => {
                if (ticket.IsMarked) {
                    let basketItemDto = new BasketItemDto();
                    basketItemDto.Type = EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket;
                    basketItemDto.Item = ticket;
                    basketItems.push(basketItemDto);
                }
            });
        }
        if (this.relatedResultList["CONTACTMOMENT"] != null) {
            let basketItemDto = new BasketItemDto();
            basketItemDto.Type = EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactMoment;
            this.relatedResultList["CONTACTMOMENT"].forEach(contactMoment => {
                if (contactMoment.IsMarked) {
                    basketItemDto.Item = contactMoment;
                    basketItemDto.ItemList.push(contactMoment);
                }
            });
            if (basketItemDto.ItemList.length > 0)
                basketItems.push(basketItemDto);
        }
        if (this.relatedResultList["DOCUMENT"] != null) {
            this.relatedResultList["DOCUMENT"].forEach(document => {
                if (document.IsMarked && document.Files != null && document.Files.length > 0) {
                    document.Files.forEach(fileDocument => {
                        if (fileDocument.IsMarked) {
                            let basketItemDto = new BasketItemDto();
                            basketItemDto.Type = EntityFqdn.Decos_Kcs_Documents_Entities_FileDocument;
                            basketItemDto.Item = fileDocument;
                            basketItems.push(basketItemDto);
                        }
                    });
                }
            });
        }
        basketItems = this.sessionManager.getMarkedItems(basketItems);
        this.dialogManager.openEmailBasket(this.data.viewContainerRef, null, EmailType.Send, basketItems);
        this.close();
    }
    ;
    downloadFileDocumentReponse(message) {
        this.stopSpinner();
        if (message != null && !GlobalFunctions.isEmpty(message.TicketId))
            this.subs.sink = this.downloadService.downloadFile(message.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
    }
    ;
    downloadFileDocument(file) {
        if (file.IsExist) {
            this.documentService.downloadFileDocument(file, this.downloadFileDocumentReponse);
            this.startSpinner();
        }
    }
    ;
    selectAll(relatedType, state) {
        if (this.relatedResultList[relatedType] != null)
            this.relatedResultList[relatedType].forEach(relatedItem => relatedItem.IsMarked = state);
    }
    ;
    relatedResultFound(result, contentType, title) {
        this.selectedDocument.Files = result;
        if (this.selectedDocument.Files != null && this.selectedDocument.Files.length > 0)
            this.selectedDocument.Files.forEach(file => file.IsMarked = true);
        this.stopSpinner();
    }
    ;
    relatedFile(document) {
        this.selectedDocument = document;
        if (document.IsMarked && (document.Files == null || document.Files == undefined || document.Files.length == 0)) {
            this.documentService.setFileRelatedResultCallback(this.relatedResultFound, GlobalFunctions.createGuid());
            this.documentService.sendRelatedRequest(document);
            this.startSpinner();
        }
    }
    close() {
        this.dialogRef.close();
    }
    ;
    resize() {
        const windowHeight = $(window).height();
        const newHeight = windowHeight - $("#attachToEmailHeader").height() - $("#attachToEmailFooter").height() - 150 + "px";
        $("#attachToEmailContainer").height(newHeight);
    }
    ;
};
TicketAttachToEmailComponent = __decorate([
    Component({
        selector: 'ticket-attach-to-email',
        templateUrl: './ticket-attach-to-email.component.html',
        styleUrls: ['./ticket-attach-to-email.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(5, Inject(MAT_DIALOG_DATA))
], TicketAttachToEmailComponent);
export { TicketAttachToEmailComponent };
//# sourceMappingURL=ticket-attach-to-email.component.js.map