var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { debounceTime } from 'rxjs';
import { SubSink } from 'subsink';
import { DefaultState, FieldDataType, FieldGroupLayout, OperationType, RecordOperationMode, RecordSelection, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailSource } from '../../../../core/enums/global-enum';
import { MainEntityType, TaskHandlerType } from '../../../../core/enums/task-enum';
import { ContentType, JsonDtoType } from '../../../../core/models/jkc-object/jkc-object';
import { CreateOrganizationRequest } from '../../../../core/models/organization/create-organization-request';
import { OrganizationDto } from '../../../../core/models/organization/organizationDto';
import { CreateOrUpdatePersonRequest } from '../../../../core/models/person/create-update-person-request';
import { PersonDto } from '../../../../core/models/person/personDto';
import { BulkHandleTaskRequest } from '../../../../core/models/task/bulk-handle-task-request';
import { ThirdPartyDto } from '../../../../core/models/ticket/third-partDto';
import { ThirdPartyContactDto } from '../../../../core/models/ticket/third-party-contactDto';
import { TicketFieldDataDto } from '../../../../core/models/ticket/ticket-field-dataDto';
import { TicketRelatedEntityDto } from '../../../../core/models/ticket/ticket-related-entityDto';
import { BroadCastEventKeys, RoutePath, SideMenuItem } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
import { JkcPanel } from '../../../../shared/helper/jkc-panel-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
import { OrganizationAddEditComponent } from '../../organization/add-edit/organization-add-edit.component';
import { RepresentativeAddComponent } from "../../organization/add-representative/organization-add-representative.component";
import { PersonAddEditComponent } from '../../person/add-edit/person-add-edit.component';
let TicketAddEditComponent = class TicketAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, ruleService, taskService, cacheManager, dialogManager, eventProvider, personService, ticketService, sessionManager, shortcutManager, viewContainerRef, translateService, organizationService, applicationSettingManager, integrationSettingManager, personFormattedAddressWithLabelPipe, organizationFormattedAddressWithLabelPipe, renderer, datePipe, dateAdapter, cdr) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.ruleService = ruleService;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.ticketService = ticketService;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.viewContainerRef = viewContainerRef;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.personFormattedAddressWithLabelPipe = personFormattedAddressWithLabelPipe;
        this.organizationFormattedAddressWithLabelPipe = organizationFormattedAddressWithLabelPipe;
        this.renderer = renderer;
        this.datePipe = datePipe;
        this.dateAdapter = dateAdapter;
        this.cdr = cdr;
        // Common fields
        this.priorityTitle = 'prioriteit';
        this.priorityField = null;
        this.statusTitle = 'status';
        this.thirdPartyTitle = 'derde partij';
        this.statusField = null;
        this.fieldDataTypeEnum = FieldDataType;
        this.fieldGroupLayoutEnum = FieldGroupLayout;
        this.customerDataType = FieldDataType.Person;
        this.showMandatoryField = false;
        this.isAllowedManualEntry = false;
        this.rights = {
            organization: false,
            person: false
        };
        this.selectedRow = null;
        this.selectedFindFrom = { option: "SelectAny" };
        this.searchEntityObject = { searchEntityTags: [] };
        this.representativeList = [];
        this.contactNumberCheck = false;
        this.contactEmailCheck = false;
        this.mainEntityObject = null;
        this.confidentialityLevel = 0;
        this.selectedRepresentativeObject = { Value: null };
        // Third party fields
        this.currentThirdPartyType = { option: "None" };
        this.thirdPartyContactNumberCheck = false;
        this.thirdPartyConfidentialityLevel = 0;
        this.thirdPartySection = { isCollapsed: false };
        this.thirdPartyContactSection = { isCollapsed: false };
        this.selectedThirdPartyForEdit = null;
        this.selectedThirdPartyContactForEdit = null;
        this.selectedThirdParty = null;
        this.selectedContacts = [];
        // Handler fields
        this.currentHandlerType = { option: "Employee" };
        this.currentHandlerName = '';
        this.handlerTypeOption = null;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.timeoutIds = [];
        this.intervalIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.subs = new SubSink();
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.bulkHandleTaskResponse = this.bulkHandleTaskResponse.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.fetchPersonDetailResponse = this.fetchPersonDetailResponse.bind(this);
        this.fillThirdPartyRepresentatives = this.fillThirdPartyRepresentatives.bind(this);
        this.addThirdPartyPersonResponse = this.addThirdPartyOrganizationResponse.bind(this);
        this.addThirdPartyOrganizationResponse = this.addThirdPartyOrganizationResponse.bind(this);
        this.redirectToEditScreenAfterResponse = this.redirectToEditScreenAfterResponse.bind(this);
        this.createOrUpdateTicketResponseHandler = this.createOrUpdateTicketResponseHandler.bind(this);
        this.registerNewThirdPartyPersonResponse = this.registerNewThirdPartyPersonResponse.bind(this);
        this.registerNewThirdPartyOrganizationResponse = this.registerNewThirdPartyOrganizationResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        try {
            this.setRights();
            this.sessionManager.startSessionIfPossible("TICKET", this.sessionManager.jkcParentPanel?.parameters?.EntityObject?.TicketType ? ScreenMode.Edit : ScreenMode.Add);
            this.isAllowedManualEntry = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "ALLOWMANUALENTRY").toLowerCase() == "true";
            this.ticket = this.sessionManager.jkcParentPanel.parameters.EntityObject;
            this.ticketType = this.sessionManager.jkcParentPanel.parameters.EntitySubType;
            this.editedTicketData = this.sessionManager.jkcParentPanel.parameters.EditedData;
            this.sessionManager.jkcParentPanel.parameters.Scope = this;
            this.ticketDto = jQuery.extend(true, {}, this.ticket);
            this.isNewTicket = this.editedTicketData != null ? GlobalFunctions.isEmpty(this.editedTicketData.Id) : !this.ticketDto.TicketType;
            this.ticketDto.TicketType = jQuery.extend(true, {}, this.ticketType);
            this.title = this.ticketDto.TicketType.Title;
            this.ticketDto.TicketTypeId = this.ticketDto.TicketType.Id;
            this.klantGroup = jlinq.from(this.ticketType.FieldGroups).equals("Description", "Klant").first();
            if (this.klantGroup != null && this.klantGroup.Fields != null && this.klantGroup.Fields.length > 0) {
                this.customerDataType = this.klantGroup.Fields[0].DataType;
                if (this.customerDataType == FieldDataType.PersonAndOrganization) {
                    if (this.isNewTicket)
                        this.currentCustomerType = this.klantGroup.Fields[0].DataTypeRule == "2" ? 'Organization' : 'Person';
                    else
                        this.currentCustomerType = this.ticket.MainEntityType == 1 ? 'Person' : 'Organization';
                }
                else
                    this.currentCustomerType = this.customerDataType == FieldDataType.Person ? 'Person' : 'Organization';
            }
            this.ruleService.setHandlerCallback = this.setHandler;
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            this.displayNumberOnUI(null, null);
            if (this.isNewTicket) {
                this.selectOptionsFromFindList();
                this.setDetailFromSocialMedia();
                this.setDetailFromEmail();
                this.initializeTicket();
                if (this.editedTicketData != null)
                    this.updateTicketDetailsfromSavedSession();
                if (this.currentHandlerType.option == "Employee")
                    this.setHandler(GlobalFunctions.getLoggedInUserId(), "Employee");
            }
            else {
                this.initializeEditTicket();
                if (this.editedTicketData != null)
                    this.updateTicketDetailsfromSavedSession();
            }
            this.registerDialogShortcutKey();
            document.getElementById('customerQuestionField')?.focus();
            this.timeoutIds.push(setTimeout(() => {
                const inputElement = document.querySelector('.datePicker');
                if (inputElement && GlobalFunctions.validDate(new Date())) {
                    this.formattedDate = this.datePipe.transform(new Date(), this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                    inputElement.value = GlobalFunctions.removeDotAfterMonth(this.formattedDate);
                }
            }));
            this.setHandlerTags();
        }
        catch (e) {
            console.log(e);
        }
    }
    ngAfterViewInit() {
        // Watch form changes after load; debounce for 300ms before updating rules.
        this.valueChangesSub = this.form.form.valueChanges.pipe(debounceTime(300)).subscribe(() => {
            this.updateRules();
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
        this.intervalIds.forEach(intervalId => clearInterval(intervalId));
        if (this.valueChangesSub)
            this.valueChangesSub.unsubscribe();
    }
    setRights() {
        this.rights.organization = GlobalFunctions.checkRights('Organization', 3);
        this.rights.person = GlobalFunctions.checkRights('Person', 3);
    }
    initDatePickerState() {
        JkcDatePickerHelper.setMargin('133px', '-45px', '', this.renderer);
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        GlobalFunctions.setDateFormat("Ontvangen", this.formattedDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
    ticketDOBChange(event, inputId) {
        GlobalFunctions.setDateFormat(inputId, event.target.value, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    updateRules() {
        try {
            this.resetFieldListEntriesVisibility();
            this.ruleService.evaluateRules(this.ticketDto, this.ticketDto.TicketType.Rules);
            this.alignFieldGroups();
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType.option) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    ;
    createOrUpdateTicketResponseHandler(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TICKET_STATISTIC);
        if (response?.Result == 0 && response?.Ticket != null) {
            if (!GlobalFunctions.isEmpty(response.EntityId) && this.sessionManager.selectedEntity != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn) && GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn)) == ContentType.Email) {
                this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
                this.sessionManager.selectedEntity.Id = response.EntityId;
                if (this.sessionManager.selectedEntity.Header != null) {
                    this.sessionManager.selectedEntity.Header.Id = response.EntityId;
                    this.sessionManager.selectedEntity.Header.EmailSource = EmailSource[EmailSource.Archive];
                }
                this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), true);
            }
            this.close(false);
            let ticketDetailUrl = `/${RoutePath.DETAIL_PATH}/ticket/${response.Ticket.Id}`;
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = response.Ticket;
            this.sessionManager.selectedEntity.locationUrl = ticketDetailUrl;
            this.sessionManager.selectedEntity.Partial = true;
            this.sessionManager.addBreadcrumbItems([response.Ticket], null, RoutePath.DETAIL_PATH);
            if (this.router.url === ticketDetailUrl)
                this.timeoutIds.push(setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL), 300));
            else
                this.router.navigate([ticketDetailUrl]);
            if (!GlobalFunctions.isEmpty(this.mainEntityObject))
                this.sessionManager.addEntityToSession(this.mainEntityObject, this.ticketDto.MainEntityType);
            this.sessionManager.addEntityToSession(this.sessionManager.selectedEntity, "Ticket");
        }
        else {
            if (response.Result == 2) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant("LBL_TICKET_EXISTS_MESSAGE") });
                this.stopSpinner();
            }
        }
    }
    ;
    fieldTypeListOnChange(field) {
        $('[name="' + field.Title.replace(/[\s]/g, '') + '"]').removeClass('error');
        if (field != null && field.System && field.Title.toLowerCase() == this.statusTitle)
            this.validateTicketStatus();
    }
    loadFieldListItems(query, field) {
        let items = [];
        if (field.FieldList && !GlobalFunctions.isEmpty(field.FieldList.Entries)) {
            let entryList = field.FieldList.Entries;
            for (let i = 0; i < entryList.length; i++) {
                if (GlobalFunctions.isEmpty(entryList[i].text))
                    entryList[i].text = entryList[i].Title;
                if (entryList[i].Visible && entryList[i].text.toLowerCase().indexOf(query.toLowerCase()) > -1)
                    items.push(entryList[i]);
            }
        }
        return items;
    }
    ;
    changeRepresentative() {
        if (GlobalFunctions.isEmpty(this.selectedRepresentativeObject.Value))
            return;
        if (this.selectedRepresentativeObject.Value.value?.toUpperCase() == "NEW") {
            if (this.currentCustomerType == "Organization") {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.ticketDto.MainEntityId, editMode: false }).afterClosed().subscribe(representative => {
                    if (!GlobalFunctions.isEmpty(representative)) {
                        this.relatedRepresentatives([representative]);
                        this.selectedRepresentativeObject.Value = representative;
                        this.registerDialogShortcutKey();
                    }
                });
            }
        }
        else {
            this.displayNumberOnUI(this.selectedRepresentativeObject.Value.PhoneNumber, this.selectedRepresentativeObject.Value.MobileNumber);
            this.ticketDto.ContactPerson = this.selectedRepresentativeObject.Value.StringRepresentation;
        }
        this.ticketDto.RepresentativeName = !GlobalFunctions.isEmpty(this.selectedRepresentativeObject.Value.StringRepresentation) ? this.selectedRepresentativeObject.Value.StringRepresentation : (this.isNewTicket ? '' : this.ticketDto.RepresentativeName);
        this.ticketDto.RepresentativeContactEmail = !GlobalFunctions.isEmpty(this.selectedRepresentativeObject.Value.EmailAddress) ? this.selectedRepresentativeObject.Value.EmailAddress : (this.isNewTicket ? '' : this.ticketDto.RepresentativeContactEmail);
        this.ticketDto.RepresentativeContactPhoneNumber = !GlobalFunctions.isEmpty(this.selectedRepresentativeObject.Value.PhoneNumber) ? this.selectedRepresentativeObject.Value.PhoneNumber : (this.isNewTicket ? '' : this.ticketDto.RepresentativeContactPhoneNumber);
        this.ticketDto.RepresentativeContactMobileNumber = !GlobalFunctions.isEmpty(this.selectedRepresentativeObject.Value.MobileNumber) ? this.selectedRepresentativeObject.Value.MobileNumber : (this.isNewTicket ? '' : this.ticketDto.RepresentativeContactMobileNumber);
    }
    ;
    displayNumberOnUI(phoneNumber, mobileNumber) {
        if (!GlobalFunctions.isEmpty(phoneNumber) && GlobalFunctions.isEmpty(this.ticketDto.ContactPhoneNumber))
            this.ticketDto.ContactPhoneNumber = $.trim(phoneNumber);
        else if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && !GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId))
            this.ticketDto.ContactPhoneNumber = this.sessionManager.currentCallerId;
        if (!GlobalFunctions.isEmpty(mobileNumber) && GlobalFunctions.isEmpty(this.ticketDto.ContactMobileNumber))
            this.ticketDto.ContactMobileNumber = $.trim(mobileNumber);
        else if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId))
            this.ticketDto.ContactMobileNumber = this.sessionManager.currentCallerId;
    }
    ;
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representativeList.push(result[i]);
                }
                if (result.length == 1)
                    this.selectedRepresentativeObject.Value = this.representativeList[this.representativeList.length - 1];
            }
            this.changeRepresentative();
        }
    }
    ;
    addDefaultRepresentative() {
        this.representativeList.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    ;
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        if (personEntity.ConfidentialityLevel != 0)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (!result && this.searchEntityObject.searchEntityTags.length > 0)
                    this.personTagRemoved(this.searchEntityObject.searchEntityTags[0]);
                document.getElementById('findFromSelectOption')?.focus();
            });
    }
    ;
    showPersonClassifiedWarning(personEntity) {
        if (personEntity.ConfidentialityLevel == 0)
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (!result && this.searchEntityObject.searchEntityTags.length > 0)
                this.personTagRemoved(this.searchEntityObject.searchEntityTags[0]);
            document.getElementById('findFromSelectOption')?.focus();
        });
    }
    ;
    setDetailFromSocialMedia() {
        if (GlobalFunctions.isEmpty(this.ticketDto.CustomerName) && GlobalFunctions.isEmpty(this.ticketDto.Description) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.ObjectSource) && this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("socialmedia") > -1) {
            let socialMediaDto = this.sessionManager.selectedEntity;
            this.ticketDto.CustomerName = socialMediaDto.User.Name;
            this.ticketDto.ReceivedDate = new Date(socialMediaDto.MessageHistoryList[0].DateTime);
            this.ticketDto.Description = socialMediaDto.Message.Message;
        }
    }
    ;
    setDetailFromEmail() {
        if (GlobalFunctions.isEmpty(this.ticketDto.Description)) {
            let result = GlobalFunctions.getLastEmailFromSession(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result) && !GlobalFunctions.isEmpty(result.Header)) {
                if (GlobalFunctions.isEmpty(this.ticketDto.ContactEmail))
                    this.ticketDto.ContactEmail = result.Header.From;
                this.ticketDto.ReceivedDate = new Date(result.Header.Date);
                this.ticketDto.Description = result.Body.PlainTextBody;
                this.ticketDto.Description = this.ticketDto.Description.trim();
            }
        }
    }
    ;
    fetchPersonDetailResponse(result) {
        this.stopSpinner();
        this.mainEntityObject = result;
        this.displayNumberOnUI(result.PhoneNumber, result.MobileNumber);
    }
    ;
    assignEmail(searchEntity, relationshipType) {
        let email = "";
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            if (GlobalFunctions.isSessionContainsEmailRecord(cachedEntities)) {
                let emailObject = GlobalFunctions.getFirstEmailFromSession(cachedEntities);
                email = !GlobalFunctions.isEmpty(emailObject.Header) ? emailObject.Header.From : "";
            }
        }
        if (!GlobalFunctions.isEmpty(searchEntity) && !GlobalFunctions.isEmpty(searchEntity.EmailAddress) && (relationshipType == "Person" || relationshipType == "Organization"))
            email = searchEntity.EmailAddress;
        return email;
    }
    fetchPersonDetail(entity) {
        let partialDto = new Object();
        partialDto.Id = entity.Id;
        partialDto.ObjectSource = entity.ObjectSource;
        this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
    }
    ;
    setMainEntity(searchEntity, relationshipType) {
        this.representativeList.length = 0;
        if (relationshipType == "")
            relationshipType = this.currentCustomerType;
        let selectedEntityName = "";
        this.searchEntityObject.searchEntityTags = [];
        let searchEntitySelected = [];
        if (searchEntity != null) {
            document.getElementById('divContactAddress')?.setAttribute("readonly", "true");
            if (relationshipType == 'Person') {
                if (searchEntity.Partial == true && GlobalFunctions.isEmpty(searchEntity.PhoneNumber)) {
                    this.startSpinner();
                    this.fetchPersonDetail(searchEntity);
                }
                if (!GlobalFunctions.isEmpty(searchEntity.Details) && GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                else if (!GlobalFunctions.isEmpty(searchEntity.ConfidentialityLevel) && searchEntity.ConfidentialityLevel != 0)
                    this.showPersonClassifiedWarning(searchEntity);
                let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
                if (!GlobalFunctions.isEmpty(searchEntity.Details) && !GlobalFunctions.isEmpty(getGrammerValue)) {
                    GlobalFunctions.setStringPresentation(searchEntity, getGrammerValue);
                    selectedEntityName = searchEntity.StringRepresentation;
                    if (!GlobalFunctions.isEmpty(searchEntity.Details.FormalName) && !GlobalFunctions.isEmpty(searchEntity.Details.FormalName.Gender)) {
                        if (searchEntity.Details.FormalName.Gender === 0)
                            selectedEntityName = this.translateService.instant("LBL_MR") + " " + selectedEntityName;
                        else if (searchEntity.Details.FormalName.Gender === 1)
                            selectedEntityName = this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                        else
                            selectedEntityName = this.translateService.instant("LBL_MR") + "/" + this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                    }
                }
                else if (!GlobalFunctions.isEmpty(searchEntity.StringRepresentation))
                    selectedEntityName = searchEntity.StringRepresentation;
            }
            else {
                selectedEntityName = searchEntity.Name;
                this.fillRepresentative(searchEntity);
            }
            this.ticketDto.CustomerName = selectedEntityName;
            searchEntitySelected.push({ text: selectedEntityName });
            this.searchEntityObject.searchEntityTags = searchEntitySelected;
            this.setSearchEntityProperties(searchEntity, relationshipType);
        }
        this.ticketDto.ContactEmail = this.assignEmail(searchEntity, relationshipType);
    }
    ;
    fillRepresentative(searchEntity) {
        if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
            this.addDefaultRepresentative();
        this.personService.clearCallbacks();
        this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
    }
    ;
    setSearchEntityProperties(searchEntitySelected, relationshipType) {
        switch (relationshipType) {
            case 'Person':
                this.fillPersonInfo(searchEntitySelected);
                break;
            case 'Organization':
                this.fillOrganizationInfo(searchEntitySelected);
                break;
        }
    }
    ;
    fillPersonInfo(selectedEntity) {
        if (selectedEntity != null) {
            let person = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Person);
            if (person == null)
                return;
            this.mainEntityObject = person;
            if (!GlobalFunctions.isEmpty(person.ConfidentialityLevel))
                this.confidentialityLevel = person.ConfidentialityLevel;
            this.ticketDto.MainEntityId = person.Id;
            this.ticketDto.MainEntitySource = person.ObjectSource;
            this.ticketDto.ContactAddress = this.personFormattedAddressWithLabelPipe.transform(person) || '';
            this.displayNumberOnUI(person.PhoneNumber, person.MobileNumber);
        }
    }
    ;
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentCustomerType, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            this.setMainEntity(searchEntity, "");
            document.getElementById('findFromSelectOption')?.focus();
        });
    }
    ;
    clearSelectedEntity() {
        this.ticketDto.CustomerName = null;
        this.ticketDto.ContactAddress = null;
        this.ticketDto.ContactEmail = null;
        this.ticketDto.RepresentativeContactEmail = null;
        this.ticketDto.RepresentativeName = null;
        this.ticketDto.RepresentativeContactPhoneNumber = null;
        this.ticketDto.RepresentativeContactMobileNumber = null;
        this.selectedRepresentativeObject.Value = null;
        this.searchEntityObject.searchEntityTags = [];
        if (GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
            this.ticketDto.ContactPhoneNumber = null;
            this.ticketDto.ContactMobileNumber = null;
        }
    }
    ;
    setMainEntityPerson() {
        if (this.selectedFindFrom.option == "Related") {
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityPerson, "Person");
        }
    }
    ;
    setMainEntityOrganization() {
        if (this.selectedFindFrom.option == "Related") {
            let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityOrganization, "Organization");
        }
    }
    ;
    personTagRemoved(tag) {
        this.representativeList.length = 0;
        this.searchEntityObject.searchEntityTags = [];
        this.clearSelectedEntity();
    }
    ;
    fillRelationEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0 && this.isNewTicket) {
            this.ticketDto.RelatedEntityList = [];
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                    let actualEntityType = value.value;
                    actualEntityType = actualEntityType.replace(/\./g, '_');
                    let relatedEntityDto = new TicketRelatedEntityDto();
                    relatedEntityDto.EntityId = value.key.Id;
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    relatedEntityDto.TicketId = this.ticketDto.Id;
                    this.ticketDto.RelatedEntityList.push(relatedEntityDto);
                }
            });
        }
    }
    ;
    update() {
        this.representativeList = [];
        this.selectedRepresentativeObject.Value = null;
        switch (this.selectedFindFrom.option) {
            case "ManualEntry":
                {
                    if (this.currentCustomerType == "Person")
                        document.getElementById("customerNameValue").focus();
                    else
                        document.getElementById("organizationNameValue").focus();
                    break;
                }
            case "Search":
                {
                    this.openSearchPopup();
                    this.selectedFindFrom.option = "SelectAny";
                    break;
                }
            case "RegisterNew":
                {
                    if (this.currentCustomerType == "Organization") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addOrganizationResponse;
                            this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    else if (this.currentCustomerType == "Person") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addPersonResponse;
                            this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    break;
                }
        }
        this.searchEntityObject.searchEntityTags = [];
        this.clearSelectedEntity();
    }
    ;
    addPersonResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption')?.focus();
    }
    addOrganizationResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption')?.focus();
    }
    fillOrganizationInfo(selectedEntity) {
        if (selectedEntity != null) {
            let organization = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Organization);
            if (organization.Partial != true)
                this.mainEntityObject = organization;
            this.ticketDto.MainEntityId = organization.Id;
            this.ticketDto.MainEntitySource = organization.ObjectSource;
            if (organization.RegistrationAddress != null)
                this.ticketDto.ContactAddress = this.organizationFormattedAddressWithLabelPipe.transform(organization) || '';
            if (!GlobalFunctions.isEmpty(organization.PhoneNumber))
                this.ticketDto.ContactPhoneNumber = !GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && !GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId) ? this.sessionManager.currentCallerId : organization.PhoneNumber;
        }
    }
    ;
    selectOptionsFromFindList() {
        this.selectedFindFrom.option = "SelectAny";
        let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
        if (mainEntityPerson != null) {
            this.currentCustomerType = this.customerDataType == FieldDataType.PersonAndOrganization ? "Person" : this.currentCustomerType;
            if (this.currentCustomerType == "Person") {
                this.setMainEntity(mainEntityPerson, "Person");
                this.selectedFindFrom.option = "Related";
            }
        }
        if (this.selectedFindFrom.option == "SelectAny") {
            let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            if (mainEntityOrganization != null) {
                this.currentCustomerType = this.customerDataType == FieldDataType.PersonAndOrganization ? "Organization" : this.currentCustomerType;
                if (this.currentCustomerType == "Organization") {
                    this.setMainEntity(mainEntityOrganization, "Organization");
                    this.selectedFindFrom.option = "Related";
                }
            }
            if (this.selectedFindFrom.option == "SelectAny" && this.isAllowedManualEntry)
                this.selectedFindFrom.option = "ManualEntry";
        }
    }
    ;
    searchEmployee() {
        const searchPopup = this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
        // Set isParentPopup to false (will not open in detail view) when opening EmployeePanel from Ticket
        if (searchPopup && searchPopup.componentInstance)
            searchPopup.componentInstance.isParentPopup = false;
    }
    ;
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById('assignHandlerTicketTagsInputControl')?.focus();
    }
    ;
    setHandler(handlerIds, handlerType = "Employee") {
        this.handlerTags.length = 0;
        let handlerIdList = handlerIds.split(';');
        for (let i = 0; i < handlerIdList.length; i++) {
            let handler = null;
            if (handlerType == "Employee")
                handler = this.cacheManager.getEmployeeById(handlerIdList[i]);
            else if (handlerType == "Department")
                handler = this.cacheManager.getDepartmentById(handlerIdList[i]);
            else if (handlerType == "Mailbox")
                handler = this.cacheManager.getTaskMailboxById(handlerIdList[i]);
            if (!GlobalFunctions.isEmpty(handler)) {
                this.handlerTags.push(handler);
                this.currentHandlerType.option = handlerType;
            }
        }
    }
    ;
    saveTicket() {
        if (!this.validateTicketData(this.form))
            return;
        this.ticketDto.CreatedBy = !GlobalFunctions.isEmpty(this.ticketDto.CreatedBy) ? this.ticketDto.CreatedBy : GlobalFunctions.getLoggedInUserId();
        this.ticketDto.HandlerList = [];
        if (this.handlerTags.length > 0) {
            for (let i = 0; i < this.handlerTags.length; i++) {
                let ticketHandler = new Object();
                ticketHandler.Id = this.handlerTags[i].TicketHandlerId;
                ticketHandler.HandlerId = this.handlerTags[i].HandlerId ? this.handlerTags[i].HandlerId : this.handlerTags[i].Id;
                ticketHandler.StringRepresentation = this.handlerTags[i].StringRepresentation;
                ticketHandler.HandlerType = this.currentHandlerType.option;
                ticketHandler.Reason = "Created";
                this.ticketDto.HandlerList.push(ticketHandler);
            }
        }
        if (!GlobalFunctions.isEmpty(this.statusField)) {
            this.ticketDto.TicketStateText = jlinq.from(this.ticketDto.TicketType.States.Entries).equals("Key", this.statusField.Data).first().Title;
            this.ticketDto.State = this.statusField.Data;
        }
        if (!GlobalFunctions.isEmpty(this.priorityField)) {
            this.ticketDto.PriorityText = jlinq.from(this.ticketDto.TicketType.Priorities.Entries).equals("Key", this.priorityField.Data).first().Title;
            this.ticketDto.Priority = this.priorityField.Data;
        }
        this.ticketDto.MainEntityType = this.currentCustomerType;
        this.fillRelationEntities();
        this.processThirdPartyDataForSave();
        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups)) {
            for (let i = 0; i < this.ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (this.isNewTicket) {
                            let ticketFieldDataDto = new TicketFieldDataDto();
                            ticketFieldDataDto.TicketId = this.ticketDto.Id;
                            ticketFieldDataDto.FieldId = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Id;
                            ticketFieldDataDto.FieldType = this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType;
                            ticketFieldDataDto.SubFieldId = this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldListId;
                            if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData)) {
                                let fieldListEntries = "";
                                for (let k = 0; k < this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData.length; k++)
                                    fieldListEntries += this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                ticketFieldDataDto.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                            }
                            else
                                ticketFieldDataDto.Data = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data;
                            if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.statusTitle)
                                this.ticketDto.State = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data;
                            this.ticketDto.FieldDataList.push(ticketFieldDataDto);
                        }
                        else {
                            let editField = jlinq.from(this.ticketDto.FieldDataList).equals("FieldId", this.ticketDto.TicketType.FieldGroups[i].Fields[j].Id).first();
                            if (editField == null) {
                                let ticketFieldDataDto = new TicketFieldDataDto();
                                ticketFieldDataDto.TicketId = this.ticketDto.Id;
                                ticketFieldDataDto.FieldId = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Id;
                                ticketFieldDataDto.FieldType = this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType;
                                ticketFieldDataDto.SubFieldId = this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldListId;
                                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData)) {
                                    let fieldListEntries = "";
                                    for (let k = 0; k < this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData.length; k++)
                                        fieldListEntries += this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                    ticketFieldDataDto.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                                    delete this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData;
                                }
                                else
                                    ticketFieldDataDto.Data = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data;
                                this.ticketDto.FieldDataList.push(ticketFieldDataDto);
                            }
                            else {
                                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData)) {
                                    let fieldListEntries = "";
                                    for (let k = 0; k < this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData.length; k++)
                                        fieldListEntries += this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData[k].Key + ";";
                                    editField.Data = fieldListEntries.substring(0, fieldListEntries.length - 1);
                                }
                                else
                                    editField.Data = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data;
                            }
                        }
                    }
                }
            }
        }
        let isValidPhone = this.validatePhoneNumber();
        let isValidRelation = this.validateRelation();
        let isValidBulkHandleTask = this.validateBulkHandleTask();
        if (isValidPhone && isValidRelation && isValidBulkHandleTask)
            this.saveTicketData();
        else {
            if (!isValidPhone) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_PHONE_NUMBER_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result && isValidRelation)
                        this.saveTicketData();
                    else if (!isValidRelation) {
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_TICKET_RELATION_WARNING").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET")), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                            if (result)
                                this.saveTicketData();
                        });
                    }
                });
            }
            else if (!isValidRelation) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_TICKET_RELATION_WARNING").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET")), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.saveTicketData();
                });
            }
            else if (!isValidBulkHandleTask) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_TICKET"), textMsg: this.translateService.instant("LBL_TICKET_BULK_HANDLE_TASK_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.bulkHandleTask();
                    this.saveTicketData();
                });
            }
        }
    }
    ;
    validatePhoneNumber() {
        let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
        return (GlobalFunctions.isEmpty(this.ticketDto.ContactPhoneNumber) || GlobalFunctions.isValidPhonenumber(this.ticketDto.ContactPhoneNumber, countryCode)) && (GlobalFunctions.isEmpty(this.ticketDto.ContactMobileNumber) || GlobalFunctions.isValidPhonenumber(this.ticketDto.ContactMobileNumber, countryCode));
    }
    ;
    validateRelation() {
        let isValid = true;
        if (!GlobalFunctions.isEmpty(this.ticketDto.RelatedEntityList) && this.ticketDto.RelatedEntityList.length > 0) {
            let groupedEntityTypes = jlinq.from(this.ticketDto.RelatedEntityList).group("entityType");
            let groupedEntityKeys = Object.keys(groupedEntityTypes);
            for (let index = 0; index < groupedEntityKeys.length; index++) {
                let key = groupedEntityKeys[index];
                if (groupedEntityTypes[key].length > 1) {
                    isValid = false;
                    break;
                }
            }
        }
        return isValid;
    }
    ;
    validateBulkHandleTask() {
        let isValid = true;
        if (this.statusField.Data == DefaultState[4] && !GlobalFunctions.isEmpty(this.cacheManager.relatedResultList) && this.cacheManager.relatedResultList["TASK"] != null && this.cacheManager.relatedResultList["TASK"].length > 0)
            isValid = false;
        return isValid;
    }
    ;
    bulkHandleTask() {
        let req = new BulkHandleTaskRequest();
        req.TaskIdList = this.cacheManager.relatedResultList["TASK"].map(t => t.Id);
        this.taskService.bulkHandleTask(req, this.bulkHandleTaskResponse, () => { });
    }
    ;
    bulkHandleTaskResponse(result) {
        this.stopSpinner();
        if (result != null) {
            switch (result.Result) {
                case 0:
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
                    break;
                case 1:
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_BULK_HANDLE"), textMsg: this.translateService.instant("LBL_MSG_BULK_HANDLE_FAIL") }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } }));
                    break;
            }
        }
    }
    ;
    saveTicketData() {
        this.startSpinner();
        this.ticketService.createOrUpdateTicket(this.parseTicketDto(this.ticketDto), this.title, this.createOrUpdateTicketResponseHandler);
        this.saveContactPersonDetail();
    }
    ;
    parseTicketDto(ticketDto) {
        // let parsedTicketDto = { ...ticketDto };
        let parsedTicketDto = jQuery.extend(true, {}, ticketDto);
        if (!GlobalFunctions.isEmpty(parsedTicketDto.TicketType.FieldGroups)) {
            for (let i = 0; i < parsedTicketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(parsedTicketDto.TicketType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < parsedTicketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (!GlobalFunctions.isEmpty(parsedTicketDto.TicketType.FieldGroups[i].Fields[j].DisplayData))
                            delete parsedTicketDto.TicketType.FieldGroups[i].Fields[j].DisplayData;
                    }
                }
            }
        }
        return parsedTicketDto;
    }
    ;
    validateTicketData(form) {
        let valid = form.valid;
        this.alignFieldGroups();
        if (this.handlerTags.length === 0)
            valid = false;
        this.ticketDto.TicketType.FieldGroups?.forEach(fieldGroup => {
            fieldGroup.Fields?.forEach(field => {
                if (field.Visible && field.DataType == FieldDataType.ListMultiSelect && field.Required && field.DisplayData.length === 0)
                    valid = false;
            });
        });
        if (this.selectedFindFrom.option != "ManualEntry" && this.searchEntityObject.searchEntityTags.length == 0)
            valid = false;
        else {
            if (valid)
                valid = this.validateTicketStatus();
        }
        if (this.contactEmailCheck && this.selectedFindFrom.option != "ManualEntry") {
            var preventDomains = this.applicationSettingManager.getApplicationSettingValueByKey("PREVENTEMAILWITHDOMAINS");
            if (!GlobalFunctions.isEmailDomainAllowed(this.ticketDto.ContactEmail, preventDomains)) {
                this.createTicketStatus = "LBL_PREVENT_EMAIL_ADDRESS_MESSAGE";
                valid = false;
                this.showMandatoryField = true;
            }
        }
        if (valid) {
            this.showMandatoryField = false;
            this.createTicketStatus = "";
            $('#divEmailAddress').removeClass('error');
        }
        return valid;
    }
    validateTicketStatus() {
        let valid = true;
        if (GlobalFunctions.isEmpty(this.ticketDto.Result) && this.statusField.Data == DefaultState[4]) {
            $('[name=resultField').addClass('error');
            this.showMandatoryField = true;
            this.createTicketStatus = "LBL_MSG_RESULT_REQUIRED_BEFORE_CLOSING_TICKET";
            $('[name=resultField').attr('required', 'true');
            valid = false;
        }
        else {
            $('[name=resultField').removeClass('error');
            this.createTicketStatus = "";
            this.showMandatoryField = false;
            $('[name=resultField').attr('required', 'false');
        }
        return valid;
    }
    processThirdPartyDataForSave() {
        if (GlobalFunctions.isEmpty(this.ticketDto.ThirdParties))
            return;
        for (let i = 0; i < this.ticketDto.ThirdParties.length; i++) {
            delete this.ticketDto.ThirdParties[i].IsChecked;
            if (GlobalFunctions.isEmpty(this.ticketDto.ThirdParties[i].Contacts))
                continue;
            for (let j = 0; j < this.ticketDto.ThirdParties[i].Contacts.length; j++) {
                if (this.ticketDto.ThirdParties[i].Contacts[j].IsChecked)
                    delete this.ticketDto.ThirdParties[i].Contacts[j].IsChecked;
                else {
                    this.ticketDto.ThirdParties[i].Contacts.splice(j, 1);
                    j--;
                }
            }
        }
    }
    ;
    saveContactPersonDetail() {
        if (!GlobalFunctions.isEmpty(this.mainEntityObject) && this.ticketDto.MainEntitySource.toUpperCase().indexOf(".DECOSCONNECT") == -1) {
            let changed = false;
            if (this.ticketDto.MainEntityType.toUpperCase() == "PERSON") {
                if (this.contactNumberCheck && !GlobalFunctions.isEmpty(this.ticketDto.ContactPhoneNumber) && this.ticketDto.ContactPhoneNumber != this.mainEntityObject.PhoneNumber) {
                    this.mainEntityObject.PhoneNumber = this.ticketDto.ContactPhoneNumber;
                    changed = true;
                }
                if (this.contactNumberCheck && !GlobalFunctions.isEmpty(this.ticketDto.ContactMobileNumber) && this.ticketDto.ContactMobileNumber != this.mainEntityObject.MobileNumber) {
                    this.mainEntityObject.MobileNumber = this.ticketDto.ContactMobileNumber;
                    changed = true;
                }
                if (this.contactNumberCheck && !GlobalFunctions.isEmpty(this.ticketDto.ContactEmail) && this.ticketDto.ContactEmail != this.mainEntityObject.EmailAddress) {
                    this.mainEntityObject.EmailAddress = this.ticketDto.ContactEmail;
                    changed = true;
                }
                if (changed) {
                    let personRequest = new CreateOrUpdatePersonRequest();
                    personRequest.Mode = RecordOperationMode.Edit;
                    personRequest.PersonDto = this.mainEntityObject;
                    this.personService.createPersonEntity(personRequest, null, null);
                }
            }
            else if (this.ticketDto.MainEntityType.toUpperCase() == "ORGANIZATION") {
                if (this.contactEmailCheck && !GlobalFunctions.isEmpty(this.ticketDto.ContactPhoneNumber) && this.ticketDto.ContactPhoneNumber != this.mainEntityObject.PhoneNumber) {
                    this.mainEntityObject.PhoneNumber = this.ticketDto.ContactPhoneNumber;
                    changed = true;
                }
                if (this.contactEmailCheck && !GlobalFunctions.isEmpty(this.ticketDto.ContactEmail) && this.ticketDto.ContactEmail != this.mainEntityObject.EmailAddress) {
                    this.mainEntityObject.EmailAddress = this.ticketDto.ContactEmail;
                    changed = true;
                }
                if (changed) {
                    this.mainEntityObject.PhoneNumber = this.ticketDto.ContactPhoneNumber;
                    let organizationRequest = new CreateOrganizationRequest();
                    organizationRequest.Mode = RecordOperationMode.Edit;
                    organizationRequest.OrganizationDto = this.mainEntityObject;
                    this.organizationService.createOrganizationEntity(organizationRequest, null, null);
                }
            }
        }
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveTicket());
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addTicketHeader").height() - $("#addTicketFooter").height() + "px";
        $("#addTicketContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        this.alignFieldGroups();
    }
    alignFieldGroups() {
        $('div[id^="fieldGroup_"]').each((key, element) => {
            if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType?.FieldGroups[key].Layout) && this.ticketDto.TicketType?.FieldGroups[key].Layout == FieldGroupLayout.Right && key > 0) {
                let previousElement = $("#fieldGroup_" + (key - 1));
                let previousElementTable = previousElement.find(".table");
                element = $(element);
                let elementTable = element.find(".table");
                let maxHeight = elementTable.innerHeight() > previousElementTable.innerHeight() ? elementTable.innerHeight() : previousElementTable.innerHeight();
                element.height(maxHeight + 31);
                previousElement.height(maxHeight + 31);
                previousElement[0].style.clear = 'both';
            }
        });
    }
    ;
    selectThirdPartyTypeOption() {
        if (this.currentThirdPartyType.option != 'None') {
            this.clearThirdPartyData();
            this.ticketDto.ThirdParties = [];
        }
        this.alignFieldGroups();
    }
    ;
    openThirdPartySearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentThirdPartyType.option, recordSelection: RecordSelection.Multiple }).afterClosed().subscribe(searchEntity => this.setThirdPartyEntity(searchEntity, this.currentThirdPartyType.option));
    }
    ;
    setThirdPartyEntity(searchEntities, thirdPartyType) {
        if (!GlobalFunctions.isEmpty(searchEntities)) {
            if (!Array.isArray(searchEntities) && (typeof searchEntities === 'object' && searchEntities != null))
                searchEntities = [searchEntities];
            this.clearThirdPartyData();
            if (thirdPartyType == 'Person') {
                for (let i = 0; i < searchEntities.length; i++) {
                    let index = !GlobalFunctions.isEmpty(this.ticketDto.ThirdParties) ? GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", searchEntities[i].Id) : -1;
                    if (index != -1)
                        continue;
                    if (GlobalFunctions.isPersonDeceased(searchEntities[i].Details.DateOfExpiration))
                        this.showThirdPartyDeceasedWarning(searchEntities[i]);
                    else if (searchEntities[i].ConfidentialityLevel != 0)
                        this.showThirdPartyClassifiedWarning(searchEntities[i]);
                    let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
                    if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                        GlobalFunctions.setStringPresentation(searchEntities[i], getGrammerValue);
                        if (!GlobalFunctions.isEmpty(searchEntities[i].Details) && !GlobalFunctions.isEmpty(searchEntities[i].Details.FormalName) && !GlobalFunctions.isEmpty(searchEntities[i].Details.FormalName.Gender)) {
                            if (searchEntities[i].Details.FormalName.Gender === 0)
                                searchEntities[i].StringRepresentation = this.translateService.instant("LBL_MR") + " " + searchEntities[i].StringRepresentation;
                            else if (searchEntities[i].Details.FormalName.Gender === 1)
                                searchEntities[i].StringRepresentation = this.translateService.instant("LBL_MRS") + " " + searchEntities[i].StringRepresentation;
                            else
                                searchEntities[i].StringRepresentation = this.translateService.instant("LBL_MR") + "/" + this.translateService.instant("LBL_MRS") + " " + searchEntities[i].StringRepresentation;
                        }
                    }
                    this.fillThirdPartyPersonInfo(searchEntities[i]);
                }
            }
            else {
                this.personService.clearCallbacks();
                for (let i = 0; i < searchEntities.length; i++) {
                    let index = !GlobalFunctions.isEmpty(this.ticketDto.ThirdParties) ? GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", searchEntities[i].Id) : -1;
                    if (index != -1)
                        continue;
                    this.personService.searchRelatedRepresentativeRequest(this.fillThirdPartyRepresentatives, searchEntities[i]);
                    this.fillThirdPartyOrganizationInfo(searchEntities[i]);
                }
            }
            ;
        }
    }
    ;
    fillThirdPartyPersonInfo(selectedEntity) {
        if (selectedEntity != null) {
            let person = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Person);
            if (person == null)
                return;
            this.thirdPartyConfidentialityLevel = person.ConfidentialityLevel;
            let personAddress = this.personFormattedAddressWithLabelPipe.transform(person) || '';
            let thirdPartyDto = new ThirdPartyDto();
            thirdPartyDto.PersonToDto(person, personAddress);
            this.ticketDto.ThirdParties.push(thirdPartyDto);
        }
    }
    ;
    fillThirdPartyOrganizationInfo(selectedEntity) {
        if (selectedEntity != null) {
            let organization = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Organization);
            let organizationAddress = organization.RegistrationAddress != null ? this.organizationFormattedAddressWithLabelPipe.transform(organization) || '' : "";
            let thirdPartyDto = new ThirdPartyDto();
            thirdPartyDto.OrganizationToDto(organization, organizationAddress);
            this.ticketDto.ThirdParties.push(thirdPartyDto);
        }
    }
    ;
    fillThirdPartyRepresentatives(result) {
        if (result != null && result.length > 0) {
            let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    let thirdPartyContact = new ThirdPartyContactDto();
                    thirdPartyContact.ToDto(result[i]);
                    let index = GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", result[i].OrganizationId);
                    if (index != -1) {
                        let contactIndex = GlobalFunctions.findIndex(this.ticketDto.ThirdParties[index].Contacts, "EntityId", thirdPartyContact.EntityId);
                        if (contactIndex == -1) {
                            if (GlobalFunctions.isEmpty(this.ticketDto.ThirdParties[index].Contacts))
                                this.ticketDto.ThirdParties[index].Contacts = [];
                            this.ticketDto.ThirdParties[index].Contacts.push(thirdPartyContact);
                        }
                        else
                            this.ticketDto.ThirdParties[index].Contacts[contactIndex].IsChecked = true;
                    }
                }
            }
        }
    }
    ;
    registerNewThirdParty() {
        if (this.currentThirdPartyType.option == "Organization") {
            if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.registerNewThirdPartyOrganizationResponse;
                this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
            }
            else
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
        }
        else if (this.currentThirdPartyType.option == "Person") {
            if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.registerNewThirdPartyPersonResponse;
                this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
            }
            else
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
        }
    }
    ;
    registerNewThirdPartyPersonResponse(selectedEntity) {
        this.setThirdPartyEntity(selectedEntity, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption')?.focus();
    }
    registerNewThirdPartyOrganizationResponse(selectedEntity) {
        this.setThirdPartyEntity(selectedEntity, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption')?.focus();
    }
    editThirdParty(event, selectedThirdParty) {
        this.thirdPartySection.isCollapsed = true;
        this.selectedThirdPartyForEdit = selectedThirdParty;
        event.preventDefault();
        event.stopPropagation();
        event.cancelBubble = false;
    }
    removeThirdParty(thirdParty) {
        let index = GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", thirdParty.EntityId);
        if (index == -1)
            return;
        this.ticketDto.ThirdParties.splice(index, 1);
        this.clearThirdPartyData();
        event.preventDefault();
        event.stopPropagation();
        event.cancelBubble = false;
    }
    saveThirdParty() {
        let createPersonRequest;
        let createOrganizationRequest;
        this.thirdPartySection.isCollapsed = false;
        let index = GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", this.selectedThirdPartyForEdit.EntityId);
        this.ticketDto.ThirdParties[index] = this.selectedThirdPartyForEdit;
        let entityDto = null;
        if (this.currentThirdPartyType.option == "Person") {
            entityDto = new PersonDto();
            createPersonRequest = new CreateOrUpdatePersonRequest();
            createPersonRequest.Mode = RecordOperationMode.Edit;
        }
        else {
            entityDto = new OrganizationDto();
            createOrganizationRequest = new CreateOrganizationRequest();
            createOrganizationRequest.Mode = RecordOperationMode.Edit;
        }
        entityDto.Partial = true;
        entityDto.EmailAddress = this.selectedThirdPartyForEdit.Email;
        entityDto.PhoneNumber = this.selectedThirdPartyForEdit.PhoneNumber;
        entityDto.MobileNumber = this.selectedThirdPartyForEdit.MobileNumber;
        entityDto.Id = this.selectedThirdPartyForEdit.EntityId;
        entityDto.ObjectSource = this.selectedThirdPartyForEdit.EntitySource;
        if (this.currentThirdPartyType.option == "Person") {
            createPersonRequest.PersonDto = entityDto;
            this.personService.createPersonEntity(createPersonRequest, null, null);
        }
        else {
            createOrganizationRequest.OrganizationDto = entityDto;
            this.organizationService.createOrganizationEntity(createOrganizationRequest, null, null);
        }
    }
    ;
    registerNewThirdPartyContact() {
        if (this.currentThirdPartyType.option == "Organization") {
            DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.selectedThirdParty.EntityId, editMode: false }).afterClosed().subscribe(newlyCreatedEntity => {
                if (!GlobalFunctions.isEmpty(newlyCreatedEntity)) {
                    if (!Array.isArray(newlyCreatedEntity) && (typeof newlyCreatedEntity === 'object'))
                        newlyCreatedEntity = [newlyCreatedEntity];
                    this.fillThirdPartyRepresentatives(newlyCreatedEntity);
                }
            });
        }
    }
    ;
    selectThirdPartyContact(index, selectedThirdParty) {
        this.selectedRow = index;
        if (GlobalFunctions.isEmpty(selectedThirdParty.Contacts))
            selectedThirdParty.Contacts = [];
        this.selectedThirdParty = selectedThirdParty;
    }
    editThirdPartyContact(selectedThirdPartyContact) {
        this.thirdPartyContactSection.isCollapsed = true;
        this.selectedThirdPartyContactForEdit = selectedThirdPartyContact;
        event.preventDefault();
        event.stopPropagation();
        event.cancelBubble = false;
    }
    saveThirdPartyContact() {
        this.thirdPartyContactSection.isCollapsed = false;
        if (!GlobalFunctions.isEmpty(this.selectedThirdPartyContactForEdit.EntityId)) {
            let index = GlobalFunctions.findIndex(this.selectedThirdParty.Contacts, "EntityId", this.selectedThirdPartyContactForEdit.EntityId);
            this.selectedThirdParty.Contacts[index] = this.selectedThirdPartyContactForEdit;
        }
        else {
            GlobalFunctions.setStringPresentation(this.selectedThirdPartyContactForEdit, "{LastName}, {Initials} {FirstName}");
            this.selectedThirdParty.Contacts.push(this.selectedThirdPartyContactForEdit);
        }
        let thirdPartyIndex = GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", this.selectedThirdParty.EntityId);
        this.ticketDto.ThirdParties[thirdPartyIndex].Contacts = this.selectedThirdParty.Contacts;
    }
    ;
    openEditView(selectedThirdPartyForEdit) {
        if (selectedThirdPartyForEdit != null && !GlobalFunctions.isEmpty(selectedThirdPartyForEdit.EntityId) && selectedThirdPartyForEdit.EntityId.toUpperCase().indexOf('DUMMY') == -1) {
            this.startSpinner();
            let partialDto = new Object();
            partialDto.Id = selectedThirdPartyForEdit.EntityId;
            partialDto.ObjectSource = selectedThirdPartyForEdit.EntitySource;
            if (selectedThirdPartyForEdit.EntityType == MainEntityType.Person || GlobalFunctions.isEmpty(selectedThirdPartyForEdit.EntityType)) {
                this.personService.fetchDetail(partialDto, this.redirectToEditScreenAfterResponse);
            }
            else if (selectedThirdPartyForEdit.EntityType == MainEntityType.Organization) {
                this.organizationService.fetchDetail(partialDto, this.redirectToEditScreenAfterResponse);
            }
        }
    }
    redirectToEditScreenAfterResponse(response) {
        this.stopSpinner();
        if (response == null)
            return;
        this.sessionManager.selectedEntity = response;
        if (response.ObjectSource == "Decos.Kcs.Organizations.DecosConnect" && response.RelatedEntityFqdn == "Decos_Kcs_Persons_Entities_Person") {
            DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.ticketDto.MainEntityId, editMode: true }).afterClosed().subscribe(newlyCreatedEntity => {
                let thirdPartyContact = new ThirdPartyContactDto();
                thirdPartyContact.ToDto(newlyCreatedEntity);
                this.selectedThirdPartyContactForEdit = thirdPartyContact;
                this.thirdPartyContactSection.isCollapsed = false;
            });
        }
        else {
            if (this.selectedThirdPartyForEdit.EntityType == MainEntityType.Organization) {
                if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                    this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                    this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                    this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addThirdPartyOrganizationResponse;
                    this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                }
                else
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
            }
            else if (this.selectedThirdPartyForEdit.EntityType == MainEntityType.Person) {
                if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                    this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                    this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                    this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addThirdPartyPersonResponse;
                    this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                }
                else
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
            }
        }
    }
    addThirdPartyPersonResponse(entity) {
        if (entity != null) {
            let person = GlobalFunctions.setEntityType(entity, JsonDtoType.Person);
            if (person == null)
                return;
            let personAddress = this.personFormattedAddressWithLabelPipe.transform(person) || '';
            let thirdPartyDto = new ThirdPartyDto();
            thirdPartyDto.PersonToDto(person, personAddress);
            this.selectedThirdPartyForEdit = thirdPartyDto;
            this.thirdPartySection.isCollapsed = false;
        }
    }
    addThirdPartyOrganizationResponse(entity) {
        if (entity != null) {
            let organization = GlobalFunctions.setEntityType(entity, JsonDtoType.Organization);
            let thirdPartyDto = new ThirdPartyDto();
            let orgAddress = organization.RegistrationAddress != null ? this.organizationFormattedAddressWithLabelPipe.transform(organization) || '' : "";
            thirdPartyDto.OrganizationToDto(organization, orgAddress);
            this.selectedThirdPartyForEdit = thirdPartyDto;
            this.thirdPartySection.isCollapsed = false;
        }
    }
    showThirdPartyDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        if (personEntity.ConfidentialityLevel != 0)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
    }
    ;
    showThirdPartyClassifiedWarning(personEntity) {
        if (personEntity.ConfidentialityLevel == 0)
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
    }
    ;
    clearThirdPartyData() {
        this.selectedContacts = [];
        this.selectedThirdPartyContactForEdit = null;
        this.selectedThirdPartyForEdit = null;
        this.selectedThirdParty = null;
    }
    initializeTicket() {
        this.ticketDto.FieldDataList = [];
        this.ticketDto.ThirdParties = [];
        this.ticketDto.Priority = { ...this.ticketDto.TicketType.DefaultPriority };
        this.ticketDto.State = { ...this.ticketDto.TicketType.DefaultState };
        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups)) {
            this.ticketDto.TicketType.FieldGroups = jlinq.from(this.ticketDto.TicketType.FieldGroups).sort("Order").select();
            for (let i = 0; i < this.ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields)) {
                    this.ticketDto.TicketType.FieldGroups[i].Fields = jlinq.from(this.ticketDto.TicketType.FieldGroups[i].Fields).sort("Order").select();
                    for (let j = 0; j < this.ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title)) {
                            if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == 'ontvangen')
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = new Date();
                            else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.statusTitle) {
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = this.ticketDto.TicketType.DefaultState;
                                this.statusField = this.ticketDto.TicketType.FieldGroups[i].Fields[j];
                            }
                            else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.priorityTitle) {
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = this.ticketDto.TicketType.DefaultPriority;
                                this.priorityField = this.ticketDto.TicketType.FieldGroups[i].Fields[j];
                            }
                            else if (this.ticketDto.TicketType.FieldGroups[i].Title.toLowerCase() == this.thirdPartyTitle && this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.thirdPartyTitle) {
                                if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule == "0")
                                    this.currentThirdPartyType.option = 'None';
                                else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule == "1")
                                    this.currentThirdPartyType.option = 'Person';
                                else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule == "2")
                                    this.currentThirdPartyType.option = 'Organization';
                            }
                            else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.Handler) {
                                this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule);
                                if (this.handlerTypeOption.EmployeeHandler)
                                    this.currentHandlerType.option = "Employee";
                                else if (this.handlerTypeOption.DepartmentHandler)
                                    this.currentHandlerType.option = "Department";
                                else if (this.handlerTypeOption.MailboxHandler)
                                    this.currentHandlerType.option = "Mailbox";
                            }
                        }
                        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType) && this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect && this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                            for (let k = 0; k < this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries.length; k++)
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries[k].text = this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries[k].Title;
                            if (GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData))
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData = [];
                        }
                        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType) && this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.List) {
                            if (GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data))
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = '';
                        }
                    }
                }
            }
        }
        this.resetFieldListEntriesVisibility();
    }
    ;
    initializeEditTicket() {
        if (GlobalFunctions.isEmpty(this.ticketDto.FieldDataList))
            this.ticketDto.FieldDataList = [];
        if (GlobalFunctions.isEmpty(this.ticketDto.ThirdParties))
            this.ticketDto.ThirdParties = [];
        if (this.isAllowedManualEntry && GlobalFunctions.isEmpty(this.ticketDto.MainEntityId))
            this.selectedFindFrom.option = "ManualEntry";
        else {
            if (this.ticketDto.MainEntityType && this.currentCustomerType.toLowerCase() == MainEntityType[this.ticketDto.MainEntityType].toLowerCase()) {
                this.searchEntityObject.searchEntityTags.push({ text: this.ticketDto.CustomerName });
                this.confidentialityLevel = this.ticketDto.personClassifiedValue;
            }
            else
                this.clearSelectedEntity();
            if (this.ticketDto.MainEntityType == MainEntityType.Organization) {
                let organizationObject = new Object();
                organizationObject.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization].toString();
                organizationObject.Id = this.ticketDto.MainEntityId;
                organizationObject.ObjectSource = this.ticketDto.MainEntitySource;
                this.fillRepresentative(organizationObject);
            }
        }
        if (!GlobalFunctions.isEmpty(this.ticketDto.ThirdParties) && !GlobalFunctions.isEmpty(this.ticketDto.ThirdParties[0].EntityType)) {
            if (this.ticketDto.ThirdParties[0].EntityType == MainEntityType.Person)
                this.currentThirdPartyType.option = 'Person';
            else if (this.ticketDto.ThirdParties[0].EntityType == MainEntityType.Organization)
                this.currentThirdPartyType.option = 'Organization';
        }
        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups)) {
            for (let i = 0; i < this.ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.DateTime) {
                            if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == 'ontvangen')
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = GlobalFunctions.isEmpty(this.ticketDto.ReceivedDate) ? this.ticketDto.CreatedDate : this.ticketDto.ReceivedDate;
                            this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data) ? null : new Date(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data);
                        }
                        else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.statusTitle) {
                            if (GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data))
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = this.ticketDto.TicketType.DefaultState;
                            this.statusField = this.ticketDto.TicketType.FieldGroups[i].Fields[j];
                        }
                        else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title.toLowerCase() == this.priorityTitle) {
                            if (GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data))
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = this.ticketDto.TicketType.DefaultPriority;
                            this.priorityField = this.ticketDto.TicketType.FieldGroups[i].Fields[j];
                        }
                        else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.Handler)
                            this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule);
                        else if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType) && this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect && this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                            for (let k = 0; k < this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries.length; k++)
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries[k].text = this.ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries[k].Title;
                        }
                        else if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.Boolean)
                            this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data == "true" ? true : false;
                        else if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType) && this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.List) {
                            if (GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data))
                                this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = '';
                        }
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.ticketDto.HandlerList)) {
            for (let h = 0; h < this.ticketDto.HandlerList.length; h++) {
                let handler = this.ticketDto.HandlerList[h];
                let handlerData = null;
                if (handler.HandlerType == TaskHandlerType.Department || handler.HandlerType == "Department") {
                    handlerData = this.cacheManager.getDepartmentById(handler.HandlerId);
                    handler.EntityType = 2;
                    this.currentHandlerType.option = "Department";
                }
                else if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee") {
                    handlerData = this.cacheManager.getEmployeeById(handler.HandlerId);
                    handler.EntityType = 1;
                    this.currentHandlerType.option = "Employee";
                }
                else if (handler.HandlerType == TaskHandlerType.Mailbox || handler.HandlerType == "Mailbox") {
                    handlerData = this.cacheManager.getTaskMailboxById(handler.HandlerId);
                    handler.EntityType = 3;
                    this.currentHandlerType.option = "Mailbox";
                }
                handler.text = handlerData != null ? handlerData.StringRepresentation : "";
                this.handlerTags.push(handler);
            }
        }
        if (this.currentThirdPartyType.option == 'Organization' && !GlobalFunctions.isEmpty(this.ticketDto.ThirdParties)) {
            for (let i = 0; i < this.ticketDto.ThirdParties.length; i++) {
                let index = !GlobalFunctions.isEmpty(this.ticketDto.ThirdParties) ? GlobalFunctions.findIndex(this.ticketDto.ThirdParties, "EntityId", this.ticketDto.ThirdParties[i].Id) : -1;
                if (index != -1)
                    continue;
                let entity = {
                    RelatedEntityFqdn: "Decos_Kcs_Organizations_Entities_Organization",
                    Id: this.ticketDto.ThirdParties[i].EntityId,
                    ObjectSource: this.ticketDto.ThirdParties[i].EntitySource
                };
                this.personService.searchRelatedRepresentativeRequest(this.fillThirdPartyRepresentatives, entity);
            }
        }
    }
    ;
    resetFieldListEntriesVisibility() {
        for (let fieldGroup of this.ticketDto.TicketType.FieldGroups) {
            for (let field of fieldGroup.Fields) {
                if (field.DataType == FieldDataType.List || field.DataType == FieldDataType.ListMultiSelect)
                    for (let entry of field.FieldList?.Entries)
                        entry.Visible = true;
            }
        }
    }
    ;
    updateTicketDetailsfromSavedSession() {
        this.title = this.editedTicketData.title;
        this.ticketDto.Id = this.editedTicketData.Id;
        this.ticketDto.TicketTypeId = this.editedTicketData.TicketTypeId;
        this.ticketDto.ReceivedDate = this.editedTicketData.ReceivedDate;
        this.ticketDto.MainEntityId = this.editedTicketData.MainEntityId;
        this.ticketDto.MainEntitySource = this.editedTicketData.MainEntitySource;
        this.ticketDto.MainEntityType = this.editedTicketData.MainEntityType;
        this.ticketDto.ContactMobileNumber = this.editedTicketData.ContactMobileNumber;
        this.ticketDto.ContactAddress = this.editedTicketData.ContactAddress;
        this.ticketDto.ContactEmail = this.editedTicketData.ContactEmail;
        this.ticketDto.ContactPhoneNumber = this.editedTicketData.ContactPhoneNumber;
        this.ticketDto.CustomerName = this.editedTicketData.CustomerName;
        this.ticketDto.Description = this.editedTicketData.Description;
        this.ticketDto.Result = this.editedTicketData.Result;
        this.ticketDto.ThirdParties = this.editedTicketData.ThirdParties;
        this.ticketDto.Priority = this.editedTicketData.Priority;
        this.ticketDto.State = this.editedTicketData.State;
        this.currentThirdPartyType = this.editedTicketData.currentThirdPartyType;
        this.ticketDto.TicketType = this.editedTicketData.TicketType;
        this.currentHandlerType = this.editedTicketData.CurrentHandlerType;
        this.ticketDto.RepresentativeContactMobileNumber = this.editedTicketData.RepresentativeContactMobileNumber;
        this.ticketDto.RepresentativeContactPhoneNumber = this.editedTicketData.RepresentativeContactPhoneNumber;
        this.ticketDto.RepresentativeName = this.editedTicketData.RepresentativeName;
        this.ticketDto.RepresentativeContactEmail = this.editedTicketData.RepresentativeContactEmail;
        this.ticketDto.ContactPerson = this.editedTicketData.ContactPerson;
        this.ticketDto.CreatedDate = this.editedTicketData.CreatedDate;
        this.ticketDto.CreatedBy = this.editedTicketData.CreatedBy;
        this.selectedRepresentativeObject = this.editedTicketData.SelectedRepresentativeObject;
        this.representativeList = this.editedTicketData.RepresentativeList;
        this.ticketDto.Number = this.editedTicketData.Number;
        if (!GlobalFunctions.isEmpty(this.editedTicketData.CurrentHandlerList)) {
            this.handlerTags = [];
            this.currentHandlerType.option = this.editedTicketData.CurrentHandlerType.option;
            for (let i = 0; i < this.editedTicketData.CurrentHandlerList.length; i++) {
                let handlerId = this.editedTicketData.CurrentHandlerList[i] && this.editedTicketData.CurrentHandlerList[i].HandlerObject ? this.editedTicketData.CurrentHandlerList[i].HandlerObject.Id : "";
                if (!GlobalFunctions.isEmpty(handlerId)) {
                    let handleData = null;
                    if (this.editedTicketData.CurrentHandlerType.option.toLowerCase() == "employee")
                        handleData = this.cacheManager.getEmployeeById(handlerId);
                    else if (this.editedTicketData.CurrentHandlerType.option.toLowerCase() == "department")
                        handleData = this.cacheManager.getDepartmentById(handlerId);
                    else if (this.editedTicketData.CurrentHandlerType.option.toLowerCase() == "mailbox")
                        handleData = this.cacheManager.getTaskMailboxById(handlerId);
                    if (handleData != null) {
                        handleData.text = handleData.StringRepresentation;
                        this.handlerTags.push(handleData);
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups)) {
            for (let i = 0; i < this.ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields)) {
                    for (let j = 0; j < this.ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.DateTime)
                            this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data = new Date(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Data);
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.editedTicketData.SearchEntityTags)) {
            this.searchEntityObject.searchEntityTags = [];
            for (let i = 0; i < this.editedTicketData.SearchEntityTags.length; i++)
                this.searchEntityObject.searchEntityTags.push(this.editedTicketData.SearchEntityTags[i]);
        }
        this.ticketDto.RelatedEntityList = this.editedTicketData.RelatedEntityList;
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    ;
    resetFieldGroup(event, fieldGroup) {
        // Check if the event was triggered (from keyborad e.g.,Enter)
        if (!GlobalFunctions.isEmpty(event) && !GlobalFunctions.isEmpty(event.detail) && event.detail == 0)
            return;
        for (let field of fieldGroup.Fields) {
            if (!GlobalFunctions.isEmpty(field.DisplayData))
                field.DisplayData = [];
            else
                field.Data = '';
        }
        if (!GlobalFunctions.isEmpty(fieldGroup)) {
            let fieldGroupName = fieldGroup.Description;
            switch (fieldGroupName.toLowerCase()) {
                case "klant":
                    {
                        this.clearSelectedEntity();
                        this.contactNumberCheck = false;
                        this.contactEmailCheck = false;
                        this.cdr.detectChanges();
                        break;
                    }
                case "opties":
                    {
                        this.handlerTags = [];
                        this.cdr.detectChanges();
                        break;
                    }
                case "omschrijving":
                    {
                        if (!GlobalFunctions.isEmpty(this.ticketDto))
                            this.ticketDto.Description = "";
                        this.cdr.detectChanges();
                        break;
                    }
                case "resultaat":
                    {
                        if (!GlobalFunctions.isEmpty(this.ticketDto))
                            this.ticketDto.Result = "";
                        this.cdr.detectChanges();
                        break;
                    }
                case "derdepartij":
                    {
                        if (!GlobalFunctions.isEmpty(this.ticketDto))
                            this.ticketDto.ThirdParties = [];
                        this.clearThirdPartyData();
                        this.cdr.detectChanges();
                        break;
                    }
            }
        }
        event.preventDefault();
        event.stopPropagation();
        this.updateRules();
    }
    ;
    changedCustomerType(customerType) {
        this.currentCustomerType = customerType;
        this.clearSelectedEntity();
        if (this.selectedFindFrom.option == "Related") {
            if (this.currentCustomerType == "Person") {
                let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
                if (mainEntityPerson != null)
                    this.setMainEntity(mainEntityPerson, "Person");
            }
            else {
                let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
                if (mainEntityOrganization != null)
                    this.setMainEntity(mainEntityOrganization, "Organization");
            }
        }
    }
    ;
    close(result) {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], TicketAddEditComponent.prototype, "form", void 0);
TicketAddEditComponent = __decorate([
    Component({
        selector: 'ticket-add-edit',
        templateUrl: './ticket-add-edit.component.html',
        styleUrls: ['./ticket-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], TicketAddEditComponent);
export { TicketAddEditComponent };
//# sourceMappingURL=ticket-add-edit.component.js.map