var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseViewerComponent } from 'src/app/components/common/base-viewer.component';
import { GlobalFunctions } from '../../../../shared/global-functions';
let ThemeViewerComponent = class ThemeViewerComponent extends BaseViewerComponent {
    constructor(userService, phoneManager, sessionManager, dialogManager, changeDetectorRef, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.userService = userService;
        this.phoneManager = phoneManager;
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.changeDetectorRef = changeDetectorRef;
        this.translateService = translateService;
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.timeoutIds = [];
    }
    ngOnInit() {
        if (this.selectedViewerEntity)
            this.parseThemePageDescription(this.selectedViewerEntity);
    }
    parseThemePageDescription(selectedViewerEntity) {
        let element = document.getElementById('theme-viewer-description');
        element.style.display = 'none';
        this.timeoutIds.push(setTimeout(() => {
            if (!GlobalFunctions.isEmpty(selectedViewerEntity.FormattedDescription)) {
                let doc = new DOMParser().parseFromString(selectedViewerEntity.FormattedDescription, 'text/html');
                doc = this.addLockIconForBlocks(doc, selectedViewerEntity.ManageLocalGroupPrivilege);
                element.innerHTML = selectedViewerEntity.FormattedDescription;
                element.style.display = 'block';
                this.resizeImage();
            }
        }, 500));
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    addLockIconForBlocks(document, manageLocalGroupPrivilegeData) {
        if (!GlobalFunctions.isEmpty(this.localUserGroups) && !GlobalFunctions.isEmpty(manageLocalGroupPrivilegeData)) {
            let allBlockWiseAssignedLocalGroups = manageLocalGroupPrivilegeData.split(';');
            if (!GlobalFunctions.isEmpty(allBlockWiseAssignedLocalGroups)) {
                let allSections = document.getElementsByTagName('section');
                if (!GlobalFunctions.isEmpty(allSections)) {
                    let title = this.translateService.instant("LBL_CLICK_TO_SEE_LOCAL_GROUP");
                    for (let i = 0; i < allSections.length; i++) {
                        let htmlContent = "";
                        for (let j = 0; j < allBlockWiseAssignedLocalGroups.length; j++) {
                            let blockWiseAssignedLocalGroups = allBlockWiseAssignedLocalGroups[j].split('|');
                            if (!GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups) && blockWiseAssignedLocalGroups.length == 2 && blockWiseAssignedLocalGroups[0] == allSections[i].id && !GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups[1])) {
                                for (let k = 0; k < this.localUserGroups.length; k++) {
                                    if (blockWiseAssignedLocalGroups[1].indexOf(this.localUserGroups[k].Id) != -1)
                                        htmlContent += "<li class='localgroupNameListLi'><div class='fieldValueWithEllipsis localgroupNameListDiv' title='" + this.localUserGroups[k].Name + "'>" + this.localUserGroups[k].Name + "</div> </li>";
                                }
                                break;
                            }
                        }
                        allSections[i].innerHTML = "<div class='dropdown divDisplayLocalGroupName' id='localgroupMenu' >"
                            + "<a role='button' class='lockIcon jkcUnlockBlue jkcSizeSmall' id='lockIcon" + allSections[i].id + "'  title='" + title + "' (click)='showLocalList(\"" + allSections[i].id + "\")' name=" + allSections[i].id + "></a>"
                            + "<ul id='" + allSections[i].id + "localgroupList' class='localgroupList dropdown-menu selectMenuCall' style='width:auto; font-size:15px; margin-top:-10px;'>"
                            + "<li></li>"
                            + htmlContent
                            + "</ul>"
                            + "</div>"
                            + allSections[i].innerHTML;
                    }
                    this.timeoutIds.push(setTimeout(() => this.adjustLocalGroupPopupPosition(), 1500));
                }
            }
        }
        return document;
    }
    ;
    resizeImage() {
        try {
            this.timeoutIds.push(setTimeout(() => {
                const img = $("#theme-viewer-description").find("img");
                if (!GlobalFunctions.isEmpty(img)) {
                    $(img).css("max-width", "100%");
                    $(img).css('height', 'auto');
                }
                this.changeDetectorRef.detectChanges();
            }, 300));
        }
        catch (e) {
            console.error(e);
        }
    }
    adjustLocalGroupPopupPosition() {
        let allOpenedPopups = $('.localgroupList');
        let themeDetailScreenWidth = $('#themeDetail').width();
        if (!GlobalFunctions.isEmpty(allOpenedPopups) && themeDetailScreenWidth > 0) {
            let maxWidthAllowed = (themeDetailScreenWidth * 70) / 100;
            for (let i = 0; i < allOpenedPopups.length; i++) {
                let tempWidth = $('#' + allOpenedPopups[i].id).width();
                if (tempWidth > 0) {
                    if (tempWidth > maxWidthAllowed) {
                        allOpenedPopups[i].style.left = ((themeDetailScreenWidth * 30) / 100) + "px";
                        allOpenedPopups[i].style.width = ((themeDetailScreenWidth * 70) / 100) + "px";
                    }
                    else
                        allOpenedPopups[i].style.left = (themeDetailScreenWidth - tempWidth - 10) + "px";
                }
            }
        }
    }
    navigateToHeading(headingId) {
        try {
            const heading = document.getElementById(headingId);
            const content = document.getElementById('viewerDetailContainerPage');
            content.scrollTo({ top: heading.getBoundingClientRect().top - content.getBoundingClientRect().top + content.scrollTop, behavior: 'smooth' });
        }
        catch (e) {
            console.error(e);
        }
    }
    resize() {
        this.resizeImage();
    }
};
ThemeViewerComponent = __decorate([
    Component({
        selector: 'theme-viewer',
        templateUrl: './theme-viewer.component.html',
        styleUrls: ['./theme-viewer.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ThemeViewerComponent);
export { ThemeViewerComponent };
//# sourceMappingURL=theme-viewer.component.js.map