var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { AlternateSearchType, ScreenMode } from 'src/app/core/enums/common-enums';
import { SearchResultSource } from 'src/app/core/enums/search-result-source.enum';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let ThemeSearchResultComponent = class ThemeSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, themeService, sessionManager, cacheManager, eventProvider, sortManager, changeDetectorRef, activatedRoute, applicationSettingManager, employeeService, formatManager, integrationSettingManager, datePipe, searchService, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.themeService = themeService;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.isLowerResolution = false;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.THEME;
        this.resultList = [];
        this.filteredSearchResult = [];
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
            if (this.searchResultSource == SearchResultSource.Dashboard || GlobalFunctions.isEmpty(this.searchStatusQuery))
                this.searchStatusQuery = this.translateService.instant('LBL_THEMES');
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.searchStatusMessage = '';
            if (this.router.url.indexOf(RoutePath.DASHBOARD) === -1)
                this.searchParameteriseTheme();
            else
                this.searchAllTheme();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchAllTheme() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.themeService.search('', false, '', '', '', this.searchResultFound, this.updateSearchStatus, null);
    }
    searchParameteriseTheme() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.themeService.search(this.searchStatusQuery, false, AlternateSearchType.None, null, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
};
ThemeSearchResultComponent = __decorate([
    Component({
        selector: 'theme-search-result',
        templateUrl: './theme-search-result.component.html',
        styleUrls: ['./theme-search-result.component.scss']
    })
], ThemeSearchResultComponent);
export { ThemeSearchResultComponent };
//# sourceMappingURL=theme-search-result.component.js.map