var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SearchDto } from 'src/app/core/models/common/searchDto';
import { StringCriteriaDto } from 'src/app/core/models/common/string-criteria';
import { ThemeSearchField } from 'src/app/core/models/jkc-object/jkc-object';
import { BaseRelatedViewComponent } from '../base-related-view';
let ThemePageComponent = class ThemePageComponent extends BaseRelatedViewComponent {
    constructor(router, themeService, sessionManager, translateService) {
        super(router, sessionManager, translateService);
        this.router = router;
        this.themeService = themeService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.themes = [];
        this.themeTitle = this.translateService.instant("LBL_THEMES");
        this.searchResponse = this.searchResponse.bind(this);
    }
    ngOnInit() {
        let themeIdList = "";
        this.relatedEntity.entityObject.forEach(relatedLink => themeIdList = themeIdList + "'" + relatedLink.content.Id + "',");
        if (themeIdList.length > 0) {
            let searchDto = new SearchDto();
            let stringCriteria = new StringCriteriaDto();
            stringCriteria.Name = ThemeSearchField.Id;
            stringCriteria.Value = themeIdList.substr(0, themeIdList.length - 1);
            searchDto.StringCriteriaList.push(stringCriteria);
            this.themeService.advancedSearch(searchDto, "", "", "", this.searchResponse, null, null);
        }
    }
    searchResponse(response) {
        if (response?.length > 0) {
            this.sessionManager.setBgColorBasedOnObjectSource(response);
            this.themes = response;
        }
    }
    recentToggle(relatedEntity) {
        super.recentToggle(relatedEntity);
        this.ngOnInit();
    }
};
ThemePageComponent = __decorate([
    Component({
        selector: 'theme-page-related-view',
        templateUrl: './theme-page.component.html',
        styleUrls: ['./theme-page.component.scss']
    })
], ThemePageComponent);
export { ThemePageComponent };
//# sourceMappingURL=theme-page.component.js.map