var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BaseRelatedViewComponent } from '../base-related-view';
let LinksComponent = class LinksComponent extends BaseRelatedViewComponent {
    constructor(router, linkService, sessionManager, translateService) {
        super(router, sessionManager, translateService);
        this.router = router;
        this.linkService = linkService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.links = [];
        this.linkTitle = this.translateService.instant("LBL_LINKS");
        this.linkDetailFound = this.linkDetailFound.bind(this);
    }
    ngOnInit() {
        this.linkService.fetchDetail(null, this.linkDetailFound, this.relatedEntity.entityObject.map(link => link.content));
    }
    linkDetailFound(response) {
        if (!GlobalFunctions.isEmpty(response?.LinkDtoList)) {
            this.sessionManager.setBgColorBasedOnObjectSource(response.LinkDtoList);
            this.links = response.LinkDtoList;
        }
    }
    recentToggle(relatedEntity) {
        super.recentToggle(relatedEntity);
        this.ngOnInit();
    }
};
LinksComponent = __decorate([
    Component({
        selector: 'links-related-view',
        templateUrl: './link.component.html',
        styleUrls: ['./link.component.scss']
    })
], LinksComponent);
export { LinksComponent };
//# sourceMappingURL=link.component.js.map