var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AttachmentType } from 'src/app/core/enums/files-enum';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import { BaseRelatedViewComponent } from '../base-related-view';
let FileEntityComponent = class FileEntityComponent extends BaseRelatedViewComponent {
    constructor(router, dialog, fileService, sessionManager, downloadService, translateService) {
        super(router, sessionManager, translateService);
        this.router = router;
        this.dialog = dialog;
        this.fileService = fileService;
        this.sessionManager = sessionManager;
        this.downloadService = downloadService;
        this.translateService = translateService;
        this.files = [];
        this.fileEntityTitle = this.translateService.instant("LBL_FILE_ENTITY");
        this.subs = new SubSink();
        this.fileDetailFound = this.fileDetailFound.bind(this);
    }
    ngOnInit() {
        this.fileService.fetchDetail(null, this.fileDetailFound, this.relatedEntity.entityObject.map(file => file.content));
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    fileDetailFound(response) {
        if (!GlobalFunctions.isEmpty(response?.FileDtoList)) {
            const files = [];
            response.FileDtoList.forEach(file => {
                if (!GlobalFunctions.isEmpty(file)) {
                    file.Type = file.Type + '_24';
                    files.push(file);
                }
            });
            this.files = files;
        }
    }
    downloadFile(file) {
        if (!GlobalFunctions.isEmpty(file.TicketId))
            this.subs.sink = this.downloadService.downloadFile(file.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
        else {
            let helpText = "";
            if (file.AttachmentType == AttachmentType.Upload)
                helpText = this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND_MESSAGE");
            else
                helpText = this.translateService.instant("LBL_FILE_ENTITY_LINK_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FILE_ENTITY_NOT_FOUND"), helpText, this.translateService.instant("LBL_FILE_ENTITY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    recentToggle(relatedEntity) {
        super.recentToggle(relatedEntity);
        this.ngOnInit();
    }
};
FileEntityComponent = __decorate([
    Component({
        selector: 'file-entity-related-view',
        templateUrl: './file-entity.component.html',
        styleUrls: ['./file-entity.component.scss']
    })
], FileEntityComponent);
export { FileEntityComponent };
//# sourceMappingURL=file-entity.component.js.map