var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseRelatedViewComponent } from '../base-related-view';
let EmployeeComponent = class EmployeeComponent extends BaseRelatedViewComponent {
    constructor(router, cacheManager, employeeService, sessionManager, translateService) {
        super(router, sessionManager, translateService);
        this.router = router;
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.employees = [];
        this.employeeEntityTitle = this.translateService.instant("LBL_EMPLOYEES");
    }
    ngOnInit() {
        const employees = [];
        for (let e = 0; e < this.relatedEntity.entityObject.length; e++)
            employees.push(this.cacheManager.getEmployeeById(this.relatedEntity.entityObject[e].content.Id));
        if (employees.length <= 15)
            this.employeeService.setEmployeeAvailability(employees);
        else {
            let selectedEmpCount = 0;
            while (selectedEmpCount < employees.length) {
                this.employeeService.setEmployeeAvailability(employees.slice(selectedEmpCount, selectedEmpCount + 15));
                selectedEmpCount += 15;
            }
        }
        this.employees = employees;
    }
    recentToggle(relatedEntity) {
        super.recentToggle(relatedEntity);
        this.ngOnInit();
    }
};
EmployeeComponent = __decorate([
    Component({
        selector: 'employee-related-view',
        templateUrl: './employee.component.html',
        styleUrls: ['./employee.component.scss']
    })
], EmployeeComponent);
export { EmployeeComponent };
//# sourceMappingURL=employee.component.js.map