var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ThemeSectionDefaultPosition, ThemeSectionType, ThemeSectionTypeCultureKey } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BaseDialogComponent } from '../../../../common/base-dialog.component';
let ArrangeThemeSectionComponent = class ArrangeThemeSectionComponent extends BaseDialogComponent {
    constructor(userSettingManager, systemComponentService, dialogRef) {
        super();
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.dialogRef = dialogRef;
        this.leftSideSections = [];
        this.rightSideSections = [];
        this.showSectionErrorMessage = false;
    }
    ngOnInit() {
        try {
            let userSetting = this.userSettingManager.getUserSettingValueByKey("ThemeSectionArrangement");
            if (!GlobalFunctions.isEmpty(userSetting)) {
                for (let section in ThemeSectionDefaultPosition) {
                    if (GlobalFunctions.isNumber(section) && !userSetting.includes(";" + section) && !userSetting.includes(section + ";") && !userSetting.includes(section + "|"))
                        userSetting = userSetting + ";" + section;
                }
                const leftSide = (userSetting.split('|')[0]).split(';');
                if (leftSide?.length > 0)
                    leftSide.forEach(section => this.leftSideSections.push(ThemeSectionTypeCultureKey[section]));
                const rightSide = (userSetting.split('|')[1]).split(';');
                if (rightSide?.length > 0)
                    rightSide.forEach(section => this.rightSideSections.push(ThemeSectionTypeCultureKey[section]));
            }
            else {
                let counter = 1;
                for (let section in ThemeSectionDefaultPosition) {
                    if (ThemeSectionDefaultPosition.hasOwnProperty(section) && !/^\d+$/.test(section)) {
                        if (counter <= 5)
                            this.leftSideSections.push(ThemeSectionTypeCultureKey[ThemeSectionType[section]]);
                        else
                            this.rightSideSections.push(ThemeSectionTypeCultureKey[ThemeSectionType[section]]);
                        counter++;
                    }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ngAfterViewInit() {
        $("#sortable1, #sortable2").sortable({ connectWith: ".sortable" }).disableSelection();
    }
    saveSectionOrder() {
        if ($('#sortable1 li').length < 4 || $('#sortable2 li').length < 4)
            return this.showSectionErrorMessage = true;
        else
            this.showSectionErrorMessage = false;
        let themeSectionsArrangement = '';
        $('#sortable1 li').each((i, element) => themeSectionsArrangement = themeSectionsArrangement + ThemeSectionTypeCultureKey[element.getAttribute('key')] + ';');
        themeSectionsArrangement = themeSectionsArrangement.slice(0, -1) + '|';
        $('#sortable2 li').each((i, element) => themeSectionsArrangement = themeSectionsArrangement + ThemeSectionTypeCultureKey[element.getAttribute('key')] + ';');
        themeSectionsArrangement = themeSectionsArrangement.slice(0, -1);
        this.systemComponentService.updateUserSettingForThemeSectionsArrangement(themeSectionsArrangement);
        this.userSettingManager.setUserSettingValueByKey("ThemeSectionArrangement", themeSectionsArrangement);
        this.close(true);
    }
    close(result) {
        return this.dialogRef.close(result);
    }
};
ArrangeThemeSectionComponent = __decorate([
    Component({
        selector: 'arrange-theme-section',
        templateUrl: './arrange-theme-section.component.html',
        styleUrls: ['./arrange-theme-section.component.scss']
    })
], ArrangeThemeSectionComponent);
export { ArrangeThemeSectionComponent };
//# sourceMappingURL=arrange-theme-section.component.js.map