var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { FileUploadSource, KeyCode, RecordOperationMode, ScreenMode, ThemeSectionDefaultPosition, ThemeSectionType, ThemeSectionTypeCultureKey } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { CreateOrUpdateThemeRequest } from '../../../../core/models/theme/create-update-theme-request';
import { ThemeSettingDto } from '../../../../core/models/theme/theme-settingDto';
import { ThemeDto } from '../../../../core/models/theme/themeDto';
import { BroadCastEventKeys, EntityName, RoutePath, TinyMCE } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { TagsInputComponent } from '../../../common/tags-input/tags-input.component';
let X2JS = require('x2js');
let ThemeAddEditComponent = class ThemeAddEditComponent extends BaseDialogComponent {
    constructor(translateService, sessionManager, userService, integrationSettingManager, themeService, dialogManager, dialog, applicationSettingManager, datepipe, fileService, router, eventProvider, cacheManager, systemComponentService, fileManager) {
        super();
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.userService = userService;
        this.integrationSettingManager = integrationSettingManager;
        this.themeService = themeService;
        this.dialogManager = dialogManager;
        this.dialog = dialog;
        this.applicationSettingManager = applicationSettingManager;
        this.datepipe = datepipe;
        this.fileService = fileService;
        this.router = router;
        this.eventProvider = eventProvider;
        this.cacheManager = cacheManager;
        this.systemComponentService = systemComponentService;
        this.fileManager = fileManager;
        this.themeSettingsLength = 8;
        this.themeDto = new ThemeDto();
        this.title = this.translateService.instant("LBL_ADD_THEME").toUpperCase();
        this.opened = false;
        this.sectionRows = [];
        this.sectionsObjectList = [];
        this.themeSources = [];
        this.selectedSource = null;
        this.styleSettings = [];
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.isLocalGroupEnabled = this.localUserGroups && this.localUserGroups.length > 0;
        this.editMode = this.sessionManager.jkcParentPanel.parameters.EditMode;
        this.themeSessionData = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.keywords = [];
        this.DateJS = Date;
        this.selectedValue = undefined;
        this.uploadedFile = null;
        this.subs = new SubSink();
        this.themeEditorId = "tinymceTheme" + GlobalFunctions.getGuid();
        this.timeoutIds = [];
        this.createOrUpdateThemeCallback = this.createOrUpdateThemeCallback.bind(this);
        this.createOrUpdateThemeErrorCallback = this.createOrUpdateThemeErrorCallback.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.sessionManager.startSessionIfPossible("THEME", this.sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        this.init();
        this.initEditor();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    clickedOut() {
        this.tagsInputComponent.addTagFromInput();
    }
    getByValue(arr, value) {
        for (let i = 0; i < arr.length; i++) {
            if (arr[i]._Id == value)
                return i;
        }
    }
    init() {
        try {
            this.timeoutIds.push(setTimeout(() => this.resize(), 500));
            let sourceResult = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Themes_Entities_Theme, "SOURCECONFIGURATION");
            if (!GlobalFunctions.isEmpty(sourceResult))
                this.themeSources = GlobalFunctions.getThemeSourceSetting(sourceResult);
            let row = 0, counter = 1;
            this.sectionRows.push(row);
            if (this.editMode) {
                this.title = this.translateService.instant("LBL_EDIT_THEME").toUpperCase();
                this.themeDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.selectedValue = this.themeSources[this.getByValue(this.themeSources, this.themeDto.SourceConfigurationId)];
                if (GlobalFunctions.isEmpty(this.themeDto.Settings))
                    this.themeDto.Settings = [];
                for (let section in ThemeSectionDefaultPosition) {
                    if (ThemeSectionDefaultPosition.hasOwnProperty(section) && !/^\d+$/.test(section)) {
                        let sectionObject = new Object();
                        sectionObject.row = row;
                        sectionObject.sectionTypeKey = ThemeSectionType[section];
                        sectionObject.sectionName = ThemeSectionTypeCultureKey[ThemeSectionType[section]];
                        sectionObject.isMarked = jlinq.from(this.themeDto.Settings).equals("SectionType", ThemeSectionType[section]).any();
                        this.sectionsObjectList.push(sectionObject);
                        if (counter == 5) {
                            counter = 1;
                            row++;
                            this.sectionRows.push(row);
                        }
                        else
                            counter++;
                    }
                }
                if (this.themeDto.Keywords != null && this.themeDto.Keywords.length > 0)
                    this.themeDto.Keywords.forEach(keyword => this.keywords.push({ text: keyword }));
                this.keywords.sort((a, b) => a.text.localeCompare(b.text));
            }
            else {
                for (let section in ThemeSectionDefaultPosition) {
                    if (ThemeSectionDefaultPosition.hasOwnProperty(section) && !/^\d+$/.test(section)) {
                        let sectionObject = new Object();
                        sectionObject.row = row;
                        sectionObject.sectionTypeKey = ThemeSectionType[section];
                        sectionObject.sectionName = ThemeSectionTypeCultureKey[ThemeSectionType[section]];
                        sectionObject.isMarked = true;
                        this.sectionsObjectList.push(sectionObject);
                        if (counter == 5) {
                            counter = 1;
                            row++;
                            this.sectionRows.push(row);
                        }
                        else
                            counter++;
                    }
                }
                if (this.themeSessionData != null) {
                    this.assignThemeSessionToDto(this.themeSessionData);
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    assignThemeSessionToDto(sessionData) {
        this.themeDto.Description = this.themeSessionData.Description;
        this.themeDto.IsPublished = this.themeSessionData.IsPublished;
        this.themeDto.Title = this.themeSessionData.Title;
        this.themeDto.Keywords = this.themeSessionData.Keywords;
        this.themeDto.ManageLocalGroupPrivilege = this.themeSessionData.ManageLocalGroupPrivilege;
        this.sectionsObjectList = this.themeSessionData.SectionObjectList;
        this.themeSources = this.themeSessionData.ThemeSources;
    }
    changeSelect() {
        this.selectedSource = this.selectedValue;
    }
    createTheme() {
        if (GlobalFunctions.editorIsEmpty(this.themeDto.Description) || this.form.invalid)
            return;
        if (!GlobalFunctions.isEmpty(this.selectedSource))
            this.themeDto.SourceConfigurationId = this.selectedSource._Id;
        this.startSpinner();
        this.setThemeDto();
        let req = new CreateOrUpdateThemeRequest();
        req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
        req.ThemeDto = this.themeDto;
        this.themeService.addTheme(req, this.createOrUpdateThemeCallback, this.createOrUpdateThemeErrorCallback);
    }
    createOrUpdateThemeCallback(response) {
        if (response.Result == 0 && response.ThemeDto != null) {
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = response.ThemeDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.THEME}`;
            if (!this.editMode)
                this.sessionManager.addBreadcrumbItems([response.ThemeDto], null, RoutePath.DETAIL_PATH);
            else {
                let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.sessionManager.addBreadcrumbItems([response.ThemeDto], null, RoutePath.DETAIL_PATH);
                this.cacheManager.updateDashboardCache(response.ThemeDto);
            }
            if (this.editMode)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
            else
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.THEME]);
        }
        else {
            if (response.Result == 2)
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_THEME"), textMsg: this.translateService.instant("LBL_THEME_EXISTS_MESSAGE") });
        }
        this.stopSpinner();
    }
    createOrUpdateThemeErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_THEME")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_THEME"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    setThemeDto() {
        if (!this.editMode)
            this.themeDto.CreatedBy = GlobalFunctions.getLoggedInUserId();
        this.themeDto.LastChangedDate = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.themeDto.Settings = [];
        this.sectionsObjectList.forEach(section => {
            if (section.isMarked == true) {
                let themeSettingDto = new ThemeSettingDto();
                themeSettingDto.SectionType = ThemeSectionType[section.sectionTypeKey];
                themeSettingDto.Ordering = ThemeSectionDefaultPosition[themeSettingDto.SectionType];
                this.themeDto.Settings.push(themeSettingDto);
            }
        });
        this.themeDto.StringRepresentation = "";
        this.sessionManager.setBreadcrumbGrammer(this.themeDto);
        this.themeDto.Keywords = new Array();
        if (this.keywords != null && this.keywords.length > 0)
            this.keywords.forEach(keyword => this.themeDto.Keywords.push(keyword.text));
    }
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        $("#themeContainer").height($("#jkcParentPanel").height() - $("#createThemeHeader").height() - $("#createThemeFooter").height() + "px");
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    manageLocalGroupPrivilege() {
        this.dialogManager.manageBlockWiseLocalGroupPrivilege(this.localUserGroups, this.themeDto.ManageLocalGroupPrivilege, this.editor.getContent()).afterClosed().subscribe(manageLocalGroupPrivilege => this.themeDto.ManageLocalGroupPrivilege = manageLocalGroupPrivilege);
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    removeAllStylesAndClasses(node) {
        let allElements = node.getElementsByTagName('*');
        if (!GlobalFunctions.isEmpty(allElements)) {
            for (let i = 0; i < allElements.length; i++) {
                allElements[i].setAttribute('style', '');
                allElements[i].setAttribute('class', '');
            }
        }
    }
    convertHtmlHeadersIntoThemeHeaders(node) {
        let doc = new DOMParser().parseFromString(node.innerHTML, 'text/html');
        let defaultHeaderStyle = 'color: #34b7db';
        let defaultSubHeaderStyle = 'color: #34b7db';
        if (!GlobalFunctions.isEmpty(this.styleSettings) && !GlobalFunctions.isEmpty(this.styleSettings[0]._IsEnabled) && this.styleSettings[0]._IsEnabled.toUpperCase() == "TRUE" && this.styleSettings[0].Style[1] && this.styleSettings[0].Style[2]) {
            defaultHeaderStyle = 'color: ' + this.styleSettings[0].Style[1]._FontColor + ';font-family:' + this.styleSettings[0].Style[1]._FontFamily + ';font-size:' + this.styleSettings[0].Style[1]._FontSize;
            defaultSubHeaderStyle = 'color: ' + this.styleSettings[0].Style[2]._FontColor + ';font-family:' + this.styleSettings[0].Style[2]._FontFamily + ';font-size:' + this.styleSettings[0].Style[2]._FontSize;
        }
        let mainHeaders = doc.getElementsByTagName('h2');
        if (mainHeaders != null && mainHeaders.length > 0) {
            for (let i = 0; i < mainHeaders.length; i++) {
                mainHeaders[i].setAttribute('style', defaultHeaderStyle);
                mainHeaders[i].setAttribute('class', 'themeheadermain');
            }
        }
        let subHeaders = doc.getElementsByTagName('h3');
        if (subHeaders != null && subHeaders.length > 0) {
            for (let i = 0; i < subHeaders.length; i++) {
                subHeaders[i].setAttribute('style', defaultSubHeaderStyle);
                subHeaders[i].setAttribute('class', 'themeheadersub');
            }
        }
        return doc.documentElement.innerHTML.replace(/<h2/g, '<span').replace(/h2>/g, 'span>').replace(/<h3/g, '<span').replace(/h3>/g, 'span>');
    }
    addDefaultLocalGroupAccess(manageLocalGroupPrivilege, blockId) {
        let defaultLocalGroups = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Themes_Entities_Theme, "DEFAULTLOCALGROUPBLOCKACCESS");
        if (!GlobalFunctions.isEmpty(defaultLocalGroups) && this.isLocalGroupEnabled) {
            let defaultLocalGroupList = defaultLocalGroups.split(';');
            let defaultManageLocalGroupPrivilege = "";
            defaultLocalGroupList.forEach(defaultLocalGroup => {
                let localGroup = jlinq.from(this.localUserGroups).equals("Name", defaultLocalGroup).first();
                if (!GlobalFunctions.isEmpty(localGroup)) {
                    if (GlobalFunctions.isEmpty(defaultManageLocalGroupPrivilege))
                        defaultManageLocalGroupPrivilege = localGroup.Id;
                    else
                        defaultManageLocalGroupPrivilege = defaultManageLocalGroupPrivilege + "," + localGroup.Id;
                }
            });
            if (!GlobalFunctions.isEmpty(defaultManageLocalGroupPrivilege)) {
                defaultManageLocalGroupPrivilege = blockId + "|" + defaultManageLocalGroupPrivilege;
                if (GlobalFunctions.isEmpty(manageLocalGroupPrivilege))
                    manageLocalGroupPrivilege = defaultManageLocalGroupPrivilege;
                else
                    manageLocalGroupPrivilege = manageLocalGroupPrivilege + ";" + defaultManageLocalGroupPrivilege;
            }
        }
        return manageLocalGroupPrivilege;
    }
    ;
    initEditor() {
        try {
            let currentFormat = 'description'; // set default format - Normal
            const checkCurrentFormat = (editor) => {
                if (editor.formatter.match('mainheader'))
                    currentFormat = 'mainheader';
                else if (editor.formatter.match('subheader'))
                    currentFormat = 'subheader';
                else if (editor.formatter.match('description'))
                    currentFormat = 'description';
            };
            let configuredStyle = {
                toolbarOptions: '',
                block_formats: '',
                formats: {},
                content_style: ''
            };
            configuredStyle.toolbarOptions = 'undo redo | fontfamily blocks fontsize | bold italic underline | removeformat alignleft aligncenter alignright | bullist numlist | outdent indent | table | forecolor backcolor | link unlink image | sections';
            configuredStyle.block_formats = this.translateService.instant("LBL_HEADING") + '=mainheader; ' + this.translateService.instant("LBL_SUB_HEADING") + '=subheader;' + this.translateService.instant("LBL_NORMAL") + '=description;';
            configuredStyle.formats = {
                mainheader: { attributes: { class: "themeheadermain" }, inline: 'span', styles: { color: '#34b7db' } },
                subheader: { attributes: { class: "themeheadersub" }, inline: 'span', styles: { color: '#34b7db' } },
                description: { attributes: { class: "themedescription" }, inline: 'span', styles: { color: 'black' } }
            };
            configuredStyle.content_style = "p {margin: 0; padding: 0}";
            let xmlStyleText = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Themes_Entities_Theme, "STYLECONFIGURATION");
            if (!GlobalFunctions.isEmpty(xmlStyleText)) {
                let x2js = new X2JS();
                let jsonObj = x2js.xml2js(xmlStyleText);
                this.styleSettings.push(jsonObj.Styles);
                if (!GlobalFunctions.isEmpty(this.styleSettings) && !GlobalFunctions.isEmpty(this.styleSettings[0]._IsEnabled) && this.styleSettings[0]._IsEnabled.toUpperCase() == "TRUE") {
                    configuredStyle.toolbarOptions = 'undo redo | blocks | bold italic underline | removeformat alignleft aligncenter alignright | bullist numlist | outdent indent | table | link unlink image | sections';
                    configuredStyle.formats = {
                        mainheader: { attributes: { class: "themeheadermain" }, inline: 'span', styles: { color: this.styleSettings[0].Style[1]._FontColor, fontFamily: this.styleSettings[0].Style[1]._FontFamily, fontSize: this.styleSettings[0].Style[1]._FontSize } },
                        subheader: { attributes: { class: "themeheadersub" }, inline: 'span', styles: { color: this.styleSettings[0].Style[2]._FontColor, fontFamily: this.styleSettings[0].Style[2]._FontFamily, fontSize: this.styleSettings[0].Style[2]._FontSize } },
                        description: { attributes: { class: "themedescription" }, inline: 'span', styles: { color: this.styleSettings[0].Style[0]._FontColor, fontFamily: this.styleSettings[0].Style[0]._FontFamily, fontSize: this.styleSettings[0].Style[0]._FontSize } }
                    };
                    configuredStyle.content_style = "p {margin: 0; padding: 0; color:" + this.styleSettings[0].Style[0]._FontColor + ";font-family:" + this.styleSettings[0].Style[0]._FontFamily + ";font-size:" + this.styleSettings[0].Style[0]._FontSize + ";}" + " body, td, th {color:" + this.styleSettings[0].Style[0]._FontColor + " !important; font-family:" + this.styleSettings[0].Style[0]._FontFamily + " !important; font-size:" + this.styleSettings[0].Style[0]._FontSize + " !important;}";
                }
            }
            this.tinymceOptions = {
                base_url: '/tinymce',
                plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime media table code help wordcount',
                iframe_aria_text: GlobalFunctions.removeHTMLTags(this.themeDto.Description),
                toolbar: configuredStyle.toolbarOptions,
                placeholder: this.translateService.instant("LBL_THEME_DESCRIPTION_PLACEHOLDER"),
                default_link_target: '_blank',
                block_formats: configuredStyle.block_formats,
                formats: configuredStyle.formats,
                resize: false,
                contextmenu: false,
                browser_spellcheck: true,
                elementpath: false,
                menubar: false,
                font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
                font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
                apply_source_formatting: true,
                statusbar: false,
                entity_encoding: 'raw',
                content_style: configuredStyle.content_style,
                height: $(window).height() - 365 + 'px',
                file_picker_types: 'image',
                media_poster: false,
                media_alt_source: false,
                paste_postprocess: (plugin, args) => {
                    if (args.node) {
                        this.removeAllStylesAndClasses(args.node);
                        if (!GlobalFunctions.isEmpty(args.node.innerHTML))
                            args.node.innerHTML = this.convertHtmlHeadersIntoThemeHeaders(args.node);
                        args.node.setAttribute('id', '42');
                    }
                },
                paste_data_images: true,
                images_upload_base_path: '/assets/images/theme/',
                force_br_newlines: false,
                forced_root_block: 'div',
                init_instance_callback: (editor) => {
                    console.log("init_instance_callback");
                    GlobalFunctions.setEditorBodyHeight();
                    this.editor = editor;
                    if (!GlobalFunctions.isEmpty(this.styleSettings) && !GlobalFunctions.isEmpty(this.styleSettings[0]._IsEnabled) && this.styleSettings[0]._IsEnabled.toUpperCase() == "TRUE") {
                        editor.execCommand("fontSize", false, this.styleSettings[0].Style[0]._FontSize);
                        this.timeoutIds.push(setTimeout(() => { $("#themeTitleTextField").focus(); }, 200));
                        if (this.editMode && !GlobalFunctions.isEmpty(currentFormat)) {
                            checkCurrentFormat(editor);
                            editor.formatter.remove('description');
                            editor.formatter.apply(currentFormat);
                        }
                        else
                            editor.formatter.apply('description');
                    }
                    editor.on('keydown', (e) => {
                        let event = e;
                        let editorContent = editor.getContent();
                        if (GlobalFunctions.isEmpty(editorContent)) {
                            let allLabels = $('#themeEditorDiv label');
                            if (!GlobalFunctions.isEmpty(allLabels)) {
                                let placeholderLabel = allLabels[allLabels.length - 1];
                                if (!GlobalFunctions.isEmpty(placeholderLabel))
                                    $(placeholderLabel).hide();
                            }
                        }
                        switch (event.key.toLocaleLowerCase()) {
                            case KeyCode.Escape: {
                                this.close(false);
                                break;
                            }
                            case KeyCode.Tab: {
                                if (KeyCode.Shift)
                                    editor.execCommand('Outdent');
                                else {
                                    let selectedContent = editor.selection.getContent();
                                    if (!GlobalFunctions.isEmpty(selectedContent) || editor.queryCommandState('InsertOrderedList') || editor.queryCommandState('InsertUnorderedList'))
                                        editor.execCommand('Indent');
                                    else
                                        editor.execCommand('mceInsertContent', false, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"); // inserts tab
                                }
                                e.preventDefault();
                                e.stopPropagation();
                                return false;
                            }
                        }
                    });
                    editor.on('keyup', (e) => {
                        let event = e;
                        switch (event.key.toLocaleLowerCase()) {
                            case KeyCode.Enter: {
                                try {
                                    let currentNode = editor.selection.getNode();
                                    if (currentNode != null && !GlobalFunctions.isEmpty(currentNode.nodeName) && currentNode.nodeName === 'A')
                                        editor.formatter.apply('description');
                                }
                                catch (e) { }
                                break;
                            }
                            case KeyCode.Backspace: {
                                try {
                                    let currentNode = editor.selection.getNode();
                                    if (currentNode != null && !GlobalFunctions.isEmpty(currentNode.nodeName) && currentNode.nodeName === 'A' && currentNode.host != currentNode.innerText)
                                        editor.execCommand("Unlink", false);
                                }
                                catch (e) { }
                                break;
                            }
                        }
                    });
                    editor.on('click', (e) => {
                        if (!GlobalFunctions.isEmpty(this.styleSettings) &&
                            !GlobalFunctions.isEmpty(this.styleSettings[0]._IsEnabled) &&
                            this.styleSettings[0]._IsEnabled.toUpperCase() == "TRUE" &&
                            !GlobalFunctions.isEmpty(e.target) &&
                            !GlobalFunctions.isEmpty(e.target.nodeName) &&
                            ((e.target.nodeName.toLowerCase() == 'section' &&
                                GlobalFunctions.isEmpty(e.target.innerText)) || (e.target.nodeName.toLowerCase() == 'body' &&
                                editor.selection.getNode() != null &&
                                editor.selection.getNode().className != 'themeheadermain' &&
                                editor.selection.getNode().className != 'themeheadersub')))
                            editor.formatter.apply('description');
                    });
                },
                file_picker_callback: (callback, value, meta) => {
                    this.fileManager.setFilePickerCallback(callback, value, meta, this.editor, EntityName.THEME);
                },
                images_upload_handler: (blobInfo, progress) => {
                    return this.fileManager.setFileUploadHandler(blobInfo, progress, this.tinymceOptions.images_upload_base_path, FileUploadSource.Theme);
                },
                setup: (editor) => {
                    if (this.isLocalGroupEnabled) {
                        editor.ui.registry.addButton('sections', {
                            text: this.translateService.instant("LBL_ADD_BLOCK"),
                            onAction: () => {
                                try {
                                    let tempContent = editor.getContent();
                                    let uniqueId = GlobalFunctions.createGuid().replace(/-/g, '');
                                    tempContent = tempContent + '<br/><section id="' + uniqueId + '" style="border: lightgray 2px solid;min-height:150px;height:auto;" tabindex="0">  </section> <br/> <br/> <br/>';
                                    editor.setContent(tempContent);
                                    let editorWindow = document.getElementsByTagName('iframe');
                                    if (editorWindow != null) {
                                        let body = editorWindow[0].contentWindow.document.getElementById('tinymce');
                                        body.style.height = editorWindow[0].style.height;
                                        editorWindow[0].contentWindow.scrollTo(0, body.scrollHeight);
                                    }
                                    this.themeDto.ManageLocalGroupPrivilege = this.addDefaultLocalGroupAccess(this.themeDto.ManageLocalGroupPrivilege, uniqueId);
                                    this.timeoutIds.push(setTimeout(() => {
                                        let secElem = editor.contentWindow.document.getElementById(uniqueId);
                                        if (secElem != null) {
                                            editor.focus();
                                            let secNode = editor.selection.select(secElem, true);
                                            editor.selection.setCursorLocation(secNode, 0);
                                            editor.formatter.apply('description');
                                        }
                                    }, 500));
                                }
                                catch (e) {
                                    console.error(e.message);
                                }
                            }
                        });
                    }
                    editor.on('keydown', (e) => {
                        let event = e;
                        if (event.shiftKey && event.key.toLowerCase() === 'enter') {
                            // Shift + Enter: break current style by adding a new empty line block
                            editor.execCommand('mceInsertContent', false, '<div><br></div>');
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        else if (event.key.toLowerCase() === KeyCode.Enter) {
                            try {
                                let currentNode = editor.selection.getNode();
                                if (currentNode != null && !GlobalFunctions.isEmpty(currentNode.className) && (currentNode.className === 'themeheadermain' || currentNode.className === 'themeheadersub')) {
                                    checkCurrentFormat(editor);
                                    if (currentNode.outerHTML.indexOf('<br><br>') != -1) {
                                        currentNode.outerHTML = currentNode.outerHTML.replace(/<br><br>/g, '<br>'); //Remove extra line-break
                                        editor.execCommand('mceInsertContent', false, '<br>'); //Add line-break
                                    }
                                }
                            }
                            catch (exception) {
                                ExceptionHelper.showException(null, null, false, e.message, "");
                            }
                        }
                        else if (event.key.toLowerCase() === KeyCode.Arrowdown || event.key.toLowerCase() === KeyCode.ArrowUp) {
                            this.timeoutIds.push(setTimeout(() => {
                                checkCurrentFormat(editor);
                                editor.formatter.apply(currentFormat);
                            }));
                        }
                    });
                }
            };
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    changeSelection(selectedSection, $event) {
        this.sectionsObjectList.forEach(section => {
            if (selectedSection.sectionTypeKey == section.sectionTypeKey) {
                selectedSection.isMarked = $event.target.checked;
                return;
            }
        });
    }
    close(result) {
        this.editor.remove();
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], ThemeAddEditComponent.prototype, "form", void 0);
__decorate([
    ViewChild('input')
], ThemeAddEditComponent.prototype, "inputElementRef", void 0);
__decorate([
    ViewChild(TagsInputComponent)
], ThemeAddEditComponent.prototype, "tagsInputComponent", void 0);
__decorate([
    HostListener("document:click")
], ThemeAddEditComponent.prototype, "clickedOut", null);
ThemeAddEditComponent = __decorate([
    Component({
        selector: 'theme-add-edit',
        templateUrl: './theme-add-edit.component.html',
        styleUrls: ['./theme-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ThemeAddEditComponent);
export { ThemeAddEditComponent };
//# sourceMappingURL=theme-add-edit.component.js.map