var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from "@angular/core";
import { TaskStatus } from "../../../core/enums/task-enum";
import { RoutePath } from "../../../shared/constants";
import { GlobalFunctions } from "../../../shared/global-functions";
import { DialogHelper } from "../../../shared/helper/dialog-helper";
import { BaseViewerComponent } from "../../common/base-viewer.component";
import { MessageboxComponent } from "../../common/messagebox/messagebox.component";
let TaskViewerComponent = class TaskViewerComponent extends BaseViewerComponent {
    constructor(router, dialog, taskService, cacheManager, phoneManager, dialogManager, sessionManager, employeeService, translateService, contactHistoryService, applicationSettingManager) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.attempts = [];
        this.loadedFromDeeplink = false;
        this.fetchTaskViewerResponse = this.fetchTaskViewerResponse.bind(this);
        this.relatedCallbackAttemptResultFound = this.relatedCallbackAttemptResultFound.bind(this);
    }
    ngOnInit() {
        if (this.selectedViewerEntity && this.selectedViewerEntity.Partial) {
            if (this.selectedViewerEntity.Type && !GlobalFunctions.isEmpty(this.selectedViewerEntity.Type))
                this.selectedViewerEntity.TaskType = this.selectedViewerEntity.Type;
            this.taskService.fetchDetail(this.selectedViewerEntity, this.fetchTaskViewerResponse);
        }
        else {
            if (this.selectedViewerEntity != null) {
                this.setTaskViewer();
                this.loadRelatedSession();
            }
        }
    }
    loadRelatedSession() {
        if (this.selectedViewerEntity.TaskType.toLowerCase() == 'callbacknote' || this.selectedViewerEntity.TaskType.toLowerCase() == 'appointment')
            this.contactHistoryService.searchRelatedCallbackAttemptToEntity(GlobalFunctions.toContentType("TASK"), this.selectedViewerEntity, this.uniqueId, this.relatedCallbackAttemptResultFound);
    }
    ;
    fetchTaskViewerResponse(taskDto) {
        if (this.employeeService.isEmployeesReceived)
            this.processTaskViewerResponse();
        else
            this.employeeService.globalEventEmployeeFetchCompleted = this.processTaskViewerResponse;
    }
    ;
    processTaskViewerResponse() {
        if (this.selectedViewerEntity.CurrentStatus == TaskStatus.HandledByReply || this.selectedViewerEntity.CurrentStatus == TaskStatus.Handled) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_' + this.selectedViewerEntity.TaskType.toUpperCase()), textMsg: this.translateService.instant('LBL_MSG_HANDLED_TASK') });
            this.router.navigate([RoutePath.DASHBOARD]);
        }
        else {
            this.selectedViewerEntity.ContactPhoneNumbers = !GlobalFunctions.isEmpty(this.selectedViewerEntity.ContactPhoneNumber) ? this.selectedViewerEntity.ContactPhoneNumber.split('/') : this.selectedViewerEntity.ContactPhoneNumbers;
            if (this.selectedViewerEntity != null) {
                this.setTaskViewer();
                this.loadRelatedSession();
            }
        }
    }
    ;
    relatedCallbackAttemptResultFound(result, contentType, title) {
        this.attempts = [];
        result.forEach(attempt => {
            attempt.HandlerDto.HandlerObject = this.cacheManager.getEmployeeById(attempt.HandlerDto.UserId);
            this.attempts.push(attempt);
        });
        let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("EmployeeDto_Popup");
        if (!GlobalFunctions.isEmpty(getGrammerValue) && this.attempts != null && this.attempts.length > 0)
            this.attempts.forEach(callbackAttempt => GlobalFunctions.setStringPresentation(callbackAttempt.HandlerDto.HandlerObject, getGrammerValue));
    }
    ;
    showHistory() {
        this.dialogManager.openJsPanelOrDialog('entity_history');
    }
    ;
    setTaskViewer() {
        if (this.selectedViewerEntity.TaskHistoryList?.length > 0) {
            for (let index = 0; index < this.selectedViewerEntity.TaskHistoryList.length; index++) {
                this.selectedViewerEntity.TaskHistoryList[index].HandlerTextList = GlobalFunctions.getTaskHandlerNameList(this.selectedViewerEntity.TaskHistoryList[index].TaskHandlerList, this.cacheManager);
                this.selectedViewerEntity.TaskHistoryList[index].CreatedBy = this.cacheManager.getEmployeeById(this.selectedViewerEntity.TaskHistoryList[index].CreatedById);
                this.selectedViewerEntity.CreatedBy = this.cacheManager.getEmployeeById(this.selectedViewerEntity.CreatedById);
            }
        }
        this.selectedViewerEntity.PriorityText = GlobalFunctions.getPriorityText(this.selectedViewerEntity.Priority, this.translateService);
        this.selectedViewerEntity.PublishToText = GlobalFunctions.getPublishText(this.selectedViewerEntity.PublishTo, this.translateService);
        this.selectedViewerEntity.TagList = this.applicationSettingManager.tagSetting.searchTagById(this.selectedViewerEntity.Tags);
    }
};
__decorate([
    Input()
], TaskViewerComponent.prototype, "uniqueId", void 0);
TaskViewerComponent = __decorate([
    Component({
        selector: 'task-viewer',
        template: '<span></span>'
    })
], TaskViewerComponent);
export { TaskViewerComponent };
//# sourceMappingURL=task-viewer.component.js.map