var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from "@angular/core";
import { ContextMenuView } from "src/app/core/enums/common-enums";
import { TaskStatus } from "../../../core/enums/task-enum";
import { ContextMenu } from "../../../core/models/common/context-menu";
import { Menu } from "../../../core/models/common/menu";
import { SourceType } from "../../../core/models/jkc-object/jkc-object";
import { BroadCastEventKeys, RoutePath } from "../../../shared/constants";
import { GlobalFunctions } from "../../../shared/global-functions";
import { DialogHelper } from "../../../shared/helper/dialog-helper";
import { BaseDetailComponent } from "../../common/base-detail.component";
import { MessageboxComponent } from "../../common/messagebox/messagebox.component";
let TaskDetailComponent = class TaskDetailComponent extends BaseDetailComponent {
    constructor(router, dialog, taskService, cacheManager, phoneManager, eventProvider, searchService, dialogManager, activatedRoute, sessionManager, employeeService, translateService, contextMenuService, contactHistoryService, applicationSettingManager, integrationSettingManager) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.dialogManager = dialogManager;
        this.activatedRoute = activatedRoute;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.contextMenuService = contextMenuService;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.attempts = [];
        this.loadedFromDeeplink = false;
        this.fetchTaskDetailResponse = this.fetchTaskDetailResponse.bind(this);
        this.processTaskDetailResponse = this.processTaskDetailResponse.bind(this);
        this.relatedCallbackAttemptResultFound = this.relatedCallbackAttemptResultFound.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.sessionManager.selectedEntity.Partial = true;
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const id = this.activatedRoute.snapshot.paramMap.get('id');
        GlobalFunctions.removeDeeplinkLocalStorage();
        if (!this.sessionManager.selectedEntity) {
            this.startSpinner();
            this.loadedFromDeeplink = true;
            this.taskService.connect().then(() => this.taskService.fetchDetail({ Id: id, TaskType: this.type, ObjectSource: SourceType.Task_Cdr }, this.fetchTaskDetailResponse));
        }
        else if (this.sessionManager.selectedEntity?.Partial == true) {
            this.startSpinner();
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Type))
                this.sessionManager.selectedEntity.TaskType = this.sessionManager.selectedEntity.Type;
            this.updateTaskHistoryForInformationRequest();
            this.taskService.connect().then(() => this.taskService.fetchDetail(this.sessionManager.selectedEntity, this.fetchTaskDetailResponse));
        }
        else {
            this.addMenuItems();
            this.setTaskDetails();
            this.loadRelatedSession();
            this.sendRelatedRequest.emit();
        }
        this.taskService.lookingOnTask(true, id);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadRelatedSession() {
        if (this.sessionManager.selectedEntity.TaskType.toLowerCase() == 'callbacknote' || this.sessionManager.selectedEntity.TaskType.toLowerCase() == 'appointment')
            this.contactHistoryService.searchRelatedCallbackAttemptToEntity(GlobalFunctions.toContentType("TASK"), this.sessionManager.selectedEntity, this.uniqueId, this.relatedCallbackAttemptResultFound);
    }
    ;
    fetchTaskDetailResponse(response) {
        if (GlobalFunctions.isEmpty(response.DetailDto) || (this.loadedFromDeeplink == true && response.DetailDto.IsClosed == true)) {
            response.Result == 3
                ? DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_UNAUTHORIZED'), textMsg: this.translateService.instant('LBL_UNAUTHORIZED_TASK_MESSAGE') })
                : DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_HANDLED'), textMsg: this.translateService.instant('LBL_MSG_HANDLED_TASK') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
        else {
            this.sessionManager.selectedEntity = response.DetailDto;
            if (!GlobalFunctions.isEmpty(response.DetailDto.SelectedRoleId) && GlobalFunctions.isEmpty(this.sessionManager.selectedRole) && !GlobalFunctions.isEmpty(this.cacheManager.roleList.length > 0)) {
                const role = jlinq.from(this.cacheManager.roleList).equals("Id", response.DetailDto.SelectedRoleId).first();
                if (role)
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.SELECT_ROLE, role);
            }
            if (this.employeeService.isEmployeesReceived)
                this.processTaskDetailResponse();
            else
                this.employeeService.globalEventEmployeeFetchCompleted = this.processTaskDetailResponse;
            this.setLookingOn(response.DetailDto);
        }
    }
    ;
    processTaskDetailResponse() {
        if (this.sessionManager.selectedEntity.IsClosed == false && (this.sessionManager.selectedEntity.CurrentStatus == TaskStatus.HandledByReply || this.sessionManager.selectedEntity.CurrentStatus == TaskStatus.Handled)) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_' + this.sessionManager.selectedEntity.TaskType.toUpperCase()), textMsg: this.translateService.instant('LBL_MSG_HANDLED_TASK') });
            this.router.navigate([RoutePath.DASHBOARD]);
        }
        else {
            this.sessionManager.selectedEntity.ContactPhoneNumbers = !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.ContactPhoneNumber) ? this.sessionManager.selectedEntity.ContactPhoneNumber.split('/') : this.sessionManager.selectedEntity.ContactPhoneNumbers;
            this.sendRelatedRequest.emit();
            if (this.sessionManager.selectedEntity) {
                this.setTaskDetails();
                this.loadRelatedSession();
                if (GlobalFunctions.isEmpty(this.sessionManager.contextMenu) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.TaskType)) {
                    this.sessionManager.loadedFromRelatedView = false;
                    this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${this.sessionManager.selectedEntity.TaskType.toLowerCase()}/${this.sessionManager.selectedEntity.Id}`;
                    this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, this.router.url);
                }
                this.addMenuItems();
                if (this.loadedFromDeeplink) {
                    this.loadedFromDeeplink = false;
                    if (this.sessionManager.selectedEntity.IsMyTask && this.sessionManager.selectedEntity.SubTaskType.toLowerCase() != 'email' && this.sessionManager.selectedEntity.SubTaskType.toLowerCase() != 'socialmedia')
                        this.dialogManager.handleTask(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toUpperCase(), this.sessionManager.headerViewContainerRef);
                }
            }
        }
        this.stopSpinner();
    }
    ;
    relatedCallbackAttemptResultFound(result, contentType, title) {
        this.attempts = [];
        result.forEach(attempt => {
            attempt.HandlerDto.HandlerObject = this.cacheManager.getEmployeeById(attempt.HandlerDto.UserId);
            this.attempts.push(attempt);
        });
        let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("EmployeeDto_Popup");
        if (!GlobalFunctions.isEmpty(getGrammerValue) && this.attempts != null && this.attempts.length > 0)
            this.attempts.forEach(callbackAttempt => GlobalFunctions.setStringPresentation(callbackAttempt.HandlerDto.HandlerObject, getGrammerValue));
    }
    ;
    showHistory() {
        this.dialogManager.openJsPanelOrDialog('entity_history');
    }
    ;
    setTaskDetails() {
        if (this.sessionManager.selectedEntity.TaskHistoryList?.length > 0) {
            this.updateTaskHistoryForInformationRequest();
            for (let index = 0; index < this.sessionManager.selectedEntity.TaskHistoryList.length; index++) {
                this.sessionManager.selectedEntity.TaskHistoryList[index].HandlerTextList = GlobalFunctions.getTaskHandlerNameList(this.sessionManager.selectedEntity.TaskHistoryList[index].TaskHandlerList, this.cacheManager);
                this.sessionManager.selectedEntity.TaskHistoryList[index].CreatedBy = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.TaskHistoryList[index].CreatedById);
                this.sessionManager.selectedEntity.CreatedBy = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.CreatedById);
            }
        }
        this.sessionManager.selectedEntity.PriorityText = GlobalFunctions.getPriorityText(this.sessionManager.selectedEntity.Priority, this.translateService);
        this.sessionManager.selectedEntity.PublishToText = GlobalFunctions.getPublishText(this.sessionManager.selectedEntity.PublishTo, this.translateService);
        this.sessionManager.selectedEntity.TagList = this.applicationSettingManager.tagSetting.searchTagById(this.sessionManager.selectedEntity.Tags);
    }
    ;
    updateTaskHistoryForInformationRequest() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.TaskType) && this.sessionManager.selectedEntity.TaskType.toUpperCase() == "INFORMATIONREQUEST" && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.TaskHistoryList)) {
            this.sessionManager.selectedEntity.TaskHistoryList = jlinq.from(this.sessionManager.selectedEntity.TaskHistoryList).sort("DateRecorded").select();
            this.scrollToBottomOfConversation();
            for (let index = 0; index < this.sessionManager.selectedEntity.TaskHistoryList.length; index++) {
                let employee = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.TaskHistoryList[index].CreatedById);
                if (employee != null) {
                    let employeeList = [];
                    employeeList.push(employee);
                    this.sessionManager.selectedEntity.TaskHistoryList[index].UserName = employee.StringRepresentation;
                    this.sessionManager.selectedEntity.TaskHistoryList[index].Picture = employee.PictureData;
                }
                else {
                    this.sessionManager.selectedEntity.TaskHistoryList[index].UserName = this.sessionManager.selectedEntity.TaskHistoryList[index].CreatedById;
                    this.sessionManager.selectedEntity.TaskHistoryList[index].Picture = 'assets/images/nophoto.png';
                }
            }
        }
    }
    ;
    scrollToBottomOfConversation() {
        let taskHistoryListElement = $('#taskHistoryList');
        if (taskHistoryListElement && taskHistoryListElement[0])
            taskHistoryListElement.scrollTop(taskHistoryListElement[0].scrollHeight);
    }
    ;
    addMenuItems() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.TaskType)) {
            this.menu.addOrUpdateMenuItem(0, this.sessionManager.selectedEntity.TaskType.toString() + "Detail", this.translateService.instant("LBL_" + this.sessionManager.selectedEntity.TaskType.toUpperCase()), false, true, true);
            if (this.sessionManager.selectedEntity.TaskType.toLowerCase() == 'appointment' || this.sessionManager.selectedEntity.TaskType.toLowerCase() == 'callbacknote')
                this.menu.addOrUpdateMenuItem(10000, "HISTORY", this.translateService.instant("LBL_HISTORY"), false);
            this.addMenuItem.emit(this.menu);
        }
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(this.sessionManager.selectedEntity.TaskType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
    }
    setLookingOn(taskDto) {
        try {
            taskDto.LookingBy = GlobalFunctions.getLoggedInUserId();
            let LookingOn = {};
            LookingOn.Title = this.translateService.instant("LBL_ASSIGN_ITEM");
            if (!GlobalFunctions.isEmpty(taskDto.LookingBy)) {
                LookingOn.UserId = taskDto.LookingBy;
                let userObject = this.cacheManager.getEmployeeById(LookingOn.UserId);
                LookingOn.UserName = userObject?.StringRepresentation;
                LookingOn.ByOtherUser = false;
                LookingOn.ByOtherUserTitle = LookingOn.ByOtherUser ? LookingOn.UserName + this.translateService.instant("LBL_ASSIGNED_ITEM") : '';
            }
            taskDto.LookingOn = LookingOn;
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    onTagClick(tag, $event) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider, $event);
    }
    ;
};
__decorate([
    Input()
], TaskDetailComponent.prototype, "type", void 0);
__decorate([
    Input()
], TaskDetailComponent.prototype, "uniqueId", void 0);
TaskDetailComponent = __decorate([
    Component({
        selector: 'task-detail',
        template: '<span></span>'
    })
], TaskDetailComponent);
export { TaskDetailComponent };
//# sourceMappingURL=task-detail.component.js.map