var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from "@angular/core";
import { cloneDeep } from "lodash";
import { SubSink } from "subsink";
import { DefaultUseTimeState, FileUploadSource, FreeBusyStatus, OperationType, RecordOperationMode, RecordSelection, ScreenMode } from "../../../core/enums/common-enums";
import { EntityFqdn } from "../../../core/enums/core-enums";
import { CreateTaskAction, MainEntityType, TaskHandlerType, TaskStatus, TaskType } from "../../../core/enums/task-enum";
import { CreateTaskRequest } from "../../../core/models/case/case-task-request";
import { BaseDto } from "../../../core/models/common/baseDto";
import { MeetingRoomDto } from "../../../core/models/common/meeting-roomDto";
import { RelatedEntityDto } from "../../../core/models/common/related-enityDto";
import { RequiredFields } from "../../../core/models/common/required-fields";
import { JsonDtoType } from "../../../core/models/jkc-object/jkc-object";
import { CreateOrganizationRequest } from "../../../core/models/organization/create-organization-request";
import { CreateOrUpdatePersonRequest } from "../../../core/models/person/create-update-person-request";
import { TaskHandlerDto } from "../../../core/models/task/task-handlerDto";
import { TaskHistoryDto } from "../../../core/models/task/task-historyDto";
import { TaskDto } from "../../../core/models/task/taskDto";
import { BroadCastEventKeys, EntityName, LanaguageCode, RoutePath, TinyMCE } from "../../../shared/constants";
import { GlobalFunctions } from "../../../shared/global-functions";
import { BooleanHelper } from "../../../shared/helper/boolean-helper";
import { CommonHelper } from "../../../shared/helper/common-helper";
import { DialogHelper } from "../../../shared/helper/dialog-helper";
import { ExceptionHelper } from "../../../shared/helper/exception-helper";
import { JkcDatePickerHelper } from "../../../shared/helper/jkc-date-picker-helper";
import { JkcPanel } from "../../../shared/helper/jkc-panel-helper";
import { BaseDialogComponent } from "../../common/base-dialog.component";
import { MessageboxComponent } from "../../common/messagebox/messagebox.component";
import { SearchPopupComponent } from "../../common/search-popup/search-popup.component";
import { OrganizationAddEditComponent } from "../organization/add-edit/organization-add-edit.component";
import { RepresentativeAddComponent } from "../organization/add-representative/organization-add-representative.component";
import { PersonAddEditComponent } from "../person/add-edit/person-add-edit.component";
let TaskAddEditComponent = class TaskAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, phoneManager, phoneService, personService, dialogManager, sessionManager, shortcutManager, formatManager, employeeService, translateService, formattedBSNPipe, viewContainerRef, userSettingManager, organizationService, systemComponentService, applicationSettingManager, integrationSettingManager, personFormattedAddressWithLabel, organizationFormattedAddressWithLabel, eventProvider, fileService, datePipe, renderer, searchService, dateAdapter, fileManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.personService = personService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.formatManager = formatManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.formattedBSNPipe = formattedBSNPipe;
        this.viewContainerRef = viewContainerRef;
        this.userSettingManager = userSettingManager;
        this.organizationService = organizationService;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.personFormattedAddressWithLabel = personFormattedAddressWithLabel;
        this.organizationFormattedAddressWithLabel = organizationFormattedAddressWithLabel;
        this.eventProvider = eventProvider;
        this.fileService = fileService;
        this.datePipe = datePipe;
        this.renderer = renderer;
        this.searchService = searchService;
        this.dateAdapter = dateAdapter;
        this.fileManager = fileManager;
        this.dateJS = Date;
        this.calendarWeekView = BooleanHelper.stringToBoolean(this.userSettingManager.getUserSettingValueByKey("CalendarWeekView"));
        this.calendarContentHeight = 500;
        this.calendarOptions = {
            allDayText: this.translateService.instant("LBL_ALL_DAY"),
            allDaySlot: false,
            contentHeight: this.calendarContentHeight,
            dayHeaders: this.calendarWeekView,
            dayHeaderFormat: 'D/M dddd',
            headerToolbar: false,
            initialView: this.calendarWeekView ? 'timeGridWeek' : 'timeGridDay',
            locale: this.translateService.currentLang,
            plugins: GlobalFunctions.getFullCalendarPlugins(),
            scrollTime: new this.dateJS().toString('HH:mm:ss'),
            slotDuration: '00:15:00',
            slotEventOverlap: false,
            slotLabelFormat: 'HH:mm',
            timeZone: 'local',
            weekends: !this.calendarWeekView
        };
        this.departmentAvailabilitySpinner = null;
        this.relationTypeOptions = ['Person', 'Organization'];
        this.callbackRelationType = this.relationTypeOptions;
        this.currentRelationType = 'Person';
        this.currentHandlerType = 'Employee';
        this.showPersonCreateType = true;
        this.taskDto = new TaskDto();
        this.currentDate = new Date();
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.searchEntityTags = [];
        this.enableDurationBox = true;
        this.enableWorkweek = false;
        this.buttonClicked = false;
        this.uniqueId = GlobalFunctions.createGuid();
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.representativeList = [];
        this.showMandatoryField = false;
        this.currentHandlerName = '';
        this.selectedSlotCallbackReceived = false;
        this.confidentialityLevel = 0;
        this.editMode = this.sessionManager.jkcParentPanel.parameters.EditMode;
        this.taskType = this.sessionManager.jkcParentPanel.parameters.EntitySubType;
        this.isContactPersonForPersonVisible = this.applicationSettingManager.UIConfigurator.CallbackNoteProperties && this.applicationSettingManager.UIConfigurator.CallbackNoteProperties['ContactPersonForPerson'] && this.applicationSettingManager.UIConfigurator.CallbackNoteProperties['ContactPersonForPerson'].IsVisible;
        this.isEmailAddressForBothRelationTypeVisible = this.applicationSettingManager.UIConfigurator.CallbackNoteProperties && this.applicationSettingManager.UIConfigurator.CallbackNoteProperties['ContactEmail'] && this.applicationSettingManager.UIConfigurator.CallbackNoteProperties['ContactEmail'].IsVisible;
        this.editedTaskData = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.entityParameter = this.sessionManager.jkcParentPanel.parameters.EntityParameter;
        this.isCustomSelectionEnabled = this.sessionManager.isCustomSelectionEnabled && this.taskType.toLowerCase() == 'callbacknote';
        this.title = this.taskType.toLowerCase() == 'appointment' ? this.translateService.instant("LBL_ADD_APPOINTMENT").toUpperCase() : this.translateService.instant("LBL_ADD_CALLBACK_NOTE").toUpperCase();
        this.showPhoneRecognizationOption = this.phoneManager.phoneState.IsPhoneFeatureEnabled;
        this.createTaskResponseReceived = false;
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        this.contactNumberCheck = false;
        this.mainEntityObject = null;
        this.phoneNumber = null;
        this.mobileNumber = null;
        this.callbackNoteSendingOption = 0;
        this.isDepartmentCBNAvailable = true;
        this.departmentAvailabilityPopup = null;
        this.planningSection = { isFullScreen: false };
        this.templates = [];
        this.currentTemplate = null;
        this.dropdownSlots = [
            { slotLength: 15, slotTime: '15 ' + this.translateService.instant("LBL_MINUTES") },
            { slotLength: 30, slotTime: '30 ' + this.translateService.instant("LBL_MINUTES") },
            { slotLength: 45, slotTime: '45 ' + this.translateService.instant("LBL_MINUTES") },
            { slotLength: 60, slotTime: '1 ' + this.translateService.instant("LBL_HOUR") },
            { slotLength: 120, slotTime: '2 ' + this.translateService.instant("LBL_HOURS") }
        ];
        this.priorities = [
            { priorityValue: 1, priorityText: this.translateService.instant("LBL_LOW") },
            { priorityValue: 2, priorityText: this.translateService.instant("LBL_MEDIUM") },
            { priorityValue: 3, priorityText: this.translateService.instant("LBL_HIGH") }
        ];
        this.priorityValue = 2;
        this.slotLength = 15;
        this.createTaskStatus = '';
        this.selectedFindFrom = '';
        this.taskData = null;
        this.selectedRepresentative = null;
        this.allAvailableMeetingRooms = [];
        this.selectedMeetingRoom = '';
        this.agendaItems = [];
        this.rights = {
            organization: false,
            person: false
        };
        this.minDate = new Date();
        this.showPreviousDayButton = false;
        this.requiredFields = new RequiredFields();
        this.timeoutIds = [];
        this._currentAvailability = [];
        this._selectedDateFromPicker = new Date();
        this._selectedStartDateTime = null;
        this.uploadedFile = null;
        this.subs = new SubSink();
        this.datePickerClosed = true;
        this.customerQuestionFieldId = 'tinymceTask' + GlobalFunctions.getGuid();
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.showTaskResult = this.showTaskResult.bind(this);
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.searchAgendaFound = this.searchAgendaFound.bind(this);
        this.getCBNLimitResponse = this.getCBNLimitResponse.bind(this);
        this.selectedSlotCallback = this.selectedSlotCallback.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.taskRelatedErrorCallback = this.taskRelatedErrorCallback.bind(this);
        this.fetchPersonDetailResponse = this.fetchPersonDetailResponse.bind(this);
        this.getCBNLimitDetailResponse = this.getCBNLimitDetailResponse.bind(this);
        this.setSendEmailResponseComplete = this.setSendEmailResponseComplete.bind(this);
        this.setAllMeetingResponseComplete = this.setAllMeetingResponseComplete.bind(this);
    }
    get currentAvailability() {
        return this._currentAvailability;
    }
    set currentAvailability(currentAvailability) {
        this._currentAvailability = currentAvailability;
        this.refreshCalendar();
    }
    ;
    get selectedDateFromPicker() {
        return this._selectedDateFromPicker;
    }
    set selectedDateFromPicker(selectedDateFromPicker) {
        this._selectedDateFromPicker = selectedDateFromPicker;
        // TODO: code should be moved into HTML pipe to prevent UI flickering
        this.timeoutIds.push(setTimeout(() => GlobalFunctions.setDateFormat('selectDatePicker', selectedDateFromPicker, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe)));
        this.dateChanged();
    }
    ;
    get selectedStartDateTime() {
        return this._selectedStartDateTime;
    }
    set selectedStartDateTime(selectedStartDateTime) {
        this._selectedStartDateTime = selectedStartDateTime;
        if (!GlobalFunctions.isEmpty(this.selectedStartDateTime) && (this.currentHandlerType == "Department" || this.currentHandlerType == "Mailbox") && !GlobalFunctions.isEmpty(this.handlerTags) && this.handlerTags.length > 0 && !GlobalFunctions.isEmpty(this.handlerTags[this.handlerTags.length - 1].Id))
            this.taskService.getCBNLimitDetail(this.handlerTags[this.handlerTags.length - 1].Id, this.selectedStartDateTime.toString('M/d/yyyy HH:mm:ss'), this.getCBNLimitDetailResponse);
        else
            this.isDepartmentCBNAvailable = true;
    }
    ;
    ngOnInit() {
        this.setRights();
        this.minDate.setHours(23, 59, 59, 999);
        this.sessionManager.startSessionIfPossible("TASK", this.sessionManager.jkcParentPanel.parameters.EditedData == null ? ScreenMode.Add : ScreenMode.Edit);
        if (!GlobalFunctions.isEmpty(this.taskType)) {
            switch (this.taskType.toLowerCase()) {
                case 'appointment': {
                    this.taskService.setAllMeetingRoomsCallbacks(this.setAllMeetingResponseComplete);
                    this.taskService.getAllMeetingRooms(new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss), new this.dateJS.today().set({ hour: 23, minute: 59 }).toString('M/d/yyyy HH:mm:ss'));
                    this.templates = this.applicationSettingManager.getTaskTemplates(EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment);
                    this.initEditor();
                    break;
                }
                case 'callbacknote': {
                    this.templates = this.applicationSettingManager.getTaskTemplates(EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote);
                    this.initEditor();
                    break;
                }
            }
        }
        this.displayNumberOnUI(null, null);
        if (this.editedTaskData != null) {
            this.convertSelectedScheduleWorkItemToTask(this.editedTaskData);
            this.showEditTaskDialog(this.taskData);
        }
        if (this.editMode) {
            if (this.taskType.toLowerCase() == 'appointment')
                this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_APPOINTMENT").toUpperCase();
            else
                this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_CALLBACK_NOTE").toUpperCase();
        }
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.initCallbackNoteSendingOption();
        this.initUseTimeCheckBox();
        this.enableWorkweek = this.calendarWeekView;
        this.calendarStateChanged();
        if (GlobalFunctions.isEmpty(this.handlerTags)) {
            if (this.sessionManager.selectedEntity?.ObjectSource?.toLowerCase().includes('employee')) {
                this.sessionManager.selectedEntity.text = this.sessionManager.selectedEntity.StringRepresentation;
                this.handlerTags = [this.sessionManager.selectedEntity];
                this.handlerTagAdded();
            }
            else {
                const lastEmployee = GlobalFunctions.getLastEmployeeFromSession(this.sessionManager.detailViewCachedEntityList);
                if (!GlobalFunctions.isEmpty(lastEmployee)) {
                    this.handlerTags = [lastEmployee];
                    this.handlerTagAdded();
                }
            }
        }
        if (!this.taskData) {
            if (!this.isCustomSelectionEnabled) {
                this.selectOptionsFromFindList();
                this.setCustomerQuestion();
            }
            else {
                if (this.taskType.toLowerCase() == 'callbacknote')
                    this.setCustomInformationForPerson();
            }
        }
        this.prefillSelectedCbnTemplate();
        this.setTaskDetailFromTicket();
        this.setTaskDetailFromSocialMedia();
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
            this.taskDto.CustomerOrOrganizationName = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson;
        if (GlobalFunctions.isEmpty(this.taskDto.ContactEmail) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail))
            this.taskDto.ContactEmail = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail;
        this.registerDialogShortcutKey();
        if (this.searchEntityTags.length > 0)
            this.timeoutIds.push(setTimeout(() => document.getElementById(this.customerQuestionFieldId)?.focus(), 1));
        else
            this.timeoutIds.push(setTimeout(() => document.getElementById("customerNameValue")?.focus(), 1));
        if (this.editedTaskData != null) {
            this.timeoutIds.push(setTimeout(() => {
                if (!GlobalFunctions.isEmpty(this.editedTaskData.selectedDateFromPicker))
                    this.selectedDateFromPicker = new Date(this.editedTaskData.selectedDateFromPicker);
                if (!GlobalFunctions.isEmpty(this.editedTaskData.enableDurationBox))
                    this.enableDurationBox = this.editedTaskData.enableDurationBox;
                if (!GlobalFunctions.isEmpty(this.editedTaskData.slotLength))
                    this.slotLength = this.editedTaskData.slotLength;
                if (!GlobalFunctions.isEmpty(this.editedTaskData.enableWorkweek))
                    this.enableWorkweek = this.editedTaskData.enableWorkweek;
                if (!GlobalFunctions.isEmpty(this.editedTaskData.selectedStartDateTime))
                    this.selectedStartDateTime = new Date(this.editedTaskData.selectedStartDateTime);
                if (!GlobalFunctions.isEmpty(this.editedTaskData.selectedEndDateTime))
                    this.selectedEndDateTime = new Date(this.editedTaskData.selectedEndDateTime);
                if (!GlobalFunctions.isEmpty(this.editedTaskData.selectedStartDateTime))
                    this.currentDate = new Date(this.editedTaskData.selectedStartDateTime);
            }, 900));
        }
        this.taskDto.ContactPerson = this.taskDto.ContactPerson?.split('/')[1];
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setRights() {
        this.rights.organization = GlobalFunctions.checkRights('Organization', 3);
        this.rights.person = GlobalFunctions.checkRights('Person', 3);
    }
    initUseTimeCheckBox() {
        let defaultUseTimeState = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTUSETIME");
        if (!GlobalFunctions.isEmpty(defaultUseTimeState)) {
            switch (parseInt(defaultUseTimeState)) {
                case DefaultUseTimeState.PreviousUsedValue:
                    let isUseTimeStr = this.userSettingManager.getUserSettingValueByKey("UseTimeForEmployeeAgenda");
                    if (!GlobalFunctions.isEmpty(isUseTimeStr) && isUseTimeStr.toUpperCase() == "FALSE")
                        this.enableDurationBox = false;
                    else
                        this.enableDurationBox = true;
                    break;
                case DefaultUseTimeState.On:
                    this.enableDurationBox = true;
                    break;
                case DefaultUseTimeState.Off:
                    this.enableDurationBox = false;
                    break;
            }
        }
    }
    ;
    initCallbackNoteSendingOption() {
        let callbackNoteSendingOption = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "CALLBACKNOTESENDINGOPTION");
        if (!GlobalFunctions.isEmpty(callbackNoteSendingOption))
            this.callbackNoteSendingOption = parseInt(callbackNoteSendingOption);
    }
    ;
    updateUseTimeSetting() {
        this.userSettingManager.setUserSettingValueByKey("UseTimeForEmployeeAgenda", this.enableDurationBox.toString());
        let userSettingDto = new Object();
        userSettingDto.Key = "UseTimeForEmployeeAgenda";
        userSettingDto.Value = this.enableDurationBox.toString();
        userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
        this.systemComponentService.updateUserSetting(userSettingDto);
    }
    ;
    convertSelectedScheduleWorkItemToTask(taskSessionData) {
        this.taskData = jQuery.extend(true, {}, taskSessionData);
        let i;
        if (!GlobalFunctions.isEmpty(taskSessionData.CurrentHandlerList)) {
            this.taskData.HandlerTags = [];
            for (i = 0; i < taskSessionData.CurrentHandlerList.length; i++) {
                let handlerId = taskSessionData.CurrentHandlerList[i].HandlerId;
                if (!GlobalFunctions.isEmpty(handlerId)) {
                    let handleData = null;
                    if (taskSessionData.CurrentHandlerType == TaskHandlerType.Employee || taskSessionData.CurrentHandlerType == "Employee")
                        handleData = this.cacheManager.getEmployeeById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Department || taskSessionData.CurrentHandlerType == "Department")
                        handleData = this.cacheManager.getDepartmentById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Mailbox || taskSessionData.CurrentHandlerType == "Mailbox")
                        handleData = this.cacheManager.getTaskMailboxById(handlerId);
                    if (handleData != null) {
                        handleData.text = handleData.StringRepresentation;
                        this.taskData.HandlerTags.push(handleData);
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(taskSessionData.SearchEntityTags)) {
            this.taskData.SearchEntityTags = [];
            for (i = 0; i < taskSessionData.SearchEntityTags.length; i++) {
                this.taskData.SearchEntityTags.push(taskSessionData.SearchEntityTags[i]);
            }
        }
    }
    ;
    changeRepresentative() {
        if (this.selectedRepresentative?.value?.toUpperCase() == 'NEW') {
            if (this.currentRelationType == 'Organization') {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.taskDto.MainEntityId, editMode: false }).afterClosed().subscribe(representative => {
                    if (representative) {
                        this.relatedRepresentatives([representative]);
                        this.selectedRepresentative = representative;
                    }
                    this.registerDialogShortcutKey();
                });
            }
        }
        else {
            if (this.selectedRepresentative) {
                if (this.selectedRepresentative.AdministeredPersonDto)
                    this.taskDto.CustomerBSN = this.formattedBSNPipe.transform(this.selectedRepresentative.AdministeredPersonDto.ServiceNumber);
                else if (this.selectedRepresentative.OtherPersonDto && this.selectedRepresentative.OtherPersonDto.Identification != '')
                    this.taskDto.CustomerBSN = this.selectedRepresentative.OtherPersonDto.Identification;
                this.taskDto.ContactAddress = this.personFormattedAddressWithLabel.transform(this.selectedRepresentative, false) || '';
                this.displayNumberOnUI(this.selectedRepresentative.PhoneNumber, this.selectedRepresentative.MobileNumber);
                this.taskDto.ContactPerson = this.selectedRepresentative.StringRepresentation;
                this.taskDto.CustomerDateOfBirth = this.selectedRepresentative.DateOfBirthText;
            }
        }
    }
    ;
    displayNumberOnUI(phoneNumber, mobileNumber) {
        if (!GlobalFunctions.isEmpty(phoneNumber) && GlobalFunctions.isEmpty(this.phoneNumber))
            this.phoneNumber = $.trim(phoneNumber);
        if (!GlobalFunctions.isEmpty(mobileNumber) && GlobalFunctions.isEmpty(this.mobileNumber))
            this.mobileNumber = $.trim(mobileNumber);
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
            if (GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId))
                this.mobileNumber = this.sessionManager.currentCallerId;
            else
                this.phoneNumber = this.sessionManager.currentCallerId;
        }
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber)) {
            let numbers = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber.split('/');
            for (let i = 0; i < numbers.length; i++) {
                if (GlobalFunctions.isMobileNumber(numbers[i]))
                    this.mobileNumber = numbers[i];
                else
                    this.phoneNumber = numbers[i];
            }
        }
    }
    ;
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representativeList.push(result[i]);
                }
                this.selectedRepresentative = this.representativeList[this.representativeList.length - 1];
            }
        }
    }
    ;
    addDefaultRepresentative() {
        this.representativeList.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    ;
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        if (personEntity.ConfidentialityLevel != 0)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (!result && this.searchEntityTags.length > 0)
                    this.personTagRemoved();
                document.getElementById("findFromSelectOption")?.focus();
            });
    }
    ;
    showPersonClassifiedWarning(personEntity) {
        if (personEntity.ConfidentialityLevel == 0)
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (!result && this.searchEntityTags.length > 0)
                this.personTagRemoved();
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    setCustomInformationForPerson() {
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && !GlobalFunctions.isEmpty(this.sessionManager.contactPersonFromRecentActivity)) {
            this.taskDto.CustomerOrOrganizationName = this.sessionManager.contactPersonFromRecentActivity;
        }
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson)) {
            this.currentRelationType = "Person";
            this.taskDto.CustomerOrOrganizationName = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson;
        }
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject))
            this.taskDto.CustomerQuestion = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject;
        if (this.applicationSettingManager.isCustomerOM()) {
            if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.CaseNumber))
                this.taskDto.CaseNumber = this.sessionManager.contactSessionNotesState.ContactHistoryDto.CaseNumber;
            this.taskDto.CustomerQuestion = this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText;
        }
    }
    ;
    setTaskDetailFromSocialMedia() {
        if (!this.editMode && GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastSocialMediaHistoryRecord(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result)) {
                this.taskDto.CustomerOrOrganizationName = result.User.Name;
                this.taskDto.CustomerQuestion = result.Message.Message;
            }
        }
    }
    ;
    setTaskDetailFromTicket() {
        if (this.editMode == false && GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastTicketFromSession(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result))
                this.taskDto.CustomerQuestion = result.Description;
        }
    }
    ;
    fetchPersonDetailResponse(result) {
        this.stopSpinner();
        if (result != null) {
            this.mainEntityObject = result;
            this.displayNumberOnUI(result.PhoneNumber, result.MobileNumber);
        }
    }
    ;
    assignEmail(searchEntity, relationshipType) {
        let email = "";
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            if (GlobalFunctions.isSessionContainsEmailRecord(cachedEntities)) {
                let emailObject = GlobalFunctions.getFirstEmailFromSession(cachedEntities);
                email = !GlobalFunctions.isEmpty(emailObject.Header) ? emailObject.Header.From : "";
            }
        }
        if (GlobalFunctions.isEmpty(email) && !GlobalFunctions.isEmpty(searchEntity)) {
            if (relationshipType == "Person")
                email = !GlobalFunctions.isEmpty(searchEntity.EmailAddress) ? searchEntity.EmailAddress : "";
            else if (relationshipType == "Organization")
                email = !GlobalFunctions.isEmpty(searchEntity.EmailAddress) ? searchEntity.EmailAddress : "";
        }
        return email;
    }
    ;
    fetchPersonDetail(entity) {
        let partialDto = new Object();
        partialDto.Id = entity.Id;
        partialDto.ObjectSource = entity.ObjectSource;
        this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
    }
    ;
    setMainEntity(searchEntity, relationshipType) {
        this.representativeList.length = 0;
        if (relationshipType == "")
            relationshipType = this.currentRelationType;
        let selectedEntityName = "";
        this.searchEntityTags = [];
        let searchEntitySelected = [];
        if (searchEntity != null) {
            document.getElementById("divContactAddress")?.setAttribute("readonly", "true");
            document.getElementById("divBsnNumber")?.setAttribute("readonly", "true");
            document.getElementById("divKvkNumber")?.setAttribute("readonly", "true");
            if (relationshipType == 'Person') {
                if (searchEntity.Partial == true && GlobalFunctions.isEmpty(searchEntity.PhoneNumber)) {
                    this.startSpinner();
                    this.fetchPersonDetail(searchEntity);
                }
                if (GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                else if (searchEntity.ConfidentialityLevel != 0)
                    this.showPersonClassifiedWarning(searchEntity);
                let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
                if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                    GlobalFunctions.setStringPresentation(searchEntity, getGrammerValue);
                    selectedEntityName = searchEntity.StringRepresentation;
                    if (!GlobalFunctions.isEmpty(searchEntity.Details) &&
                        !GlobalFunctions.isEmpty(searchEntity.Details.FormalName) &&
                        !GlobalFunctions.isEmpty(searchEntity.Details.FormalName.Gender)) {
                        if (searchEntity.Details.FormalName.Gender === 0)
                            selectedEntityName = this.translateService.instant("LBL_MR") + " " + selectedEntityName;
                        else if (searchEntity.Details.FormalName.Gender === 1)
                            selectedEntityName = this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                        else
                            selectedEntityName = this.translateService.instant("LBL_MR") + "/" + this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                    }
                }
            }
            else {
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
                    this.addDefaultRepresentative();
                selectedEntityName = searchEntity.Name;
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
            }
            this.taskDto.CustomerOrOrganizationName = selectedEntityName;
            searchEntitySelected.push({ text: selectedEntityName });
            this.searchEntityTags = searchEntitySelected;
            this.setSearchEntityProperties(searchEntity, relationshipType);
        }
        this.taskDto.ContactEmail = this.assignEmail(searchEntity, relationshipType);
    }
    ;
    setSearchEntityProperties(searchEntitySelected, relationshipType) {
        switch (relationshipType) {
            case 'Person':
                this.fillPersonInfo(searchEntitySelected);
                break;
            case 'Organization':
                this.fillOrganizationInfo(searchEntitySelected);
                break;
            default:
        }
    }
    ;
    fillPersonInfo(selectedEntity) {
        if (selectedEntity != null) {
            let person = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Person);
            if (person == null)
                return;
            this.mainEntityObject = person;
            this.confidentialityLevel = person.ConfidentialityLevel;
            this.taskDto.MainEntityId = person.Id;
            this.taskDto.MainEntitySource = person.ObjectSource;
            this.taskDto.CustomerDateOfBirth = !GlobalFunctions.isEmpty(person.Details.DateOfBirth) ? new this.dateJS(person.Details.DateOfBirth).toString('M/d/yyyy HH:mm:ss') : null;
            this.taskDto.CustomerBSN = this.formattedBSNPipe.transform(person.AdministeredPersonDto.ServiceNumber);
            this.taskDto.ContactAddress = this.personFormattedAddressWithLabel.transform(person, false) || '';
            this.displayNumberOnUI(person.PhoneNumber, person.MobileNumber);
        }
    }
    ;
    handlerTagAdded() {
        if (this.handlerTags.length > 0)
            this.initCalendar();
    }
    ;
    handlerTagRemoved() {
        if (this.handlerTags.length > 0)
            this.initCalendar();
        else {
            this.employeeAvailability = null;
            this.currentHandlerName = "";
            if (this.allAvailableMeetingRooms) {
                let selectedRoom;
                this.allAvailableMeetingRooms.forEach(meetingRoom => {
                    if (this.selectedMeetingRoom == meetingRoom.EmailAddress)
                        selectedRoom = meetingRoom;
                });
                if (selectedRoom?.Availability?.length > 0)
                    this.currentAvailability = { ...selectedRoom.Availability };
            }
        }
    }
    ;
    taskRelatedErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_TASK")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    saveCallerId() {
        if (!GlobalFunctions.isEmpty(this.contactNumberCheck) && this.contactNumberCheck === true && !GlobalFunctions.isEmpty(this.taskDto.MainEntityId) && !GlobalFunctions.isEmpty(this.taskDto.MainEntitySource) && this.showPhoneRecognizationOption) {
            let callerInfoDto = new Object();
            callerInfoDto.PhoneNumber = this.taskDto.ContactPhoneNumber;
            callerInfoDto.ObjectId = this.taskDto.MainEntityId;
            callerInfoDto.ObjectType = GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.taskDto.MainEntityType));
            callerInfoDto.ObjectSource = this.taskDto.MainEntitySource;
            this.phoneService.updateCallerIdRequest(callerInfoDto);
        }
    }
    ;
    saveTask(callbackSendingOption) {
        if (GlobalFunctions.editorIsEmpty(this.taskDto.CustomerQuestion) || this.handlerTags.length === 0 || this.form.invalid)
            return;
        this.planningSection.isFullScreen = false;
        let selectedCallbackDate = new this.dateJS(this.selectedDateFromPicker.getFullYear(), this.selectedDateFromPicker.getMonth(), this.selectedDateFromPicker.getDate(), 23, 0, 0, 0);
        let currentDate = new this.dateJS();
        let currentDateWithTime = new this.dateJS(currentDate.getFullYear(), currentDate.getMonth(), currentDate.getDate(), currentDate.getHours(), currentDate.getMinutes(), 0, 0);
        if (this.form.invalid || selectedCallbackDate < new this.dateJS() || (this.selectedStartDateTime < currentDateWithTime && this.enableDurationBox)) {
            if (selectedCallbackDate < new this.dateJS() || (this.selectedStartDateTime < currentDateWithTime && this.enableDurationBox)) {
                this.showMandatoryField = true;
                this.createTaskStatus = "LBL_CALLBACK_DATE_WARNING";
            }
        }
        this.taskDto.SendAsAppointment = callbackSendingOption == 1;
        this.assignContactNumberInTaskDto();
        if (this.taskDto && this.handlerTags.length > 0) {
            if (this.taskDto.ContactPerson && (this.currentRelationType == "Organization" || this.isContactPersonForPersonVisible))
                this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName + "/" + this.taskDto.ContactPerson;
            else
                this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName;
            let taskHistoryDto = new TaskHistoryDto();
            taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            taskHistoryDto.TaskHandlerList = [];
            taskHistoryDto.StatusText = this.translateService.instant("LBL_UNHANDLED");
            taskHistoryDto.Status = TaskStatus.Unhandled;
            let currentHandlerList = "";
            if (this.handlerTags.length > 0) {
                for (let i = 0; i < this.handlerTags.length; i++) {
                    let taskHandler = new TaskHandlerDto();
                    taskHandler.HandlerId = this.handlerTags[i].Id;
                    let jsonHandlerString = JSON.stringify(this.handlerTags[i]);
                    let currentHandlerJsonType = JsonDtoType.Employee;
                    if (this.currentHandlerType == "Department")
                        currentHandlerJsonType = JsonDtoType.Department;
                    else if (this.currentHandlerType == "Mailbox") {
                        currentHandlerJsonType = JsonDtoType.TaskMailbox;
                        taskHandler.DepartmentId = this.handlerTags[i].Department;
                    }
                    jsonHandlerString = jsonHandlerString.substr(1);
                    jsonHandlerString = currentHandlerJsonType + jsonHandlerString;
                    this.handlerTags[i] = JSON.parse(jsonHandlerString);
                    taskHandler.HandlerObject = this.handlerTags[i];
                    taskHandler.HandlerType = TaskHandlerType[this.currentHandlerType];
                    taskHistoryDto.TaskHandlerList.push(taskHandler);
                    if (currentHandlerList.length == 0)
                        currentHandlerList = this.handlerTags[i].StringRepresentation;
                    else
                        currentHandlerList = currentHandlerList + ", " + this.handlerTags[i].StringRepresentation;
                }
            }
            this.taskDto.TaskHistoryList = [];
            this.taskDto.TaskHistoryList.push(taskHistoryDto);
            this.taskDto.CreateTaskAction = CreateTaskAction.Direct;
            this.taskDto.CurrentStatus = TaskStatus.Unhandled;
            this.taskDto.Priority = this.priorityValue;
            if (this.priorityValue !== 0)
                this.taskDto.PriorityText = this.priorities[this.priorityValue - 1].priorityText;
            if (!this.editMode) {
                this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                this.taskDto.Tags = this.sessionManager.getTags();
                this.taskDto.CreatedById = GlobalFunctions.getLoggedInUserId();
                if (this.employeeService.loggedInEmployee != null) {
                    let baseDtoObject = new BaseDto();
                    baseDtoObject.Id = this.taskDto.CreatedById;
                    let loggedInEmployee = this.cacheManager.getEmployeeById(this.taskDto.CreatedById);
                    if (!GlobalFunctions.isEmpty(loggedInEmployee))
                        baseDtoObject.StringRepresentation = loggedInEmployee.StringRepresentation;
                    this.taskDto.CreatedBy = baseDtoObject;
                }
            }
            this.taskDto.RequiredCallbackDate = new this.dateJS(this.selectedStartDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenStartDate = new this.dateJS(this.selectedStartDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenEndDate = new this.dateJS(this.selectedEndDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.MainEntityType = MainEntityType[this.currentRelationType];
            this.taskDto.ReferenceNumber = GlobalFunctions.isEmpty(this.taskDto.ReferenceNumber) ? 0 : this.taskDto.ReferenceNumber;
            this.fillRelationEntities();
            if (this.taskType.toLowerCase() == 'callbacknote')
                this.taskDto.TaskType = TaskType[TaskType.CallbackNote];
            else if (this.taskType.toLowerCase() == 'appointment') {
                this.taskDto.TaskType = TaskType[TaskType.Appointment];
                let selectedRoom;
                if (this.allAvailableMeetingRooms != null) {
                    this.allAvailableMeetingRooms.forEach((meetingRoom, i) => {
                        if (this.selectedMeetingRoom == meetingRoom.EmailAddress)
                            selectedRoom = this.allAvailableMeetingRooms[i];
                    });
                    let selectedRoomList = [];
                    selectedRoomList.push(selectedRoom);
                    if (!GlobalFunctions.isEmpty(selectedRoom))
                        this.taskDto.MeetingRoomList = selectedRoomList;
                }
            }
            if (GlobalFunctions.isEmpty(this.taskDto.Id)) {
                this.taskDto.Id = GlobalFunctions.createGuid().replace(/-/g, '');
                if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
                    this.taskDto.RoleId = this.sessionManager.selectedRole.Id;
            }
            if (GlobalFunctions.isEmpty(this.taskDto.CaseNumber))
                this.taskDto.CaseNumber = GlobalFunctions.getCaseNumberFromSession(this.sessionManager.detailViewCachedEntityList);
            if (this.validateContactNumbers(this.taskDto.ContactPhoneNumber))
                this.sendSaveRequests();
            else {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CALLBACK_NOTE"), textMsg: this.translateService.instant("LBL_PHONE_NUMBER_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result)
                        this.sendSaveRequests();
                });
            }
            this.showMandatoryField = false;
            this.createTaskStatus = "";
        }
        else {
            this.showMandatoryField = true;
            this.createTaskStatus = "LBL_MESSAGE_HANDLER_IS_NOT_SET";
        }
    }
    ;
    validateContactNumbers(contactNumber) {
        let isValidNumber = true;
        if (!GlobalFunctions.isEmpty(contactNumber)) {
            let contactNumbers = contactNumber.split('/');
            let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
            for (let i = 0; i < contactNumbers.length; i++) {
                if (!GlobalFunctions.isValidPhonenumber(contactNumbers[i], countryCode))
                    isValidNumber = false;
            }
        }
        else
            isValidNumber = false;
        return isValidNumber;
    }
    ;
    sendSaveRequests() {
        if (this.currentHandlerType == "Department" || this.currentHandlerType == "Mailbox") {
            let handlerIds = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "CONFIGURECBNLIMITTODEPARTMENT");
            if (handlerIds.indexOf(this.handlerTags[this.handlerTags.length - 1].Id) != -1)
                this.taskService.getCBNLimitDetail(this.handlerTags[this.handlerTags.length - 1].Id, this.selectedStartDateTime.toString('M/d/yyyy HH:mm:ss'), this.getCBNLimitResponse);
            else
                this.sendSaveRequest();
        }
        else
            this.sendSaveRequest();
    }
    ;
    getCBNLimitResponse(response) {
        if (response.IsSlotAvailable == false) {
            this.isDepartmentCBNAvailable = false;
            this.showMandatoryField = true;
            this.createTaskStatus = "LBL_CALLBACK_LIMIT_WARNING";
        }
        else {
            this.sendSaveRequest();
            this.isDepartmentCBNAvailable = true;
            this.createTaskStatus = "";
            this.showMandatoryField = false;
        }
    }
    ;
    sendSaveRequest() {
        this.taskService.createTask(this.createTaskRequest(), this.showTaskResult, this.taskRelatedErrorCallback, this.setSendEmailResponseComplete);
        this.processAfterTaskCreation();
        this.updateUseTimeSetting();
        GlobalFunctions.updateCalendarWeekView(this.enableWorkweek, this.userSettingManager, this.systemComponentService);
        this.saveCallerId();
        this.saveContactPersonPhone();
    }
    ;
    saveContactPersonPhone() {
        if (this.contactNumberCheck && !GlobalFunctions.isEmpty(this.mainEntityObject)) {
            if (this.taskDto.MainEntityType.toString().toUpperCase() == "PERSON") {
                if ((!GlobalFunctions.isEmpty(this.phoneNumber) && this.phoneNumber != this.mainEntityObject.PhoneNumber)
                    || (!GlobalFunctions.isEmpty(this.mobileNumber) && this.mobileNumber != this.mainEntityObject.MobileNumber)) {
                    this.mainEntityObject.PhoneNumber = this.phoneNumber;
                    this.mainEntityObject.MobileNumber = this.mobileNumber;
                    let personRequest = new CreateOrUpdatePersonRequest();
                    personRequest.Mode = RecordOperationMode.Edit;
                    personRequest.PersonDto = this.mainEntityObject;
                    personRequest.AssignCallerId = true;
                    this.personService.createPersonEntity(personRequest, null, null);
                }
            }
            else if (this.taskDto.MainEntityType.toString().toUpperCase() == "ORGANIZATION") {
                if (!GlobalFunctions.isEmpty(this.phoneNumber) && this.phoneNumber != this.mainEntityObject.PhoneNumber) {
                    this.mainEntityObject.PhoneNumber = this.phoneNumber;
                    let organizationRequest = new CreateOrganizationRequest();
                    organizationRequest.Mode = RecordOperationMode.Edit;
                    organizationRequest.OrganizationDto = this.mainEntityObject;
                    organizationRequest.AssignCallerId = true;
                    this.organizationService.createOrganizationEntity(organizationRequest, null, null);
                }
            }
        }
    }
    ;
    createTaskRequest(isUseTimeForEmployeeAgenda) {
        let createTaskRequest = new CreateTaskRequest();
        createTaskRequest.TaskDto = this.taskDto;
        createTaskRequest.IsUseTimeForEmployeeAgenda = this.enableDurationBox;
        return createTaskRequest;
    }
    ;
    setSendEmailResponseComplete(result) {
        let emailSendResponse = JSON.parse(result);
        if (emailSendResponse && emailSendResponse.Result === "1") {
            let header = null;
            let message = null;
            if (this.taskType.toLowerCase() === "callbacknote") {
                header = this.translateService.instant("LBL_CALLBACK_NOTE");
                message = this.translateService.instant("LBL_ERROR_MAIL_VIA_CALLBACK_NOTE");
            }
            else if (this.taskType.toLowerCase() === "appointment") {
                header = this.translateService.instant("LBL_APPOINTMENT");
                message = this.translateService.instant("LBL_ERROR_MAIL_VIA_APPOINTMENT");
            }
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
        }
    }
    ;
    setAllMeetingResponseComplete(response) {
        let allMeetingResponse = JSON.parse(response);
        if (allMeetingResponse != null && allMeetingResponse.MeetingRoomList != null && allMeetingResponse.MeetingRoomList.length > 0) {
            this.allAvailableMeetingRooms = [];
            let defaultOption = new MeetingRoomDto();
            defaultOption.EmailAddress = "selectany";
            defaultOption.RoomName = this.translateService.instant("LBL_SELECT_ANY");
            this.allAvailableMeetingRooms.push(defaultOption);
            this.selectedMeetingRoom = this.allAvailableMeetingRooms[0].EmailAddress;
            allMeetingResponse.MeetingRoomList.forEach(meetingRoom => {
                this.allAvailableMeetingRooms.push(meetingRoom);
            });
        }
    }
    ;
    meetingRoomChanged() {
        let selectedRoom;
        this.allAvailableMeetingRooms.forEach(meetingRoom => {
            if (this.selectedMeetingRoom == meetingRoom.EmailAddress)
                selectedRoom = meetingRoom;
        });
        if (selectedRoom != null) {
            if (selectedRoom.Availability != null && selectedRoom.Availability.length > 0) {
                if (GlobalFunctions.isEmpty(this.employeeAvailability))
                    this.currentAvailability = { ...selectedRoom.Availability };
                else {
                    this.currentAvailability = { ...this.employeeAvailability };
                    for (let slot = 0; slot < selectedRoom.Availability.length; slot++) {
                        if (selectedRoom.Availability[slot].FreeBusyStatus != FreeBusyStatus.Free)
                            this.currentAvailability[slot].FreeBusyStatus = selectedRoom.Availability[slot].FreeBusyStatus;
                    }
                }
            }
            else {
                if (!GlobalFunctions.isEmpty(this.employeeAvailability))
                    this.currentAvailability = { ...this.employeeAvailability };
            }
        }
    }
    ;
    dateChanged() {
        if (this.enableWorkweek && this.selectedSlotCallbackReceived)
            return this.selectedSlotCallbackReceived = false;
        if (this.selectedDateFromPicker) {
            let dtNow = new Date();
            this.currentDate = this.selectedDateFromPicker;
            this.currentDate.setHours(dtNow.getHours());
            this.currentDate.setMinutes(dtNow.getMinutes());
            if (this.enableDurationBox) {
                this.selectedStartDateTime = cloneDeep(this.currentDate);
                let minuteDiff = this.selectedStartDateTime.getMinutes() % this.slotLength;
                if (minuteDiff != 0)
                    this.selectedStartDateTime = this.selectedStartDateTime.addMinutes(this.slotLength - minuteDiff);
                this.selectedEndDateTime = cloneDeep(this.selectedStartDateTime);
                this.selectedEndDateTime.addMinutes(this.slotLength);
                this.startTime = this.selectedStartDateTime.toString();
                this.endTime = this.selectedEndDateTime.toString();
            }
            else {
                this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, 0, 0, 0);
                this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 17, 0, 0, 0);
                this.startTime = this.selectedStartDateTime.toString();
                this.endTime = this.selectedEndDateTime.toString();
            }
            this.initCalendar();
            this.showPreviousDayButton = this.minDate.getTime() <= this.selectedDateFromPicker.getTime();
        }
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    nextDayButtonClick() {
        if (this.enableWorkweek)
            this.currentDate.setDate(this.currentDate.getDate() + 7);
        else
            this.currentDate.setDate(this.currentDate.getDate() + 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        if (!this.enableDurationBox)
            this.buttonClicked = true;
        this.showPreviousDayButton = true;
    }
    ;
    previousDayButtonClick() {
        if (this.enableWorkweek)
            this.currentDate.setDate(this.currentDate.getDate() - 7);
        else
            this.currentDate.setDate(this.currentDate.getDate() - 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        if (!this.enableDurationBox)
            this.buttonClicked = true;
    }
    ;
    setCallbackBetweenTime() {
        let dt = this.currentDate;
        this.startTime = dt.toString("HH:mm");
        dt.setMinutes(dt.getMinutes() + 15);
        this.endTime = dt.toString("HH:mm");
    }
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentRelationType, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            this.setMainEntity(searchEntity, "");
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    clearSelectedEntity() {
        this.taskDto.CustomerOrOrganizationName = null;
        this.taskDto.CustomerBSN = null;
        this.taskDto.CustomerKVKNumber = null;
        this.taskDto.CustomerDateOfBirth = null;
        this.taskDto.ContactAddress = null;
        this.taskDto.ContactEmail = null;
        if (GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
            this.phoneNumber = null;
            this.mobileNumber = null;
            this.taskDto.ContactPhoneNumber = null;
        }
        document.getElementById("divContactAddress")?.removeAttribute("readonly");
        document.getElementById("divBsnNumber")?.removeAttribute("readonly");
        document.getElementById("divKvkNumber")?.removeAttribute("readonly");
    }
    ;
    setMainEntityPerson() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityPerson, "Person");
        }
    }
    ;
    setMainEntityOrganization() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityOrganization, "Organization");
        }
    }
    ;
    personTagRemoved() {
        this.representativeList.length = 0;
        this.searchEntityTags = [];
        if (this.confidentialityLevel != 0)
            this.confidentialityLevel = 0;
        this.clearSelectedEntity();
    }
    ;
    processAfterTaskCreation() {
        this.dialogManager.openJsPanelOrDialog("END_SESSION_DIALOG");
        this.close();
        this.sessionManager.loadedFromRelatedView = false;
        let taskDtoForSession = jQuery.extend({}, this.taskDto);
        if (!this.editMode) {
            taskDtoForSession.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            taskDtoForSession.CallBetweenStartDate = this.selectedStartDateTime;
            taskDtoForSession.CallBetweenEndDate = this.selectedEndDateTime;
            GlobalFunctions.setStringPresentation(taskDtoForSession, this.applicationSettingManager.getObjectGrammerSetting("CallbackNoteDto_Breadcrumb"));
            if (this.taskType.toLowerCase() == 'callbacknote') {
                taskDtoForSession.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote];
                this.sessionManager.addItemsToDetailViewCacheList(taskDtoForSession, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote]));
            }
            else if (this.taskType.toLowerCase() == 'appointment') {
                taskDtoForSession.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment];
                this.sessionManager.addItemsToDetailViewCacheList(taskDtoForSession, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment]));
            }
        }
        else
            this.sessionManager.selectedEntity = taskDtoForSession;
    }
    ;
    showTaskResult(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        if (this.createTaskResponseReceived)
            return;
        switch (response?.Result) {
            case 0:
                {
                    this.createTaskResponseReceived = true;
                    this.close();
                    this.sessionManager.loadedFromRelatedView = false;
                    this.taskDto.Id = response.TaskId;
                    this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    this.taskDto.CallBetweenStartDate = this.selectedStartDateTime;
                    this.taskDto.CallBetweenEndDate = this.selectedEndDateTime;
                    if (this.taskType.toLowerCase() == 'callbacknote')
                        this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_CallbackNote];
                    else if (this.taskType.toLowerCase() == 'appointment')
                        this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment];
                    this.sessionManager.selectedEntity = this.taskDto;
                    this.sessionManager.selectedEntity.Partial = true;
                    this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${this.taskType.toLowerCase()}/${this.taskDto.Id}`;
                    if (!this.editMode) {
                        if (this.taskData != null) {
                            let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                            this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                            if (this.taskType.toLowerCase() == 'callbacknote')
                                GlobalFunctions.setStringPresentation(this.taskDto, this.applicationSettingManager.getObjectGrammerSetting("CallbackNoteDto_Breadcrumb"));
                            this.sessionManager.addBreadcrumbItems([this.taskDto], null, RoutePath.DETAIL_PATH);
                        }
                        else
                            this.sessionManager.addBreadcrumbItems([this.taskDto], null, this.router.url);
                        this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                    }
                    else
                        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
                    if (this.selectedFindFrom != "ManualEntry")
                        this.sessionManager.addEntityToSession(this.mainEntityObject, this.taskDto.MainEntityType);
                    break;
                }
            default:
                {
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_CALLBACK_NOTE") });
                    break;
                }
        }
    }
    ;
    initCalendar() {
        this.refreshCalendar();
        if (this.currentHandlerType == "Employee") {
            if (this.taskDto && this.handlerTags.length > 0) {
                let employeeIdList = [];
                employeeIdList.push(this.handlerTags[this.handlerTags.length - 1].Id);
                if (this.enableWorkweek) {
                    let mondayDate = cloneDeep(this.currentDate);
                    let fridayDate = cloneDeep(this.currentDate);
                    mondayDate.last().monday();
                    if (!fridayDate.is().friday())
                        fridayDate.next().friday();
                    this.employeeService.searchAgenda(employeeIdList, mondayDate, fridayDate, this.searchAgendaFound);
                }
                else
                    this.employeeService.searchAgenda(employeeIdList, this.currentDate, null, this.searchAgendaFound);
                this.currentHandlerName = "(" + this.translateService.instant("LBL_AGENDA_FOR") + " : " + this.handlerTags[this.handlerTags.length - 1].StringRepresentation + ")";
            }
        }
        else if (this.currentHandlerType == "Department") {
            if (this.taskDto && this.handlerTags?.length > 0) {
                let departmentIdList = [];
                departmentIdList.push(this.handlerTags[this.handlerTags.length - 1].Id);
                if (this.enableWorkweek) {
                    let mondayDate = cloneDeep(this.currentDate);
                    let fridayDate = cloneDeep(this.currentDate);
                    mondayDate.last().monday();
                    if (!fridayDate.is().friday())
                        fridayDate.next().friday();
                    this.employeeService.searchAgenda(departmentIdList, mondayDate, fridayDate, this.searchAgendaFound);
                }
                else
                    this.employeeService.searchAgenda(departmentIdList, this.currentDate, null, this.searchAgendaFound);
                this.currentHandlerName = "(" + this.translateService.instant("LBL_AGENDA_FOR") + " : " + this.handlerTags[this.handlerTags.length - 1].StringRepresentation + ")";
            }
        }
        if (!GlobalFunctions.isEmpty(this.selectedStartDateTime) && (this.currentHandlerType == "Department" || this.currentHandlerType == "Mailbox")) {
            let handlerIds = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "CONFIGURECBNLIMITTODEPARTMENT");
            if (handlerIds.indexOf(this.handlerTags[this.handlerTags.length - 1].Id) != -1)
                this.taskService.getCBNLimitDetail(this.handlerTags[this.handlerTags.length - 1].Id, this.selectedStartDateTime.toString('M/d/yyyy HH:mm:ss'), this.getCBNLimitDetailResponse);
        }
    }
    ;
    getCBNLimitDetailResponse(response) {
        this.stopDepartmentAvailabilitySpinner();
        if (response.IsSlotAvailable == false) {
            this.isDepartmentCBNAvailable = false;
            this.showMandatoryField = true;
            this.createTaskStatus = "LBL_CALLBACK_LIMIT_WARNING";
        }
        else {
            this.isDepartmentCBNAvailable = true;
            this.createTaskStatus = "";
            this.showMandatoryField = false;
        }
    }
    ;
    selectedSlotCallback(dates) {
        let dateMoment = new Date(dates.start);
        let hr = dateMoment.getHours();
        let min = dateMoment.getMinutes();
        this.startTime = dates.start.toString();
        this.selectedStartDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        dateMoment = new Date(dates.end);
        hr = dateMoment.getHours();
        min = dateMoment.getMinutes();
        this.endTime = dates.end.toString();
        this.selectedEndDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        if (this.enableWorkweek) {
            this.selectedSlotCallbackReceived = true;
            this.selectedDateFromPicker = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate());
        }
        this.calendar.getApi()?.getEventById('selectedEvent')?.remove();
        this.calendar.getApi()?.addEvent({
            allDay: false,
            editable: false,
            id: 'selectedEvent',
            end: new Date(dates.end),
            backgroundColor: '#34b7db',
            start: new Date(dates.start)
        });
    }
    ;
    calendarStateChanged() {
        if (this.enableDurationBox) {
            let dtNow = new Date();
            this.currentDate.setHours(dtNow.getHours());
            this.currentDate.setMinutes(dtNow.getMinutes());
            this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, 0, 0, 0);
            this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, this.slotLength, 0, 0);
            this.startTime = this.selectedStartDateTime.toString();
            this.endTime = this.selectedEndDateTime.toString();
            this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        }
        else {
            this.currentDate.setHours(8);
            this.currentDate.setMinutes(0);
            this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 8, 0, 0, 0);
            this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), 17, 0, 0, 0);
            this.startTime = this.selectedStartDateTime.toString();
            this.endTime = this.selectedEndDateTime.toString();
            this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
            if (this.buttonClicked)
                this.buttonClicked = !this.buttonClicked;
        }
        this.refreshCalendar();
    }
    ;
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
    fillRelationEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            this.taskDto.RelatedEntityList = [];
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.RelatedEntityId = value.key.Id;
                    let actualEntityType = value.value.replace(/\./g, '_');
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    relatedEntityDto.EntityTitle = GlobalFunctions.sanitizeAndTruncate(value.key.StringRepresentation);
                    this.taskDto.RelatedEntityList.push(relatedEntityDto);
                }
            });
        }
    }
    ;
    refreshCalendar() {
        this.timeoutIds.push(setTimeout(() => {
            this.calendarContentHeight = (this.planningSection.isFullScreen ? 500 : 250);
            let dateTimeNow = null;
            if (!GlobalFunctions.isEmpty(this.editedTaskData) && !GlobalFunctions.isEmpty(this.editedTaskData.RequiredCallbackDate))
                dateTimeNow = new Date(this.editedTaskData.RequiredCallbackDate);
            else if (!GlobalFunctions.isEmpty(this.editedTaskData) && !GlobalFunctions.isEmpty(this.editedTaskData.selectedStartDateTime))
                dateTimeNow = new Date(this.editedTaskData.selectedStartDateTime);
            if (!this.enableWorkweek)
                GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridDay', this.agendaItems, this.currentDate, this.currentAvailability, this.calendarContentHeight, this.translateService, this.selectedSlotCallback, this.enableDurationBox, this.slotLength, false, true, dateTimeNow);
            else
                GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridWeek', this.agendaItems, this.currentDate, this.currentAvailability, this.calendarContentHeight, this.translateService, this.selectedSlotCallback, this.enableDurationBox, this.slotLength, false, true, dateTimeNow);
        }, 100));
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveTask(0));
    }
    ;
    update() {
        this.representativeList = [];
        this.selectedRepresentative = null;
        switch (this.selectedFindFrom) {
            case "ManualEntry":
                {
                    if (this.selectedFindFrom == "ManualEntry") {
                        if (this.currentRelationType == "Person")
                            document.getElementById("customerNameValue")?.focus();
                        else
                            document.getElementById("organizationNameValue")?.focus();
                    }
                    break;
                }
            case "Search":
                {
                    if (this.selectedFindFrom == "Search") {
                        this.openSearchPopup();
                        this.selectedFindFrom = "SelectAny";
                    }
                    break;
                }
            case "RegisterNew":
                {
                    if (this.currentRelationType == "Organization") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addOrganizationResponse;
                            this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    else if (this.currentRelationType == "Person") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addPersonResponse;
                            this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    break;
                }
        }
        this.searchEntityTags = [];
        this.clearSelectedEntity();
    }
    ;
    addPersonResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById("findFromSelectOption")?.focus();
    }
    ;
    addOrganizationResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById("findFromSelectOption")?.focus();
    }
    ;
    fillOrganizationInfo(selectedEntity) {
        if (selectedEntity != null) {
            let organization = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Organization);
            if (organization.Partial != true)
                this.mainEntityObject = organization;
            this.taskDto.MainEntityId = organization.Id;
            this.taskDto.MainEntitySource = organization.ObjectSource;
            this.taskDto.CustomerKVKNumber = organization.AdministeredOrganizationDto.Identification;
            if (organization.RegistrationAddress != null)
                this.taskDto.ContactAddress = this.organizationFormattedAddressWithLabel.transform(organization, false) || '';
            if (!GlobalFunctions.isEmpty(organization.PhoneNumber))
                this.phoneNumber = !GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && !GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId) ? this.sessionManager.currentCallerId : organization.PhoneNumber;
        }
    }
    ;
    selectOptionsFromFindList() {
        let result = GlobalFunctions.isSessionContainsPersonOrganizationRecord(this.sessionManager.detailViewCachedEntityList);
        if (result) {
            this.selectedFindFrom = "Related";
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            if (mainEntityPerson) {
                this.currentRelationType = "Person";
                this.setMainEntity(mainEntityPerson, "Person");
            }
            else {
                this.currentRelationType = "Organization";
                let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
                this.setMainEntity(mainEntityOrganization, "Organization");
            }
        }
        else
            this.selectedFindFrom = "ManualEntry";
    }
    ;
    searchAgendaFound(result) {
        console.log('CreateCallback->searchAgendaFound:', result);
        if (result != null && result.length > 0 && result[0].AvailabilityCollection != null && result[0].AvailabilityCollection.length > 0) {
            this.agendaItems = result[0].AvailabilityCollection[0].AgendaItems;
            this.currentAvailability = result[0].AvailabilityCollection[0].Availability;
            if (!GlobalFunctions.isEmpty(this.taskType) && this.taskType.toLowerCase() == 'appointment') {
                if (!GlobalFunctions.isEmpty(result[0].AvailabilityCollectionList))
                    this.employeeAvailability = result[0].AvailabilityCollectionList[0].Availability;
                if (this.allAvailableMeetingRooms != null) {
                    let selectedRoom;
                    this.allAvailableMeetingRooms.forEach(meetingRoom => {
                        if (this.selectedMeetingRoom == meetingRoom.EmailAddress)
                            selectedRoom = meetingRoom;
                    });
                    if (selectedRoom != null) {
                        if (selectedRoom.Availability != null && selectedRoom.Availability.length > 0) {
                            for (let slot = 0; slot < selectedRoom.Availability.length; slot++) {
                                if (selectedRoom.Availability[slot].FreeBusyStatus != FreeBusyStatus.Free)
                                    this.currentAvailability[slot].FreeBusyStatus = selectedRoom.Availability[slot].FreeBusyStatus;
                            }
                        }
                    }
                }
            }
        }
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("assignHandlerCallbackTagsInputControl")?.focus();
        this.isDepartmentCBNAvailable = true;
        this.showMandatoryField = false;
        this.createTaskStatus = "";
    }
    ;
    setTaskRequiredCallbackDateInfo(taskData) {
        try {
            let requiredCallbackDate = new Date(taskData.RequiredCallbackDate.split("T")[0]);
            this.currentDate = requiredCallbackDate;
            this.selectedDateFromPicker = requiredCallbackDate;
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    showEditTaskDialog(taskData) {
        if (taskData != null) {
            if (!GlobalFunctions.isEmpty(taskData.HandlerTags)) {
                this.handlerTags = taskData.HandlerTags;
                if (this.handlerTags.length > 0)
                    this.handlerTagAdded();
            }
            if (GlobalFunctions.isEmpty(taskData.MainEntityId))
                this.selectedFindFrom = "ManualEntry";
            else
                this.selectedFindFrom = "Related";
            this.taskDto = jQuery.extend(true, {}, taskData);
            if (!GlobalFunctions.isEmpty(this.taskDto) && !GlobalFunctions.isEmpty(this.taskDto.ContactPhoneNumber)) {
                let phoneNumbers = this.taskDto.ContactPhoneNumber.split("/");
                if (phoneNumbers.length == 2) {
                    if (GlobalFunctions.isMobileNumber(phoneNumbers[0])) {
                        this.mobileNumber = phoneNumbers[0];
                        this.phoneNumber = phoneNumbers[1];
                    }
                    else if (GlobalFunctions.isMobileNumber(phoneNumbers[1])) {
                        this.mobileNumber = phoneNumbers[1];
                        this.phoneNumber = phoneNumbers[0];
                    }
                    else {
                        this.phoneNumber = phoneNumbers[0];
                        this.mobileNumber = phoneNumbers[1];
                    }
                }
                else {
                    if (GlobalFunctions.isMobileNumber(phoneNumbers[0]))
                        this.mobileNumber = phoneNumbers[0];
                    else
                        this.phoneNumber = phoneNumbers[0];
                }
            }
            this.priorityValue = taskData.Priority;
            if (!GlobalFunctions.isEmpty(taskData.MainEntityType)) {
                if (typeof this.taskData.MainEntityType === 'number')
                    this.currentRelationType = MainEntityType[taskData.MainEntityType];
                else
                    this.currentRelationType = taskData.MainEntityType;
            }
            this.currentHandlerType = taskData.CurrentHandlerType;
            if (!GlobalFunctions.isEmpty(taskData.SearchEntityTags))
                this.searchEntityTags = taskData.SearchEntityTags;
            if (!GlobalFunctions.isEmpty(this.currentRelationType) && typeof this.currentRelationType === 'string' && this.currentRelationType.toLowerCase() == "organization") {
                let organizationDto = new Object();
                organizationDto.Id = this.taskDto.MainEntityId;
                organizationDto.ObjectSource = this.taskDto.MainEntitySource;
                organizationDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization];
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, organizationDto);
            }
            if (this.handlerTags?.length > 0)
                this.initCalendar();
            this.setTaskRequiredCallbackDateInfo(taskData);
        }
    }
    ;
    assignContactNumberInTaskDto() {
        if (!GlobalFunctions.isEmpty(this.phoneNumber) && !GlobalFunctions.isEmpty(this.mobileNumber))
            this.taskDto.ContactPhoneNumber = this.phoneNumber.replace(/ /g, '') + "/" + this.mobileNumber.replace(/ /g, '');
        else if (!GlobalFunctions.isEmpty(this.phoneNumber))
            this.taskDto.ContactPhoneNumber = this.phoneNumber.replace(/ /g, '');
        else
            this.taskDto.ContactPhoneNumber = this.mobileNumber.replace(/ /g, '');
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addTaskHeader").height() - $("#addTaskFooter").height() + "px";
        $("#addTaskContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        this.refreshCalendar();
        if (!GlobalFunctions.isEmpty(this.taskType) && this.taskType.toLowerCase() === 'appointment') {
            let customerQuestionHeight = $("#jkcParentPanel").height() - $("#addTaskHeader").height() - $("#addTaskFooter").height() - 550;
            let custQuesDiv = $("#customerQuestionFieldDiv");
            custQuesDiv.height((customerQuestionHeight + 20) + "px");
            custQuesDiv.css('min-height', '120px');
            custQuesDiv.css('max-height', '220px');
            let iframHeight;
            let iframeElements = $('[id*="ui-tinymce-"]');
            if (iframeElements && iframeElements.length > 0) {
                iframHeight = customerQuestionHeight - $(".mce-toolbar-grp ").height();
                let iframeElem = iframeElements.length > 2 ? $(iframeElements[2]) : $(iframeElements[0]);
                if (!GlobalFunctions.isEmpty(iframeElem)) {
                    iframeElem.height(iframHeight + "px");
                    iframeElem.css('min-height', '100px');
                    iframeElem.css('max-height', '200px');
                }
            }
        }
    }
    stopDepartmentAvailabilitySpinner() {
        if (this.departmentAvailabilityPopup) {
            this.departmentAvailabilityPopup.close();
            this.departmentAvailabilityPopup = null;
        }
    }
    searchEmployee() {
        const searchPopup = this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL');
        searchPopup.afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
                this.handlerTagAdded();
            }
        });
        // Set isParentPopup to false (will not open in detail view) when opening EmployeePanel from Task
        if (searchPopup && searchPopup.componentInstance)
            searchPopup.componentInstance.isParentPopup = false;
    }
    ;
    resizePlanningSection() {
        this.planningSection.isFullScreen = !this.planningSection.isFullScreen;
        this.refreshCalendar();
    }
    ;
    disableWeekendDates(date, mode) {
        return (mode === 'day' && (date.getDay() === 0 || date.getDay() === 6));
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    ;
    setCustomerQuestion() {
        if (this.taskType.toLowerCase() == 'callbacknote' && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes)) {
            let copyFromSessionNote = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "PREFILLSESSIONNOTESINQUESTION");
            if (!GlobalFunctions.isEmpty(copyFromSessionNote) && copyFromSessionNote.toLowerCase() == "true")
                this.taskDto.CustomerQuestion = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes;
        }
    }
    ;
    prefillSelectedCbnTemplate() {
        if (this.taskType.toLowerCase() == 'callbacknote' && !GlobalFunctions.isEmpty(this.entityParameter) && this.templates?.length > 0) {
            this.currentTemplate = jlinq.from(this.templates).equals("Id", this.entityParameter.Id).first();
            this.templateChanged();
        }
    }
    templateChanged() {
        if (this.editMode) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_TASK_TEMPLATE_CHANGE'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (!result) {
                    this.currentTemplate = null;
                    return;
                }
                else
                    this.updateQuestionBodyAsPerTemplate();
            });
        }
        else
            this.updateQuestionBodyAsPerTemplate();
    }
    ;
    updateQuestionBodyAsPerTemplate() {
        this.taskDto.CustomerQuestion = this.getHtmlBody();
        let customerQuestionContent = this.taskDto.CustomerQuestion;
        let questionBody = $(customerQuestionContent);
        if (questionBody.length > 0) {
            customerQuestionContent = "";
            questionBody.each((i, eachQuestionNode) => {
                if (eachQuestionNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(eachQuestionNode.id) && eachQuestionNode.id == "newQuestionContent") {
                    if (!GlobalFunctions.isEmpty(eachQuestionNode.outerHTML) && eachQuestionNode.outerHTML.indexOf("taskSelectedTemplate") == -1 && !GlobalFunctions.isEmpty(this.currentTemplate))
                        eachQuestionNode.innerHTML = "<div id='taskSelectedTemplate'>" + this.formatManager.mergeTaskTemplate(this.currentTemplate.Content).replace(/([\"]*[\&]*amp;[amp;]*[\"]*)/g, "") + "</div>" + eachQuestionNode.innerHTML.replace(/<p><\/p><p><\/p><p><\/p> <br><br><br><br>/gi, '');
                    else {
                        eachQuestionNode.childNodes.forEach(childNode => {
                            if (childNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(childNode.id) && childNode.id == "taskSelectedTemplate")
                                childNode.innerHTML = !GlobalFunctions.isEmpty(this.currentTemplate) ? this.formatManager.mergeTaskTemplate(this.currentTemplate.Content) : "";
                        });
                    }
                }
            });
        }
        questionBody.each((i, eachQuestionNode) => {
            if (eachQuestionNode.nodeName.toUpperCase() == "#TEXT")
                customerQuestionContent += eachQuestionNode.data;
            else
                customerQuestionContent += eachQuestionNode.outerHTML;
        });
        this.taskDto.CustomerQuestion = customerQuestionContent;
        if (!GlobalFunctions.isEmpty(this.currentTemplate) && this.currentTemplate.RequiredFields?.length > 0)
            this.requiredFields = GlobalFunctions.setRequiredFieldsFromTaskTemplate(this.currentTemplate);
        else
            this.requiredFields = new RequiredFields();
        if (!GlobalFunctions.isEmpty(this.currentTemplate) && this.currentTemplate.HandlerIds?.length > 0) {
            this.handlerTags = [];
            let handlerType = GlobalFunctions.setHandlerListFromTaskTemplate(this.currentTemplate, this.cacheManager, this.handlerTags);
            this.currentHandlerType = handlerType;
        }
    }
    getHtmlBody() {
        return "<div id='newQuestionContent'><p></p><p></p><p></p><p></p> <br/><br/><br/><br/></div>";
    }
    ;
    initEditor() {
        this.tinymceOptions = {
            plugins: TinyMCE.PLUGINS,
            toolbar: TinyMCE.TASK_TOOLBAR,
            font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
            font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
            contextmenu: false,
            browser_spellcheck: true,
            force_br_newlines: false,
            forced_root_block: 'div',
            paste_data_images: true,
            base_url: '/tinymce',
            iframe_aria_text: GlobalFunctions.removeHTMLTags(this.taskDto.CustomerQuestion),
            resize: false,
            elementpath: false,
            menubar: false,
            apply_source_formatting: true,
            statusbar: false,
            entity_encoding: 'raw',
            content_style: "p {margin: 0; padding: 0;} body {font: 400 15px 'Open Sans', sans-serif !important;} body.mce-content-body {height: auto!important;max- height: 296px;overflow - y: auto;margin: 0;padding: 8px;}",
            height: '300',
            paste_postprocess: (plugin, args) => args.node.setAttribute('id', '42'),
            file_picker_types: 'image',
            images_upload_base_path: '/cacheddata/' + GlobalFunctions.getSessionTokenAsString() + '/',
            init_instance_callback: editor => {
                GlobalFunctions.setEditorBodyHeight();
                this.editor = editor;
                editor.on('keydown', event => {
                    if (event.keyCode === 27)
                        this.close();
                });
            },
            file_picker_callback: (callback, value, meta) => {
                this.fileManager.setFilePickerCallback(callback, value, meta, this.editor, EntityName.TASK);
            },
            images_upload_handler: (blobInfo, progress) => {
                return this.fileManager.setFileUploadHandler(blobInfo, progress, this.tinymceOptions.images_upload_base_path, FileUploadSource.Task);
            }
        };
        this.resize();
        if (this.translateService.currentLang != LanaguageCode.EN_CODE)
            this.tinymceOptions.language = LanaguageCode.NL_CODE;
    }
    initDatePickerState() {
        JkcDatePickerHelper.setMargin('120px', '-150px', 'fixed', this.renderer); // Renderere2 - class used to make custom UI changes
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        GlobalFunctions.setDateFormat('selectDatePicker', this.selectedDateFromPicker, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
};
__decorate([
    ViewChild('form')
], TaskAddEditComponent.prototype, "form", void 0);
__decorate([
    ViewChild('calendar')
], TaskAddEditComponent.prototype, "calendar", void 0);
__decorate([
    ViewChild('selectDatePicker')
], TaskAddEditComponent.prototype, "dateInput", void 0);
TaskAddEditComponent = __decorate([
    Component({
        selector: 'task-add-edit',
        template: '<span></span>'
    })
], TaskAddEditComponent);
export { TaskAddEditComponent };
//# sourceMappingURL=task-add-edit.component.js.map