var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { EntityFqdn } from '../../../../../../core/enums/core-enums';
import { PhoneStatus } from '../../../../../../core/enums/phone-enum';
import { SessionStatus } from '../../../../../../core/enums/session-enum';
import { RoutePath } from '../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../shared/global-functions';
import { BaseDialogComponent } from '../../../../../common/base-dialog.component';
let SessionSaveComponent = class SessionSaveComponent extends BaseDialogComponent {
    constructor(router, dialog, chatService, phoneManager, data, sessionService, sessionManager, employeeService, shortcutManager, translateService, dialogRef, integrationSettingManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.chatService = chatService;
        this.phoneManager = phoneManager;
        this.data = data;
        this.sessionService = sessionService;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.integrationSettingManager = integrationSettingManager;
        this.currentCallerId = this.sessionManager.currentCallerId;
        this.sessionDescription = null;
        this.callbackResponse = this.callbackResponse.bind(this);
        this.createSessionErrorCallback = this.createSessionErrorCallback.bind(this);
    }
    ngOnInit() {
        this.sessionDescription = this.data.defaultDescription;
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession) && !GlobalFunctions.isEmpty(this.sessionManager.currentSession.Description))
            this.sessionDescription = this.sessionManager.currentSession.Description;
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveSession());
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    clearAndRedirectToDashboard() {
        this.endCurrentChat();
        this.sessionManager.endSession();
        this.close(true);
        if (this.data.calledDialog != undefined && this.data.calledDialog != null)
            this.data.calledDialog.close(true);
        if (this.data.clickedFrom != undefined && this.data.clickedFrom == "")
            this.router.navigate([RoutePath.DASHBOARD]);
    }
    ;
    callbackResponse(response) {
        if (this.currentCallerId != null)
            this.phoneManager.updatePhoneAvailabilityStatus(PhoneStatus.Available);
        this.currentCallerId = null;
        if (response?.Result != 1) {
            this.stopSpinner();
            this.clearAndRedirectToDashboard();
        }
    }
    ;
    createSessionErrorCallback(status) {
        if (status == 1) {
            this.stopSpinner();
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_SESSION")]);
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_SESSION"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    saveSession() {
        if (this.form.invalid)
            return;
        this.startSpinner();
        const session = this.sessionManager.createCurrentSession(SessionStatus.Park, this.sessionDescription, null, this.data.uiObject, this.data.uiState, this.sessionManager.sessionStartDateTime);
        this.sessionService.createOrUpdateSession(session, this.callbackResponse, this.createSessionErrorCallback);
    }
    endCurrentChat() {
        if (this.chatService.chatMessage != null && !GlobalFunctions.isEmpty(this.chatService.chatMessage.Id)) {
            let message = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "CHATENDMESSAGE");
            let userName = !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee) ? this.employeeService.loggedInEmployee.FirstName : "";
            this.chatService.endChat(userName, message);
        }
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
};
__decorate([
    ViewChild('form')
], SessionSaveComponent.prototype, "form", void 0);
SessionSaveComponent = __decorate([
    Component({
        selector: 'session-save',
        templateUrl: './session-save.component.html',
        styleUrls: ['./session-save.component.scss']
    }),
    __param(4, Inject(MAT_DIALOG_DATA))
], SessionSaveComponent);
export { SessionSaveComponent };
//# sourceMappingURL=session-save.component.js.map