var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { ScreenMode } from 'src/app/core/enums/common-enums';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { TaskStatus, TaskType } from 'src/app/core/enums/task-enum';
import { CreateTaskRequest } from 'src/app/core/models/case/case-task-request';
import { BaseDto } from 'src/app/core/models/common/baseDto';
import { RelatedEntityDto } from 'src/app/core/models/common/related-enityDto';
import { TaskHandlerDto } from 'src/app/core/models/task/task-handlerDto';
import { TaskHistoryDto } from 'src/app/core/models/task/task-historyDto';
import { TaskDto } from 'src/app/core/models/task/taskDto';
import { BroadCastEventKeys, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
let ReportImprovementAddEditComponent = class ReportImprovementAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, eventProvider, dialogManager, data, sessionManager, shortcutManager, translateService, applicationSettingManager, dialogRef) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.data = data;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogRef = dialogRef;
        this.dateJS = Date;
        this.employeeNames = "";
        this.selectedEmployees = [];
        this.taskDto = new TaskDto();
        this.title = this.translateService.instant("LBL_ADD_IMPROVEMENT").toUpperCase();
        this.taskType = "reportimprovement";
        this.isHtmlInjected = false;
        this.subs = new SubSink();
        this.addReportImprovementResponse = this.addReportImprovementResponse.bind(this);
        this.addReportImprovementErrorCallback = this.addReportImprovementErrorCallback.bind(this);
    }
    ngOnInit() {
        this.sessionManager.startSessionIfPossible("TASK", this.data.editMode ? ScreenMode.Edit : ScreenMode.Add);
        if (this.data.editMode) {
            this.taskDto = jQuery.extend(true, {}, this.data.selectedEntity);
            this.title = this.translateService.instant("LBL_EDIT_AS_IMPROVEMENT").toUpperCase();
            if (!GlobalFunctions.isEmpty(this.taskDto) && !GlobalFunctions.isEmpty(this.taskDto.CreatedBy) && !GlobalFunctions.isEmpty(this.taskDto.CreatedBy.StringRepresentation)) {
                if (this.employeeNames.indexOf(this.taskDto.CreatedBy.StringRepresentation) == -1) {
                    this.employeeNames += this.taskDto.CreatedBy.StringRepresentation + '; ';
                    this.selectedEmployees.push(this.taskDto.CreatedBy);
                    $(".searchPopup.jkcSearchCircleClose").show();
                }
            }
        }
        this.getDefaultOwnersEmail();
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.addReportImprovement());
        if (this.data.improvementSessionData != null)
            this.assignSessionDataToDto(this.data.improvementSessionData);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    getDefaultOwnersEmail() {
        let emailAddress = this.applicationSettingManager.getOwnerEmailAddress(this.data.selectedEntity.ObjectSource);
        if (!GlobalFunctions.isEmpty(emailAddress)) {
            this.selectedEmployees = [];
            this.employeeNames = "";
            let splitEmailAddress = emailAddress.split(";");
            for (let index = 0; index < splitEmailAddress.length; index++) {
                if (splitEmailAddress[index] != '') {
                    let getOwnerEmployee = this.cacheManager.getEmployeeByEmailId(splitEmailAddress[index].replace(/ /g, ''));
                    if (getOwnerEmployee != null) {
                        this.selectedEmployees.push(getOwnerEmployee);
                        this.employeeNames = this.employeeNames + getOwnerEmployee.StringRepresentation + '; ';
                    }
                }
            }
            $(".searchPopup.jkcSearchCircleClose").show();
        }
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                if (this.employeeNames.indexOf(result.selectedEmployee.StringRepresentation) == -1) {
                    this.employeeNames += result.selectedEmployee.StringRepresentation + '; ';
                    this.selectedEmployees.push(result.selectedEmployee);
                    $(".searchPopup.jkcSearchCircleClose").show();
                }
            }
        });
    }
    ;
    setTaskEntity() {
        if (!this.data.editMode) {
            this.taskDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            let loggedInEmployee = this.cacheManager.getEmployeeById(GlobalFunctions.getLoggedInUserId());
            loggedInEmployee = GlobalFunctions.setEmployeeExtraProperties(loggedInEmployee);
            let employeeBaseDto = new BaseDto();
            employeeBaseDto.StringRepresentation = loggedInEmployee.StringRepresentation;
            this.taskDto.CreatedBy = employeeBaseDto;
            this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.RequiredCallbackDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenStartDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenEndDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.Tags = this.sessionManager.getTags();
            let relatedEntityDto = new RelatedEntityDto();
            relatedEntityDto.RelatedEntityId = this.data.selectedEntity.Id;
            let actualEntityType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", this.data.selectedEntity).replace(/\./g, '_');
            relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
            relatedEntityDto.ObjectSource = this.data.selectedEntity.ObjectSource;
            this.taskDto.RelatedEntityList.push(relatedEntityDto);
            if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
                this.taskDto.RoleId = this.sessionManager.selectedRole.Id;
        }
        this.taskDto.TaskType = TaskType[TaskType.ReportImprovement];
        this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_ReportImprovement];
        this.taskDto.CurrentStatus = TaskStatus.Unhandled;
        this.taskDto.Priority = 2;
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.CreatedById = this.taskDto.CreatedById;
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.Status = TaskStatus.Unhandled;
        let currentHandlerList = "";
        if (!GlobalFunctions.isEmpty(this.selectedEmployees)) {
            for (let i = 0; i < this.selectedEmployees.length; i++) {
                let taskHandler = new TaskHandlerDto();
                taskHandler.HandlerId = this.selectedEmployees[i].Id;
                taskHandler.HandlerObject = this.selectedEmployees[i];
                taskHandler.HandlerType = 1;
                taskHistoryDto.TaskHandlerList.push(taskHandler);
                if (currentHandlerList.length == 0)
                    currentHandlerList = this.selectedEmployees[i].StringRepresentation;
                else
                    currentHandlerList = currentHandlerList + ", " + this.selectedEmployees[i].StringRepresentation;
            }
        }
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
    }
    ;
    addReportImprovementErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_TASK")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    addReportImprovement() {
        if (!this.form.invalid) {
            this.isHtmlInjected = GlobalFunctions.detectHtmlInjection(this.taskDto.CustomerQuestion);
            if (this.isHtmlInjected)
                console.log("ERROR: ADD SUGGEST AN IMPROVEMENT : HTML injection detected");
            else {
                this.startSpinner();
                this.setTaskEntity();
                let createTaskRequest = new CreateTaskRequest();
                createTaskRequest.TaskDto = this.taskDto;
                this.taskService.createTask(createTaskRequest, this.addReportImprovementResponse, this.addReportImprovementErrorCallback, () => { });
            }
        }
    }
    ;
    addReportImprovementResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        if (response?.Result === 0) {
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.taskDto.Id = response.TaskId;
            this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.sessionManager.selectedEntity = this.taskDto;
            this.sessionManager.selectedEntity.Partial = true;
            this.sessionManager.selectedEntity.TaskType = "reportimprovement";
            this.sessionManager.selectedEntity.locationUrl = `/${RoutePath.DETAIL_PATH}/reportimprovement/${this.taskDto.Id}`;
            if (!this.data.editMode)
                this.sessionManager.addBreadcrumbItems([this.taskDto], null, RoutePath.DETAIL_PATH);
            else {
                let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.sessionManager.addBreadcrumbItems([this.taskDto], null, RoutePath.DETAIL_PATH);
            }
            if (this.router.url === this.sessionManager.selectedEntity.locationUrl)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            else
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_IMPROVEMENT'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_IMPROVEMENT") });
    }
    ;
    clearSearchValue() {
        $(".searchPopup.jkcSearchCircleClose").hide();
        this.employeeNames = "";
        this.selectedEmployees = [];
    }
    ;
    assignSessionDataToDto(sessionData) {
        this.taskDto.CustomerQuestion = sessionData.CustomerQuestion;
        this.selectedEmployees = sessionData.SelectedEmployees;
        this.employeeNames = sessionData.EmployeeNames;
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
};
__decorate([
    ViewChild('form')
], ReportImprovementAddEditComponent.prototype, "form", void 0);
ReportImprovementAddEditComponent = __decorate([
    Component({
        selector: 'report-improvement-add-edit',
        templateUrl: './report-improvement-add-edit.component.html',
        styleUrls: ['./report-improvement-add-edit.component.scss']
    }),
    __param(6, Inject(MAT_DIALOG_DATA))
], ReportImprovementAddEditComponent);
export { ReportImprovementAddEditComponent };
//# sourceMappingURL=report-improvement-add-edit.component.js.map