var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from "@angular/core";
import { ExceptionHelper } from "src/app/shared/helper/exception-helper";
import { SubSink } from 'subsink';
import { OperationType, ScreenMode } from '../../../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../../../core/enums/core-enums';
import { ForwardTaskType, TaskHandlerType, TaskStatus } from '../../../../../../core/enums/task-enum';
import { BaseDto } from '../../../../../../core/models/common/baseDto';
import { TaskHandlerDto } from '../../../../../../core/models/task/task-handlerDto';
import { TaskHistoryDto } from '../../../../../../core/models/task/task-historyDto';
import { TaskDto } from '../../../../../../core/models/task/taskDto';
import { BroadCastEventKeys, RoutePath, SideMenuItem } from '../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../shared/global-functions';
import { DialogHelper } from '../../../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from "../../../../../common/base-dialog.component";
import { MessageboxComponent } from "../../../../../common/messagebox/messagebox.component";
import { EmployeeAgendaComponent } from "../../../../employee/agenda/employee-agenda.component";
let CallbackNoteHandleComponent = class CallbackNoteHandleComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, phoneManager, sessionManager, searchService, eventProvider, dialogManager, shortcutManager, translateService, integrationSettingManager, applicationSettingManager, localSearchResultDataService) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.dateJS = Date;
        this.reasonList = [];
        this.answerList = [];
        this.reasonIndex = null;
        this.answerIndex = null;
        this.enableReasonValidation = false;
        this.enableAnswerValidation = false;
        this.taskDto = this.sessionManager.selectedEntity;
        this.taskHandleOption = 'Completed';
        this.taskHandlingStatusTitle = this.translateService.instant("LBL_ANSWER");
        this.rescheduleDate = new Date();
        this.enableRescheduleTaskDate = false;
        this.answerFreeText = "";
        this.reasonFreeText = "";
        this.requiredCallbackDate = this.taskDto.RequiredCallbackDate;
        this.callbackStartTime = this.taskDto.CallBetweenStartDate;
        this.callbackEndTime = this.taskDto.CallBetweenEndDate;
        this.validationMessage = "";
        this.callbackNoteSendingOption = 0;
        this.forwarded = false;
        this.hasReassignRights = false;
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.reassignReasonFreeText = "";
        this.enableReassignReasonValidation = false;
        this.reassignReasonList = [];
        this.reassignReasonIndex = null;
        this.currentHandlerType = 'Employee';
        this.taskType = 'CALLBACKNOTE';
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.handleTaskResponse = this.handleTaskResponse.bind(this);
        this.forwardTaskResponseReceived = this.forwardTaskResponseReceived.bind(this);
        this.taskHandleRelatedErrorCallback = this.taskHandleRelatedErrorCallback.bind(this);
        this.forwardHandledTaskErrorCallback = this.forwardHandledTaskErrorCallback.bind(this);
        this.sendCallbackAttemptTaskResponse = this.sendCallbackAttemptTaskResponse.bind(this);
        this.taskCallbackAttemptRelatedErrorCallback = this.taskCallbackAttemptRelatedErrorCallback.bind(this);
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 300);
        if (this.taskDto?.TaskHistoryList?.length > 1)
            this.forwarded = true;
        this.sessionManager.startSessionIfPossible("TASK", ScreenMode.Edit);
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.save(0));
        this.subs.sink = this.integrationSettingManager.cacheHandlerSettings().subscribe(() => this.initialize());
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#handleTaskHeader").height() - $("#handleTaskFooter").height() - 1 + "px";
        $("#handleTaskContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    taskHandleOptionChanged() {
        this.enableAnswerValidation = false;
        this.enableReasonValidation = false;
        this.enableReassignReasonValidation = false;
        switch (this.taskHandleOption) {
            case 'Completed':
                {
                    this.taskHandlingStatusTitle = this.translateService.instant("LBL_ANSWER");
                    this.changeAnswerOption();
                    break;
                }
            case 'NotCompleted':
                {
                    this.taskHandlingStatusTitle = this.translateService.instant("LBL_REASON");
                    this.changeReasonOption();
                    break;
                }
            case 'Reassign':
                {
                    this.taskHandlingStatusTitle = this.translateService.instant("LBL_REASON");
                    this.changeReassignReasonOption();
                    break;
                }
        }
    }
    ;
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems != undefined || breadCrumbItems != null) {
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        let index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        }
        this.localSearchResultDataService.localSearchResultData.localResult = [];
        this.localSearchResultDataService.localSearchResultData.contentType = "";
        if (breadCrumbItems != null && breadCrumbItems.length > 0) {
            this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItems[0].sourceUrl.substring(breadCrumbItems[0].sourceUrl.lastIndexOf("/") + 1);
            breadCrumbItems.forEach((el) => {
                if (!el.isDeleted)
                    this.localSearchResultDataService.localSearchResultData.localResult.push(el.itemData);
                this.localSearchResultDataService.localSearchResultData.contentType = el.sourceUrl.substring(el.sourceUrl.lastIndexOf("/") + 1);
            });
            breadCrumbItems[0].isSelected = true;
            this.sessionManager.addBreadcrumbTypeItems(breadCrumbItems, false);
            GlobalFunctions.navigateWithOptionalQueryParam(this.router, breadCrumbItems[0].sourceUrl);
        }
    }
    ;
    handleTaskResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_CONTACT_STATISTIC);
        let taskTypeString = this.translateService.instant("LBL_" + this.taskType.toUpperCase());
        if (response?.Result == 0) {
            this.close();
            if (this.sessionManager.BreadcrumbItems) {
                if (this.sessionManager.BreadcrumbItems.length > 0 && this.sessionManager.BreadcrumbItems.length > (this.sessionManager.selectedBreadcrumbIndex + 1) && this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex + 1][0].sourceUrl.indexOf('/list/task') != -1)
                    this.loadLastSelectedSearchResult();
                else
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
            }
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK'), textMsg: this.translateService.instant(GlobalFunctions.formatStringValue(this.translateService.instant("LBL_MSG_HANDLE_TASK_FAILED"), [taskTypeString])) });
            this.close();
        }
    }
    ;
    sendCallbackAttemptTaskResponse(result) {
        this.stopSpinner();
        if (result != null && result.Result == 0) {
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_ATTEMPT'), textMsg: this.translateService.instant("LBL_MSG_FAILED_CREATE_CALLBACK_ATTEMPT") });
            this.close();
        }
    }
    ;
    taskCallbackAttemptRelatedErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_CALLBACK_ATTEMPT_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    sendCallbackAttemptTaskRequest() {
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = TaskStatus.None;
        taskHistoryDto.Reason = this.selectedReason;
        taskHistoryDto.ReasonFreeText = this.reasonFreeText;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        if (this.taskDto.TaskHistoryList != null && this.taskDto.TaskHistoryList.length > 0) {
            taskHistoryDto.TaskHandlerList = this.taskDto.TaskHistoryList[0].TaskHandlerList;
            if (taskHistoryDto.TaskHandlerList != null && taskHistoryDto.TaskHandlerList.length > 0) {
                for (let index = 0; index < taskHistoryDto.TaskHandlerList.length; index++) {
                    let taskHandler = taskHistoryDto.TaskHandlerList[index];
                    if (taskHandler != null) {
                        let baseDtoObject = new BaseDto();
                        baseDtoObject.Id = taskHandler.HandlerId;
                        taskHistoryDto.TaskHandlerList[index].HandlerObject = baseDtoObject;
                    }
                }
            }
        }
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        this.taskDto.CallbackAttemptDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        if (this.enableRescheduleTaskDate) {
            this.taskDto.RequiredCallbackDate = new this.dateJS(this.selectedStartDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenStartDate = new this.dateJS(this.selectedStartDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.CallBetweenEndDate = new this.dateJS(this.selectedEndDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        }
        this.taskService.sendCallbackAttemptRequest(this.taskDto, this.enableRescheduleTaskDate, this.sendCallbackAttemptTaskResponse, this.taskCallbackAttemptRelatedErrorCallback);
    }
    ;
    taskHandleRelatedErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_CALLBACK_ATTEMPT_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    sendHandleTaskRequest() {
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = TaskStatus.Handled;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        let taskHandler = new TaskHandlerDto();
        taskHandler.HandlerId = GlobalFunctions.getLoggedInUserId();
        taskHandler.HandlerType = TaskHandlerType.Employee;
        let baseDtoObject = new BaseDto();
        baseDtoObject.Id = taskHandler.HandlerId;
        taskHandler.HandlerObject = baseDtoObject;
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.TaskHandlerList.push(taskHandler);
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        this.taskDto.CurrentStatus = TaskStatus.Handled;
        this.taskDto.Result = this.selectedAnswer;
        this.taskDto.ResultFreeText = this.answerFreeText;
        this.taskService.handleTask(this.taskDto, this.handleTaskResponse, this.taskHandleRelatedErrorCallback);
    }
    ;
    forwardHandledTaskErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_TASK_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    sendForwardTaskRequest() {
        if (this.defaultTaskHandlerType != 0 && this.defaultTaskHandlerId != '') {
            let taskHistoryDto = new TaskHistoryDto();
            taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            taskHistoryDto.Status = TaskStatus.Forwarded;
            taskHistoryDto.Reason = this.selectedReason;
            taskHistoryDto.ReasonFreeText = this.reasonFreeText;
            taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            let taskHandler = new TaskHandlerDto();
            taskHandler.HandlerId = this.defaultTaskHandlerId;
            taskHandler.HandlerType = this.defaultTaskHandlerType;
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = taskHandler.HandlerId;
            taskHandler.HandlerObject = baseDtoObject;
            taskHistoryDto.TaskHandlerList = [];
            taskHistoryDto.TaskHandlerList.push(taskHandler);
            this.taskDto.TaskHistoryList = [];
            this.taskDto.TaskHistoryList.push(taskHistoryDto);
            this.taskService.forwardTask(this.taskDto, ForwardTaskType.NotForMe, this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC), this.forwardHandledTaskErrorCallback);
        }
    }
    ;
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
    changeReasonOption() {
        if (this.reasonIndex != null) {
            this.selectedReason = this.reasonList[this.reasonIndex];
            if (!this.isRemarkFieldMandatory)
                this.enableReasonValidation = (this.reasonList.length == (this.reasonIndex + 1));
            else
                this.enableReasonValidation = this.taskHandleOption == 'NotCompleted';
        }
    }
    ;
    changeAnswerOption() {
        if (this.answerIndex != null) {
            this.selectedAnswer = this.answerList[this.answerIndex];
            if (!this.isRemarkFieldMandatory)
                this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
            else
                this.enableAnswerValidation = this.taskHandleOption == 'Completed';
        }
    }
    ;
    changecRescheduleTaskCheck() {
        if (!this.enableRescheduleTaskDate) {
            this.selectedStartDateTime = null;
            this.selectedEndDateTime = null;
            this.validationMessage = "";
        }
    }
    ;
    setDefaultReason() {
        try {
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTFAILEDATTEMPTREASONS");
            if (result != null && result != "") {
                result = result.replace(/\n/g, "\r");
                let splitResult = result.split("\r");
                if (splitResult != null && splitResult.length > 0) {
                    for (let index = 0; index < splitResult.length; index++) {
                        if (splitResult[index] != '')
                            this.reasonList.push(splitResult[index]);
                    }
                }
            }
            this.reasonList.push(this.translateService.instant("LBL_OTHER"));
            this.changeReasonOption();
        }
        catch (e) { }
    }
    ;
    setDefaultAnswer() {
        try {
            let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTANSWERS");
            if (result != null && result != "") {
                result = result.replace(/\n/g, "\r");
                let splitResult = result.split("\r");
                if (splitResult != null && splitResult.length > 0) {
                    for (let index = 0; index < splitResult.length; index++) {
                        if (splitResult[index] != '')
                            this.answerList.push(splitResult[index]);
                    }
                }
            }
            this.answerList.push(this.translateService.instant("LBL_OTHER"));
            this.timeoutIds.push(setTimeout(() => this.answerList));
            this.changeAnswerOption();
        }
        catch (e) { }
    }
    ;
    setDefaultHandler() {
        this.defaultTaskHandlerId = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTTASKHANDLERID");
        if (GlobalFunctions.isEmpty(this.defaultTaskHandlerId))
            this.defaultTaskHandlerId = 'ac47b52f48d749168362245833f47307';
        let defaultTaskHandlerType = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTTASKHANDLERTYPE");
        this.defaultTaskHandlerType = TaskHandlerType.None;
        switch (defaultTaskHandlerType) {
            case "1":
                this.defaultTaskHandlerType = TaskHandlerType.Employee;
                break;
            case "2":
                this.defaultTaskHandlerType = TaskHandlerType.Department;
                break;
            case "3":
                this.defaultTaskHandlerType = TaskHandlerType.Mailbox;
                break;
        }
    }
    ;
    disabled(date, mode) {
        return (mode === 'day' && (date.getDay() === 0 || date.getDay() === 6));
    }
    ;
    open() {
        if (this.enableRescheduleTaskDate) {
            DialogHelper.openDialog(this.dialog, EmployeeAgendaComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), {}).afterClosed().subscribe(innerResult => {
                if (innerResult.result && innerResult.selectedStartDateTime != null && innerResult.selectedEndDateTime != null) {
                    this.selectedStartDateTime = innerResult.selectedStartDateTime;
                    this.selectedEndDateTime = innerResult.selectedEndDateTime;
                    this.validationMessage = "";
                }
            });
        }
    }
    ;
    toSuperscript(value) {
        let retValue = "";
        if (value > 0) {
            if (this.translateService.currentLang.toLowerCase() == "nl")
                retValue = "e";
            else {
                let strValue = value.toString();
                let lastDigit = parseInt(strValue.substring(strValue.length - 1, 1));
                switch (lastDigit) {
                    case 1:
                        retValue = "st";
                        break;
                    case 2:
                        retValue = "nd";
                        break;
                    case 3:
                        retValue = "rd";
                        break;
                    default:
                        retValue = "th";
                        break;
                }
            }
        }
        return retValue;
    }
    ;
    validateAttempts() {
        let message = this.autoHandleCBNAfterFailedAttempts == 'true' ? this.translateService.instant("LBL_MSG_EXCEED_CALLBACK_ATTEMPT_AUTO_HANDLE") : this.translateService.instant("LBL_MSG_EXCEED_CALLBACK_ATTEMPT");
        message = GlobalFunctions.formatStringValue(message, [this.taskDto.CallbackAttemptCount, this.toSuperscript(this.taskDto.CallbackAttemptCount)]);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_ATTEMPT'), textMsg: message }).afterClosed().subscribe(() => {
            this.sendCallbackAttemptTaskRequest();
            if (this.autoHandleCBNAfterFailedAttempts == 'true')
                this.sendHandleTaskRequest();
            else
                this.sendForwardTaskRequest();
        });
    }
    save(callbackSendingOption) {
        try {
            this.validationMessage = "";
            this.taskDto.SendAsAppointment = callbackSendingOption == 1;
            this.form.onSubmit(null);
            if ((this.taskHandleOption === 'Reassign' && this.handlerTags.length === 0) || this.form.invalid)
                return;
            switch (this.taskHandleOption) {
                case 'Completed': {
                    this.startSpinner();
                    this.sendHandleTaskRequest();
                    break;
                }
                case 'NotCompleted': {
                    if (this.enableRescheduleTaskDate) {
                        if (this.selectedStartDateTime != null || this.selectedStartDateTime != undefined) {
                            let currentDate = new this.dateJS();
                            let currentDateWithSeconds = new this.dateJS(currentDate.getFullYear(), currentDate.getMonth(), currentDate.getDate(), currentDate.getHours(), currentDate.getMinutes(), 0, 0);
                            if (this.selectedStartDateTime < currentDateWithSeconds)
                                this.validationMessage = this.translateService.instant("LBL_CALLBACK_DATE_WARNING");
                        }
                        else
                            this.validationMessage = this.translateService.instant("LBL_MSG_RESCHEDULE_DATE");
                    }
                    if (GlobalFunctions.isEmpty(this.validationMessage)) {
                        this.startSpinner();
                        this.taskDto.CallbackAttemptCount += 1;
                        if (this.taskDto.CallbackAttemptCount >= this.allowedNumberOfFailedAttempts && !this.enableRescheduleTaskDate)
                            this.validateAttempts();
                        else
                            this.sendCallbackAttemptTaskRequest();
                    }
                    break;
                }
                case 'Reassign':
                    {
                        this.reassignTask();
                        break;
                    }
            }
            if (this.applicationSettingManager.autoIgnoreSession)
                this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager, false);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ;
    initialize() {
        this.allowedNumberOfFailedAttempts = parseInt(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "ALLOWEDNUMBEROFFAILEDATTEMPTS"));
        this.autoHandleCBNAfterFailedAttempts = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "AUTOHANDLECALLBACKNOTE").toLowerCase();
        this.isRemarkFieldMandatory = GlobalFunctions.toBoolean(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "ISREMARKFIELDMANDATORY").toLowerCase());
        this.setDefaultHandler();
        this.setDefaultReason();
        this.setDefaultAnswer();
        this.initCallbackNoteSendingOption();
        this.setDefaultReassignReason();
        this.setReassignRights();
        this.phoneManager.setPhoneStatusAction("0");
    }
    ;
    initCallbackNoteSendingOption() {
        let callbackNoteSendingOption = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "CALLBACKNOTESENDINGOPTION");
        if (!GlobalFunctions.isEmpty(callbackNoteSendingOption))
            this.callbackNoteSendingOption = parseInt(callbackNoteSendingOption);
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("assignHandlerTagsInputControl").focus();
    }
    ;
    setDefaultReassignReason() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTNOTFORMEREASONS");
        if (!GlobalFunctions.isEmpty(result)) {
            result = result.replace(/\n/g, "\r");
            let splitResult = result.split("\r");
            if (splitResult != null && splitResult.length > 0) {
                for (let index = 0; index < splitResult.length; index++) {
                    if (splitResult[index] != '')
                        this.reassignReasonList.push(splitResult[index]);
                }
            }
        }
        this.reassignReasonList.push(this.translateService.instant("LBL_OTHER"));
        this.changeReassignReasonOption();
    }
    ;
    changeReassignReasonOption() {
        if (this.reassignReasonIndex != null) {
            this.selectedReassignReason = this.reassignReasonList[this.reassignReasonIndex];
            if (!this.isRemarkFieldMandatory)
                this.enableReassignReasonValidation = (this.reassignReasonList.length == (this.reassignReasonIndex + 1));
            else
                this.enableReassignReasonValidation = this.taskHandleOption == 'Reassign';
        }
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    ;
    setReassignRights() {
        let contentType = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Task]);
        let objectSource = GlobalFunctions.getObjectSourceForTask(this.taskType);
        this.hasReassignRights = GlobalFunctions.hasRight(contentType, OperationType.Reassign, objectSource);
    }
    reassignTask() {
        if (this.handlerTags.length > 0) {
            this.startSpinner();
            let taskHandlerDto = new TaskHandlerDto();
            taskHandlerDto.HandlerId = this.handlerTags[0].Id;
            taskHandlerDto.HandlerType = TaskHandlerType[this.currentHandlerType];
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = this.handlerTags[0].Id;
            taskHandlerDto.HandlerObject = baseDtoObject;
            if (taskHandlerDto.HandlerType == TaskHandlerType.Mailbox)
                taskHandlerDto.DepartmentId = this.handlerTags[0].Department;
            let taskHistoryDto = new TaskHistoryDto();
            taskHistoryDto.Reason = this.selectedReassignReason;
            taskHistoryDto.ReasonFreeText = this.reassignReasonFreeText;
            taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            taskHistoryDto.Status = TaskStatus.Forwarded;
            taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            taskHistoryDto.TaskHandlerList.push(taskHandlerDto);
            baseDtoObject = new BaseDto();
            baseDtoObject.Id = taskHistoryDto.CreatedById;
            let loggedInEmployee = this.cacheManager.getEmployeeById(taskHistoryDto.CreatedById);
            if (!GlobalFunctions.isEmpty(loggedInEmployee))
                baseDtoObject.StringRepresentation = loggedInEmployee.StringRepresentation;
            taskHistoryDto.CreatedBy = baseDtoObject;
            let taskDto = new TaskDto();
            taskDto = this.sessionManager.selectedEntity;
            taskDto.TaskHistoryList = [];
            taskDto.TaskHistoryList.push(taskHistoryDto);
            taskDto.CurrentStatus = TaskStatus.Unhandled;
            this.taskService.forwardTask(taskDto, ForwardTaskType.Reassign, this.forwardTaskResponseReceived, this.forwardHandledTaskErrorCallback);
        }
        else
            this.validationMessage = "LBL_MSG_EMPTY_HANDLER";
    }
    ;
    forwardTaskResponseReceived(result) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        if (result.Result == 0) {
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
            if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems))
                this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex][0].isDeleted = true;
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAILED_TO_FORWARD_TASK") });
    }
    ;
    onTagClick(tag) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider);
    }
    ;
};
__decorate([
    ViewChild('form')
], CallbackNoteHandleComponent.prototype, "form", void 0);
CallbackNoteHandleComponent = __decorate([
    Component({
        selector: 'callback-note-handle',
        templateUrl: './callback-note-handle.component.html',
        styleUrls: ['./callback-note-handle.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], CallbackNoteHandleComponent);
export { CallbackNoteHandleComponent };
//# sourceMappingURL=callback-note-handle.component.js.map