var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from '../../../../../../components/common/base-dialog.component';
import { ScreenMode } from '../../../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../../../core/enums/core-enums';
import { TaskHandlerType, TaskStatus } from '../../../../../../core/enums/task-enum';
import { AttachmentDto } from '../../../../../../core/models/attachment/attachmentDto';
import { BaseDto } from '../../../../../../core/models/common/baseDto';
import { TaskHandlerDto } from '../../../../../../core/models/task/task-handlerDto';
import { TaskHistoryDto } from '../../../../../../core/models/task/task-historyDto';
import { BroadCastEventKeys, RoutePath, SideMenuItem } from '../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../shared/global-functions';
import { DialogHelper } from '../../../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../../../shared/helper/exception-helper';
import { MessageboxComponent } from '../../../../../common/messagebox/messagebox.component';
let AssignmentHandleComponent = class AssignmentHandleComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, phoneManager, dialogManager, searchService, eventProvider, sessionManager, shortcutManager, translateService, applicationSettingManager, localSearchResultDataService) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.dateJS = Date;
        this.taskDto = this.sessionManager.selectedEntity;
        this.fileAttachments = [];
        this.uploadedFiles = [];
        this.timeoutIds = [];
        this.handleTaskResponse = this.handleTaskResponse.bind(this);
        this.taskHandleRelatedErrorCallback = this.taskHandleRelatedErrorCallback.bind(this);
    }
    ngOnInit() {
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.sessionManager.startSessionIfPossible("TASK", ScreenMode.Edit);
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.save());
        document.getElementById("answerFieldTextArea").focus();
        this.phoneManager.setPhoneStatusAction("0");
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems)
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        this.localSearchResultDataService.localSearchResultData.localResult = [];
        this.localSearchResultDataService.localSearchResultData.contentType = "";
        if (breadCrumbItems != null && breadCrumbItems.length > 0) {
            this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItems[0].sourceUrl.substring(breadCrumbItems[0].sourceUrl.lastIndexOf("/") + 1);
            breadCrumbItems.forEach((breadCrumbItem, i) => {
                if (!breadCrumbItem.isDeleted)
                    this.localSearchResultDataService.localSearchResultData.localResult.push(breadCrumbItem.itemData);
                this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItem.sourceUrl.substring(breadCrumbItem.sourceUrl.lastIndexOf("/") + 1);
            });
            breadCrumbItems[0].isSelected = true;
            this.sessionManager.addBreadcrumbTypeItems(breadCrumbItems, false);
            GlobalFunctions.navigateWithOptionalQueryParam(this.router, breadCrumbItems[0].sourceUrl);
        }
    }
    ;
    handleTaskResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_CONTACT_STATISTIC);
        if (response?.Result == 0) {
            this.close();
            if (this.applicationSettingManager.autoIgnoreSession)
                this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
            else if (this.sessionManager.BreadcrumbItems.length > 0 && this.sessionManager.BreadcrumbItems.length > (this.sessionManager.selectedBreadcrumbIndex + 1) && this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex + 1][0].sourceUrl.indexOf('/list/task') != -1)
                this.loadLastSelectedSearchResult();
            else
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
        }
        else {
            let message = this.translateService.instant("MSG_HANDLE_TASK_FAILED");
            message = GlobalFunctions.formatStringValue(message, [this.translateService.instant("LBL_ASSIGNMENT")]);
            message = this.translateService.instant(message);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('TASK'), textMsg: message });
            this.close();
        }
    }
    ;
    taskHandleRelatedErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_HANDLE_TASK_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    ;
    sendHandleTaskRequest() {
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = TaskStatus.Handled;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        let taskHandler = new TaskHandlerDto();
        taskHandler.HandlerId = GlobalFunctions.getLoggedInUserId();
        taskHandler.HandlerType = TaskHandlerType.Employee;
        let baseDtoObject = new BaseDto();
        baseDtoObject.Id = taskHandler.HandlerId;
        taskHandler.HandlerObject = baseDtoObject;
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.TaskHandlerList.push(taskHandler);
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        this.taskDto.CurrentStatus = TaskStatus.Handled;
        this.taskDto.Result = this.selectedAnswer;
        if (this.fileAttachments.length > 0) {
            if (GlobalFunctions.isEmpty(this.taskDto.AttachmentList))
                this.taskDto.AttachmentList = [];
            for (let i = 0; i < this.fileAttachments.length; i++) {
                const attachment = new AttachmentDto();
                attachment.OnServer = !GlobalFunctions.isEmpty(this.fileAttachments[i].id);
                attachment.FileName = this.fileAttachments[i].fileNameOnServer;
                attachment.Name = this.fileAttachments[i].text;
                attachment.IsMarked = true;
                attachment.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Notes_Entities_InformationResponse;
                this.taskDto.AttachmentList.push(attachment);
            }
        }
        this.taskService.handleTask(this.taskDto, this.handleTaskResponse, this.taskHandleRelatedErrorCallback);
    }
    ;
    save() {
        if (this.form.invalid)
            return;
        this.startSpinner();
        this.sendHandleTaskRequest();
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    ;
    onUpload(file) {
        this.startSpinner();
        this.errorMessage = '';
        this.uploadedFiles[this.uploadedFiles.length] = file.name;
    }
    ;
    onSuccess(response) {
        this.fileAttachments.push({ text: this.uploadedFiles[this.uploadedFiles.length - 1], fileNameOnServer: response[0].fileName });
        this.errorMessage = '';
        this.stopSpinner();
    }
    ;
    onError(error) {
        this.uploadedFiles.splice(this.uploadedFiles.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(error, this.translateService);
        this.stopSpinner();
    }
    ;
    onTagClick(tag) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider);
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#handleAssignmentImprovementHeader").height() - $("#handleAssignmentImprovementFooter").height() + "px";
        $("#handleAssignmentImprovementContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], AssignmentHandleComponent.prototype, "form", void 0);
AssignmentHandleComponent = __decorate([
    Component({
        selector: 'assignment-handle',
        templateUrl: './assignment-handle.component.html',
        styleUrls: ['./assignment-handle.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], AssignmentHandleComponent);
export { AssignmentHandleComponent };
//# sourceMappingURL=assignment-handle.component.js.map