var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from '../../../../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../../../../core/models/common/context-menu';
import { Menu } from '../../../../../../../core/models/common/menu';
import { BroadCastEventKeys } from '../../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../../shared/global-functions';
import { BaseDetailComponent } from '../../../../../../common/base-detail.component';
let AppointmentDetailSmartCjmComponent = class AppointmentDetailSmartCjmComponent extends BaseDetailComponent {
    constructor(taskService, phoneManager, eventProvider, sessionManager, dialogManager, translateService, contextMenuService, integrationSettingManager) {
        super(phoneManager, dialogManager, translateService);
        this.taskService = taskService;
        this.phoneManager = phoneManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.contextMenuService = contextMenuService;
        this.integrationSettingManager = integrationSettingManager;
        this.isPerson = this.sessionManager.selectedEntity.MainEntityObject?.ObjectSource?.includes('Person');
        this.fetchAppointmentDetailResponse = this.fetchAppointmentDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        try {
            this.startSpinner();
            this.taskService.fetchAppointmentDetail(this.sessionManager.selectedEntity.Id, this.fetchAppointmentDetailResponse);
        }
        catch (e) {
            console.error(e);
        }
    }
    fetchAppointmentDetailResponse(response) {
        if (response?.AppointmentDto) {
            this.isPerson = this.sessionManager.selectedEntity.MainEntityObject?.ObjectSource?.includes('Person');
            this.sessionManager.selectedEntity = response.AppointmentDto;
            this.sessionManager.selectedEntity.location = this.sessionManager.getAppointmentLocation(response.AppointmentDto.Location);
            this.sessionManager.selectedEntity.product = this.sessionManager.getAppointmentProduct(response.AppointmentDto.ServiceId);
            this.sendRelatedRequest.emit();
            this.menu.addOrUpdateMenuItem(0, this.sessionManager.selectedEntity.TaskType.toString() + 'Detail', this.translateService.instant('LBL_' + this.sessionManager.selectedEntity.TaskType.toUpperCase()), false, true, true);
            this.addMenuItem.emit(this.menu);
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.contextMenuService.loadActionButton(detailEntityType);
        }
        this.stopSpinner();
    }
};
AppointmentDetailSmartCjmComponent = __decorate([
    Component({
        selector: 'appointment-detail-smart-cjm',
        templateUrl: './appointment-detail-smart-cjm.component.html',
        styleUrls: ['./appointment-detail-smart-cjm.component.scss']
    })
], AppointmentDetailSmartCjmComponent);
export { AppointmentDetailSmartCjmComponent };
//# sourceMappingURL=appointment-detail-smart-cjm.component.js.map