var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { ContextMenuView, DateCompareType, DocumentFormat, OperationType, ScreenMode } from '../../../../core/enums/common-enums';
import { TaskSource } from '../../../../core/enums/core-enums';
import { SessionStatus } from '../../../../core/enums/session-enum';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { DateCriteriaDto } from '../../../../core/models/common/date-criteria';
import { ScheduledWorkDto } from '../../../../core/models/common/schedule-workDto';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../../core/models/common/string-criteria';
import { FilterEntryDto } from '../../../../core/models/filter/filter-entryDto';
import { FilterList } from '../../../../core/models/filter/filter-list';
import { FilterDto } from '../../../../core/models/filter/filterDto';
import { ContentType, TaskSearchField } from '../../../../core/models/jkc-object/jkc-object';
import { CreateExportReportRequest } from '../../../../core/models/report/create-export-report-request';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { PrintComponent } from '../../../common/print/print.component';
import { TaskHandlerType } from '../../../../core/enums/task-enum';
let TaskSearchResultComponent = class TaskSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, dialog, datePipe, taskService, sortManager, searchService, cacheManager, dialogManager, sessionManager, formatManager, eventProvider, sessionService, taskFilterPipe, activatedRoute, viewContainerRef, employeeService, translateService, changeDetectorRef, htmlToPlainTextPipe, contactHistoryService, applicationSettingManager, downloadService, integrationSettingManager, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.dialog = dialog;
        this.datePipe = datePipe;
        this.taskService = taskService;
        this.sortManager = sortManager;
        this.searchService = searchService;
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.formatManager = formatManager;
        this.eventProvider = eventProvider;
        this.sessionService = sessionService;
        this.taskFilterPipe = taskFilterPipe;
        this.activatedRoute = activatedRoute;
        this.viewContainerRef = viewContainerRef;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.changeDetectorRef = changeDetectorRef;
        this.htmlToPlainTextPipe = htmlToPlainTextPipe;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.downloadService = downloadService;
        this.integrationSettingManager = integrationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.dateJS = Date;
        this.tags = [];
        this.locations = {};
        this.selectedIndex = 0;
        this.selectContent = true;
        this.previousTaskCount = null;
        this.previousSessionCount = null;
        this.filterList = new FilterList();
        this.loggedInUserId = GlobalFunctions.getLoggedInUserId();
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.createReportResponse = this.createReportResponse.bind(this);
        this.searchTaskResultFound = this.searchTaskResultFound.bind(this);
        this.searchSessionResultFound = this.searchSessionResultFound.bind(this);
        this.updateSearchStatusFromSession = this.updateSearchStatusFromSession.bind(this);
        this.employeeFetchingCompleted = this.employeeFetchingCompleted.bind(this);
        this.subs.sink = activatedRoute.queryParams.subscribe(queryParams => this.selectedOption = queryParams.filter || '');
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_LOCATIONS_SEARCH_RESULTS).subscribe(location => this.selectLocation(location));
    }
    ngOnInit() {
        this.type = EntityName.TASK;
        this.resultList = [];
        this.filteredSearchResult = [];
        this.sessionManager.localSearchFieldList = this.applicationSettingManager.getSearchFieldListByEntity(ContentType.Task);
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase().includes("task")) {
            this.sourceCount = 0;
            this.filterList.Filters = this.taskService.lastAppliedFilters;
            this.filterList.FilterOptions = this.taskService.filterOptions;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.locations = {};
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_LOCATIONS, this.locations);
            this.taskService.scheduleWorkList = [];
            this.searchStatusMessage = "";
            if (!this.employeeService.isEmployeesReceived)
                this.employeeService.globalEventEmployeeFetchCompleted = this.employeeFetchingCompleted;
            this.updateSearchStatus(this.activeHandlersObj);
            if (!this.selectedOption)
                this.searchTasks();
            else if (this.selectedOption === 'my')
                this.searchMyTasks();
            else
                this.searchTasksByParam();
            this.filterList.Filters = [];
            this.filterList.FilterOptions = this.getTaskFilters();
        }
        this.sessionManager.contextMenu = new ContextMenu('', 'TASK', this.translateService, null, GlobalFunctions.getLoggedInUserId(), ContextMenuView.SearchList, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    employeeFetchingCompleted() {
        if (this.taskService?.scheduleWorkList?.length > 0) {
            this.taskService.scheduleWorkList.forEach(scheduleWorkDto => {
                if (scheduleWorkDto.ScheduledWorkType == 'Session') {
                    scheduleWorkDto.CurrentHandlerName = GlobalFunctions.getHandlerName(scheduleWorkDto.ObjectSourceDto.CurrentUserId, this.cacheManager);
                    scheduleWorkDto.CurrentHandlerDepartmentName = this.getHandlerDepartmentName(scheduleWorkDto.ObjectSourceDto.CurrentUserId);
                }
                else {
                    scheduleWorkDto.CurrentHandlerName = GlobalFunctions.getTaskHandlerNameList(scheduleWorkDto.ObjectSourceDto.CurrentHandlerList, this.cacheManager, ' - ');
                    scheduleWorkDto.CurrentHandlerDepartmentName = this.getHandlerListDepartmentNames(scheduleWorkDto.ObjectSourceDto.CurrentHandlerList);
                }
            });
        }
    }
    ;
    selectAllTask() {
        this.taskService.scheduleWorkList.forEach((value, key) => {
            if (value != null)
                value.IsMarked = this.selectContent;
        });
        this.selectContent = !this.selectContent;
    }
    ;
    removeLoadedSessionFromSessionsList(result, id) {
        let removableSession = -1;
        if (!GlobalFunctions.isEmpty(result) && !GlobalFunctions.isEmpty(id)) {
            for (let index = 0; index < result.length; index++) {
                if (!GlobalFunctions.isEmpty(result[index]) && result[index].Id == id) {
                    removableSession = index;
                    break;
                }
            }
            if (removableSession > -1)
                result.splice(removableSession, 1);
        }
        return result;
    }
    ;
    searchTaskResultFound(result) {
        if (result?.length > 0) {
            const taskArrayList = this.convertTaskToScheduleWorkDto(result);
            if (taskArrayList?.length > 0)
                this.taskService.scheduleWorkList = this.taskService.scheduleWorkList.concat(taskArrayList);
            GlobalFunctions.updateResultListWitTags(this.isTagFeatureEnabled, this.taskService.scheduleWorkList, this.applicationSettingManager);
            this.resultList = this.taskService.scheduleWorkList;
            this.resultList = this.sortManager.sortEntityBasedOnApplicationSetting('TASK', this.resultList);
            this.sessionManager.setBgColorBasedOnObjectSource(result);
        }
    }
    searchSessionResultFound(result) {
        if (result?.length > 0) {
            if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession) && !GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
                result = this.removeLoadedSessionFromSessionsList(result, this.sessionManager.currentSession.Id);
            const sessionArrayList = this.convertSessionToScheduleWorkDto(result);
            if (sessionArrayList?.length > 0)
                this.taskService.scheduleWorkList = this.taskService.scheduleWorkList.concat(sessionArrayList);
            this.resultList = this.taskService.scheduleWorkList;
            this.sessionManager.setBgColorBasedOnObjectSource(result);
        }
    }
    ;
    getHandlerListDepartmentNames(taskHandlerDtoList) {
        let handlerList = '';
        let departmentList = [];
        if (handlerList != null && !GlobalFunctions.isEmpty(taskHandlerDtoList) && taskHandlerDtoList.length > 0) {
            if (taskHandlerDtoList[0].HandlerType == TaskHandlerType.Employee || taskHandlerDtoList[0].HandlerType == 'Employee') {
                for (let index1 = 0; index1 < taskHandlerDtoList.length; index1++) {
                    let employee = this.cacheManager.getEmployeeById(taskHandlerDtoList[index1].HandlerId);
                    if (employee != null && employee != undefined && employee.Department != undefined && employee.Department.Name != undefined && employee.Department.Name.length > 0) {
                        if (!jlinq.from(departmentList).contains(employee.Department.Name).any()) {
                            departmentList.push(employee.Department.Name);
                            if (handlerList == '')
                                handlerList = employee.Department.Name;
                            else
                                handlerList += ' - ' + employee.Department.Name;
                        }
                    }
                }
            }
            else if (taskHandlerDtoList[0].HandlerType == TaskHandlerType.Mailbox || taskHandlerDtoList[0].HandlerType == "Mailbox") {
                let mailbox = this.cacheManager.getTaskMailboxById(taskHandlerDtoList[0].HandlerId);
                if (mailbox != null && !GlobalFunctions.isEmpty(mailbox.Department)) {
                    let department = this.cacheManager.getDepartmentById(mailbox.Department);
                    if (department != null)
                        handlerList = department.Name;
                }
            }
        }
        return handlerList;
    }
    getHandlerDepartmentName(id) {
        let handlerName = '';
        if (!GlobalFunctions.isEmpty(id)) {
            let employee = this.cacheManager.getEmployeeById(id);
            if (employee != null && employee != undefined && employee.Department != undefined && employee.Department.Name != undefined && employee.Department.Name.length > 0)
                handlerName = employee.Department.Name;
        }
        return handlerName;
    }
    convertTaskToScheduleWorkDto(taskResultList) {
        let taskArrayList = null;
        if (taskResultList != null && taskResultList.length > 0) {
            taskArrayList = [];
            taskResultList.forEach(currentTaskDto => {
                if (GlobalFunctions.isEmpty(currentTaskDto.PrivateFields) || currentTaskDto.PrivateFields.indexOf('|CREATEDBY|') == -1)
                    currentTaskDto.CreatedBy = this.cacheManager.getEmployeeById(currentTaskDto.CreatedById);
                let scheduledWorkDto = new ScheduledWorkDto();
                scheduledWorkDto.Id = currentTaskDto.Id;
                scheduledWorkDto.Priority = currentTaskDto.Priority;
                scheduledWorkDto.CallbackAttemptCount = currentTaskDto.CallbackAttemptCount;
                scheduledWorkDto.CurrentHandlerName = GlobalFunctions.getTaskHandlerNameList(currentTaskDto.CurrentHandlerList, this.cacheManager, ' - ');
                scheduledWorkDto.CurrentHandlerDepartmentName = this.getHandlerListDepartmentNames(currentTaskDto.CurrentHandlerList);
                if (currentTaskDto.TaskType?.toLowerCase() == 'reportimprovement')
                    scheduledWorkDto.ScheduledWorkDescription = currentTaskDto.CustomerQuestion;
                else
                    scheduledWorkDto.ScheduledWorkDescription = this.htmlToPlainTextPipe.transform(currentTaskDto.CustomerQuestion);
                scheduledWorkDto.ScheduledWorkType = currentTaskDto.TaskType;
                scheduledWorkDto.ScheduledWorkSubType = currentTaskDto.SubTaskType;
                scheduledWorkDto.ScheduledWorkSubject = currentTaskDto.ContactPerson;
                scheduledWorkDto.ScheduledWorkReceivedDate = currentTaskDto.CreatedDate;
                scheduledWorkDto.ScheduledWorkCallbackDate = currentTaskDto.RequiredCallbackDate;
                scheduledWorkDto.ScheduledWorkCallbackDateText = this.datePipe.transform(currentTaskDto.RequiredCallbackDate, this.sessionManager.defaultOptions.defaultDateFormat);
                scheduledWorkDto.ScheduledWorkCallbackDateStartTime = currentTaskDto.CallBetweenStartDate;
                scheduledWorkDto.ScheduledWorkCallbackDateEndTime = currentTaskDto.CallBetweenEndDate;
                scheduledWorkDto.ScheduledWorkReceivedDateText = this.datePipe.transform(currentTaskDto.CreatedDate, this.sessionManager.defaultOptions.defaultDateFormat);
                scheduledWorkDto.ObjectSourceDto = currentTaskDto;
                scheduledWorkDto.ObjectSource = currentTaskDto.ObjectSource;
                scheduledWorkDto.StringRepresentation = scheduledWorkDto.ScheduledWorkDescription;
                scheduledWorkDto.RelatedEntityFqdn = currentTaskDto.TaskType;
                scheduledWorkDto.Location = currentTaskDto.Location;
                scheduledWorkDto.HasPartialViewRights = currentTaskDto.HasPartialViewRights;
                scheduledWorkDto.PrivateFields = currentTaskDto.PrivateFields;
                scheduledWorkDto.Tags = currentTaskDto.Tags;
                scheduledWorkDto.IsMyTask = currentTaskDto.IsMyTask;
                scheduledWorkDto.LockedBy = {};
                scheduledWorkDto.LockedBy.Show = currentTaskDto.ShowLockedBy;
                scheduledWorkDto.CurrentStatus = currentTaskDto.CurrentStatus;
                this.setLookingOnTask(currentTaskDto, scheduledWorkDto);
                if (!GlobalFunctions.isEmpty(currentTaskDto.LockedBy)) {
                    scheduledWorkDto.LockedBy.HandlerId = currentTaskDto.LockedBy;
                    let handlerObject = this.cacheManager.getEmployeeById(scheduledWorkDto.LockedBy.HandlerId);
                    scheduledWorkDto.LockedBy.HandlerName = handlerObject ? handlerObject.StringRepresentation : '';
                    scheduledWorkDto.LockedBy.Show = scheduledWorkDto.LockedBy.HandlerId == GlobalFunctions.getLoggedInUserId();
                }
                taskArrayList.push(scheduledWorkDto);
                if (!GlobalFunctions.isEmpty(currentTaskDto.Location)) {
                    if (this.locations[currentTaskDto.Location] == null)
                        this.locations[currentTaskDto.Location] = 1;
                    else
                        this.locations[currentTaskDto.Location]++;
                }
            });
        }
        this.locations = GlobalFunctions.sortDictionary(this.locations);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_LOCATIONS, this.locations);
        return taskArrayList;
    }
    setLookingOnTask(currentTaskDto, scheduledWorkDto) {
        let lookingOn = {};
        lookingOn.Title = this.translateService.instant('LBL_ASSIGN_ITEM');
        if (!GlobalFunctions.isEmpty(currentTaskDto.LookingBy)) {
            lookingOn.UserId = currentTaskDto.LookingBy;
            let userObject = this.cacheManager.getEmployeeById(lookingOn.UserId);
            lookingOn.UserName = userObject ? userObject.StringRepresentation : '';
            lookingOn.ByOtherUser = lookingOn.UserId != GlobalFunctions.getLoggedInUserId();
            lookingOn.Title = lookingOn.ByOtherUser ? GlobalFunctions.formatStringValue(this.translateService.instant('LBL_ASSIGNED_ITEM_TO_OTHER_USER'), [lookingOn.UserName]) : this.translateService.instant('LBL_UNASSIGN_ITEM');
            lookingOn.ByOtherUserTitle = lookingOn.ByOtherUser ? lookingOn.UserName + this.translateService.instant('LBL_ASSIGNED_ITEM') : '';
        }
        scheduledWorkDto.LookingOn = lookingOn;
    }
    ;
    convertSessionToScheduleWorkDto(sessionResultList) {
        let sessionArrayList = null;
        if (sessionResultList?.length > 0) {
            sessionArrayList = [];
            sessionResultList.forEach(currentSessionDto => {
                const scheduledWorkDto = new ScheduledWorkDto();
                scheduledWorkDto.Id = currentSessionDto.Id;
                scheduledWorkDto.CurrentHandlerId = currentSessionDto.CurrentUserId;
                scheduledWorkDto.CurrentHandlerName = GlobalFunctions.getHandlerName(currentSessionDto.CurrentUserId, this.cacheManager);
                scheduledWorkDto.CurrentHandlerDepartmentName = this.getHandlerDepartmentName(currentSessionDto.CurrentUserId);
                scheduledWorkDto.ScheduledWorkDescription = currentSessionDto.Description;
                scheduledWorkDto.ScheduledWorkType = 'Session';
                scheduledWorkDto.ScheduledWorkSubject = currentSessionDto.CustomerName;
                scheduledWorkDto.ScheduledWorkReceivedDate = currentSessionDto.SessionStartDateTime;
                scheduledWorkDto.ScheduledWorkReceivedDateText = this.datePipe.transform(currentSessionDto.SessionStartDateTime, this.sessionManager.defaultOptions.defaultDateFormat);
                scheduledWorkDto.ObjectSourceDto = currentSessionDto;
                scheduledWorkDto.ObjectSource = currentSessionDto.ObjectSource;
                scheduledWorkDto.StringRepresentation = scheduledWorkDto.ScheduledWorkDescription;
                scheduledWorkDto.RelatedEntityFqdn = currentSessionDto.RelatedEntityFqdn;
                scheduledWorkDto.Location = currentSessionDto.Location;
                sessionArrayList.push(scheduledWorkDto);
                if (!GlobalFunctions.isEmpty(currentSessionDto.Location)) {
                    if (this.locations[currentSessionDto.Location] == null)
                        this.locations[currentSessionDto.Location] = 1;
                    else
                        this.locations[currentSessionDto.Location]++;
                }
            });
        }
        this.locations = GlobalFunctions.sortDictionary(this.locations);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_LOCATIONS, this.locations);
        return sessionArrayList;
    }
    ;
    setResultList() {
        if (this.filterList.Filters.length > 0 && this.taskService.scheduleWorkList != null && this.taskService.scheduleWorkList.length > 0) {
            let query = '';
            let filterResult = this.taskService.scheduleWorkList;
            if (filterResult.length > 0) {
                let typeFilters = jlinq.from(this.filterList.Filters).equals('Type', this.translateService.instant('LBL_TYPE')).select();
                if (typeFilters != null && typeFilters.length > 0) {
                    query = typeFilters.map(f => f.Key).join(';');
                    filterResult = this.taskFilterPipe.transform(filterResult, query, 'Type');
                }
                if (filterResult.length > 0) {
                    {
                        let priorityFilters = jlinq.from(this.filterList.Filters).equals('Type', this.translateService.instant('LBL_PRIORITY')).select();
                        if (priorityFilters != null && priorityFilters.length > 0) {
                            query = priorityFilters.map(f => f.Key).join(';');
                            filterResult = this.taskFilterPipe.transform(filterResult, query, 'Priority');
                        }
                    }
                }
                if (filterResult.length > 0) {
                    {
                        let statusFilters = jlinq.from(this.filterList.Filters).equals('Type', this.translateService.instant('LBL_STATUS')).select();
                        if (statusFilters != null && statusFilters.length > 0) {
                            query = statusFilters.map(f => f.Key).join(';');
                            filterResult = this.taskFilterPipe.transform(filterResult, query, 'Status');
                        }
                    }
                }
            }
            this.resultList = filterResult;
            this.taskService.lastAppliedFilters = this.filterList.Filters;
            this.taskService.filterOptions = this.filterList.FilterOptions;
        }
        else
            this.resultList = this.taskService.scheduleWorkList;
    }
    ;
    getTaskFilters() {
        let taskFilters = [];
        let filterType = new FilterDto();
        filterType.Description = this.translateService.instant('LBL_TYPE');
        filterType.Title = filterType.Description;
        filterType.Id = GlobalFunctions.createGuid();
        let filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_CALLBACK_NOTE');
        filterEntryType.Key = 'callbacknote';
        filterType.Entries.push(filterEntryType);
        filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_APPOINTMENT');
        filterEntryType.Key = 'appointment';
        filterType.Entries.push(filterEntryType);
        filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_ASSIGNMENT');
        filterEntryType.Key = 'assignment';
        filterType.Entries.push(filterEntryType);
        filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_INFORMATION_REQUEST');
        filterEntryType.Key = 'informationrequest';
        filterType.Entries.push(filterEntryType);
        filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_SESSION');
        filterEntryType.Key = 'session';
        filterType.Entries.push(filterEntryType);
        taskFilters.push(filterType);
        filterEntryType = new FilterEntryDto();
        filterEntryType.Id = GlobalFunctions.createGuid();
        filterEntryType.Title = this.translateService.instant('LBL_REPORT_IMPROVEMENT');
        filterEntryType.Key = 'reportimprovement';
        filterType.Entries.push(filterEntryType);
        let filterPriority = new FilterDto();
        filterPriority.Description = this.translateService.instant('LBL_PRIORITY');
        filterPriority.Title = filterPriority.Description;
        filterPriority.Id = GlobalFunctions.createGuid();
        let filterEntryPriority = new FilterEntryDto();
        filterEntryPriority.Id = GlobalFunctions.createGuid();
        filterEntryPriority.Title = this.translateService.instant('LBL_LOW');
        filterEntryPriority.Key = '1';
        filterPriority.Entries.push(filterEntryPriority);
        filterEntryPriority = new FilterEntryDto();
        filterEntryPriority.Id = GlobalFunctions.createGuid();
        filterEntryPriority.Title = this.translateService.instant('LBL_MEDIUM');
        filterEntryPriority.Key = '2';
        filterPriority.Entries.push(filterEntryPriority);
        filterEntryPriority = new FilterEntryDto();
        filterEntryPriority.Id = GlobalFunctions.createGuid();
        filterEntryPriority.Title = this.translateService.instant('LBL_HIGH');
        filterEntryPriority.Key = '3';
        filterPriority.Entries.push(filterEntryPriority);
        taskFilters.push(filterPriority);
        let filterStatus = new FilterDto();
        filterStatus.Description = this.translateService.instant('LBL_STATUS');
        filterStatus.Title = filterStatus.Description;
        filterStatus.Id = GlobalFunctions.createGuid();
        let filterEntryStatus = new FilterEntryDto();
        filterEntryStatus.Id = GlobalFunctions.createGuid();
        filterEntryStatus.Title = this.translateService.instant('LBL_UNHANDLED');
        filterEntryStatus.Key = '0;1';
        filterStatus.Entries.push(filterEntryStatus);
        filterEntryStatus = new FilterEntryDto();
        filterEntryStatus.Id = GlobalFunctions.createGuid();
        filterEntryStatus.Title = this.translateService.instant('LBL_REPLIED');
        filterEntryStatus.Key = '7';
        filterStatus.Entries.push(filterEntryStatus);
        taskFilters.push(filterStatus);
        return taskFilters;
    }
    toggleStatusFilter() {
        let statusFilter = jlinq.from(this.filterList.FilterOptions).equals('Title', this.translateService.instant('LBL_STATUS')).first();
        if (statusFilter) {
            let repliedStatusFilter = jlinq.from(statusFilter.Entries).equals('Title', this.translateService.instant('LBL_REPLIED')).first();
            if (repliedStatusFilter != null) {
                repliedStatusFilter.Selected = GlobalFunctions.isEmpty(repliedStatusFilter.Selected) ? true : !repliedStatusFilter.Selected;
                repliedStatusFilter.Type = this.translateService.instant('LBL_STATUS');
                if (this.filterList.Filters.length == 0)
                    this.filterList.Filters.push(repliedStatusFilter);
                else
                    this.filterList.Filters = [];
                this.setResultList();
            }
        }
    }
    updateSearchStatusFromSession(result) {
        if (this.sourceCount != null && this.previousTaskCount != null) {
            if (result.ActiveHandlers.length > 0)
                this.sourceCount += 1;
            else if (result.ActiveHandlers.length == 0 && this.previousTaskCount == 0)
                this.sourceCount = 0;
            else if (result.ActiveHandlers.length == 0 && this.sourceCount > 0)
                this.sourceCount = this.previousTaskCount;
        }
        else
            this.sourceCount = result.ActiveHandlers.length;
        this.previousSessionCount = result.ActiveHandlers.length;
        if (result.ActiveHandlers.length == 0 && this.previousTaskCount != null && this.previousTaskCount == 0)
            this.updateScheduleWorkCount(this.resultList);
    }
    createSessionErrorCallback(status) {
        if (status == 0) {
            this.sessionManager.endSession();
            if (!GlobalFunctions.isEmpty(this.loadItem))
                this.sessionManager.loadSession(this.loadItem, this.dialogManager, this.viewContainerRef);
        }
        else {
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant('LBL_CREATE_ERROR_MSG'), [this.translateService.instant('LBL_SESSION')]);
            let exception = ExceptionHelper.create(this.translateService.instant('LBL_ERROR_MSG'), helpMessage, this.translateService.instant('LBL_SESSION'));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    saveExistingSession(item, saveSession, sessionItem) {
        if (saveSession) {
            let session = this.sessionManager.createCurrentSession(SessionStatus.Park, item.Description, null, item.uiObject, item.uiState, this.sessionManager.sessionStartDateTime);
            this.sessionService.createOrUpdateSession(session, null, this.createSessionErrorCallback);
            this.loadItem = sessionItem;
        }
        else {
            if (!GlobalFunctions.isEmpty(item.Id))
                this.sessionService.handleSession(item.Id, () => { });
            this.sessionManager.endSession();
        }
    }
    ;
    onItemClick(task) {
        if (task.ScheduledWorkType.toLowerCase() === 'session') {
            if (this.sessionManager.currentSession) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_SESSION'), textMsg: this.translateService.instant('LBL_MESSAGE_HANDLE_SESSION'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession)) {
                        if (result)
                            this.saveExistingSession(this.sessionManager.currentSession, true, task);
                        else {
                            if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
                                this.saveExistingSession(this.sessionManager.currentSession, false, null);
                            this.sessionManager.loadSession(task, this.dialogManager, this.sessionManager.headerViewContainerRef);
                        }
                    }
                });
            }
            else
                this.sessionManager.loadSession(task, this.dialogManager, this.sessionManager.headerViewContainerRef);
        }
        else
            super.onItemClick(task);
    }
    select(item, $event) {
        let element = ($event.target);
        if (element != null && element.type != 'checkbox') {
            if (item != null && item.ObjectSourceDto != null) {
                if (item.ObjectSource != null && item.ObjectSource.toLowerCase() == 'decos.kcs.tasks.decosconnect' && item.ObjectSourceDto.SourceApplicationDeeplink != null)
                    window.open(item.ObjectSourceDto.SourceApplicationDeeplink, "_blank");
                else if (item.ObjectSourceDto.TaskType != undefined && (item.ObjectSourceDto.TaskType.toLowerCase() == 'callbacknote' || item.ObjectSourceDto.TaskType.toLowerCase() == 'assignment' || item.ObjectSourceDto.TaskType.toLowerCase() == 'appointment' || item.ObjectSourceDto.TaskType.toLowerCase() == 'reportimprovement' || item.ObjectSourceDto.TaskType.toLowerCase() == 'informationrequest')) {
                    this.sessionManager.loadedFromRelatedView = false;
                    this.sessionManager.selectedEntity = item.ObjectSourceDto;
                    //this.resultList = this.orderByPipe.transform(this.resultList, 'ScheduledWorkType');
                    this.resultList.forEach(objectSource => {
                        objectSource.locationUrl = `${RoutePath.DETAIL_PATH}/${item.ObjectSourceDto.TaskType.toLowerCase()}/${item.ObjectSourceDto.Id}`;
                        objectSource.Id = objectSource.ObjectSourceDto.Id;
                        objectSource.searchStatusQuery = this.searchStatusQuery;
                    });
                    this.sessionManager.addBreadcrumbItems(this.resultList, item.ObjectSourceDto, this.router.url);
                    this.router.navigate([RoutePath.DETAIL_PATH, item.ObjectSourceDto.TaskType.toLowerCase(), item.ObjectSourceDto.Id]);
                }
                else {
                    if (this.sessionManager.currentSession != null) {
                        let message = this.translateService.instant('LBL_MESSAGE_HANDLE_SESSION');
                        let header = this.translateService.instant('LBL_SESSION');
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                            if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession)) {
                                if (result)
                                    this.saveExistingSession(this.sessionManager.currentSession, true, item);
                                else {
                                    if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
                                        this.saveExistingSession(this.sessionManager.currentSession, false, null);
                                    this.sessionManager.loadSession(item, this.dialogManager, this.viewContainerRef);
                                }
                            }
                        });
                    }
                    else
                        this.sessionManager.loadSession(item, this.dialogManager, this.viewContainerRef);
                }
            }
        }
        this.taskService.lastAppliedFilters = this.filterList.Filters;
        this.taskService.filterOptions = this.filterList.FilterOptions;
    }
    ;
    selectLocation(location) {
        const locationList = [];
        this.taskService.scheduleWorkList.forEach(task => {
            if (!GlobalFunctions.isEmpty(task.Location) && task.Location.includes(location))
                locationList.push(task);
        });
        this.resultList = locationList;
    }
    ;
    hasTaskTypeRights(taskType) {
        return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Task'), OperationType.View, TaskSource[taskType]);
    }
    lockUnlockTask(task, event) {
        event.stopPropagation();
        if (event.target.checked) {
            let handlerObject = this.cacheManager.getEmployeeById(GlobalFunctions.getLoggedInUserId());
            task.LockedBy.HandlerId = handlerObject.Id;
            task.LockedBy.HandlerName = handlerObject.StringRepresentation;
            this.taskService.lockUnlockTask(true, task.Id);
        }
        else {
            task.LockedBy.HandlerId = null;
            task.LockedBy.HandlerName = null;
            this.taskService.lockUnlockTask(false, task.Id);
        }
    }
    ;
    searchTasks() {
        this.taskService.advancedSearch(this.searchService.advancedSearchOption.searchDto, GlobalFunctions.createGuid(), this.searchTaskResultFound, this.updateSearchStatus);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    ;
    searchMyTasks() {
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
        const searchDto = new SearchDto();
        searchDto.ObjectSource = !this.sessionManager.selectedRole ? this.selectedOption : 'myrole';
        this.searchStatusQuery = this.translateService.instant('LBL_MY') + ' ' + this.translateService.instant('LBL_TASKS');
        this.taskService.advancedSearch(searchDto, GlobalFunctions.createGuid(), this.searchTaskResultFound, this.updateSearchStatus);
        this.sessionService.searchSession(searchDto, GlobalFunctions.createGuid(), this.searchSessionResultFound, this.updateSearchStatusFromSession);
    }
    onTagClick(tag, $event) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider, $event);
    }
    ;
    updateScheduleWorkCount(resultList) {
        if (this.selectedOption == 'my') {
            this.sessionManager.pendingCount.MyScheduledWorkCount = resultList.length;
            this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount = jlinq.from(this.resultList).equals('CurrentStatus', 7).count();
        }
    }
    executeMenuItem(key) {
        switch (key.toUpperCase()) {
            case 'SENDREMINDERS':
                this.sendReminder();
                break;
            case 'BULKHANDLE':
                if (this.filteredSearchResult.length > 0)
                    this.dialogManager.bulkHandle(this.filteredSearchResult);
                else
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_BULK_HANDLE'), textMsg: this.translateService.instant('LBL_MSG_BULK_HANDLE_NO_TASK') });
                break;
            case 'SENDTOEXCEL':
                this.sendToReport(DocumentFormat.Xlsx);
                break;
            case 'SENDTOPRINTER':
                this.sendToReport(DocumentFormat.Pdf);
                break;
        }
    }
    sendReminder() {
        if (GlobalFunctions.isEmpty(this.filteredSearchResult))
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK'), textMsg: this.translateService.instant('LBL_MSG_NOT_SENDING_REMINDERS') });
        else {
            if (this.filteredSearchResult.length > 0) {
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK'), textMsg: GlobalFunctions.formatStringValue(this.translateService.instant('LBL_MSG_SEND_REMINDERS_CONFIRMATION'), [this.filteredSearchResult.length]), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result) {
                        if (!GlobalFunctions.isEmpty(this.filteredSearchResult))
                            this.taskService.sendReminder(this.getTaskIdFromList(this.filteredSearchResult));
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK'), textMsg: this.translateService.instant('LBL_MSG_SEND_REMINDERS') });
                    }
                });
            }
        }
    }
    ;
    sendToReport(documentFormat) {
        if (!GlobalFunctions.isEmpty(this.filteredSearchResult)) {
            DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
            let exportReportRequest = new CreateExportReportRequest();
            exportReportRequest.DocumentFormat = documentFormat;
            exportReportRequest.SearchQuery = this.sessionManager.localSearchQuery;
            exportReportRequest.LogOnName = this.employeeService.loggedInEmployee.LoggedInUserName;
            if (this.router.url.toLowerCase().indexOf('task') > -1) {
                exportReportRequest.EntityIdList = this.getTaskIdFromList(this.filteredSearchResult);
                this.taskService.createReport(exportReportRequest, this.createReportResponse);
            }
            if (this.router.url.toLowerCase().indexOf('contacthistory') > -1)
                this.contactHistoryService.createReport(this.getContactHistoryIdFromList(this.filteredSearchResult), documentFormat, this.employeeService.loggedInEmployee.LoggedInUserName, this.sessionManager.localSearchQuery, this.createReportResponse);
        }
    }
    ;
    getTaskIdFromList(taskList) {
        let taskIdList = [];
        if (!GlobalFunctions.isEmpty(taskList)) {
            taskList.forEach(taskItem => {
                if (!GlobalFunctions.isEmpty(taskItem) && !GlobalFunctions.isEmpty(taskItem.ObjectSourceDto))
                    taskIdList.push(taskItem.ObjectSourceDto.Id);
            });
        }
        return taskIdList;
    }
    ;
    createReportResponse(response) {
        this.dialog.closeAll();
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.DownloadTicketId))
            this.subs.sink = this.downloadService.downloadFile(response.DownloadTicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
    }
    ;
    getContactHistoryIdFromList(chList) {
        let contactHistoryIdList = [];
        if (!GlobalFunctions.isEmpty(chList)) {
            chList.forEach(ch => {
                if (!GlobalFunctions.isEmpty(ch))
                    contactHistoryIdList.push(ch.Id);
            });
        }
        return contactHistoryIdList;
    }
    ;
    searchTasksByParam() {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        switch (this.selectedOption.toLowerCase()) {
            case "opentaskforme":
                {
                    let handlerSearchCriteria = new StringCriteriaDto();
                    handlerSearchCriteria.IsInUse = true;
                    handlerSearchCriteria.Name = TaskSearchField.Handler;
                    handlerSearchCriteria.CompareType = 0;
                    handlerSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                    break;
                }
            case "opentaskforrole":
                {
                    let createdByRoleSearchCriteria = new StringCriteriaDto();
                    createdByRoleSearchCriteria.IsInUse = true;
                    createdByRoleSearchCriteria.Name = TaskSearchField.Role;
                    createdByRoleSearchCriteria.CompareType = 0;
                    createdByRoleSearchCriteria.Value = this.sessionManager.selectedRole.Id;
                    searchDto.StringCriteriaList.push(createdByRoleSearchCriteria);
                    break;
                }
            case "opentaskfordepartment":
                {
                    let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                    let handlerSearchCriteria = new StringCriteriaDto();
                    handlerSearchCriteria.IsInUse = true;
                    handlerSearchCriteria.Name = TaskSearchField.Handler;
                    handlerSearchCriteria.CompareType = 1;
                    handlerSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join(',').trim() : GlobalFunctions.getLoggedInUserId();
                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                    break;
                }
            case "createdtaskbyme":
            case "createdtaskbyrole":
            case "createdtaskbydepartment":
                {
                    let createdByMeSearchCriteria = new StringCriteriaDto();
                    createdByMeSearchCriteria.IsInUse = true;
                    createdByMeSearchCriteria.CompareType = 0;
                    switch (this.selectedOption.toLowerCase()) {
                        case "createdtaskbyme":
                            {
                                createdByMeSearchCriteria.Name = TaskSearchField.CreatedById;
                                createdByMeSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                                break;
                            }
                        case "createdtaskbyrole":
                            {
                                createdByMeSearchCriteria.Name = TaskSearchField.CreatedByRole;
                                createdByMeSearchCriteria.Value = this.sessionManager.selectedRole.Id;
                                break;
                            }
                        case "createdtaskbydepartment":
                            {
                                let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                                createdByMeSearchCriteria.Name = TaskSearchField.CreatedById;
                                createdByMeSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join(',').trim() : GlobalFunctions.getLoggedInUserId();
                                ;
                                break;
                            }
                    }
                    searchDto.StringCriteriaList.push(createdByMeSearchCriteria);
                    let dateSearchCriteria = new DateCriteriaDto();
                    dateSearchCriteria.CompareType = DateCompareType.Between;
                    dateSearchCriteria.Name = TaskSearchField.CreatedDate;
                    ;
                    dateSearchCriteria.Value = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
                    dateSearchCriteria.ToDate = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
                    searchDto.DateCriteriaList.push(dateSearchCriteria);
                    break;
                }
        }
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
        this.taskService.advancedSearch(searchDto, GlobalFunctions.createGuid(), this.searchTaskResultFound, this.updateSearchStatus);
        this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_" + this.selectedOption.toUpperCase()) + "}";
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $('#taskSearchResults').height(windowHeight - 246 + 'px');
    }
};
TaskSearchResultComponent = __decorate([
    Component({
        selector: 'task-search-result',
        templateUrl: './task-search-result.component.html',
        styleUrls: ['./task-search-result.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], TaskSearchResultComponent);
export { TaskSearchResultComponent };
//# sourceMappingURL=task-search-result.component.js.map