var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { DateCompareType, ScreenMode, StringCompareType } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { TaskType } from '../../../../core/enums/task-enum';
import { AdvancedSearchItem } from '../../../../core/models/common/advance-serach-item';
import { DateCriteriaDto } from '../../../../core/models/common/date-criteria';
import { EnumCriteriaDto } from '../../../../core/models/common/enum-criteria';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../../core/models/common/string-criteria';
import { TaskSearchField } from '../../../../core/models/jkc-object/jkc-object';
import { EntityName } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let TaskSearchCriteriaComponent = class TaskSearchCriteriaComponent extends BaseSearchResultComponent {
    constructor(changeDetectorRef, activatedRoute, router, sortManager, cacheManager, searchService, sessionManager, eventProvider, formatManager, employeeService, translateService, integrationSettingManager, applicationSettingManager, datePipe, taskService, sessionService, renderer, dateAdapter) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.sortManager = sortManager;
        this.cacheManager = cacheManager;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.formatManager = formatManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.datePipe = datePipe;
        this.taskService = taskService;
        this.sessionService = sessionService;
        this.renderer = renderer;
        this.dateAdapter = dateAdapter;
        this.dateJS = Date;
        this.currentHandlerType = 'Employee';
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.searchInType = "All";
        this.isRoleSelected = (this.sessionManager.selectedRole !== null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id));
        this.dateSearch = { 'Option': "0", 'DateField': "Registration", 'FromDate': null, 'ToDate': null };
        this.tagCompareType = "0";
        this.tags = [];
        this.tagItems = [];
        this.advancedSearchMatrix = [];
        this.validationMessage = '';
        this.uniqueId = GlobalFunctions.createGuid();
        this.datePickerClosed = true;
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.pendingTasksCountReceived = this.pendingTasksCountReceived.bind(this);
    }
    ngOnInit() {
        try {
            this.type = EntityName.TASK;
            this.updatePendingCount();
            this.initAdvanceSearchMatrix();
            this.initializeDateRangeOption();
            this.setHandlerTags();
            this.tagItems = this.applicationSettingManager.tagSetting.searchTagByQuery('', false);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList(false);
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById('handlerTagControl')?.focus();
    }
    search() {
        if (!this.validate())
            return;
        this.searchService.advanceSearch({
            searchDto: this.prepareSearchDto(),
            searchFrom: 'dashboard',
            searchType: this.type
        });
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
    }
    ;
    initAdvanceSearchMatrix() {
        let taskAdvancedSearchItem = null;
        this.advancedSearchMatrix = [];
        //Customer Name
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CUSTOMER";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 1;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.ContactPerson;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        taskAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
        //Phone Number
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_PHONE_NUMBER";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.PhoneNumber;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 1;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        taskAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        taskAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
        //Mobile Number
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_MOBILE_NUMBER";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.MobileNumber;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 1;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        taskAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        taskAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
        //Email
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_EMAIL";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.Email;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 1;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        taskAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        taskAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
        //Question
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DESCRIPTION";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.Question;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 1;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        taskAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        taskAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
        //Type
        taskAdvancedSearchItem = new AdvancedSearchItem();
        taskAdvancedSearchItem.SearchCriteria = new EnumCriteriaDto();
        taskAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_TYPE";
        taskAdvancedSearchItem.SearchCriteria.IsInUse = true;
        taskAdvancedSearchItem.SearchCriteria.CompareType = 0;
        taskAdvancedSearchItem.SearchCriteria.Value = -1;
        taskAdvancedSearchItem.SearchCriteria.Name = TaskSearchField.TaskType;
        taskAdvancedSearchItem.TypeOfSearchCriteria = "NumericCriteria";
        taskAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        taskAdvancedSearchItem.IsComboBoxEnabled = true;
        taskAdvancedSearchItem.ComboBoxValues = [];
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": -1, "Text": "ALL" });
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": 1, "Text": "CALLBACKNOTE" });
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": 2, "Text": "APPOINTMENT" });
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": 3, "Text": "ASSIGNMENT" });
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": 4, "Text": "REPORTIMPROVEMENT" });
        taskAdvancedSearchItem.ComboBoxValues.push({ "Value": 5, "Text": "INFORMATIONREQUEST" });
        this.advancedSearchMatrix.push(taskAdvancedSearchItem);
    }
    ;
    prepareSearchDto() {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        let searchContentType = new Object();
        searchContentType.SearchCriteriaField = [];
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].SearchCriteria.Value != null && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                if (this.advancedSearchMatrix[item].SearchCriteria.TypeOfCompareType[this.advancedSearchMatrix[item].SearchCriteria.CompareType].criteriaChanged) {
                    let searchField = new Object();
                    searchField._Name = this.advancedSearchMatrix[item].SearchCriteria.Name;
                    searchField._Value = this.advancedSearchMatrix[item].SearchCriteria.CompareType;
                    searchContentType.SearchCriteriaField.push(searchField);
                }
                if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                    this.searchService.advancedSearchQuery += ' , ';
                this.setAdvancedSearchQuery(this.advancedSearchMatrix[item].SearchCriteria, this.advancedSearchMatrix[item].TypeOfSearchCriteria);
                switch (this.advancedSearchMatrix[item].TypeOfSearchCriteria) {
                    case 'StringCriteria':
                        searchDto.StringCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'NumericCriteria':
                        searchDto.NumericCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'DateCriteria':
                        searchDto.DateCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'EnumCriteria':
                        searchDto.EnumCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                }
            }
        }
        //Handler
        if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0) {
            let handlerSearchCriteria = new StringCriteriaDto();
            handlerSearchCriteria.IsInUse = true;
            handlerSearchCriteria.DisplayName = "LBL_HANDLER";
            handlerSearchCriteria.Name = TaskSearchField.Handler;
            handlerSearchCriteria.CompareType = 1;
            handlerSearchCriteria.Value = "";
            let handlerList = "";
            for (let i = 0; i < this.handlerTags.length; i++) {
                handlerSearchCriteria.Value += "'" + this.handlerTags[i].Id + "',";
                handlerList += "'" + this.handlerTags[i].text + "',";
            }
            searchDto.StringCriteriaList.push(handlerSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_HANDLER") + "}: " + (handlerList.slice(0, -1));
        }
        //tags
        if (this.tags != undefined && this.tags != null && this.tags.length > 0) {
            let tagSearchCriteria = new StringCriteriaDto();
            tagSearchCriteria.IsInUse = true;
            tagSearchCriteria.DisplayName = "LBL_TAGS";
            tagSearchCriteria.Name = TaskSearchField.Tags;
            tagSearchCriteria.CompareType = this.tagCompareType == "0" ? StringCompareType.Like : StringCompareType.EqualsTo;
            tagSearchCriteria.Value = "";
            let tagList = "";
            for (let i = 0; i < this.tags.length; i++) {
                tagSearchCriteria.Value += this.tags[i].Id + ";";
                tagList += this.tags[i].text + ",";
            }
            tagSearchCriteria.Value = tagSearchCriteria.Value.slice(0, -1);
            tagList = tagList.slice(0, -1);
            searchDto.StringCriteriaList.push(tagSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_TAGS") + "}: " + tagList;
        }
        //Date
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) && !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            let dateSearchCriteria = new DateCriteriaDto();
            dateSearchCriteria.CompareType = DateCompareType.Between;
            if (this.dateSearch.DateField === "Registration") {
                dateSearchCriteria.DisplayName = "LBL_REGISTRATION_DATE";
                dateSearchCriteria.Name = TaskSearchField.CreatedDate;
            }
            else {
                dateSearchCriteria.Name = TaskSearchField.CallbackDate;
                dateSearchCriteria.DisplayName = "LBL_CALLBACK_DATE";
            }
            dateSearchCriteria.Value = this.dateSearch.FromDate.toString('M/d/yyyy HH:mm:ss');
            dateSearchCriteria.ToDate = this.dateSearch.ToDate.toString('M/d/yyyy HH:mm:ss');
            searchDto.DateCriteriaList.push(dateSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.setAdvancedSearchQuery(dateSearchCriteria, "DateCriteria");
        }
        ;
        if (this.searchInType == 'Created') {
            let createdByMeSearchCriteria = new StringCriteriaDto();
            createdByMeSearchCriteria.IsInUse = true;
            createdByMeSearchCriteria.DisplayName = "LBL_CREATED";
            createdByMeSearchCriteria.Name = TaskSearchField.CreatedById;
            createdByMeSearchCriteria.CompareType = 0;
            createdByMeSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
            searchDto.StringCriteriaList.push(createdByMeSearchCriteria);
        }
        else if (this.searchInType == 'Role') {
            let createdByRoleSearchCriteria = new StringCriteriaDto();
            createdByRoleSearchCriteria.IsInUse = true;
            createdByRoleSearchCriteria.DisplayName = "LBL_ROLE";
            createdByRoleSearchCriteria.Name = TaskSearchField.Role;
            createdByRoleSearchCriteria.CompareType = 0;
            createdByRoleSearchCriteria.Value = this.sessionManager.selectedRole.Id;
            searchDto.StringCriteriaList.push(createdByRoleSearchCriteria);
        }
        if (GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery)) {
            if (this.searchInType === "All")
                this.searchService.advancedSearchQuery = this.translateService.instant("LBL_ALL") + " " + this.translateService.instant("LBL_TASKS");
            else if (this.searchInType === "Created")
                this.searchService.advancedSearchQuery = this.translateService.instant("LBL_CREATED_BY_ME");
            else if (this.searchInType === "Role")
                this.searchService.advancedSearchQuery = this.translateService.instant("LBL_ROLE") + " (" + this.sessionManager.selectedRole.Name + ")";
        }
        return searchDto;
    }
    ;
    changeVisibility(advancedSearchItem) {
        advancedSearchItem.IsToDateInputBoxEnabled = false;
        advancedSearchItem.SearchCriteria.TypeOfCompareType[advancedSearchItem.SearchCriteria.CompareType].criteriaChanged = true;
        if (advancedSearchItem.IsCalenderEnabled && advancedSearchItem.SearchCriteria.CompareType == 5)
            advancedSearchItem.IsToDateInputBoxEnabled = true;
    }
    ;
    validate() {
        let count = 0;
        this.validationMessage = undefined;
        let isAdvanceSearch = false;
        for (const item in this.advancedSearchMatrix) {
            if ((this.advancedSearchMatrix[item].TypeOfSearchCriteria == "DateCriteria" && !GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].FromDate)) ||
                (this.advancedSearchMatrix[item].SearchCriteria.Value != null && this.advancedSearchMatrix[item].SearchCriteria.Value != "") ||
                (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) || !GlobalFunctions.isEmpty(this.dateSearch.ToDate))) {
                isAdvanceSearch = true;
                break;
            }
        }
        if (isAdvanceSearch === false)
            this.validationMessage = this.translateService.instant("LBL_ONE_ADVANCED_SEARCH_REQUIRED_ERROR");
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].IsRequired)
                break;
            if (this.advancedSearchMatrix[item].TypeOfSearchCriteria == "DateCriteria") {
                if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].FromDate)) {
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].FromDate;
                    count++;
                }
                else
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].FromDate;
                if (this.advancedSearchMatrix[item].SearchCriteria.CompareType == 5) {
                    if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].ToDate)) {
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate;
                        count++;
                    }
                    else
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate;
                }
                else
                    this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate = "";
            }
            else if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value) || this.advancedSearchMatrix[item].SearchCriteria.Value == 0)
                count++;
            else if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value) || this.advancedSearchMatrix[item].SearchCriteria.Value == -1) {
                this.advancedSearchMatrix[item].SearchCriteria.Value = null;
                count++;
            }
        }
        if (count < this.advancedSearchMatrix.length) {
            for (let item in this.advancedSearchMatrix) {
                if (this.advancedSearchMatrix[item].SearchCriteria.Value != undefined && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                    if (this.advancedSearchMatrix[item].TypeOfSearchCriteria != "DateCriteria" && this.advancedSearchMatrix[item].TypeOfSearchCriteria != "NumericCriteria") {
                        if (this.advancedSearchMatrix[item].SearchCriteria.CompareType != 0 && this.advancedSearchMatrix[item].SearchCriteria.Value.length < 3) {
                            this.validationMessage = this.translateService.instant("LBL_QUERY_LENGTH_ADVANCED_SEARCH_ERROR");
                            break;
                        }
                    }
                    if (this.advancedSearchMatrix[item].RegularExpressionValidator != null) {
                        if (!this.isValid(this.advancedSearchMatrix[item].SearchCriteria.Value, this.advancedSearchMatrix[item].RegularExpressionValidator)) {
                            this.validationMessage = this.advancedSearchMatrix[item].ValidationMessage;
                            break;
                        }
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) || !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            if (GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (this.dateSearch.ToDate < this.dateSearch.FromDate)
                this.validationMessage = this.translateService.instant("LBL_INVALID_DATE_BETWEEN_ERROR");
        }
        else
            this.validationMessage = this.translateService.instant("LBL_REPORT_HELP_TEXT4");
        return this.validationMessage == undefined ? true : false;
    }
    ;
    setAdvancedSearchQuery(searchDto, TypeOfSearchCriteria) {
        try {
            let criteria;
            searchDto.TypeOfCompareType.forEach((value, key) => {
                if (key != null && key == searchDto.CompareType)
                    criteria = value.Text;
            });
            let searchQuery;
            let searchDtoToDate;
            if (TypeOfSearchCriteria == "DateCriteria") {
                searchQuery = this.datePipe.transform(searchDto.Value, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                searchQuery = GlobalFunctions.removeDotAfterMonth(searchQuery);
                if (searchDto.CompareType == "5") {
                    searchDtoToDate = this.datePipe.transform(searchDto.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                    searchDtoToDate = GlobalFunctions.removeDotAfterMonth(searchDtoToDate);
                    searchQuery += " - " + searchDtoToDate;
                }
            }
            if (searchDto.Name === TaskSearchField.TaskType)
                searchQuery = this.translateService.instant("LBL_" + TaskType[searchDto.Value].toUpperCase());
            else
                searchQuery = searchQuery ? searchQuery : searchDto.Value;
            this.searchService.advancedSearchQuery += '{' + this.translateService.instant(searchDto.DisplayName) + '} ' + this.translateService.instant("LBL_" + criteria.toUpperCase()) + " " + "'" + searchQuery + "'" + " ";
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    changeStartDate(inputId) {
        GlobalFunctions.setDateFormat(inputId, this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        if (this.dateSearch.Option === "0" && !GlobalFunctions.isEmpty(this.dateSearch.FromDate) && GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            this.dateSearch.ToDate = this.dateSearch.FromDate;
        }
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    ;
    initDatePickerState(event, inputId) {
        this.clickedOut();
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(window.navigator.language);
    }
    clickedOut() {
        this.timeoutIds.push(setTimeout(() => {
            //date format will not change when click outside.
            if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                GlobalFunctions.setDateFormat("selectStartDatePicker", this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (!GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                GlobalFunctions.setDateFormat("selectEndDatePicker", this.dateSearch.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }, 10));
    }
    changeDateOption() {
        switch (this.dateSearch.Option) {
            case "0":
                {
                    this.dateSearch.FromDate = null;
                    this.dateSearch.ToDate = null;
                    break;
                }
            case "1":
                {
                    this.dateSearch.FromDate = new Date();
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "2":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = fromDate;
                    break;
                }
            case "3":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "4":
                {
                    let fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 7);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "5":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 30);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
        }
        this.clickedOut();
    }
    ;
    initializeDateRangeOption() {
        this.dateSearch.Option = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTSEARCHDATERANGE");
        this.changeDateOption();
    }
    updatePendingCount() {
        if (this.applicationSettingManager.refreshCountSetting.Task.OnMenu) {
            this.messageId = GlobalFunctions.createGuid();
            this.sessionManager.pendingCount.MyScheduledWorkCount = "...";
            this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount = 0;
            this.taskService.getPendingTasksCount(this.messageId, this.pendingTasksCountReceived);
            this.sessionService.getPendingSessionsCount(this.messageId, this.pendingTasksCountReceived);
        }
    }
    ;
    pendingTasksCountReceived(result) {
        if (result && result.MessageId == this.messageId && result.PendingItemsCountDtoList != null && result.PendingItemsCountDtoList.length > 0) {
            if (this.sessionManager.pendingCount.MyScheduledWorkCount == "...")
                this.sessionManager.pendingCount.MyScheduledWorkCount = 0;
            for (let index = 0; index < result.PendingItemsCountDtoList.length; index++) {
                let item = result.PendingItemsCountDtoList[index];
                if (item) {
                    this.sessionManager.pendingCount.MyScheduledWorkCount += (this.sessionManager.pendingCount.MyScheduledWorkCount == "..." ? 0 : item.Count);
                    this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount += (item.UnreplyCount == undefined ? 0 : item.UnreplyCount);
                }
            }
        }
    }
    ;
};
__decorate([
    HostListener("document:click")
], TaskSearchCriteriaComponent.prototype, "clickedOut", null);
TaskSearchCriteriaComponent = __decorate([
    Component({
        selector: 'task-search-criteria',
        templateUrl: './task-search-criteria.component.html',
        styleUrls: ['./task-search-criteria.component.scss']
    })
], TaskSearchCriteriaComponent);
export { TaskSearchCriteriaComponent };
//# sourceMappingURL=task-search-criteria.component.js.map