var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { ForwardTaskType, TaskStatus } from '../../../../core/enums/task-enum';
import { BaseDto } from '../../../../core/models/common/baseDto';
import { TaskHandlerDto } from '../../../../core/models/task/task-handlerDto';
import { TaskHistoryDto } from '../../../../core/models/task/task-historyDto';
import { TaskDto } from '../../../../core/models/task/taskDto';
import { BroadCastEventKeys, RoutePath, SideMenuItem } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TaskForwardComponent = class TaskForwardComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, dialogManager, eventProvider, sessionManager, shortcutManager, translateService, dialogRef, integrationSettingManager, applicationSettingManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.dateJS = Date;
        this.reasonList = [];
        this.reasonIndex = 0;
        this.enableReasonValidation = false;
        this.taskHandlerDto = new TaskHandlerDto();
        this.taskHistoryDto = new TaskHistoryDto();
        this.taskDto = new TaskDto();
        this.questionIndex = 0;
        this.handlerTypeList = [];
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.subs = new SubSink();
        this.forwardTaskErrorCallback = this.forwardTaskErrorCallback.bind(this);
        this.forwardTaskResponseReceived = this.forwardTaskResponseReceived.bind(this);
    }
    ngOnInit() {
        this.setHandlerTypes();
        this.setTitle();
        this.fillCachedEmployee();
        this.setDefaultNotForMeReasons();
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.forwardTask());
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("handlerForwardTaskTagControl")?.focus();
    }
    ;
    setDefaultNotForMeReasons() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTNOTFORMEREASONS");
        if (!GlobalFunctions.isEmpty(result)) {
            result = result.replace(/\n/g, "\r");
            let splitResult = result.split("\r");
            if (splitResult != null && splitResult.length > 0) {
                for (let index = 0; index < splitResult.length; index++) {
                    if (splitResult[index] != '')
                        this.reasonList.push(splitResult[index]);
                }
            }
        }
        this.reasonList.push(this.translateService.instant("LBL_OTHER"));
        this.taskHistoryDto.Reason = this.reasonList[this.questionIndex];
        this.changeReasonOption();
    }
    ;
    changeReasonOption() {
        this.taskHistoryDto.Reason = this.reasonList[this.reasonIndex];
        this.enableReasonValidation = (this.reasonList.length == (this.reasonIndex + 1));
    }
    ;
    forwardTaskErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_TASK_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    forwardTask() {
        if (this.handlerTags.length === 0 || this.form.invalid)
            return;
        this.startSpinner();
        this.taskHandlerDto.HandlerId = this.handlerTags[0].Id;
        this.taskHandlerDto.HandlerType = this.currentHandlerType;
        let baseDtoObject = new BaseDto();
        baseDtoObject.Id = this.handlerTags[0].Id;
        this.taskHandlerDto.HandlerObject = baseDtoObject;
        if (this.currentHandlerType == "Mailbox")
            this.taskHandlerDto.DepartmentId = this.handlerTags[0].Department;
        this.taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.taskHistoryDto.Status = TaskStatus.Forwarded;
        this.taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        this.taskHistoryDto.TaskHandlerList.push(this.taskHandlerDto);
        baseDtoObject = new BaseDto();
        baseDtoObject.Id = this.taskHistoryDto.CreatedById;
        let loggedInEmployee = this.cacheManager.getEmployeeById(this.taskHistoryDto.CreatedById);
        if (!GlobalFunctions.isEmpty(loggedInEmployee))
            baseDtoObject.StringRepresentation = loggedInEmployee.StringRepresentation;
        this.taskHistoryDto.CreatedBy = baseDtoObject;
        this.taskDto = this.sessionManager.selectedEntity;
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(this.taskHistoryDto);
        this.taskDto.CurrentStatus = TaskStatus.Unhandled;
        this.taskService.forwardTask(this.taskDto, ForwardTaskType.Reassign, this.forwardTaskResponseReceived, this.forwardTaskErrorCallback);
    }
    ;
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems != undefined || breadCrumbItems != null)
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
    }
    ;
    forwardTaskResponseReceived(result) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        if (result.Result == 0) {
            this.close();
            this.loadLastSelectedSearchResult();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAILED_TO_FORWARD_TASK") });
    }
    setTitle() {
        let taskType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
        switch (taskType.toUpperCase()) {
            case "CALLBACKNOTE":
                this.forwardTaskTitle = this.translateService.instant("LBL_CALLBACK_NOTE");
                break;
            case "APPOINTMENT":
                this.forwardTaskTitle = this.translateService.instant("LBL_APPOINTMENT");
                break;
            case "REPORTIMPROVEMENT":
                this.forwardTaskTitle = this.translateService.instant("LBL_REPORT_IMPROVEMENT");
                break;
            case "INFORMATIONREQUEST":
                this.forwardTaskTitle = this.translateService.instant("LBL_INFORMATION_REQUEST");
                break;
            case "ASSIGNMENT":
                this.forwardTaskTitle = this.translateService.instant("LBL_ASSIGNMENT");
                break;
        }
        this.forwardTaskTitle += " (" + this.translateService.instant("LBL_REASSIGN") + ")";
        this.forwardTaskTitle = this.forwardTaskTitle.toUpperCase();
    }
    ;
    fillCachedEmployee() {
        if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList != undefined) {
            let cachedEntities = this.sessionManager.detailViewCachedEntityList;
            if (cachedEntities != null && cachedEntities.length > 0) {
                this.cachedEmployeeEntities = [];
                cachedEntities.forEach(value => {
                    if (!GlobalFunctions.isEmpty(value.value)) {
                        let actualEntityType = value.value.replace(/\./g, '_');
                        if (EntityFqdn["" + actualEntityType + ""] == 22)
                            this.cachedEmployeeEntities.push(value.key);
                    }
                });
            }
        }
    }
    ;
    setHandlerTypes() {
        this.currentHandlerType = "Employee";
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        if (this.handlerTypeOption.EmployeeHandler)
            this.handlerTypeList.push({ handlerTypeValue: "Employee", handlerTypeText: this.translateService.instant("LBL_EMPLOYEE") });
        if (this.handlerTypeOption.DepartmentHandler)
            this.handlerTypeList.push({ handlerTypeValue: "Department", handlerTypeText: this.translateService.instant("LBL_DEPARTMENT") });
        if (this.handlerTypeOption.MailboxHandler)
            this.handlerTypeList.push({ handlerTypeValue: "Mailbox", handlerTypeText: this.translateService.instant("LBL_MAILBOX") });
        if (!this.handlerTypeOption.EmployeeHandler)
            this.currentHandlerType = "Department";
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    close() {
        this.dialogRef.close();
    }
};
__decorate([
    ViewChild('form')
], TaskForwardComponent.prototype, "form", void 0);
TaskForwardComponent = __decorate([
    Component({
        selector: 'task-forward',
        templateUrl: './task-forward.component.html',
        styleUrls: ['./task-forward.component.scss']
    })
], TaskForwardComponent);
export { TaskForwardComponent };
//# sourceMappingURL=task-forward.component.js.map