var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { interval } from 'rxjs';
import { ContextMenuView, MessageMediaType, ScreenMode, SocialMediaStatus, SocialMediaType } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { EntityFqdn } from '../../../../../core/enums/core-enums';
import { PhoneState } from '../../../../../core/models/common/phone-state';
import { SocialMediaContactHistoryDto } from '../../../../../core/models/social-media/social-media-contact-historyDto';
import { SocialMediaReplyMessageDto } from '../../../../../core/models/social-media/social-media-reply-messageDto';
import { SocialMediaDto } from '../../../../../core/models/social-media/social-mediaDto';
import { BroadCastEventKeys, RoutePath } from '../../../../../shared/constants';
import { DialogHelper } from '../../../../../shared/helper/dialog-helper';
import { BaseDetailComponent } from '../../../../common/base-detail.component';
import { MessageboxComponent } from '../../../../common/messagebox/messagebox.component';
let WhatsAppDetailComponent = class WhatsAppDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, socialMediaService, taskService, contactHistoryService, employeeService, integrationSettingManager, dialog, eventProvider, phoneManager, dialogManager, translateService, contextMenuService, router, downloadService) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.socialMediaService = socialMediaService;
        this.taskService = taskService;
        this.contactHistoryService = contactHistoryService;
        this.employeeService = employeeService;
        this.integrationSettingManager = integrationSettingManager;
        this.dialog = dialog;
        this.eventProvider = eventProvider;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.contextMenuService = contextMenuService;
        this.router = router;
        this.downloadService = downloadService;
        this.isNormalSizeDetailView = true;
        this.replyMessageText = "";
        this.timerPromise = null;
        this.autoUpdateTime = 15000;
        this.handlingInProgress = false;
        this.disableControl = false;
        this.showEdit = true;
        this.previousMemoText = "";
        this.errorMessage = "";
        this.repliedMessageHistory = new Object();
        this.attachment = { originalName: '', uploadedName: '' };
        this.DateJS = Date;
        this.phoneState = new PhoneState();
        this.timeoutIds = [];
        this.fileErrorMessage = "";
        this.fetchDetailResponse = this.fetchDetailResponse.bind(this);
        this.messageHandlingResponse = this.messageHandlingResponse.bind(this);
        this.replyMessageResponse = this.replyMessageResponse.bind(this);
        this.fetchAutoDetailResponse = this.fetchAutoDetailResponse.bind(this);
        this.updateMemoResponse = this.updateMemoResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_DETAIL_VIEW).subscribe(() => this.ngOnInit());
    }
    ngOnInit() {
        try {
            this.phoneState = this.phoneManager.phoneState;
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager, this.socialMediaService);
            this.contextMenuService.loadActionButton(detailEntityType);
            this.menu.addOrUpdateMenuItem(0, "WhatsAppDetail", this.translateService.instant("LBL_WHATSAPP"), false, true, true);
            this.menu.addOrUpdateMenuItem(10000, "MESSAGES", this.translateService.instant("LBL_MESSAGES"), false);
            this.addMenuItem.emit(this.menu);
            //FETCH RELATED ENTITY TO WHATSAPP
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.User)) {
                this.contactHistoryService.getRecentActivities(this.sessionManager.selectedEntity.User.MobileNumber);
                this.taskService.getRecentActivities(this.sessionManager.selectedEntity.User.MobileNumber);
            }
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.socialMediaService.connect().then(() => this.socialMediaService.fetchDetail(partialDto, SocialMediaType.WhatsApp, this.fetchDetailResponse));
                this.startSpinner();
            }
            else
                this.fetchDetailResponse(this.sessionManager.selectedEntity);
            let autoUpdateTimeSetting = parseInt(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_WhatsApp, "AUTOUPDATETIMEDURATION"));
            if (!GlobalFunctions.isEmpty(autoUpdateTimeSetting))
                this.autoUpdateTime = autoUpdateTimeSetting;
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ngOnDestroy() {
        if (this.timerPromise != null)
            this.timerPromise.unsubscribe();
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    fetchDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            if (!GlobalFunctions.isEmpty(result.MessageHistoryList))
                for (let index = 0; index < result.MessageHistoryList.length; index++) {
                    if (result.MessageHistoryList[index].ReplyBy === "Handler")
                        result.MessageHistoryList[index].User = this.getUserDetail(result.MessageHistoryList[index].User);
                }
            this.sessionManager.selectedEntity = result;
            this.scrollToHistoryList();
            this.timerPromise = interval(this.autoUpdateTime).subscribe(x => {
                let partialDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                partialDto.Partial = true;
                this.socialMediaService.fetchDetail(partialDto, SocialMediaType.WhatsApp, this.fetchAutoDetailResponse);
            });
            this.contextMenuService.loadActionButton(GlobalFunctions.getObjectTypeName(result.RelatedEntityFqdn));
            this.sendRelatedRequest.emit();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_HANDLED'), textMsg: this.translateService.instant('LBL_HANDLED_SOCIAL_MEDIA') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
    }
    fetchAutoDetailResponse(result) {
        if (result != null) {
            if (!GlobalFunctions.isEmpty(result.MessageHistoryList) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.MessageHistoryList)) {
                let count = result.MessageHistoryList.length - this.sessionManager.selectedEntity.MessageHistoryList.length;
                if (count > 0) {
                    for (var index = 0; index < result.MessageHistoryList.length; index++) {
                        if (result.MessageHistoryList[index].ReplyBy === "Handler")
                            result.MessageHistoryList[index].User = this.getUserDetail(result.MessageHistoryList[index].User);
                    }
                    this.sessionManager.selectedEntity.MessageHistoryList = result.MessageHistoryList;
                    this.timeoutIds.push(setTimeout(() => this.scrollToHistoryList(), 10));
                }
            }
        }
    }
    replyMessage(message) {
        if (!GlobalFunctions.isEmpty(message) || !GlobalFunctions.isEmpty(this.attachment.originalName)) {
            if (this.attachment.originalName.length == 0) {
                this.sendMessage(message, "", MessageMediaType.Text);
            }
            else {
                let textType = this.getMessageMediaType(this.attachment.originalName);
                this.sendMessage(message, this.attachment.uploadedName, textType);
            }
        }
    }
    getMessageMediaType(fileName) {
        let messageMediaType = MessageMediaType.Other;
        fileName = fileName.toLowerCase();
        if (fileName.indexOf('.jpeg') != -1 || fileName.indexOf('.jpg') != -1 || fileName.indexOf('.png') != -1)
            messageMediaType = MessageMediaType.Image;
        else
            messageMediaType = MessageMediaType.Other;
        return messageMediaType;
    }
    sendMessage(message, media, messageType) {
        this.isTextAreaEmpty = false;
        let replyMessage = new SocialMediaReplyMessageDto();
        replyMessage.MediaType = messageType;
        replyMessage.Message = message;
        if (messageType != MessageMediaType.Text)
            replyMessage.MediaList.push(media);
        replyMessage.DateTime = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        replyMessage.IsPrivate = this.sessionManager.selectedEntity.Message.IsPrivate;
        replyMessage.ParentMessageId = this.sessionManager.selectedEntity.Id;
        replyMessage.HandlingId = this.sessionManager.selectedEntity.MessageHandling.Id;
        replyMessage.UserName = this.employeeService.loggedInEmployee.LoggedInUserName;
        let receiveMessageList = this.socialMediaService.getReceiveMessageList(this.sessionManager.selectedEntity);
        this.socialMediaService.replyMessage(replyMessage, receiveMessageList, SocialMediaType.WhatsApp, this.replyMessageResponse);
        this.startSpinner();
        this.disableControl = true;
    }
    replyMessageResponse(replyMessage, result) {
        this.disableControl = false;
        this.stopSpinner();
        if (result == 0 && replyMessage != null) {
            this.removeFile();
            replyMessage.User = this.getUserDetail(replyMessage.User);
            this.sessionManager.selectedEntity.MessageHistoryList.push(replyMessage);
            this.timeoutIds.push(setTimeout(() => {
                this.isTextAreaEmpty = true;
                this.scrollToHistoryList();
            }, 10));
        }
        ;
    }
    getUserDetail(user) {
        if (user != null) {
            let employee = this.cacheManager.getEmployeeById(user.Id);
            if (employee != null) {
                let employeeList = new Array();
                employeeList.push(employee);
                user.Name = employee.StringRepresentation;
                user.Picture = employee.PictureData;
            }
        }
        return user;
    }
    scrollToHistoryList() {
        if (!GlobalFunctions.isEmpty($('#socialMediaHistoryList')))
            $('#socialMediaHistoryList').scrollTop($('#socialMediaHistoryList')[0].scrollHeight);
    }
    messageHandlingResponse(result) {
        if (result != null) {
            if (result.CurrentStatus == SocialMediaStatus.Unhandled) {
                this.sessionManager.selectedEntity.MessageHandling = result;
                this.scrollToHistoryList();
                $("#replyMessageTextId").focus();
                this.handlingInProgress = false;
                this.phoneManager.setPhoneStatusAction('2');
            }
            else {
                let socialMediaDto = new SocialMediaDto();
                socialMediaDto.Id = result.Id;
                socialMediaDto.ObjectSource = result.ObjectSource;
                socialMediaDto.Type = result.Type;
                socialMediaDto.StringRepresentation = this.translateService.instant("LBL_SOCIALMEDIA") + " - " + this.translateService.instant("LBL_WHATSAPP");
                socialMediaDto.SocialMediaObject = this.sessionManager.selectedEntity;
                this.sessionManager.addItemsToDetailViewCacheList(socialMediaDto, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]), true);
                this.socialMediaService.updateContactSessionNotesWithSocialMediaDetails(this.sessionManager);
                this.sessionManager.addRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                this.timeoutIds.push(setTimeout(() => {
                    this.sessionManager.selectedEntity.MessageHandling.CurrentStatus = SocialMediaStatus.Handled;
                    this.handlingInProgress = false;
                }));
                if (this.sessionManager.isAssignmentTaskAutoIgnoreSessionValid(this.cacheManager, "socialmedia")) {
                    this.taskService.handleAssignmentTask(this.cacheManager);
                    this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
                }
                else
                    this.dialogManager.openEndSessionDialog();
            }
            for (let i = 0; i < this.sessionManager.BreadcrumbItems.length; i++) {
                if (this.sessionManager.BreadcrumbItems[i] && this.sessionManager.BreadcrumbItems[i][0].itemData && this.sessionManager.BreadcrumbItems[i][0].itemData.Id == this.sessionManager.selectedEntity.Id) {
                    this.sessionManager.BreadcrumbItems.splice(i, 1);
                    this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, "detail");
                    break;
                }
            }
        }
    }
    startMessageHandling() {
        if (!this.handlingInProgress) {
            this.handlingInProgress = true;
            let messageHandlingDto = this.socialMediaService.getMessageHandlingDto(this.sessionManager.selectedEntity);
            if (messageHandlingDto != null) {
                this.sessionManager.startSessionIfPossible("SOCIALMEDIA", ScreenMode.Edit);
                this.socialMediaService.startHandlingMessage(messageHandlingDto, this.messageHandlingResponse);
            }
        }
    }
    stopMessageHandling() {
        if (!this.handlingInProgress) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_WHATSAPP"), this.translateService.instant("LBL_STOP_HANDLING_CONFIRMATION"), true, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                if (result == 1) {
                    this.handlingInProgress = true;
                    this.sessionManager.selectedEntity.MessageHistoryList.forEach((message) => {
                        if (!jlinq.from(this.sessionManager.selectedEntity.MessageHandling.SocialMediaContactHistoryList).equals("MessageId", message.Id).any()) {
                            let socialMediaMessage = new SocialMediaContactHistoryDto;
                            socialMediaMessage.SocialMediaContactId = this.sessionManager.selectedEntity.MessageHandling.Id;
                            socialMediaMessage.Message = message.Message;
                            socialMediaMessage.MediaType = message.MediaType;
                            socialMediaMessage.MediaList = message.MediaList;
                            socialMediaMessage.MessageId = message.Id;
                            socialMediaMessage.ReplyBy = message.ReplyBy;
                            socialMediaMessage.MessageDateTime = message.DateTime;
                            socialMediaMessage.UserId = message.User.Id;
                            socialMediaMessage.UserName = message.User.Name;
                            this.sessionManager.selectedEntity.MessageHandling.SocialMediaContactHistoryList.push(socialMediaMessage);
                        }
                    });
                    if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber))
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager.selectedEntity.User.MobileNumber;
                    if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = this.sessionManager.selectedEntity.User.Name;
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "WhatsApp";
                    let messageHandlingDto = this.sessionManager.selectedEntity.MessageHandling;
                    if (messageHandlingDto != null)
                        this.socialMediaService.stopHandlingMessage(messageHandlingDto, this.messageHandlingResponse, null);
                }
            });
        }
    }
    cancelMemo() {
        this.sessionManager.selectedEntity.MessageHandling.Memo = this.previousMemoText;
        $("#internalMemoTextName").attr('disabled', 'true');
        this.showEdit = true;
    }
    editMemo() {
        this.errorMessage = null;
        this.previousMemoText = this.sessionManager.selectedEntity.MessageHandling.Memo;
        this.timeoutIds.push(setTimeout(() => { $("#internalMemoId").focus(); }, 1));
        this.showEdit = false;
    }
    saveMemo() {
        this.errorMessage = null;
        this.socialMediaService.updateSocialMediaMemo(this.sessionManager.selectedEntity.MessageHandling.Memo, this.sessionManager.selectedEntity.MessageHandling.Id, this.updateMemoResponse);
    }
    updateMemoResponse(response) {
        if (!GlobalFunctions.isEmpty(response) && response.Result === 1) {
            this.errorMessage = this.translateService.instant("LBL_MESSAGE_FAILED_MEMO");
            this.sessionManager.selectedEntity.MessageHandling.Memo = this.previousMemoText;
        }
        $("#internalMemoTextName").attr('disabled', 'true');
        this.timeoutIds.push(setTimeout(() => { this.showEdit = true; }, 1));
        $('#internalMemoId').scrollTop($('#internalMemoId')[0].scrollHeight - 100);
    }
    downloadMedia(mediaUrl) {
        if (!GlobalFunctions.isEmpty(mediaUrl))
            window.open(mediaUrl);
    }
    openLinkView(type) {
        this.dialogManager.openLinkContactInfo(type);
    }
    onUpload(files) {
        this.attachment.originalName = files.name;
        this.startSpinner();
    }
    onError(response) {
        this.fileErrorMessage = GlobalFunctions.getFileUploadErrorText(response, this.translateService);
        this.stopSpinner();
    }
    onSuccess(response) {
        this.attachment.uploadedName = response[0].fileName;
        this.stopSpinner();
    }
    removeFile() {
        this.attachment.originalName = "";
        this.attachment.uploadedName = "";
        this.fileErrorMessage = "";
    }
};
__decorate([
    ViewChild('form')
], WhatsAppDetailComponent.prototype, "form", void 0);
WhatsAppDetailComponent = __decorate([
    Component({
        selector: 'whatsapp-detail',
        templateUrl: './whatsapp-detail.component.html',
        styleUrls: ['./whatsapp-detail.component.scss']
    })
], WhatsAppDetailComponent);
export { WhatsAppDetailComponent };
//# sourceMappingURL=whatsapp-detail.component.js.map