var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { ContextMenuView, OperationType, SocialMediaSearchType, SocialMediaType } from 'src/app/core/enums/common-enums';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { ContextMenu, ContextMenuItem } from 'src/app/core/models/common/context-menu';
import { FilterList } from 'src/app/core/models/filter/filter-list';
import { ArchiveSocialMediaMessageRequest } from 'src/app/core/models/social-media/archive-social-media-message-request';
import { DeleteSocialMediaMessageRequest } from 'src/app/core/models/social-media/delete-social-media-message-request';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let SocialMediaSearchResultComponent = class SocialMediaSearchResultComponent extends BaseSearchResultComponent {
    constructor(translateService, socialMediaService, sortManager, sessionManager, activatedRoute, eventProvider, router, elementRef, formatManager, dialogManager, dialog, shortcutManager, changeDetectorRef, cacheManager, employeeService, applicationSettingManager, integrationSettingManager, datePipe, searchService, filterPipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.translateService = translateService;
        this.socialMediaService = socialMediaService;
        this.sortManager = sortManager;
        this.sessionManager = sessionManager;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.router = router;
        this.elementRef = elementRef;
        this.formatManager = formatManager;
        this.dialogManager = dialogManager;
        this.dialog = dialog;
        this.shortcutManager = shortcutManager;
        this.changeDetectorRef = changeDetectorRef;
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.filterPipe = filterPipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.filteredResultList = [];
        this.type = '';
        this.selectedSocialEntities = [];
        this.publishResultContition = false;
        this.filterList = new FilterList();
        this.isAllMenuItemVisible = false;
        this.menuItems = [];
        this.searchStatus = this.searchStatus.bind(this);
        this.employeeFetchingCompleted = this.employeeFetchingCompleted.bind(this);
        this.subs.sink = this.activatedRoute.queryParams.subscribe(queryParams => {
            this.isAllMenuItemVisible = false;
            this.selectedOption = queryParams.filter || 'new';
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "socialmedia";
        this.resultList = [];
        this.filteredSearchResult = [];
        this.filterList = new FilterList();
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase().includes(this.type.toLowerCase()) || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase().includes("advanced"))) {
            this.sourceCount = 0;
            this.filterList.Filters = this.socialMediaService.lastAppliedFilters;
            this.filterList.FilterOptions = this.socialMediaService.filterOptions;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.searchStatusMessage = '';
            this.filterList.EnableAddColumn = false;
            this.menuItems = [];
            if (this.employeeService != null && !this.employeeService.isEmployeesReceived)
                this.employeeService.globalEventEmployeeFetchCompleted = this.employeeFetchingCompleted;
            if (this.selectedOption.toLowerCase() === 'all')
                this.isAllMenuItemVisible = true;
            this.searchSocialMedia(this.selectedOption);
            this.filterList.FilterOptions = Object.assign([], this.socialMediaService.getFilterList());
        }
        this.loadSearchResultMenuItem();
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.elementRef.nativeElement.remove();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    searchSocialMedia(option) {
        this.selectedOption = option;
        this.selectedSocialEntities = [];
        this.socialMediaService.lastSelectedOption = option;
        this.updateSearchStatus(this.activeHandlersObj);
        switch (option.toUpperCase()) {
            case "ALL":
                {
                    this.resetSearch(this.translateService.instant("LBL_ALL_MESSAGES"));
                    this.socialMediaService.advancedSearch(null, SocialMediaType.All, SocialMediaSearchType.All, this.searchResultFound, this.searchStatus);
                    break;
                }
            case "TOTALOPENSOCIALMEDIA":
            case "NEW":
                {
                    this.resetSearch(this.translateService.instant("LBL_NEW_MESSAGES"));
                    this.socialMediaService.advancedSearch(null, SocialMediaType.All, SocialMediaSearchType.New, this.searchResultFound, this.searchStatus);
                    break;
                }
            case "INPROGRESSSOCIALMEDIABYME":
            case "INPROGRESSSOCIALMEDIABYDEPARTMENT":
            case "MY":
                {
                    this.resetSearch(this.translateService.instant("LBL_MY_MESSAGES"));
                    this.socialMediaService.advancedSearch(null, SocialMediaType.All, SocialMediaSearchType.My, this.searchResultFound, this.searchStatus);
                    break;
                }
            case "PUBLISHED":
                {
                    this.publishResultContition = false;
                    this.resetSearch(this.translateService.instant("LBL_PUBLISHED_MESSAGES"));
                    this.socialMediaService.advancedSearch(null, SocialMediaType.All, SocialMediaSearchType.Published, this.searchResultFound, this.searchStatus);
                    break;
                }
            case "ARCHIVE":
                {
                    this.publishResultContition = true;
                    this.resetSearch(this.translateService.instant("LBL_ARCHIVED_MESSAGES"));
                    this.socialMediaService.advancedSearch(null, SocialMediaType.All, SocialMediaSearchType.Published, this.searchResultFound, this.searchStatus);
                    break;
                }
        }
        this.sessionManager.contextMenu = new ContextMenu("", "SocialMedia", this.translateService, null, GlobalFunctions.getLoggedInUserId(), ContextMenuView.SearchList, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
    }
    resetSearch(searchQuery) {
        this.resultList = [];
        this.sourceCount = null;
        this.searchStatusQuery = searchQuery;
    }
    searchStatus(result) {
        super.updateSearchStatus(result);
        this.timeoutIds.push(setTimeout(() => {
            if (this.sourceCount == 0) {
                this.updateSocialMessageCount();
                this.socialMediaService.resultCompleteList = this.resultList;
                if (this.selectedOption.toUpperCase() === 'PUBLISHED' || this.selectedOption.toUpperCase() === 'ARCHIVE') {
                    let filteredPublicResults = this.filterPipe.transform(this.resultList, ['IsArchivedMessage'], this.publishResultContition);
                    this.resultList = filteredPublicResults;
                }
                if (this.filterList.Filters != null && this.filterList.Filters.length > 0 && this.resultList.length > 0)
                    this.setResultList();
            }
        }, 5));
    }
    updateSocialMessageCount() {
        switch (this.selectedOption.toUpperCase()) {
            case "ALL":
                {
                    this.sessionManager.pendingCount.SocialMediaMessageCount.AllMessageCount = this.resultList.length;
                    this.sessionManager.pendingCount.SocialMediaMessageCount.AllUnreadMessageCount = jlinq.from(this.resultList).sum("UnhandledMessage");
                    break;
                }
            case "NEW":
                {
                    this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount = this.resultList.length;
                    break;
                }
            case "MY":
                {
                    this.sessionManager.pendingCount.SocialMediaMessageCount.MyMessageCount = this.resultList.length;
                    this.sessionManager.pendingCount.SocialMediaMessageCount.MyUnreadMessageCount = jlinq.from(this.resultList).sum("UnhandledMessage");
                    break;
                }
            case "SOCIALMEDIA":
                {
                    break;
                }
            case "PUBLISHED":
            case "ARCHIVE":
                {
                    this.sessionManager.pendingCount.SocialMediaMessageCount.PublishArchiveMessageCount = jlinq.from(this.resultList).is("IsArchivedMessage").count();
                    this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedMessageCount = this.resultList.length - this.sessionManager.pendingCount.SocialMediaMessageCount.PublishArchiveMessageCount;
                    break;
                }
        }
        this.sessionManager.pendingCount.SocialMediaMessageCount.TotalMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount + this.sessionManager.pendingCount.SocialMediaMessageCount.AllMessageCount + this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedMessageCount;
    }
    setResultList() {
        if (this.filterList.Filters.length > 0 && this.socialMediaService.resultCompleteList != null && this.socialMediaService.resultCompleteList.length > 0) {
            this.resultList = [];
            let appliedFilterType = [];
            this.filteredResultList = [];
            for (let ft = 0; ft < this.filterList.Filters.length; ft++) {
                if (this.filterList.Filters[ft].Id !== "MessageType" && !jlinq.from(appliedFilterType).contains(this.filterList.Filters[ft].Type).any()) {
                    let filtersOfType = jlinq.from(this.filterList.Filters).equals("Type", this.filterList.Filters[ft].Type).select();
                    if (filtersOfType && filtersOfType.length > 0) {
                        let resultsOfType = [];
                        this.filteredResultList = Object.assign([], this.socialMediaService.resultCompleteList);
                        for (let fr = 0; fr < this.filteredResultList.length; fr++) {
                            for (let ftype = 0; ftype < filtersOfType.length; ftype++) {
                                let result = this.filteredResultList[fr];
                                if (this.filteredResultList[fr].SourceName.toLowerCase() == filtersOfType[ftype].Title.toLowerCase()) {
                                    resultsOfType.push(result);
                                    break;
                                }
                            }
                        }
                        let combineResultList = this.filteredResultList.filter(n => resultsOfType.indexOf(n) !== -1);
                        for (let t = 0; t < combineResultList.length; t++)
                            this.resultList.push(combineResultList[t]);
                    }
                    appliedFilterType.push(this.filterList.Filters[ft].Type);
                }
            }
            for (let fl = 0; fl < this.filterList.Filters.length; fl++) {
                if (this.filterList.Filters[fl].Id === "MessageType" && !jlinq.from(appliedFilterType).contains(this.filterList.Filters[fl].Type).any()) {
                    let filterOfType = jlinq.from(this.filterList.Filters).equals("Type", this.filterList.Filters[fl].Type).select();
                    if (filterOfType != null && filterOfType.length > 0) {
                        let resultOfType = [];
                        if (GlobalFunctions.isEmpty(appliedFilterType))
                            this.filteredResultList = Object.assign([], this.socialMediaService.resultCompleteList);
                        else
                            this.filteredResultList = Object.assign([], this.resultList);
                        for (let fk = 0; fk < this.filteredResultList.length; fk++) {
                            let results = this.filteredResultList[fk];
                            if (filterOfType.length === 2 || (!GlobalFunctions.isEmpty(this.filteredResultList[fk].Message) && this.filteredResultList[fk].Message.IsPrivate.toString().toLowerCase() === filterOfType[0].Key.toLowerCase()))
                                resultOfType.push(results);
                        }
                        this.resultList = this.filteredResultList.filter(n => resultOfType.indexOf(n) !== -1);
                    }
                    appliedFilterType.push(this.filterList.Filters[fl].Type);
                }
            }
            GlobalFunctions.remove_duplicates(this.resultList);
        }
        else
            this.resultList = this.socialMediaService.resultCompleteList;
    }
    selectEntity(event, selectedEntity) {
        let checkBox = event.target;
        if (checkBox.checked && !jlinq.from(this.selectedSocialEntities).starts("Id", selectedEntity.Id).any() && (selectedEntity.Type.toLowerCase() == "facebook" || selectedEntity.Type.toLowerCase() == 'whatsapp'))
            this.selectedSocialEntities.push(selectedEntity);
        else {
            let selectedItem = jlinq.from(this.selectedSocialEntities).starts("Id", selectedEntity.Id).first();
            if (!GlobalFunctions.isEmpty(selectedItem)) {
                let index = this.selectedSocialEntities.indexOf(selectedItem);
                this.selectedSocialEntities.splice(index, 1);
            }
        }
        this.selectedSocialEntities;
        if (event.stopPropagation)
            event.stopPropagation();
        event.cancelBubble = true;
    }
    select(item) {
        super.onItemClick(item);
        this.socialMediaService.lastAppliedFilters = this.filterList.Filters;
        this.socialMediaService.filterOptions = this.filterList.FilterOptions;
    }
    employeeFetchingCompleted() {
        this.formatManager.setUserDetail(this.resultList, this.cacheManager);
    }
    // Action Menu/Context Menu Start
    loadSearchResultMenuItem() {
        let menuContentType = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]);
        this.addMenuItem("LBL_BULK_REPLY", "BULKREPLY", OperationType.BulkReplySocialMessage, menuContentType);
        if (!GlobalFunctions.isEmpty(this.socialMediaService) && !GlobalFunctions.isEmpty(this.socialMediaService.lastSelectedOption) && this.socialMediaService.lastSelectedOption.toUpperCase() == "NEW")
            this.addMenuItem("LBL_BULK_DELETE", "BULKDELETE", OperationType.BulkDelete, menuContentType);
        if (!GlobalFunctions.isEmpty(this.socialMediaService) && !GlobalFunctions.isEmpty(this.socialMediaService.lastSelectedOption) && this.socialMediaService.lastSelectedOption.toUpperCase() == "PUBLISHED")
            this.addMenuItem("LBL_ARCHIVE", "ARCHIVESOCIALMEDIA", OperationType.ArchiveSocialMedia, menuContentType);
    }
    addMenuItem(title, key, operation, oldContentType, dontCheckRight = false, objectSource = null) {
        /*if Operation type Add check view rights too*/
        if (operation == OperationType.Add && !dontCheckRight) {
            if (GlobalFunctions.hasRight(oldContentType, operation, objectSource) && GlobalFunctions.hasRight(oldContentType, OperationType.View, objectSource))
                this.menuItems.push(new ContextMenuItem(this.translateService.instant(title), key, this.type));
        }
        else if (dontCheckRight || GlobalFunctions.hasRight(oldContentType, operation, objectSource))
            this.menuItems.push(new ContextMenuItem(this.translateService.instant(title), key, this.type));
    }
    executeMenuItem(key) {
        switch (key.toUpperCase()) {
            case "BULKDELETE":
                {
                    if (this.selectedSocialEntities.length > 0)
                        this.bulkDeleteInit();
                    else {
                        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_BULK_DELETE"), this.translateService.instant("LBL_MSG_BULK_DELETE_NO_NOTE"), false, null, null, null, null, this.translateService);
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                    }
                    break;
                }
            case "BULKREPLY":
                {
                    if (this.selectedSocialEntities.length > 0)
                        this.dialogManager.bulkReplyMessage(this.selectedSocialEntities);
                    else {
                        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_BULK_REPLY"), this.translateService.instant("LBL_MSG_BULK_REPLY_NO_MESSAGE"), false, null, null, null, null, this.translateService);
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                    }
                    break;
                }
            case "ARCHIVESOCIALMEDIA":
                {
                    if (this.selectedSocialEntities.length > 0)
                        this.archiveMessage(this.selectedSocialEntities);
                    else {
                        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_ARCHIVE"), this.translateService.instant("LBL_MSG_ARCHIVE_NO_MESSAGE"), false, null, null, null, null, this.translateService);
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                        break;
                    }
                }
        }
    }
    bulkDeleteInit() {
        try {
            this.sendBulkDeleteRequest();
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', function () { this.bulkDelete(); });
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    sendBulkDeleteRequest() {
        if (!GlobalFunctions.isEmpty(this.selectedSocialEntities)) {
            let message = this.translateService.instant("LBL_MSG_BULK_DELETE_SOCIAL");
            let header = this.translateService.instant("LBL_BULK_DELETE");
            if (this.selectedSocialEntities.length == 0) {
                let messageInfo = DialogHelper.getMessage(header, this.translateService.instant("LBL_MSG_BULK_DELETE_NO_MESSAGE"), false, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
            }
            else {
                message = GlobalFunctions.formatStringValue(message, [this.selectedSocialEntities.length]);
                message = this.translateService.instant(message);
                let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (result) {
                        let request = new DeleteSocialMediaMessageRequest();
                        request.SocialMediaMessageList = this.selectedSocialEntities;
                        this.socialMediaService.deleteSocialMediaMessage(request, this.bulkDeleteSocialMediaResponse, this.deleteMessageErrorCallback);
                    }
                });
            }
        }
    }
    bulkDeleteSocialMediaResponse(result) {
        let header = this.translateService.instant("LBL_BULK_REPLY");
        switch (result.Result) {
            case 0:
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
                break;
            case 1:
                let message = this.translateService.instant("LBL_MSG_BULK_DELETE_FAIL_SOCIAL");
                let messageInfo = DialogHelper.getMessage(header, message, false, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]));
                break;
        }
    }
    deleteMessageErrorCallback() { }
    // Delete Context Menu end
    archiveMessage(resultList) {
        if (!GlobalFunctions.isEmpty(resultList)) {
            let message = this.translateService.instant("LBL_MSG_ARCHIVE_SOCIAL");
            let header = this.translateService.instant("LBL_ARCHIVE");
            if (resultList.length == 0)
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
            else {
                message = GlobalFunctions.formatStringValue(message, [resultList.length]);
                message = this.translateService.instant(message);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result) {
                        let request = new ArchiveSocialMediaMessageRequest();
                        request.SocialMediaMessageList = resultList;
                        this.socialMediaService.archiveSocialMediaMessage(request, this.archiveMessageResponse);
                    }
                });
            }
        }
    }
    ;
    archiveMessageResponse(result) {
        if (result.Result == 0)
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'socialmedia'], { queryParams: { filter: 'archive' } });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_ARCHIVE"), textMsg: this.translateService.instant("LBL_MSG_ARCHIVE_FAIL_SOCIAL"), isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'socialmediapublished'], { queryParams: { filter: 'archive' } }));
    }
};
SocialMediaSearchResultComponent = __decorate([
    Component({
        selector: 'social-media-search-result',
        templateUrl: './social-media-search-result.component.html',
        styleUrls: ['./social-media-search-result.component.scss']
    })
], SocialMediaSearchResultComponent);
export { SocialMediaSearchResultComponent };
//# sourceMappingURL=social-media-search-result.component.js.map