var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SocialMediaType } from 'src/app/core/enums/common-enums';
import { FullTextSearchParameters } from 'src/app/core/models/common/full-text-search-parameters';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { SocialMediaMessageCountDto } from '../../../../core/models/social-media/social-media-message-countDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
let SocialMediaSearchCriteriaComponent = class SocialMediaSearchCriteriaComponent {
    constructor(translateService, socialMediaService, applicationSettingManager, employeeService, cacheManager, sessionManager, sortManager, searchService, router) {
        this.translateService = translateService;
        this.socialMediaService = socialMediaService;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.sortManager = sortManager;
        this.searchService = searchService;
        this.router = router;
        this.selectContent = true;
        this.fullTextSearchWidth = "";
        this.pendingSocialMediaMessageCountReceived = this.pendingSocialMediaMessageCountReceived.bind(this);
    }
    ngOnInit() {
        try {
            this.updatePendingCount();
            this.searchPlaceholder = this.applicationSettingManager.getSearchDescriptionText(ContentType.SocialMedia);
            this.SearchFrom = this.translateService.instant("LBL_SELECT_SOURCE");
            this.fullTextSearchWidth = "65%";
            this.init();
            this.resize();
        }
        catch (e) {
            console.error(e);
        }
    }
    init() {
        document.getElementById('searchTextBox').focus();
        this.openFullTextSearchPopup(this.getFulltextSearchParameters("socialmedia"));
    }
    getFulltextSearchParameters(option) {
        let popup_params = null;
        let socialMediaType = SocialMediaType;
        let sources = [];
        let allMessages = new Object();
        allMessages.value = socialMediaType.All;
        allMessages.text = this.translateService.instant("LBL_ALL_MESSAGES");
        sources.push(allMessages);
        let whatsapp = new Object();
        whatsapp.value = socialMediaType.WhatsApp;
        whatsapp.text = this.translateService.instant("LBL_WHATSAPP");
        sources.push(whatsapp);
        let twitter = new Object();
        twitter.value = socialMediaType.Twitter;
        twitter.text = this.translateService.instant("LBL_TWITTER");
        sources.push(twitter);
        let facebook = new Object();
        facebook.value = socialMediaType.Facebook;
        facebook.text = this.translateService.instant("LBL_FACEBOOK");
        sources.push(facebook);
        popup_params = new FullTextSearchParameters("SOCIALMEDIA", sources);
        return popup_params;
    }
    openFullTextSearchPopup(fulltextSearchParameters) {
        this.showSearchSources = (fulltextSearchParameters.sources.length > 1) ? true : false;
        this.searchSources = fulltextSearchParameters.sources;
        this.selectedSearchSource = this.searchSources[0].value;
        this.searchPlaceholder = this.applicationSettingManager.getSearchDescriptionText(ContentType.Email);
    }
    search(searchText, option) {
        if (this.validateForm()) {
            this.searchService.searchQuery = searchText;
            let selectedSearchOption = {
                searchType: 'socialmedia',
                searchQuery: searchText,
                searchFrom: 'dashboard'
            };
            this.searchService.searchOptionChanged(selectedSearchOption);
        }
    }
    validateForm() {
        return this.form.valid;
    }
    resize() {
        let windowHeight = $(window).height();
        $("#dashBoardItemDivFlow").height(windowHeight - 100 + 'px');
    }
    updatePendingCount() {
        if (this.applicationSettingManager.refreshCountSetting.SocialMedia.OnMenu) {
            this.messageId = GlobalFunctions.createGuid();
            this.sessionManager.pendingCount.SocialMediaMessageCount = new SocialMediaMessageCountDto();
            this.sessionManager.pendingCount.SocialMediaMessageCount.TotalMessageCount = "...";
            this.socialMediaService.getPendingSocialMediaMessageCount(this.messageId, this.pendingSocialMediaMessageCountReceived);
            this.socialMediaService.lastSelectedOption = "socialmedia";
        }
    }
    ;
    pendingSocialMediaMessageCountReceived(message) {
        if (message?.MessageId === this.messageId)
            this.socialMediaService.updatePendingSocialMediaCount(message);
    }
    ;
};
__decorate([
    ViewChild('form')
], SocialMediaSearchCriteriaComponent.prototype, "form", void 0);
SocialMediaSearchCriteriaComponent = __decorate([
    Component({
        selector: 'social-media-search-criteria',
        templateUrl: './social-media-search-criteria.component.html',
        styleUrls: ['./social-media-search-criteria.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], SocialMediaSearchCriteriaComponent);
export { SocialMediaSearchCriteriaComponent };
//# sourceMappingURL=social-media-search-criteria.component.js.map