var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { EntityName, RoutePath } from 'src/app/shared/constants';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let ReassignMessageComponent = class ReassignMessageComponent extends BaseDialogComponent {
    constructor(dialogRef, translateService, shortcutManager, sessionManager, cacheManager, socialMediaService, dialog, router) {
        super();
        this.dialogRef = dialogRef;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.socialMediaService = socialMediaService;
        this.dialog = dialog;
        this.router = router;
        this.cachedEmployeeEntities = [];
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.reassignMessageResponse = this.reassignMessageResponse.bind(this);
    }
    ngOnInit() {
        try {
            this.reassignMessageTitle = this.translateService.instant("LBL_" + this.sessionManager.selectedEntity.Type.toUpperCase()) + " (" + this.translateService.instant("LBL_REASSIGN") + ")";
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.reassignMessage());
            this.handlerTagItems = this.cacheManager.getEmployeeList(true);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    reassignMessage() {
        if (this.handlerTags?.length > 0) {
            this.startSpinner();
            this.socialMediaService.reassignMessage(this.handlerTags[0].Id, this.sessionManager.selectedEntity.Type, this.sessionManager.selectedEntity.MessageHandling.Id, this.reassignMessageResponse);
        }
        else
            this.errorMessage = "LBL_MSG_EMPTY_HANDLER";
    }
    reassignMessageResponse(message) {
        this.stopSpinner();
        if (message != null && message != undefined && message.Result == 0) {
            this.close();
            this.loadLastSelectedSearchResult();
        }
        else {
            let message = this.translateService.instant("LBL_MSG_FAILED_TO_FORWARD_TASK");
            let header = this.translateService.instant("LBL_" + this.sessionManager.selectedEntity.Type.toUpperCase()) + " (" + this.translateService.instant("LBL_REASSIGN") + ")";
            let messageInfo = DialogHelper.getMessage(message, header, false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
        }
    }
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems != undefined || breadCrumbItems != null) {
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        }
        this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
    }
    close() {
        this.dialogRef.close();
    }
};
ReassignMessageComponent = __decorate([
    Component({
        selector: 'reassign-message',
        templateUrl: './reassign-message.component.html',
        styleUrls: ['./reassign-message.component.scss']
    })
], ReassignMessageComponent);
export { ReassignMessageComponent };
//# sourceMappingURL=reassign-message.component.js.map