var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable, ViewChild } from '@angular/core';
import { interval } from 'rxjs';
import { ContextMenuView, ScreenMode, SocialMediaStatus, SocialMediaType } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { SocialMediaContactHistoryDto } from '../../../../core/models/social-media/social-media-contact-historyDto';
import { SocialMediaReplyMessageDto } from '../../../../core/models/social-media/social-media-reply-messageDto';
import { SocialMediaDto } from '../../../../core/models/social-media/social-mediaDto';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDetailComponent } from '../../../common/base-detail.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let BaseFacebookDetailComponent = class BaseFacebookDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, translateService, phoneManager, socialMediaService, taskService, contactHistoryService, employeeService, integrationSettingManager, dialogManager, dialog, eventProvider, contextMenuService, router) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.phoneManager = phoneManager;
        this.socialMediaService = socialMediaService;
        this.taskService = taskService;
        this.contactHistoryService = contactHistoryService;
        this.employeeService = employeeService;
        this.integrationSettingManager = integrationSettingManager;
        this.dialogManager = dialogManager;
        this.dialog = dialog;
        this.eventProvider = eventProvider;
        this.contextMenuService = contextMenuService;
        this.router = router;
        this.isNormalSizeDetailView = true;
        this.replyMessageText = "";
        this.timerPromise = null;
        this.isNewMessagesAvailable = false;
        this.newMessageCountAlert = 0;
        this.autoUpdateTime = 30000;
        this.handlingInProgress = false;
        this.commentReply = false;
        this.showEdit = true;
        this.previousMemoText = "";
        this.userName = "";
        this.parentCommentId = "";
        this.errorMessage = "";
        this.repliedMessageHistory = new Object();
        this.timeoutIds = [];
        this.fetchDetailResponse = this.fetchDetailResponse.bind(this);
        this.messageHandlingResponse = this.messageHandlingResponse.bind(this);
        this.fetchAutoUpdateDetailResponse = this.fetchAutoUpdateDetailResponse.bind(this);
        this.replyMessageResponse = this.replyMessageResponse.bind(this);
        this.updateMemoResponse = this.updateMemoResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_DETAIL_VIEW).subscribe(() => this.ngOnInit());
    }
    ngOnInit() {
        try {
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager, this.socialMediaService);
            this.contextMenuService.loadActionButton(detailEntityType);
            this.menu.addOrUpdateMenuItem(0, "FacebookDetail", this.translateService.instant("LBL_FACEBOOK"), false, true, true);
            this.menu.addOrUpdateMenuItem(10000, "MESSAGES", this.translateService.instant("LBL_MESSAGES"), false);
            this.addMenuItem.emit(this.menu);
            this.contactHistoryService.getRecentActivities(this.sessionManager.selectedEntity.User.MobileNumber);
            this.taskService.getRecentActivities(this.sessionManager.selectedEntity.User.MobileNumber);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.socialMediaService.fetchDetail(partialDto, SocialMediaType.Facebook, this.fetchDetailResponse);
                let autoUpdateTimeSetting = parseInt(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook, "AUTOUPDATETIMEDURATION"));
                if (!GlobalFunctions.isEmpty(autoUpdateTimeSetting))
                    this.autoUpdateTime = autoUpdateTimeSetting;
                this.timerPromise = interval(this.autoUpdateTime).subscribe(x => {
                    partialDto.AutoUpdate = true;
                    if (partialDto.messageHandling == undefined && this.sessionManager.selectedEntity.MessageHandling != undefined)
                        partialDto.messageHandling = this.sessionManager.selectedEntity.MessageHandling;
                    this.socialMediaService.fetchDetail(partialDto, SocialMediaType.Facebook, this.fetchAutoUpdateDetailResponse);
                });
                this.startSpinner();
            }
            this.sendRelatedRequest.emit();
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ngOnDestroy() {
        if (this.timerPromise != null)
            this.timerPromise.unsubscribe();
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    fetchDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null && result.MessageHistoryList != null && result.MessageHistoryList.length > 0) {
            for (let index = 0; index < result.MessageHistoryList.length; index++) {
                if (result.MessageHistoryList[index].ReplyBy == "Handler")
                    result.MessageHistoryList[index].User = this.getUserDetail(result.MessageHistoryList[index].User);
            }
            this.sessionManager.selectedEntity = result;
            $(".replyMessageTextarea").focus();
            this.orderMessage();
            this.timeoutIds.push(setTimeout(() => this.scrollToHistoryList(), 500));
            this.contextMenuService.loadActionButton(GlobalFunctions.getObjectTypeName(result.RelatedEntityFqdn));
            this.sendRelatedRequest.emit();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_HANDLED'), textMsg: this.translateService.instant('LBL_HANDLED_SOCIAL_MEDIA') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
    }
    replyIndividual(messageHistory) {
        this.userName = messageHistory.User.Name;
        this.commentReply = true;
        this.parentCommentId = this.parse(messageHistory.Id);
    }
    parse(id) {
        let formattedIdParts = id.split("|");
        if (formattedIdParts.length == 2)
            id = formattedIdParts[1];
        return id;
    }
    removeReply() {
        this.commentReply = false;
    }
    fetchAutoUpdateDetailResponse(result) {
        this.stopSpinner();
        if (result != null) {
            if (result.AutoUpdate == true) {
                if (result.MessageHistoryList != null && this.sessionManager.selectedEntity?.MessageHistoryList != null && result.MessageHistoryList.length > this.sessionManager.selectedEntity?.MessageHistoryList?.length) {
                    this.isNewMessagesAvailable = true;
                    let message = this.translateService.instant("LBL_MSG_VIEW_NEW_MESSAGE");
                    message = GlobalFunctions.formatStringValue(message, [result.MessageHistoryList.length - this.sessionManager.selectedEntity.MessageHistoryList.length]);
                    this.newMessageCountAlert = this.translateService.instant(message);
                }
            }
            else {
                if (result.MessageHistoryList != null && this.sessionManager.selectedEntity.MessageHistoryList != null && result.MessageHistoryList.length > this.sessionManager.selectedEntity.MessageHistoryList.length) {
                    this.isNewMessagesAvailable = false;
                    for (let idx = 0; idx < result.MessageHistoryList.length; idx++) {
                        if (result.MessageHistoryList[idx].ReplyBy == "Handler")
                            result.MessageHistoryList[idx].User = this.getUserDetail(result.MessageHistoryList[idx].User);
                    }
                    this.sessionManager.selectedEntity.MessageHistoryList = result.MessageHistoryList;
                    this.timeoutIds.push(setTimeout(() => this.scrollToHistoryList(), 500));
                }
            }
            this.orderMessage();
        }
    }
    messageHandlingResponse(result) {
        if (result.CurrentStatus == SocialMediaStatus.Unhandled) {
            this.sessionManager.selectedEntity.MessageHandling = result;
            this.scrollToHistoryList();
            this.timeoutIds.push(setTimeout(() => {
                $(".replyMessageTextarea").focus();
                this.handlingInProgress = false;
            }));
            this.phoneManager.setPhoneStatusAction("2");
        }
        else {
            let socialMediaDto = new SocialMediaDto();
            socialMediaDto.Id = result.Id;
            socialMediaDto.ObjectSource = result.ObjectSource;
            socialMediaDto.Type = result.Type;
            socialMediaDto.StringRepresentation = this.translateService.instant("LBL_SOCIALMEDIA") + " - " + this.translateService.instant("LBL_FACEBOOK");
            socialMediaDto.SocialMediaObject = this.sessionManager.selectedEntity;
            this.sessionManager.addItemsToDetailViewCacheList(socialMediaDto, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]), true);
            this.socialMediaService.updateContactSessionNotesWithSocialMediaDetails(this.sessionManager);
            this.sessionManager.addRelatedPersonOrOrganizationIntoSession(this.cacheManager);
            this.timeoutIds.push(setTimeout(() => {
                this.sessionManager.selectedEntity.MessageHandling.CurrentStatus = SocialMediaStatus.Handled;
                this.handlingInProgress = false;
            }));
            if (this.sessionManager.isAssignmentTaskAutoIgnoreSessionValid(this.cacheManager, "socialmedia")) {
                this.taskService.handleAssignmentTask(this.cacheManager);
                this.sessionManager.autoIgnoreSession(this.dialog, this.dialogManager, this.cacheManager, this.phoneManager);
            }
            else
                this.dialogManager.openEndSessionDialog();
        }
    }
    startMessageHandling() {
        if (!this.handlingInProgress) {
            this.handlingInProgress = true;
            let messageHandlingDto = this.socialMediaService.getMessageHandlingDto(this.sessionManager.selectedEntity);
            if (messageHandlingDto != null) {
                this.sessionManager.startSessionIfPossible("SOCIALMEDIA", ScreenMode.Edit);
                this.socialMediaService.startHandlingMessage(messageHandlingDto, this.messageHandlingResponse);
            }
        }
    }
    stopMessageHandling() {
        if (!this.handlingInProgress) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_FACEBOOK"), this.translateService.instant("LBL_STOP_HANDLING_CONFIRMATION"), true, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                if (result == 1) {
                    this.handlingInProgress = true;
                    this.sessionManager.selectedEntity.MessageHistoryList.forEach((message) => {
                        if (!jlinq.from(this.sessionManager.selectedEntity.MessageHandling.SocialMediaContactHistoryList).equals("MessageId", message.Id).any()) {
                            let socialMediaMessage = new SocialMediaContactHistoryDto;
                            socialMediaMessage.SocialMediaContactId = this.sessionManager.selectedEntity.MessageHandling.Id;
                            socialMediaMessage.Message = message.Message;
                            socialMediaMessage.MediaType = message.MediaType;
                            socialMediaMessage.MediaList = message.MediaList;
                            socialMediaMessage.MessageId = message.Id;
                            socialMediaMessage.ReplyBy = message.ReplyBy;
                            socialMediaMessage.MessageDateTime = message.DateTime;
                            socialMediaMessage.UserId = message.User.Id;
                            socialMediaMessage.UserName = message.User.Name;
                            this.sessionManager.selectedEntity.MessageHandling.SocialMediaContactHistoryList.push(socialMediaMessage);
                        }
                    });
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Facebook";
                    let messageHandlingDto = this.sessionManager.selectedEntity.MessageHandling;
                    if (messageHandlingDto != null)
                        this.socialMediaService.stopHandlingMessage(messageHandlingDto, this.messageHandlingResponse, null);
                }
            });
        }
    }
    replyMessageResponse(replyMessage, result) {
        this.stopSpinner();
        if (result == 0 && replyMessage != null) {
            replyMessage.User = this.getUserDetail(replyMessage.User);
            this.sessionManager.selectedEntity.MessageHistoryList.push(replyMessage);
            this.isTextAreaEmpty = true;
            this.scrollToHistoryList();
        }
        ;
    }
    getUserDetail(user) {
        if (user != null) {
            let employee = this.cacheManager.getEmployeeById(user.Id);
            if (employee != null) {
                let employeeList = [];
                employeeList.push(employee);
                user.Name = employee.StringRepresentation;
                user.Picture = employee.PictureData;
            }
        }
        return user;
    }
    replyMessage(message) {
        this.isTextAreaEmpty = false;
        if (message != "") {
            let replyMessage = new SocialMediaReplyMessageDto();
            replyMessage.Message = message;
            replyMessage.DateTime = new Date();
            replyMessage.IsPrivate = this.sessionManager.selectedEntity.Message.IsPrivate;
            replyMessage.ParentMessageId = this.sessionManager.selectedEntity.Id;
            replyMessage.HandlingId = this.sessionManager.selectedEntity.MessageHandling.Id;
            replyMessage.IsMessageCommentReply = this.commentReply;
            replyMessage.SocialUserId = this.sessionManager.selectedEntity.User.Id;
            if (replyMessage.IsMessageCommentReply)
                replyMessage.ParentCommentId = this.parentCommentId;
            let receiveMessageList = this.socialMediaService.getReceiveMessageList(this.sessionManager.selectedEntity);
            this.socialMediaService.replyMessage(replyMessage, receiveMessageList, SocialMediaType.Facebook, this.replyMessageResponse);
            this.commentReply = false;
            this.startSpinner();
        }
    }
    orderMessage() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.MessageHistoryList))
            this.sessionManager.selectedEntity.MessageHistoryList = jlinq.from(this.sessionManager.selectedEntity.MessageHistoryList ?? []).sort("DateTime").select();
    }
    scrollToHistoryList() {
        if (!GlobalFunctions.isEmpty($('#socialMediaHistoryList')))
            $('#socialMediaHistoryList').scrollTop($('#socialMediaHistoryList')[0].scrollHeight);
    }
    fetchDetails() {
        this.isNewMessagesAvailable = false;
        let partialDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
        partialDto.AutoUpdate = false;
        this.socialMediaService.fetchDetail(partialDto, SocialMediaType.Facebook, this.fetchAutoUpdateDetailResponse);
    }
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight * (1 / 2) + "px";
        $("#socialMediaHistoryList").css('max-height', newHeight);
    }
    cancelMemo() {
        this.sessionManager.selectedEntity.MessageHandling.Memo = this.previousMemoText;
        $("#internalMemoTextName").attr('disabled', 'true');
        this.showEdit = true;
    }
    editMemo() {
        this.errorMessage = null;
        this.previousMemoText = this.sessionManager.selectedEntity.MessageHandling.Memo;
        this.timeoutIds.push(setTimeout(() => { $("#internalMemoId").focus(); }, 1));
        this.showEdit = false;
    }
    saveMemo() {
        this.errorMessage = null;
        this.socialMediaService.updateSocialMediaMemo(this.sessionManager.selectedEntity.MessageHandling.Memo, this.sessionManager.selectedEntity.MessageHandling.Id, this.updateMemoResponse);
    }
    updateMemoResponse(response) {
        if (!GlobalFunctions.isEmpty(response) && response.Result === 1) {
            this.errorMessage = this.translateService.instant("LBL_MESSAGE_FAILED_MEMO");
            this.sessionManager.selectedEntity.MessageHandling.Memo = this.previousMemoText;
        }
        $("#internalMemoTextName").attr('disabled', 'true');
        this.timeoutIds.push(setTimeout(() => { this.showEdit = true; }, 1));
        $('#internalMemoId').scrollTop($('#internalMemoId')[0].scrollHeight - 100);
    }
    openLinkView(type) {
        this.dialogManager.openLinkContactInfo(type);
    }
};
__decorate([
    ViewChild('form')
], BaseFacebookDetailComponent.prototype, "form", void 0);
BaseFacebookDetailComponent = __decorate([
    Injectable()
], BaseFacebookDetailComponent);
export { BaseFacebookDetailComponent };
//# sourceMappingURL=base-facebook-detail.component.js.map