var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { SocialMediaType } from 'src/app/core/enums/common-enums';
import { BulkReplyMessageRequest } from 'src/app/core/models/social-media/bulk-reply-message-request';
import { SocialMediaBulkReplyMessageDto } from 'src/app/core/models/social-media/social-media-bulk-reply-messageDto';
import { SocialMediaContactDto } from 'src/app/core/models/social-media/social-media-contactDto';
import { SocialMediaReplyMessageDto } from 'src/app/core/models/social-media/social-media-reply-messageDto';
import { EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { SubSink } from 'subsink';
let BulkReplyComponent = class BulkReplyComponent extends BaseDialogComponent {
    constructor(resultList, translateService, shortcutManager, dialog, dialogRef, router, socialMediaService, sessionManager) {
        super();
        this.resultList = resultList;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.dialog = dialog;
        this.dialogRef = dialogRef;
        this.router = router;
        this.socialMediaService = socialMediaService;
        this.sessionManager = sessionManager;
        this.DateJS = Date;
        this.message = '';
        this.subs = new SubSink();
        this.bulkReplyHandleSocialMediaResponse = this.bulkReplyHandleSocialMediaResponse.bind(this);
    }
    ngOnInit() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.bulkReply());
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    bulkReply() {
        if (this.form.invalid)
            return;
        this.sendBulkReplyRequest();
    }
    sendBulkReplyRequest() {
        if (!GlobalFunctions.isEmpty(this.resultList.selectedSocialEntities)) {
            let message = this.translateService.instant("LBL_MSG_BULK_REPLY");
            let header = this.translateService.instant("LBL_BULK_REPLY");
            let dialogBox = null;
            if (this.resultList.selectedSocialEntities.length == 0) {
                let messageInfo = DialogHelper.getMessage(header, this.translateService.instant("LBL_MSG_BULK_REPLY_NO_MESSAGE"), false, null, null, null, null, this.translateService);
                dialogBox = DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
            }
            else {
                message = GlobalFunctions.formatStringValue(message, [this.resultList.selectedSocialEntities.length]);
                message = this.translateService.instant(message);
                let messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (result) {
                        let req = [];
                        for (let index = 0; index < this.resultList.selectedSocialEntities.length; index++) {
                            let obj = new SocialMediaBulkReplyMessageDto();
                            let replyMessage = new SocialMediaReplyMessageDto();
                            replyMessage.Message = this.message;
                            replyMessage.IsPrivate = this.resultList.selectedSocialEntities[index].Message.IsPrivate;
                            replyMessage.Id = this.resultList.selectedSocialEntities[index].Id;
                            replyMessage.DateTime = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                            replyMessage.Type = this.resultList.selectedSocialEntities[index].Type;
                            replyMessage.SocialUserId = this.resultList.selectedSocialEntities[index].User.Id;
                            // For facebook bulk reply we were not using parentMessageId so we have excluded it so that it will not break facebook implementation.
                            if (replyMessage.Type.toString() != SocialMediaType[SocialMediaType.Facebook]) {
                                replyMessage.ParentMessageId = replyMessage.Id;
                                if (replyMessage.Type.toString() == SocialMediaType[SocialMediaType.Twitter])
                                    replyMessage.Message = '@' + this.resultList.selectedSocialEntities[index].User.ScreenName + ' ' + replyMessage.Message;
                            }
                            if (!GlobalFunctions.isEmpty(this.resultList.selectedSocialEntities[index].MessageHandling) && !GlobalFunctions.isEmpty(this.resultList.selectedSocialEntities[index].MessageHandling.Id))
                                replyMessage.HandlingId = this.resultList.selectedSocialEntities[index].MessageHandling.Id;
                            obj.ReplyMessage = replyMessage;
                            let handlingMessage = new SocialMediaContactDto();
                            handlingMessage = this.socialMediaService.getMessageHandlingDto(this.resultList.selectedSocialEntities[index]);
                            obj.HandlingMessage = handlingMessage;
                            req.push(obj);
                        }
                        let reqObj = new BulkReplyMessageRequest();
                        reqObj.SocialMediaBulkReplyMessageDto = req;
                        this.startSpinner();
                        this.socialMediaService.bulkReplyHandleSocialMedia(reqObj, this.bulkReplyHandleSocialMediaResponse, this.replyMessageErrorCallback);
                    }
                    else
                        this.close();
                });
            }
        }
    }
    bulkReplyHandleSocialMediaResponse(result) {
        this.stopSpinner();
        let message = this.translateService.instant("LBL_MSG_BULK_REPLY");
        let header = this.translateService.instant("LBL_BULK_REPLY");
        let dialogBox = null;
        switch (result.Result) {
            case 0:
                this.close();
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
                break;
            case 1:
                message = this.translateService.instant("LBL_MSG_BULK_DELETE_FAIL");
                let messageInfo = DialogHelper.getMessage(header, message, false, null, null, null, null, this.translateService);
                dialogBox = DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
                dialogBox.afterClosed.then(() => {
                    this.close();
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.SOCIAL_MEDIA]);
                });
                break;
        }
    }
    replyMessageErrorCallback() {
    }
    close() {
        this.dialogRef.close(true);
    }
};
__decorate([
    ViewChild('form')
], BulkReplyComponent.prototype, "form", void 0);
BulkReplyComponent = __decorate([
    Component({
        selector: 'bulk-reply',
        templateUrl: './bulk-reply.component.html',
        styleUrls: ['./bulk-reply.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], BulkReplyComponent);
export { BulkReplyComponent };
//# sourceMappingURL=bulk-reply.component.js.map