var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { RecordOperationMode } from 'src/app/core/enums/common-enums';
import { CallStatus } from 'src/app/core/enums/phone-enum';
import { CreateOrganizationRequest } from 'src/app/core/models/organization/create-organization-request';
import { CreateOrUpdatePersonRequest } from 'src/app/core/models/person/create-update-person-request';
import { PhoneCallerInfoDto } from 'src/app/core/models/phone/phone-caller-infoDto';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { SubSink } from 'subsink';
let PhoneStatusComponent = class PhoneStatusComponent extends BaseDialogComponent {
    constructor(phoneManager, phoneService, eventProvider, personService, sessionManager, shortcutManager, translateService, organizationService, applicationSettingManager, dialogManager) {
        super();
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogManager = dialogManager;
        this.existingSavedPhoneNumber = "";
        this.enableCallNumberExecuted = false;
        this.subs = new SubSink();
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL).subscribe(entity => {
            if (!GlobalFunctions.isEmpty(entity)) {
                this.enableCallNumberExecuted = true;
                this.enableCallNumberCheckbox(entity);
            }
        });
    }
    ngOnInit() {
        if (!this.enableCallNumberExecuted) {
            if (this.sessionManager.selectedEntity != null)
                this.enableCallNumberCheckbox(this.sessionManager.selectedEntity);
        }
        this.enableCallNumberExecuted = false;
        this.shortcutManager.bind('LBL_SHORTCUT_PHONE_HANG_UP_CALL', () => this.endCall());
        this.shortcutManager.bind('LBL_SHORTCUT_PHONE_TRANSFER_CALL', () => {
            if (this.phoneManager.phoneState.WarmTransferCallConnected)
                this.transferCall();
        });
        this.shortcutManager.bind('LBL_SHORTCUT_PHONE_CANCEL_CALL', () => {
            if (this.phoneManager.phoneState.WarmTransferCallConnected)
                this.endCall();
        });
        this.shortcutManager.bind('LBL_SHORTCUT_PHONE_HOLD_UNHOLD_CALL', () => {
            if (!this.phoneManager.phoneState.WarmTransferCallConnected)
                this.holdUnhold();
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    transferCall(transferSession = false) {
        this.phoneManager.transferCall(this.phoneManager.phoneState.CurrentCaller.PhoneNumber, this.phoneManager.phoneState.CurrentCaller.Name, this.phoneManager.phoneState.CurrentCaller.Picture, false, null, transferSession);
    }
    endCall() {
        if (this.phoneManager.phoneState.CurrentState == CallStatus.Hold)
            this.dialogManager.openPhoneHoldWarningMessage();
        else
            this.phoneManager.hangupCall();
    }
    dialpadClick() {
        this.phoneManager.phoneState.IsCallFailed = false;
        let top = $("#dialpadButton").offset().top - 337;
        let left = ($(window).outerWidth() + 41) - $("#dialpadButton").offset().left - 300;
        if ($(window).outerWidth() >= 1500)
            left = $('#phoneMenu').offset().left - $("#dialpadButton").offset().left + $("#mainPhoneContainer").width() - 150;
        if (top < 0)
            top = top + 293;
        this.phoneManager.setScreenPosition(-left, top);
        $("#mainPhoneContainer").toggle();
        if ($("#dialExtensionTextField") != null)
            $("#dialExtensionTextField").focus();
        this.timeoutIds.push(setTimeout(() => $("#phonePanel").css("z-index", "960"), 1));
    }
    holdCall() {
        this.phoneService.holdCallRequest(this.phoneManager.phoneState.CurrentCallDto);
        this.phoneManager.phoneState.CurrentState = CallStatus.Hold;
    }
    unholdCall() {
        this.phoneService.unholdCallRequest(this.phoneManager.phoneState.CurrentCallDto);
        this.phoneManager.phoneState.CurrentState = CallStatus.Active;
    }
    holdUnhold() {
        if (this.phoneManager.phoneState.CurrentState == CallStatus.Hold)
            this.unholdCall();
        else
            this.holdCall();
    }
    enableCallNumberCheckbox(newVal) {
        if (!GlobalFunctions.isEmpty(newVal)) {
            if (!GlobalFunctions.isEmpty(newVal.ObjectSource) && (newVal.ObjectSource.toLowerCase().indexOf("person") > -1) || (this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("organization") > -1)) {
                this.phoneManager.phoneState.EnableCallNumberCheckbox = true;
                this.lastLoadedPersonOrOrganizationEntity = newVal;
            }
        }
    }
    changeCallerId(event) {
        let callerInfoDto = new PhoneCallerInfoDto();
        callerInfoDto.PhoneNumber = this.phoneManager.phoneState.CurrentCaller.PhoneNumber;
        callerInfoDto.ObjectId = this.lastLoadedPersonOrOrganizationEntity.Id;
        callerInfoDto.ObjectType = GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.lastLoadedPersonOrOrganizationEntity.RelatedEntityFqdn));
        callerInfoDto.ObjectSource = this.lastLoadedPersonOrOrganizationEntity.ObjectSource;
        this.phoneManager.phoneState.SaveCallNumber = event.target.checked;
        if (this.phoneManager.phoneState.SaveCallNumber) {
            this.phoneManager.phoneState.CurrentCaller.Name = callerInfoDto.ObjectType.indexOf("Person") != -1 ? GlobalFunctions.getCallerName(this.lastLoadedPersonOrOrganizationEntity, this.applicationSettingManager?.getObjectGrammerSetting("Person_CallerID")) : this.lastLoadedPersonOrOrganizationEntity.StringRepresentation;
            this.phoneService.updateCallerIdRequest(callerInfoDto);
            if (callerInfoDto.ObjectType.indexOf("Person") != -1) {
                if (GlobalFunctions.isMobileNumber(callerInfoDto.PhoneNumber)) {
                    this.existingSavedPhoneNumber = !GlobalFunctions.isEmpty(this.lastLoadedPersonOrOrganizationEntity.MobileNumber) ? this.lastLoadedPersonOrOrganizationEntity.MobileNumber : "";
                    this.lastLoadedPersonOrOrganizationEntity.MobileNumber = callerInfoDto.PhoneNumber;
                }
                else {
                    this.existingSavedPhoneNumber = !GlobalFunctions.isEmpty(this.lastLoadedPersonOrOrganizationEntity.PhoneNumber) ? this.lastLoadedPersonOrOrganizationEntity.PhoneNumber : "";
                    this.lastLoadedPersonOrOrganizationEntity.PhoneNumber = callerInfoDto.PhoneNumber;
                }
                this.createPersonRequest(this.lastLoadedPersonOrOrganizationEntity);
            }
            else if (callerInfoDto.ObjectType.indexOf("Organization") != -1) {
                this.existingSavedPhoneNumber = !GlobalFunctions.isEmpty(this.lastLoadedPersonOrOrganizationEntity.PhoneNumber) ? this.lastLoadedPersonOrOrganizationEntity.PhoneNumber : "";
                this.lastLoadedPersonOrOrganizationEntity.PhoneNumber = callerInfoDto.PhoneNumber;
                this.createOrganizationRequest(this.lastLoadedPersonOrOrganizationEntity);
            }
            this.phoneManager.phoneState.UpdateCallNumberText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER");
        }
        else {
            this.phoneManager.phoneState.CurrentCaller.Name = this.translateService.instant("LBL_NO_PERSON_FOUND");
            this.phoneService.deleteCallerIdRequest(callerInfoDto);
            if (callerInfoDto.ObjectType.indexOf("Person") != -1) {
                if (GlobalFunctions.isMobileNumber(callerInfoDto.PhoneNumber))
                    this.lastLoadedPersonOrOrganizationEntity.MobileNumber = this.existingSavedPhoneNumber;
                else
                    this.lastLoadedPersonOrOrganizationEntity.PhoneNumber = this.existingSavedPhoneNumber;
                this.createPersonRequest(this.lastLoadedPersonOrOrganizationEntity);
            }
            else if (callerInfoDto.ObjectType.indexOf("Organization") != -1) {
                this.lastLoadedPersonOrOrganizationEntity.PhoneNumber = this.existingSavedPhoneNumber;
                this.createOrganizationRequest(this.lastLoadedPersonOrOrganizationEntity);
            }
            this.phoneManager.phoneState.UpdateCallNumberText = this.translateService.instant("LBL_ADD_PHONE_NUMBER");
        }
    }
    createPersonRequest(lastLoadedPersonOrOrganizationEntity) {
        let personRequest = new CreateOrUpdatePersonRequest();
        personRequest.Mode = RecordOperationMode.Edit;
        personRequest.PersonDto = this.lastLoadedPersonOrOrganizationEntity;
        this.personService.createPersonEntity(personRequest, null, null);
    }
    createOrganizationRequest(lastLoadedPersonOrOrganizationEntity) {
        let organizationRequest = new CreateOrganizationRequest();
        organizationRequest.Mode = RecordOperationMode.Edit;
        organizationRequest.OrganizationDto = this.lastLoadedPersonOrOrganizationEntity;
        this.organizationService.createOrganizationEntity(organizationRequest, null, null);
    }
    resize() {
        this.phoneManager.resizePhoneStatusPanel();
    }
};
PhoneStatusComponent = __decorate([
    Component({
        selector: 'phone-status',
        templateUrl: './phone-status.component.html',
        styleUrls: ['./phone-status.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], PhoneStatusComponent);
export { PhoneStatusComponent };
//# sourceMappingURL=phone-status.component.js.map