var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { CallStatus } from 'src/app/core/enums/phone-enum';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let IncomingSessionComponent = class IncomingSessionComponent extends BaseDialogComponent {
    constructor(cacheManager, phoneManager, phoneService, dialogManager, sessionManager, translateService, viewContainerRef) {
        super();
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.viewContainerRef = viewContainerRef;
        this.incomingSesionText = "";
    }
    ngOnInit() {
        try {
            let employeeInfo = this.translateService.instant("LBL_ANONYMOUS");
            if (this.phoneManager.phoneState.TransferSessionManagerDto != null) {
                let empObj = this.cacheManager.getEmployeeById(this.phoneManager.phoneState.TransferSessionManagerDto.SourceEmployeeId);
                if (!GlobalFunctions.isEmpty(empObj))
                    employeeInfo = empObj.StringRepresentation;
            }
            let message = this.translateService.instant("LBL_LOAD_INCOMING_SESSION");
            message = GlobalFunctions.formatStringValue(message, [employeeInfo.toUpperCase()]);
            this.incomingSesionText = this.translateService.instant(message);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    closeActiveModal() {
        DialogHelper.closeDialog();
    }
    acceptSession() {
        this.unholdCall();
        this.executeAcceptSession();
    }
    ;
    acceptSessionAndHold() {
        this.executeAcceptSession();
        this.holdCall();
        $("#sessionIncomingContainer").empty();
    }
    executeAcceptSession() {
        if (this.phoneManager.phoneState.TransferSessionManagerDto != null) {
            let sessionItem = new Object();
            sessionItem.ObjectSourceDto = this.phoneManager.phoneState.TransferSessionManagerDto.Session;
            this.sessionManager.loadSession(sessionItem, this.dialogManager, this.viewContainerRef, false);
        }
        $("#sessionIncomingContainer").empty();
    }
    holdCall() {
        this.phoneManager.phoneState.CurrentState = CallStatus.Hold;
    }
    unholdCall() {
        try {
            this.phoneService.unholdCallRequest(this.phoneManager.phoneState.CurrentCallDto);
            this.phoneManager.phoneState.CurrentState = CallStatus.Unhold;
            $("#phonePanel").css("width", "auto");
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resize() {
        this.phoneManager.resizeIncomingSessionPanel();
    }
};
IncomingSessionComponent = __decorate([
    Component({
        selector: 'incoming-session',
        templateUrl: './incoming-session.component.html',
        styleUrls: ['./incoming-session.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], IncomingSessionComponent);
export { IncomingSessionComponent };
//# sourceMappingURL=incoming-session.component.js.map