var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { ScreenMode } from 'src/app/core/enums/common-enums';
import { CallStatus, PhoneStatus } from 'src/app/core/enums/phone-enum';
import { RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let IncomingCallComponent = class IncomingCallComponent extends BaseDialogComponent {
    constructor(translateService, phoneManager, sessionManager, shortcutManager, dialogManager, sessionService, applicationFeatureManager, phoneService, applicationSettingManager, dialog, router, viewContainerRef) {
        super();
        this.translateService = translateService;
        this.phoneManager = phoneManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.dialogManager = dialogManager;
        this.sessionService = sessionService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.phoneService = phoneService;
        this.applicationSettingManager = applicationSettingManager;
        this.dialog = dialog;
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        this.createSessionErrorCallback = this.createSessionErrorCallback.bind(this);
    }
    ngOnInit() {
        try {
            this.shortcutManager.bind("LBL_SHORTCUT_PHONE_PICK_UP_CALL", () => this.pickupCallThroughShortcut());
            this.timeoutIds.push(setTimeout(() => {
                document.querySelector(".phone-container").style.visibility = "visible";
                if (!this.sessionManager.isSessionStart)
                    $("#pickupCallButton").focus();
                else
                    $("#keepSessionButton").focus();
            }, 1));
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    createSessionErrorCallback(status) {
        if (status == 0)
            this.pickupCall();
        else {
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_SESSION")]);
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_SESSION"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    closeActiveModal() {
        this.dialog.closeAll();
    }
    keepSession() {
        this.sessionService.keepSession(this.sessionManager, this.applicationFeatureManager, this.translateService, () => { }, this.createSessionErrorCallback);
        this.pickupCall();
    }
    ignoreSession() {
        this.closeActiveModal();
        this.pickupCall();
    }
    refuseCall() {
        this.phoneManager.phoneState.CurrentState = CallStatus.Inactive;
        $('#phoneMenu').removeClass('open');
        $("#mainPhoneContainer").hide();
        this.phoneManager.phoneState.CurrentCallDto.HandlerId = GlobalFunctions.getLoggedInUserId();
        this.phoneService.refuseCallRequest(this.phoneManager.phoneState.CurrentCallDto);
    }
    pickupCall() {
        this.phoneManager.phoneState.CurrentCallDto.HandlerId = GlobalFunctions.getLoggedInUserId();
        this.phoneService.pickupCallRequest(this.phoneManager.phoneState.CurrentCallDto);
        if (this.sessionManager.isSessionStart)
            this.sessionManager.endSession();
        const isActivityLoaded = this.router.url.toLowerCase().includes(RoutePath.ACTIVITY_PATH);
        if (!isActivityLoaded || !this.sessionManager.isActivityFound) {
            this.timeoutIds.push(setTimeout(() => {
                if (this.phoneManager.phoneState.CurrentCaller.Item != null) {
                    this.phoneManager.loadResolvedItem(this.phoneManager.phoneState?.CurrentCaller);
                    this.phoneManager.isCallerLoaded = true;
                    this.phoneManager.checkLoadedEntity();
                }
                else if (!this.sessionManager.isActive('/Dashboard'))
                    this.router.navigate([RoutePath.DASHBOARD]);
                DialogHelper.closeDialog();
            }, 500));
        }
        //code to reload the breadcrumbitems associated with activities loaded
        if (isActivityLoaded && (this.sessionManager.isCallerRecentActivityFeatureEnabled && this.applicationSettingManager.isCallerRecentActivityEnabled()) && this.sessionManager.BreadcrumbItems.length == 0)
            this.sessionManager.addBreadcrumbItems(this.sessionManager.ActivityItemsRelatedBreadCrumbs, null, RoutePath.ACTIVITY_PATH, "Activities");
        this.phoneManager.phoneState.CurrentState = CallStatus.Active;
        this.phoneManager.phoneState.SelectedPhoneStatus = this.phoneManager.phoneState.GetPhoneStatus(PhoneStatus.NotAvailable, null);
        this.phoneManager.changeAvailabilityStatus();
        $('#phoneMenu').removeClass('open');
        $("#mainPhoneContainer").hide();
        if (!this.phoneManager.isValidExtensionNumber(this.phoneManager.phoneState.CurrentCallDto)) {
            this.sessionManager.startSessionIfPossible("notype", ScreenMode.None);
            this.sessionManager.currentCallerId = this.phoneManager.phoneState?.CurrentCallDto?.CallerId?.Id;
            this.sessionManager.currentCallId = this.phoneManager.phoneState?.CurrentCallDto?.CallId;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager?.currentCallerId;
        }
        if (this.phoneManager.phoneState.CurrentCaller.Name !== this.translateService.instant("LBL_NO_PERSON_FOUND") && this.phoneManager.phoneState.CurrentCaller?.Name !== (this.translateService.instant("LBL_PERSON_FOUND") + "...")) {
            this.sessionManager.contactPersonFromRecentActivity = this.phoneManager.phoneState.CurrentCaller?.Name;
            if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = this.phoneManager.phoneState.CurrentCaller?.Name;
        }
        if (!GlobalFunctions.isEmpty(this.phoneManager.phoneState.TransferSessionManagerDto) && !GlobalFunctions.isEmpty(this.phoneManager.phoneState.TransferSessionManagerDto.Session)) {
            let sessionItem = new Object();
            sessionItem.ObjectSourceDto = this.phoneManager.phoneState.TransferSessionManagerDto.Session;
            this.sessionManager.loadSession(sessionItem, this.dialogManager, this.viewContainerRef, false);
        }
        this.phoneManager.resizePhoneStatusPanel();
    }
    pickupCallThroughShortcut() {
        if (this.phoneManager.phoneState.CurrentState == CallStatus.Ringing)
            this.pickupCall();
    }
    resize() {
        this.phoneManager.resizeIncomingCallPanel();
    }
};
IncomingCallComponent = __decorate([
    Component({
        selector: 'incoming-call',
        templateUrl: './incoming-call.component.html',
        styleUrls: ['./incoming-call.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], IncomingCallComponent);
export { IncomingCallComponent };
//# sourceMappingURL=incoming-call.component.js.map