var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { OperationType, RecordOperationMode, RecordSelection, ScreenMode } from '../../../../core/enums/common-enums';
import { CountryDto } from '../../../../core/models/common/countryDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { AddressDto } from '../../../../core/models/person/addressDto';
import { AdministeredPersonDto } from '../../../../core/models/person/administered-personDto';
import { CreateOrUpdatePersonRequest } from '../../../../core/models/person/create-update-person-request';
import { PersonAddressNameDto } from '../../../../core/models/person/person-address-nameDto';
import { PersonAddressDto } from '../../../../core/models/person/person-addressDto';
import { PersonDetailsDto } from '../../../../core/models/person/person-detailDto';
import { PersonNameDto } from '../../../../core/models/person/person-nameDto';
import { PersonsNationalityDto } from '../../../../core/models/person/person-nationalityDto';
import { PersonDto } from '../../../../core/models/person/personDto';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let PersonAddEditComponent = class PersonAddEditComponent extends BaseDialogComponent {
    constructor(translateService, sessionManager, applicationSettingManager, shortcutManager, router, dialog, personService, datePipe, eventProvider, renderer, searchService, dialogManager, dateAdapter, cacheManager) {
        super();
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.shortcutManager = shortcutManager;
        this.router = router;
        this.dialog = dialog;
        this.personService = personService;
        this.datePipe = datePipe;
        this.eventProvider = eventProvider;
        this.renderer = renderer;
        this.searchService = searchService;
        this.dialogManager = dialogManager;
        this.dateAdapter = dateAdapter;
        this.cacheManager = cacheManager;
        this.dateJS = Date;
        this.title = this.translateService.instant('LBL_REGISTER_NEW_PERSON');
        this.isOpenFromDialog = false;
        this.editMode = false;
        this.personDto = new PersonDto();
        this.personSessionData = null;
        this.countries = CommonHelper.getCountries();
        this.subs = new SubSink();
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.genders = [
            { genderValue: "Male", genderText: this.translateService.instant("LBL_MALE") },
            { genderValue: "Female", genderText: this.translateService.instant("LBL_FEMALE") },
            { genderValue: "Unknown", genderText: this.translateService.instant("LBL_UNKNOWN") }
        ];
        this.searchingState = 0;
        this.searchingType = '';
        this.datePickerClosed = true;
        this.timeoutIds = [];
        this.isManualDateEntry = false;
        this.isEduarte = false;
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updateSearchStatus = this.updateSearchStatus.bind(this);
        this.sessionManager.startSessionIfPossible("PERSON", sessionManager.jkcParentPanel?.parameters?.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        if (sessionManager.jkcParentPanel?.parameters?.IsChildPanel) {
            this.editMode = sessionManager.jkcChildPanel?.parameters?.EditMode;
            this.personSessionData = sessionManager.jkcChildPanel?.parameters?.EditedData;
            sessionManager.jkcChildPanel.parameters.Scope = this;
        }
        else {
            this.editMode = sessionManager.jkcParentPanel?.parameters?.EditMode;
            this.personSessionData = sessionManager.jkcParentPanel?.parameters?.EditedData;
            sessionManager.jkcParentPanel.parameters.Scope = this;
        }
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        try {
            this.resize();
            this.PersonRequiredProperties = this.applicationSettingManager.entityRequiredPropertyList.PersonRequiredProperties;
            this.isOpenFromDialog = this.sessionManager.jkcParentPanel?.parameters?.IsChildPanel;
            this.newPersonDto = null;
            this.personDto = new PersonDto();
            if (this.editMode === true) {
                this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_PERSON").toUpperCase();
                if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
                    this.personDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                    if (!GlobalFunctions.isEmpty(this.personDto)) {
                        if (!GlobalFunctions.isEmpty(this.personDto.Details.DateOfBirth) && this.personDto.Details.DateOfBirth !== '0001-01-01T00:00:00')
                            this.date = this.personDto.Details.DateOfBirth;
                        if (this.personDto?.ResidentialAddress != null && this.personDto?.ResidentialAddress?.Address?.HouseNumber == 0)
                            this.personDto.ResidentialAddress.Address.HouseNumber = null;
                        this.personDto.Details.FormalName.Gender = this.genders[this.personDto.Details.FormalName.Gender].genderValue;
                        if (!this.personDto?.ResidentialAddress)
                            this.personDto.ResidentialAddress = new PersonAddressDto();
                        if (!this.personDto.ResidentialAddress.Address)
                            this.personDto.ResidentialAddress.Address = new AddressDto();
                        if (!this.personDto.ResidentialAddress.Address.Country)
                            this.personDto.ResidentialAddress.Address.Country = new CountryDto();
                        if (!this.personDto.AdministeredPersonDto)
                            this.personDto.AdministeredPersonDto = new AdministeredPersonDto();
                        if (!this.personDto.Nationality)
                            this.personDto.Nationality = new PersonsNationalityDto();
                        if (!this.personDto.AdministeredPersonDto.Nationality)
                            this.personDto.AdministeredPersonDto.Nationality = new PersonsNationalityDto();
                        if (this.sessionManager.selectedEntity.AdministeredPersonDto != null)
                            this.personDto.AdministeredPersonDto.ServiceNumber = this.sessionManager.selectedEntity.AdministeredPersonDto.ServiceNumber;
                        this.timeoutIds.push(setTimeout(() => GlobalFunctions.setDateFormat("dateOfBirthDatePicker", this.date, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe)));
                        if (!GlobalFunctions.isEmpty(this.personDto.ObjectSource) && this.personDto.ObjectSource.toLocaleLowerCase() === "decos.kcs.persons.eduarte")
                            this.isEduarte = true;
                    }
                }
            }
            else {
                this.title = this.translateService.instant("LBL_REGISTER_NEW_PERSON").toUpperCase();
                this.personAddress = new PersonAddressDto();
                let address = new AddressDto();
                address.Country = new CountryDto();
                this.personAddress.Address = address;
                this.personDto.Nationality = new PersonsNationalityDto();
                this.personDto.ResidentialAddress = this.personAddress;
                this.personDto.AdministeredPersonDto = new AdministeredPersonDto();
                this.personDto.AdministeredPersonDto.Nationality = new PersonsNationalityDto();
                this.personDto.Details = new PersonDetailsDto();
                this.personDto.Details.FormalName = new PersonNameDto();
                this.personDto.Details.AddressName = new PersonAddressNameDto();
                this.personDto.ResidentialAddress.Address.HouseNumber = null;
                if (this.personSessionData != null)
                    this.assignPersonSessionToDto(this.personSessionData);
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createPerson());
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
    }
    initDatePickerState() {
        this.isManualDateEntry = false;
        JkcDatePickerHelper.setMargin('294px', '-47px', 'fixed', this.renderer); // Renderere2 - class used to make custom UI changes
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        if (this.date && this.datePipe.transform(this.date, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
            GlobalFunctions.setDateFormat("dateOfBirthDatePicker", this.date, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
    resize() {
        this.isOpenFromDialog = this.sessionManager.jkcParentPanel?.parameters?.IsChildPanel;
        const windowHeight = $(window).height();
        if (this.isOpenFromDialog) {
            $("#jkcChildPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcChildPanel?.parameters.TopSpace) - 100 + "px") });
            const newHeight = $("#jkcChildPanel").height() - $("#addPersonHeader").height() - $("#addPersonFooter").height() + "px";
            $("#addPersonContainer").height(newHeight);
            $('#' + this.sessionManager.jkcChildPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcChildPanel").width()) });
            $('#' + this.sessionManager.jkcChildPanel?.parameters?.FooterId).css({ 'width': ($("#jkcChildPanel").width()) });
        }
        else {
            $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
            const newHeight = $("#jkcParentPanel").height() - $("#addPersonHeader").height() - $("#addPersonFooter").height() + "px";
            $("#addPersonContainer").height(newHeight);
            $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
            $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        }
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    createPerson() {
        this.errorMessage = "";
        if (this.form.invalid)
            return;
        var preventDomains = this.applicationSettingManager.getApplicationSettingValueByKey("PREVENTEMAILWITHDOMAINS");
        if (!GlobalFunctions.isEmailDomainAllowed(this.personDto.EmailAddress, preventDomains)) {
            this.errorMessage = this.translateService.instant("LBL_PREVENT_EMAIL_ADDRESS_MESSAGE");
            return;
        }
        if (this.editMode)
            this.personDto.Details.DateOfBirth = this.date;
        if (!GlobalFunctions.isEmpty(this.personDto.Details.DateOfBirth) && GlobalFunctions.validDate(new Date(this.personDto.Details.DateOfBirth)))
            this.personDto.Details.DateOfBirth = new this.dateJS(this.personDto.Details.DateOfBirth).toString('M/d/yyyy HH:mm:ss');
        else
            this.personDto.Details.DateOfBirth = null;
        if (this.personDto.ResidentialAddress != null && GlobalFunctions.isEmpty(this.personDto.ResidentialAddress?.Address?.HouseNumber))
            this.personDto.ResidentialAddress.Address.HouseNumber = 0;
        if (GlobalFunctions.isEmpty(this.personDto.Details.FormalName.Gender))
            this.personDto.Details.FormalName.Gender = "Unknown";
        let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
        if ((GlobalFunctions.isEmpty(this.personDto.PhoneNumber) || GlobalFunctions.isValidPhonenumber(this.personDto.PhoneNumber, countryCode)) && (GlobalFunctions.isEmpty(this.personDto.MobileNumber) || GlobalFunctions.isValidPhonenumber(this.personDto.MobileNumber, countryCode)))
            this.createPersonInternal(this.personDto);
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_PERSON"), textMsg: this.translateService.instant("LBL_PHONE_NUMBER_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result)
                    this.createPersonInternal(this.personDto);
            });
        }
    }
    ;
    addPersonResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0 && response.PersonDto != null) {
            this.newPersonDto = response.PersonDto;
            this.close();
            if (!this.isOpenFromDialog) {
                this.sessionManager.loadedFromRelatedView = false;
                this.sessionManager.selectedEntity = this.newPersonDto;
                if (!this.editMode)
                    this.sessionManager.addBreadcrumbItems([this.newPersonDto], null, this.router.url);
                else {
                    let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                    this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                    this.sessionManager.addBreadcrumbItems([this.newPersonDto], null, this.router.url);
                    this.cacheManager.updateDashboardCache(this.newPersonDto);
                }
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.PERSON]);
            }
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_PERSON'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_PERSON") });
    }
    ;
    addPersonErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this?.translateService?.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_PERSON")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_PERSON"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    createPersonInternal(personDto) {
        this.personDto.PhoneNumber = GlobalFunctions.isEmpty(this.personDto.PhoneNumber) ? "" : this.personDto.PhoneNumber;
        this.personDto.MobileNumber = GlobalFunctions.isEmpty(this.personDto.MobileNumber) ? "" : this.personDto.MobileNumber;
        this.personDto.Details.FormalName.FirstNames[0] = GlobalFunctions.isEmpty(this.personDto.Details.FormalName.FirstNames[0]) ? "" : this.personDto.Details.FormalName.FirstNames[0].trim();
        this.personDto.Details.FormalName.Surname = GlobalFunctions.isEmpty(this.personDto.Details.FormalName.Surname) ? "" : this.personDto.Details.FormalName.Surname.trim();
        const req = new CreateOrUpdatePersonRequest();
        req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
        req.PersonDto = personDto;
        this.startSpinner();
        this.personService.createPersonEntity(req, this.addPersonResponse, this.addPersonErrorCallback);
    }
    assignPersonSessionToDto(sessionData) {
        this.personDto.AdministeredPersonDto.ServiceNumber = sessionData.ServiceNumber;
        this.personDto.Details.AddressName.Initials = sessionData.Initials;
        this.personDto.Details.FormalName.Surname = sessionData.Surname;
        this.personDto.Details.FormalName.FirstNames[0] = sessionData.FirstName;
        this.personDto.Details.FormalName.Prefix = sessionData.Prefix;
        this.personDto.Details.FormalName.Gender = sessionData.Gender;
        this.personDto.Nationality.CountryId = sessionData.Nationality;
        this.personDto.ResidentialAddress.Address.StreetName = sessionData.StreetName;
        this.personDto.ResidentialAddress.Address.ZipCode = sessionData.ZipCode;
        this.personDto.ResidentialAddress.Address.City = sessionData.City;
        this.personDto.ResidentialAddress.Address.Country.Name = sessionData.Country;
        this.personDto.PhoneNumber = sessionData.PhoneNumber;
        this.personDto.MobileNumber = sessionData.MobileNumber;
        this.personDto.EmailAddress = sessionData.EmailAddress;
        this.personDto.Details.DateOfBirth = sessionData.DateOfBirth;
        this.personDto.ResidentialAddress.Address.HouseNumber = sessionData.HouseNumber;
        this.personDto.ResidentialAddress.Address.State = sessionData.State;
        this.personDto.ResidentialAddress.Address.HouseNumberAddition = sessionData.HouseNumberAddition;
        this.personDto.WhatsAppNumber = sessionData.WhatsAppNumber;
        this.personDto.TwitterId = sessionData.TwitterId;
        this.personDto.FacebookId = sessionData.FacebookId;
    }
    inputPersonGenderChange(event) {
        if (!GlobalFunctions.isEmpty(event.target?.value))
            this.personDto.Details.FormalName.Gender = event.target.value;
    }
    inputPersonNationalityChange(event) {
        if (!GlobalFunctions.isEmpty(event.target?.value))
            this.personDto.AdministeredPersonDto.Nationality.CountryId = event.target.value;
    }
    personCountryChange(event) {
        if (!GlobalFunctions.isEmpty(event.target?.value))
            this.personDto.ResidentialAddress.Address.Country.Name = event.target.value;
    }
    inputPersonDOB(inputId) {
        this.timeoutIds.push(setTimeout(() => {
            if (this.date && this.datePipe.transform(this.date, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                this.personDto.Details.DateOfBirth = GlobalFunctions.setDateFormat(inputId, this.date, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            else if (this.isManualDateEntry && this.manualEnteredDate)
                this.personDto.Details.DateOfBirth = GlobalFunctions.setDateFormat(inputId, this.manualEnteredDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            this.verifyPerson('dob');
        }));
        this.datePicker.close();
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    close() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod) && !GlobalFunctions.isEmpty(this.newPersonDto))
            this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod(this.newPersonDto);
        if (this.isOpenFromDialog)
            this.sessionManager.closeJkcChildPanel();
        else {
            this.dialogManager.removeComponent();
            this.sessionManager.closeJkcParentPanel();
        }
    }
    searchPersonByQuery(type) {
        const query = this.getSearchQuery(type);
        if (!GlobalFunctions.isEmpty(query))
            DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: 'person', query, recordSelection: RecordSelection.Single });
    }
    verifyPerson(type) {
        const query = this.getSearchQuery(type);
        if (this.searchingState != 1 && !GlobalFunctions.isEmpty(query)) {
            this.searchingType = type;
            this.searchingState = 1;
            this.personService.search(query, false, null, null, null, this.searchResultFound, this.updateSearchStatus, null, null, null);
        }
    }
    ;
    searchResultFound(result) {
        if (result != null && result.length > 0)
            this.searchingState = 2;
    }
    ;
    updateSearchStatus(result) {
        if (result.ActiveHandlers.length == 0 && this.searchingState == 1)
            this.searchingState = 0;
    }
    ;
    getSearchQuery(type) {
        let query = '';
        switch (type) {
            case 'email':
                {
                    if (!GlobalFunctions.isEmpty(this.personDto.EmailAddress))
                        query = this.personDto.EmailAddress;
                    break;
                }
            case 'dob':
                {
                    if (!GlobalFunctions.isEmpty(this.date) && this.datePipe.transform(this.date, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                        query = new this.dateJS(this.date).toString('dd-MM-yyyy');
                    else if (this.manualEnteredDate)
                        query = new this.dateJS(this.manualEnteredDate).toString('dd-MM-yyyy');
                    else
                        query = "";
                    break;
                }
        }
        return query;
    }
    ;
    handleManualDateInput_Person(target) {
        this.isManualDateEntry = true;
        this.manualEnteredDate = GlobalFunctions.handleManualDateInput(target, this.sessionManager);
    }
};
__decorate([
    ViewChild('form')
], PersonAddEditComponent.prototype, "form", void 0);
__decorate([
    ViewChild('picker')
], PersonAddEditComponent.prototype, "datePicker", void 0);
__decorate([
    ViewChild('dateInput')
], PersonAddEditComponent.prototype, "dateInput", void 0);
PersonAddEditComponent = __decorate([
    Component({
        selector: 'person-add-edit',
        templateUrl: './person-add-edit.component.html',
        styleUrls: ['./person-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], PersonAddEditComponent);
export { PersonAddEditComponent };
//# sourceMappingURL=person-add-edit.component.js.map