var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseViewerComponent } from 'src/app/components/common/base-viewer.component';
import { OperationType } from 'src/app/core/enums/common-enums';
import { PhoneState } from 'src/app/core/models/common/phone-state';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let OrganizationViewerComponent = class OrganizationViewerComponent extends BaseViewerComponent {
    constructor(phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.phoneState = new PhoneState();
        this.hasRightLocation = false;
    }
    ngOnInit() {
        this.phoneState = this.phoneManager.phoneState;
        this.organizationPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
        this.hasRightLocation = GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && GlobalFunctions.isValidToShowMap(this.organizationPrivateFields);
    }
    select(url) {
        if (!GlobalFunctions.isEmpty(url)) {
            url = GlobalFunctions.ensureHttpPrefix(url);
            GlobalFunctions.popUpCenter(url, 1024, 550);
        }
    }
};
OrganizationViewerComponent = __decorate([
    Component({
        selector: 'organization-viewer',
        templateUrl: './organization-viewer.component.html',
        styleUrls: ['./organization-viewer.component.scss']
    })
], OrganizationViewerComponent);
export { OrganizationViewerComponent };
//# sourceMappingURL=organization-viewer.component.js.map