var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { OperationType, RecordOperationMode, RecordSelection } from '../../../../core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { PersonDto } from '../../../../core/models/person/personDto';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let RepresentativeAddComponent = class RepresentativeAddComponent extends BaseDialogComponent {
    constructor(dialog, eventProvider, personService, sessionManager, data, translateService, organizationService, dialogRef, applicationSettingManager) {
        super();
        this.dialog = dialog;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.sessionManager = sessionManager;
        this.data = data;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.dialogRef = dialogRef;
        this.applicationSettingManager = applicationSettingManager;
        this.emptyNameError = '';
        this.personDto = new PersonDto();
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.searchingState = 0;
        this.genders = [
            { genderValue: "Male", genderText: this.translateService.instant("LBL_MALE") },
            { genderValue: "Female", genderText: this.translateService.instant("LBL_FEMALE") },
            { genderValue: "Unknown", genderText: this.translateService.instant("LBL_UNKNOWN") }
        ];
        this.subs = new SubSink();
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updateSearchStatus = this.updateSearchStatus.bind(this);
        this.addRepresentativeResponse = this.addRepresentativeResponse.bind(this);
        this.addRepresentativeErrorCallback = this.addRepresentativeErrorCallback.bind(this);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    createRepresentative() {
        var preventDomains = this.applicationSettingManager.getApplicationSettingValueByKey("PREVENTEMAILWITHDOMAINS");
        if (GlobalFunctions.isEmpty(this.personDto.Details.FormalName.FirstNames[0]) && GlobalFunctions.isEmpty(this.personDto.Details.FormalName.Surname))
            this.emptyNameError = this.translateService.instant('LBL_MSG_EMPTY_NAME');
        else if (!GlobalFunctions.isEmailDomainAllowed(this.personDto.EmailAddress, preventDomains))
            this.emptyNameError = this.translateService.instant("LBL_PREVENT_EMAIL_ADDRESS_MESSAGE");
        else {
            this.startSpinner();
            if (GlobalFunctions.isEmpty(this.personDto.Details.FormalName.Gender))
                this.personDto.Details.FormalName.Gender = "Unknown";
            if (this.data.editMode)
                this.organizationService.createOrganizationRepresentativeEntity(this.personDto, this.data.organizationId, this.addRepresentativeResponse, this.addRepresentativeErrorCallback, RecordOperationMode.Edit);
            else
                this.organizationService.createOrganizationRepresentativeEntity(this.personDto, this.data.organizationId, this.addRepresentativeResponse, this.addRepresentativeErrorCallback, RecordOperationMode.New);
        }
    }
    ;
    addRepresentativeResponse(response) {
        this.stopSpinner();
        if (response?.Result == 0) {
            this.personDto.Id = response.NewRepresentativeKey;
            this.newlyCreatedPerson = { ...this.personDto };
            this.newlyCreatedPerson.OrganizationId = this.data.organizationId;
            this.newlyCreatedPerson.ObjectSource = response.ObjectSource;
        }
        this.close(true);
        this.dialogRef.close(this.newlyCreatedPerson);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
    }
    addRepresentativeErrorCallback() {
        this.stopSpinner();
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_PERSON")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_PERSON"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    close(result = false) {
        this.dialogRef.close(result);
    }
    searchPerson() {
        let query = this.personDto.EmailAddress;
        if (!GlobalFunctions.isEmpty(query)) {
            DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: 'person', query, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
                if (!GlobalFunctions.isEmpty(searchEntity))
                    this.close(false);
            });
        }
    }
    ;
    verifyPerson() {
        let query = this.personDto.EmailAddress;
        if (this.searchingState != 1 && !GlobalFunctions.isEmpty(query)) {
            this.searchingState = 1;
            this.personService.search(query, false, null, null, null, this.searchResultFound, this.updateSearchStatus, null, null, null);
        }
    }
    ;
    searchResultFound(result) {
        if (result != null && result.length > 0)
            this.searchingState = 2;
    }
    ;
    updateSearchStatus(result) {
        if (result.ActiveHandlers.length == 0 && this.searchingState == 1)
            this.searchingState = 0;
    }
    ;
};
RepresentativeAddComponent = __decorate([
    Component({
        selector: 'add-representative',
        templateUrl: './organization-add-representative.component.html',
        styleUrls: ['./organization-add-representative.component.scss']
    }),
    __param(4, Inject(MAT_DIALOG_DATA))
], RepresentativeAddComponent);
export { RepresentativeAddComponent };
//# sourceMappingURL=organization-add-representative.component.js.map