var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { OperationType, RecordOperationMode, RecordSelection, ScreenMode } from '../../../../core/enums/common-enums';
import { CountryDto } from '../../../../core/models/common/countryDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { CreateOrganizationRequest } from '../../../../core/models/organization/create-organization-request';
import { OrganizationAddressDto } from '../../../../core/models/organization/organization-addressDto';
import { OrganizationDto } from '../../../../core/models/organization/organizationDto';
import { AddressDto } from '../../../../core/models/person/addressDto';
import { PersonAddressNameDto } from '../../../../core/models/person/person-address-nameDto';
import { PersonAdministeredOrganizationDto } from '../../../../core/models/person/person-administered-organizationDto';
import { PersonDetailsDto } from '../../../../core/models/person/person-detailDto';
import { PersonNameDto } from '../../../../core/models/person/person-nameDto';
import { PersonDto } from '../../../../core/models/person/personDto';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let OrganizationAddEditComponent = class OrganizationAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, translateService, shortcutManager, organizationService, dialog, router, eventProvider, dialogManager, cacheManager, applicationSettingManager) {
        super();
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.organizationService = organizationService;
        this.dialog = dialog;
        this.router = router;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.cacheManager = cacheManager;
        this.applicationSettingManager = applicationSettingManager;
        this.title = this.translateService.instant('LBL_REGISTER_NEW_ORGANIZATION').toUpperCase();
        this.isOpenFromDialog = false;
        this.newOrganizationDto = null;
        this.personDto = new PersonDto();
        this.organizationDto = new OrganizationDto();
        this.countries = CommonHelper.getCountries();
        this.representativeVisibility = "";
        this.editMode = false;
        this.organizationSessionData = null;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.isNameEmpty = false;
        this.subs = new SubSink();
        this.genders = [
            { genderValue: "Male", genderText: this.translateService.instant("LBL_MALE") },
            { genderValue: "Female", genderText: this.translateService.instant("LBL_FEMALE") },
            { genderValue: "Unknown", genderText: this.translateService.instant("LBL_UNKNOWN") }
        ];
        this.searchingState = 0;
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updateSearchStatus = this.updateSearchStatus.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.createOrganizationErrorCallback = this.createOrganizationErrorCallback.bind(this);
        this.addOrganizationRepresentativeResponse = this.addOrganizationRepresentativeResponse.bind(this);
        this.sessionManager.startSessionIfPossible("ORGANIZATION", sessionManager.jkcParentPanel?.parameters?.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        if (sessionManager.jkcParentPanel?.parameters?.IsChildPanel) {
            this.editMode = sessionManager.jkcChildPanel?.parameters?.EditMode;
            this.organizationSessionData = sessionManager.jkcChildPanel?.parameters?.EditedData;
            sessionManager.jkcChildPanel.parameters.Scope = this;
        }
        else {
            this.editMode = sessionManager.jkcParentPanel?.parameters?.EditMode;
            this.organizationSessionData = sessionManager.jkcParentPanel?.parameters?.EditedData;
            sessionManager.jkcParentPanel.parameters.Scope = this;
        }
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        try {
            this.resize();
            this.isOpenFromDialog = this.sessionManager.jkcParentPanel?.parameters?.IsChildPanel;
            this.newOrganizationDto = null;
            this.personDto = new PersonDto();
            this.organizationDto = new OrganizationDto();
            this.representativeVisibility = "";
            if (this.editMode) {
                this.initEditedOrganization();
                this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_ORGANIZATION").toUpperCase();
                this.representativeVisibility = "none";
            }
            else {
                this.title = this.translateService.instant("LBL_REGISTER_NEW_ORGANIZATION").toUpperCase();
                this.init();
                if (this.organizationSessionData != null)
                    this.assignOrganizationSessionToDto(this.organizationSessionData);
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createOrganization());
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, null, true, e.message, "");
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
    }
    assignOrganizationSessionToDto(sessionData) {
        this.organizationDto.Name = sessionData.Name;
        this.organizationDto.EmailAddress = sessionData.EmailAddress;
        this.organizationDto.PhoneNumber = sessionData.PhoneNumber;
        this.organizationDto.AdministeredOrganizationDto.Identification = sessionData.KVKNumber;
        this.organizationDto.FaxNumber = sessionData.FaxNumber;
        this.organizationDto.Website = sessionData.Website;
        this.organizationDto.RegistrationAddress.Address.ZipCode = sessionData.ZipCode;
        this.organizationDto.RegistrationAddress.Address.City = sessionData.City;
        this.organizationDto.RegistrationAddress.Address.StreetName = sessionData.StreetName;
        this.organizationDto.RegistrationAddress.Address.Country = sessionData.Country;
        this.organizationDto.RegistrationAddress.Address.State = sessionData.State;
        this.organizationDto.RegistrationAddress.Address.POBoxNumber = sessionData.POBoxNumber;
        this.organizationDto.WhatsAppNumber = sessionData.WhatsAppNumber;
        this.organizationDto.TwitterId = sessionData.TwitterId;
        this.organizationDto.FacebookId = sessionData.FacebookId;
        this.personDto.Details.FormalName.Surname = sessionData.ContactPersonSurname;
        this.personDto.Details.FormalName.FirstNames[0] = sessionData.ContactPersonFirstName;
        this.personDto.Details.FormalName.Prefix = sessionData.ContactPersonPrefix;
        this.personDto.Details.FormalName.Gender = sessionData.ContactPersonGender;
        this.personDto.PhoneNumber = sessionData.ContactPersonPhoneNumber;
        this.personDto.MobileNumber = sessionData.ContactPersonMobileNumber;
        this.personDto.EmailAddress = sessionData.ContactPersonEmailAddress;
        this.personDto.WhatsAppNumber = sessionData.ContactPersonWhatsAppNumber;
        this.personDto.TwitterId = sessionData.ContactPersonTwitterId;
        this.personDto.FacebookId = sessionData.ContactPersonFacebookId;
        this.personDto.Function = sessionData.ContactPersonFunction;
        this.personDto.Details.AddressName.Initials = sessionData.ContactPersonInitials;
    }
    init() {
        this.organizationDto.RegistrationAddress = new OrganizationAddressDto();
        this.organizationDto.RegistrationAddress.Address = new AddressDto();
        this.organizationDto.RegistrationAddress.Address.Country = new CountryDto();
        this.organizationDto.RegistrationAddress.Address.Country.Name = "Nederland";
        this.organizationDto.AdministeredOrganizationDto = new PersonAdministeredOrganizationDto();
        this.personDto.Details = new PersonDetailsDto();
        this.personDto.Details.FormalName = new PersonNameDto();
        this.personDto.Details.FormalName.Gender = "Unknown";
        this.personDto.Details.AddressName = new PersonAddressNameDto();
    }
    initEditedOrganization() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            this.organizationDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
            if (!this.organizationDto.RegistrationAddress)
                this.organizationDto.RegistrationAddress = new OrganizationAddressDto();
            if (!this.organizationDto.RegistrationAddress.Address)
                this.organizationDto.RegistrationAddress.Address = new AddressDto();
            if (!this.organizationDto.RegistrationAddress.Address.Country) {
                this.organizationDto.RegistrationAddress.Address.Country = new CountryDto();
                this.organizationDto.RegistrationAddress.Address.Country.Name = "Nederland";
            }
        }
    }
    resize() {
        this.isOpenFromDialog = this.sessionManager.jkcParentPanel?.parameters?.IsChildPanel;
        const windowHeight = $(window).height();
        if (this.isOpenFromDialog) {
            $("#jkcChildPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcChildPanel?.parameters?.TopSpace) - 100 + "px") });
            const newHeight = $("#jkcChildPanel").height() - $("#addOrganizationHeader").height() - $("#addOrganizationFooter").height() + "px";
            $("#addOrganizationContainer").height(newHeight);
            $('#' + this.sessionManager.jkcChildPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcChildPanel").width()) });
            $('#' + this.sessionManager.jkcChildPanel?.parameters?.FooterId).css({ 'width': ($("#jkcChildPanel").width()) });
        }
        else {
            $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
            const newHeight = $("#jkcParentPanel").height() - $("#addOrganizationHeader").height() - $("#addOrganizationFooter").height() + "px";
            $("#addOrganizationContainer").height(newHeight);
            $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
            $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        }
    }
    sendCreateOrganizationRequest() {
        const req = new CreateOrganizationRequest();
        req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
        req.OrganizationDto = this.organizationDto;
        this.organizationService.createOrganizationEntity(req, this.addOrganizationResponse, this.createOrganizationErrorCallback);
    }
    ;
    createOrganizationErrorCallback() {
        this.stopSpinner();
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_ORGANIZATION")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_ORGANIZATION"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    createOrganization() {
        this.errorMessage = "";
        if (this.form.invalid)
            return;
        var preventDomains = this.applicationSettingManager.getApplicationSettingValueByKey("PREVENTEMAILWITHDOMAINS");
        if (!GlobalFunctions.isEmailDomainAllowed(this.organizationDto.EmailAddress, preventDomains)) {
            this.errorMessage = this.translateService.instant("LBL_PREVENT_EMAIL_ADDRESS_MESSAGE");
            return;
        }
        if (GlobalFunctions.isEmpty(this.organizationDto.AdministeredOrganizationDto.Identification))
            this.organizationDto.AdministeredOrganizationDto.Identification = 0;
        let result = this.validatePhoneNumber();
        if (result.isValid) {
            this.organizationDto.StringRepresentation = "";
            this.sessionManager.setBreadcrumbGrammer(this.organizationDto);
            this.startSpinner();
            this.sendCreateOrganizationRequest();
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_ORGANIZATION"), textMsg: GlobalFunctions.formatStringValue(this.translateService.instant("LBL_PHONE_NUMBER_WARNING"), [result.msg]), isConfirmation: true, noButton: 'LBL_NO', yesButton: 'LBL_YES' }).afterClosed().subscribe(result => {
                if (result) {
                    this.startSpinner();
                    this.sendCreateOrganizationRequest();
                }
            });
        }
    }
    ;
    validatePhoneNumber() {
        let result = { isValid: true, msg: "" };
        if (!GlobalFunctions.isEmpty(this.organizationDto.PhoneNumber)) {
            let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
            result.isValid = GlobalFunctions.isValidPhonenumber(this.organizationDto.PhoneNumber, countryCode);
        }
        if (!result.isValid)
            result.msg = this.translateService.instant("LBL_PHONE_NUMBER");
        return result;
    }
    addOrganizationResponse(response) {
        if (response != null && response.Result == 0 && response.OrganizationDto != null) {
            this.newOrganizationDto = response.OrganizationDto;
            this.close();
            if (this.editMode || (GlobalFunctions.isEmpty(this.personDto?.Details?.FormalName?.FirstNames[0]) && GlobalFunctions.isEmpty(this.personDto?.Details?.FormalName?.Surname))) {
                this.stopSpinner();
                this.loadUpdatedOrganizationInDetail();
                this.cacheManager.updateDashboardCache(this.newOrganizationDto);
            }
            else
                this.sendCreatePersonAsRepresentativeRequest(this.newOrganizationDto.Id);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_ORGANIZATION"), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_ORGANIZATION") });
    }
    ;
    loadUpdatedOrganizationInDetail() {
        if (!GlobalFunctions.isEmpty(this.newOrganizationDto)) {
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = this.newOrganizationDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/organization`;
            if (!this.editMode)
                this.sessionManager.addBreadcrumbItems([this.newOrganizationDto], null, this.router.url);
            else {
                let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.sessionManager.addBreadcrumbItems([this.newOrganizationDto], null, this.router.url);
            }
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
    }
    sendCreatePersonAsRepresentativeRequest(id) {
        if (!GlobalFunctions.isEmpty(id))
            this.organizationService.createOrganizationRepresentativeEntity(this.personDto, id, this.addOrganizationRepresentativeResponse, () => { });
        else
            this.stopSpinner();
    }
    addOrganizationRepresentativeResponse(response) {
        this.stopSpinner();
        this.close();
        if (!this.isOpenFromDialog) {
            if (response != null && response.Result == 0 && !GlobalFunctions.isEmpty(this.newOrganizationDto))
                this.loadUpdatedOrganizationInDetail();
        }
    }
    close() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod))
            this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod(this.newOrganizationDto);
        if (this.isOpenFromDialog)
            this.sessionManager.closeJkcChildPanel();
        else {
            this.dialogManager.removeComponent();
            this.sessionManager.closeJkcParentPanel();
        }
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    searchOrganization(type) {
        let query = '';
        if (type == 'name' && !GlobalFunctions.isEmpty(this.organizationDto))
            query = GlobalFunctions.isEmpty(this.organizationDto.Name) ? '' : this.organizationDto.Name;
        if (!GlobalFunctions.isEmpty(query)) {
            DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: 'organization', query, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
                if (!GlobalFunctions.isEmpty(searchEntity)) {
                    this.newOrganizationDto = searchEntity;
                    this.close();
                    this.loadUpdatedOrganizationInDetail();
                }
            });
        }
    }
    ;
    verifyOrganization() {
        if (this.searchingState != 1 && !GlobalFunctions.isEmpty(this.organizationDto) && !GlobalFunctions.isEmpty(this.organizationDto.Name)) {
            this.searchingState = 1;
            this.organizationService.search(this.organizationDto.Name, null, null, null, null, this.searchResultFound, this.updateSearchStatus, null);
        }
    }
    ;
    searchResultFound(result) {
        if (result != null && result.length > 0)
            this.searchingState = 2;
    }
    ;
    updateSearchStatus(result) {
        if (result.ActiveHandlers.length == 0 && this.searchingState == 1)
            this.searchingState = 0;
    }
    ;
};
__decorate([
    ViewChild('form')
], OrganizationAddEditComponent.prototype, "form", void 0);
OrganizationAddEditComponent = __decorate([
    Component({
        selector: 'organization-add-edit',
        templateUrl: './organization-add-edit.component.html',
        styleUrls: ['./organization-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], OrganizationAddEditComponent);
export { OrganizationAddEditComponent };
//# sourceMappingURL=organization-add-edit.component.js.map