var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType, OperationType, ScreenMode } from 'src/app/core/enums/common-enums';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { NoteBulkDeleteComponent } from '../bulk-delete/note-bulk-delete.component';
import { BroadCastEventKeys } from '../../../../shared/constants';
let NoteSearchResultComponent = class NoteSearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, router, translateService, noteService, sessionManager, searchService, sortManager, changeDetectorRef, eventProvider, applicationSettingManager, employeeService, formatManager, dialog, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.translateService = translateService;
        this.noteService = noteService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.dialog = dialog;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.enabledBulkDelete = false;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ;
    ngOnInit() {
        this.type = "noteentity";
        this.resultList = [];
        this.filteredSearchResult = [];
        this.enabledBulkDelete = GlobalFunctions.checkRights('NoteEntity', OperationType.BulkDelete);
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "noteentity") {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.searchStatusMessage = '';
            this.searchNote();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchNote() {
        this.updateSearchStatus(this.activeHandlersObj);
        let searchQueryParts = this.searchStatusQuery.split('|');
        this.searchStatusQuery = GlobalFunctions.isEmpty(searchQueryParts[1]) ? searchQueryParts[0] : searchQueryParts[1];
        if (!GlobalFunctions.isEmpty(searchQueryParts[1]))
            this.noteService.search(searchQueryParts[1], false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus);
        else if (searchQueryParts[0] == "my") {
            this.searchStatusQuery = this.translateService.instant("LBL_MY") + " " + this.translateService.instant("LBL_NOTE_ENTITYS");
            this.noteService.advancedSearch(new SearchDto(), "", this.searchResultFound, this.updateSearchStatus);
        }
        else if (searchQueryParts[0] == "all") {
            this.searchStatusQuery = this.translateService.instant("LBL_ALL") + " " + this.translateService.instant("LBL_NOTE_ENTITYS");
            this.noteService.search(null, null, null, "", null, this.searchResultFound, this.updateSearchStatus);
        }
        else {
            this.noteService.search(searchQueryParts[0], null, null, "", null, this.searchResultFound, this.updateSearchStatus); //Search from Search Link popup
        }
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
    }
    ;
    fetchSourceCaption(person) {
        this.sessionManager.fetchSourceCaption(person.additionalObjectSource, null);
    }
    ;
    bulkDelete() {
        DialogHelper.openDialog(this.dialog, NoteBulkDeleteComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { resultList: this.filteredSearchResult }).afterClosed().subscribe(result => {
            if (result)
                this.searchNote();
        });
    }
    ;
};
NoteSearchResultComponent = __decorate([
    Component({
        selector: 'note-search-result',
        templateUrl: './note-search-result.component.html',
        styleUrls: ['./note-search-result.component.scss']
    })
], NoteSearchResultComponent);
export { NoteSearchResultComponent };
//# sourceMappingURL=note-search-result.component.js.map