var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let NoteDetailComponent = class NoteDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, contextMenuService, noteService, eventProvider, integrationSettingManager, formatManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.noteService = noteService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.formatManager = formatManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.fetchNoteDetailResponse = this.fetchNoteDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadNoteDetail();
    }
    ;
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadNoteDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "NoteEntityDetail", this.translateService.instant("LBL_NOTE"), false, true, true);
            this.addMenuItem.emit(this.menu);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                this.noteService.fetchDetail(partialDto, this.fetchNoteDetailResponse);
                this.startSpinner();
            }
            else {
                this.formatManager.setCreatedBy([this.sessionManager.selectedEntity]);
                this.sendRelatedRequest.emit();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    fetchNoteDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null && result.length > 0) {
            let noteEntity = result[0];
            if (noteEntity.Id === this.sessionManager.selectedEntity.Id) {
                this.formatManager.setCreatedBy([noteEntity]);
                this.sessionManager.setBreadcrumbGrammer(noteEntity);
                this.sessionManager.selectedEntity = noteEntity;
                this.sendRelatedRequest.emit();
            }
        }
    }
};
NoteDetailComponent = __decorate([
    Component({
        selector: 'note-detail',
        templateUrl: './note-detail.component.html',
        styleUrls: ['./note-detail.component.scss']
    })
], NoteDetailComponent);
export { NoteDetailComponent };
//# sourceMappingURL=note-detail.component.js.map