var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { AlternateSearchType, ScreenMode } from 'src/app/core/enums/common-enums';
import { SearchResultSource } from 'src/app/core/enums/search-result-source.enum';
import { BroadCastEventKeys, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
let NewsSearchResultComponent = class NewsSearchResultComponent extends BaseSearchResultComponent {
    constructor(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, cacheManager, systemComponentService, datePipe, employeeService, formatManager, integrationSettingManager, searchService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.translateService = translateService;
        this.changeDetectorRef = changeDetectorRef;
        this.sessionManager = sessionManager;
        this.router = router;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.sortManager = sortManager;
        this.applicationSettingManager = applicationSettingManager;
        this.cacheManager = cacheManager;
        this.systemComponentService = systemComponentService;
        this.datePipe = datePipe;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.integrationSettingManager = integrationSettingManager;
        this.searchService = searchService;
        this.type = "NEWS";
        this.resultList = [];
        this.selectContent = true;
        this.selectedContentItem = "";
        this.searchStatusContainerId = "dashboardContainer";
        this.listSearchCompleted = true;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
        if (this.searchResultSource == SearchResultSource.Dashboard || GlobalFunctions.isEmpty(this.searchStatusQuery))
            this.searchStatusQuery = this.translateService.instant("LBL_NEWS");
        this.resultList = [];
        this.filteredSearchResult = [];
        this.searchStatusMessage = '';
        if (this.router.url.indexOf(RoutePath.DASHBOARD) != -1)
            this.searchNewsByDashboard();
        else
            this.searchNewByParameter();
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.searchStatusQuery = "";
    }
    searchNewsByDashboard() {
        try {
            this.updateSearchStatus(this.activeHandlersObj);
            this.systemComponentService.searchNews(null, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    searchNewByParameter() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.systemComponentService.searchNews(this.searchStatusQuery, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null);
    }
    resize() {
        GlobalFunctions.resizejkcBootstrapTable();
    }
    hasDashboardView() {
        if (this.searchResultSource == SearchResultSource.Dashboard)
            return true;
        else
            return false;
    }
};
NewsSearchResultComponent = __decorate([
    Component({
        selector: 'news-search-result',
        templateUrl: './news-search-result.component.html',
        styleUrls: ['./news-search-result.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], NewsSearchResultComponent);
export { NewsSearchResultComponent };
//# sourceMappingURL=news-search-result.component.js.map