var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from 'src/app/components/common/base-detail.component';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu, SubMenuItem } from 'src/app/core/models/common/menu';
import { RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { BroadCastEventKeys } from '../../../../shared/constants';
let NewsDetailComponent = class NewsDetailComponent extends BaseDetailComponent {
    constructor(router, zone, cacheManager, sessionManager, dialog, contextMenuService, systemComponentService, searchService, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.zone = zone;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.systemComponentService = systemComponentService;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.subMenuItem = new SubMenuItem();
        this.fetchNewsDetailResponse = this.fetchNewsDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.subMenuItem = new SubMenuItem();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        if (this.sessionManager.selectedEntity != null)
            this.sessionManager.addItemToSession(this.sessionManager.selectedEntity);
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadNewsDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    loadNewsDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "NewsDetail", this.translateService.instant("LBL_NEWS"), false, true, true, true, false, this.subMenuItem);
            this.addMenuItem.emit(this.menu);
            this.sendRelatedRequest.emit();
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                this.startSpinner();
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                partialDto.Query = this.searchService.selectedSearchOption ? this.searchService.selectedSearchOption.searchQuery : "";
                partialDto.Name = !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Name) ? this.sessionManager.selectedEntity.Name : this.sessionManager.selectedEntity.StringRepresentation;
                partialDto.SourceApplicationDeeplink = this.sessionManager.selectedEntity.SourceApplicationDeeplink;
                this.systemComponentService.fetchNewsDetail(partialDto, this.fetchNewsDetailResponse);
            }
            else {
                const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
                const oldContentType = GlobalFunctions.toContentType(detailEntityType);
                this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
                this.processFirstDescriptionElement();
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    fetchNewsDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.processFirstDescriptionElement();
        }
        else {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_NEWS_NOT_FOUND"), this.translateService.instant("LBL_NEWS_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_NEWS"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    processFirstDescriptionElement() {
        this.addSubMenuItems(this.sessionManager.selectedEntity);
        if (this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity.Descriptions != null && this.sessionManager.selectedEntity.Descriptions.length > 0)
            this.sessionManager.selectedEntity.Descriptions[0].Title = "";
    }
    addSubMenuItems(newsDto) {
        if (newsDto != null) {
            if (newsDto.Descriptions != null && newsDto.Descriptions.length > 0) {
                for (let index = 0; index < newsDto.Descriptions.length; index++) {
                    if (newsDto.Descriptions[index].Title != "" && newsDto.Descriptions[index].Title != undefined)
                        this.subMenuItem.addMenuItem(newsDto.Descriptions[index].Title, index.toString());
                }
            }
        }
    }
    loadRoute(relatedObject) {
        relatedObject.Name = relatedObject.StringRepresentation;
        relatedObject.RelatedEntityFqdn = "Decos_Kcs_News_Entities_Item";
        this.sessionManager.setBreadcrumbGrammer(relatedObject);
        this.sessionManager.addBreadcrumbItems([relatedObject], null, RoutePath.DETAIL_PATH);
        this.sessionManager.selectedEntity = relatedObject;
        this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, "news"]));
    }
};
NewsDetailComponent = __decorate([
    Component({
        selector: 'news-detail',
        templateUrl: './news-detail.component.html',
        styleUrls: ['./news-detail.component.scss']
    })
], NewsDetailComponent);
export { NewsDetailComponent };
//# sourceMappingURL=news-detail.component.js.map