var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { LocationDto } from '../../../../core/models/common/locationDto';
import { EntityName, RoutePath } from '../../../../shared/constants';
let LocationSearchResultComponent = class LocationSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, geoLayerService, searchService, sessionManager, applicationSettingManager, sortManager, changeDetectorRef, activatedRoute, eventProvider, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.geoLayerService = geoLayerService;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.hideBSN = false;
    }
    ngOnInit() {
        this.loadDetail();
    }
    loadDetail() {
        const locationDto = new LocationDto();
        locationDto.Id = GlobalFunctions.getGuid();
        locationDto.Partial = false;
        if (GlobalFunctions.isValidToShowMap(this.privateFields)) {
            locationDto.GeoSeachCriteria = this.searchService.searchQuery;
        }
        locationDto.StringRepresentation = this.searchService.searchQuery;
        locationDto.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.LOCATION}`;
        locationDto.RelatedEntityFqdn = 'Decos_Kcs_Locations_Entities_AddressableObjectMark';
        this.sessionManager.selectedEntity = locationDto;
        this.sessionManager.addBreadcrumbItems([locationDto], null, this.router.url);
        this.router.navigate([locationDto.locationUrl]);
    }
};
LocationSearchResultComponent = __decorate([
    Component({
        selector: 'location-search-result',
        templateUrl: './location-search-result.component.html',
        styleUrls: ['./location-search-result.component.scss']
    })
], LocationSearchResultComponent);
export { LocationSearchResultComponent };
//# sourceMappingURL=location-search-result.component.js.map