var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { LicenseSpecificFeature, OperationType } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let LocationDetailComponent = class LocationDetailComponent extends BaseDetailComponent {
    constructor(sessionManager, geoLayerService, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.sessionManager = sessionManager;
        this.geoLayerService = geoLayerService;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.timeoutIds = [];
    }
    ngOnInit() {
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.sessionManager.showDetailViewActionOption = false;
        if (GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AddressesAndBuildings) && GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View)) {
            this.geoLayerService.plotGeoMap();
            this.menu.addOrUpdateMenuItem(0, "LocationEntityDetail", this.translateService.instant("LBL_LOCATION"), false, true, false);
            this.addMenuItem.emit(this.menu);
        }
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    resize() {
        let windowHeight = window.innerHeight;
        let newHeight = windowHeight - 180 + "px";
        $("#map").height(newHeight);
    }
};
LocationDetailComponent = __decorate([
    Component({
        selector: 'location-detail',
        templateUrl: './location-detail.component.html',
        styleUrls: ['./location-detail.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], LocationDetailComponent);
export { LocationDetailComponent };
//# sourceMappingURL=location-detail.component.js.map