var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseViewerComponent } from '../../../common/base-viewer.component';
let IssueViewerComponent = class IssueViewerComponent extends BaseViewerComponent {
    constructor(cacheManager, sessionManager, translateService, integrationSettingManager, phoneManager, dialogManager) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.url = '';
        this.timeoutIds = [];
    }
    ;
    ngOnInit() {
        let detailQuery = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "DETAILQUERY");
        let appUrl = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Issues_Entities_Issue, "APPURL");
        if (!GlobalFunctions.isEmpty(detailQuery) && !GlobalFunctions.isEmpty(appUrl))
            this.url = appUrl + detailQuery + this.sessionManager.selectedEntity.Id;
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
    }
    ;
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    resize() {
        $("#frame").height($(window).height() - 123 + "px");
    }
    ;
};
IssueViewerComponent = __decorate([
    Component({
        selector: 'issue-viewer',
        templateUrl: './issue-viewer.component.html',
        styleUrls: ['./issue-viewer.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], IssueViewerComponent);
export { IssueViewerComponent };
//# sourceMappingURL=issue-viewer.component.js.map