var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType } from 'src/app/core/enums/common-enums';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let IssueSearchResultComponent = class IssueSearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, router, translateService, issueService, sessionManager, searchService, sortManager, changeDetectorRef, eventProvider, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.translateService = translateService;
        this.issueService = issueService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ;
    ngOnInit() {
        this.type = "issue";
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.resultList = [];
            this.filteredSearchResult = [];
            this.searchStatusMessage = '';
            this.searchIssue();
        }
    }
    ;
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchIssue() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.issueService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, null);
    }
    ;
    fetchSourceCaption(person) {
        this.sessionManager.fetchSourceCaption(person.additionalObjectSource, null);
    }
    ;
    searchInOlderData() {
        this.resultList = [];
        this.alternateSearchSources = [];
        this.isSearchingInOlderData = true;
        this.issueService.search(this.searchService.selectedSearchOption.searchQuery, false, AlternateSearchType.None, "searchInOlderData", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived);
    }
    ;
};
IssueSearchResultComponent = __decorate([
    Component({
        selector: 'issue-search-result',
        templateUrl: './issue-search-result.component.html',
        styleUrls: ['./issue-search-result.component.scss']
    })
], IssueSearchResultComponent);
export { IssueSearchResultComponent };
//# sourceMappingURL=issue-search-result.component.js.map