var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { RecordOperationMode, RecordSelection, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { AttachmentType } from '../../../../core/enums/files-enum';
import { CreateOrUpdateFileRequest } from '../../../../core/models/file/create-update-file-request';
import { FileDto } from '../../../../core/models/file/fileDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { ManageLocalGroupPrivilegeComponent } from '../../../common/manage-local-group-privilege/manage-local-group-privilege.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let FileAddEditComponent = class FileAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, dialogManager, translateService, shortcutManager, fileService, integrationSettingManager, userService, dialog, router, eventProvider, searchService, cacheManager) {
        super();
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.fileService = fileService;
        this.integrationSettingManager = integrationSettingManager;
        this.userService = userService;
        this.dialog = dialog;
        this.router = router;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.cacheManager = cacheManager;
        this.fileDto = new FileDto();
        this.attachmentType = "0";
        this.title = "";
        this.isLocalGroupEnabled = false;
        this.showUploadAttachmentType = true;
        this.showLinkAttachmentType = true;
        this.files = [];
        this.fileLinksTags = [];
        this.localUserGroups = [];
        this.editMode = false;
        this.fileSessionData = null;
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.addFileResponse = this.addFileResponse.bind(this);
        this.addFileErrorCallback = this.addFileErrorCallback.bind(this);
        this.sessionManager.startSessionIfPossible("fileentity", sessionManager.jkcParentPanel.parameters.EditMode ? ScreenMode.Edit : ScreenMode.Add);
        if (sessionManager.jkcParentPanel.parameters.IsChildPanel) {
            this.editMode = sessionManager.jkcChildPanel.parameters.EditMode;
            this.fileSessionData = sessionManager.jkcChildPanel.parameters.EditedData;
            sessionManager.jkcChildPanel.parameters.Scope = this;
        }
        else {
            this.editMode = sessionManager.jkcParentPanel.parameters.EditMode;
            this.fileSessionData = sessionManager.jkcParentPanel.parameters.EditedData;
            sessionManager.jkcParentPanel.parameters.Scope = this;
        }
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ;
    ngOnInit() {
        this.init();
        this.initLocalGroups();
    }
    ;
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    init() {
        try {
            if (this.editMode) {
                this.fileDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
                this.title = this.translateService.instant("LBL_EDIT_FILE_ENTITY").toUpperCase();
                let file = new Object();
                if (this.fileDto.AttachmentType == AttachmentType.Upload) {
                    if (this.fileDto.IsAttachmentExist) {
                        file.Text = this.fileDto.Name;
                        file.NameOnServer = "";
                        this.files.push(file);
                    }
                }
                else {
                    this.attachmentType = AttachmentType.Link;
                    if (this.fileDto.IsAttachmentExist) {
                        file.Text = this.fileDto.Name;
                        this.fileLinksTags.push(file);
                    }
                    this.timeoutIds.push(setTimeout(() => this.attachmentTypeLink.nativeElement.checked = true));
                }
            }
            else {
                this.title = this.translateService.instant("LBL_ADD_FILE_ENTITY").toUpperCase();
                if (this.fileSessionData != null)
                    this.assignFileSessionToDto(this.fileSessionData);
            }
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createFile());
            this.showDefaultAttachmentType();
            this.resize();
        }
        catch (e) {
            console.error(e.message);
        }
    }
    assignFileSessionToDto(sessionData) {
        if (sessionData.Files.length > 0) {
            this.fileDto.Description = sessionData.Description;
            this.fileDto.IsAttachmentExist = sessionData.IsAttachmentExist;
            this.fileDto.Name = sessionData.Name;
            this.fileDto.Title = sessionData.Title;
            this.fileDto.Path = sessionData.Path;
            this.files.push(sessionData.Files[0]);
        }
    }
    showDefaultAttachmentType() {
        let showAttachmentType = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Files_Entities_FileEntity, "SHOWATTACHMENTTYPE");
        if (!GlobalFunctions.isEmpty(showAttachmentType) && showAttachmentType != "2") {
            if (this.editMode) {
                if (showAttachmentType == "1" && this.fileDto.AttachmentType == AttachmentType.Link)
                    this.showUploadAttachmentType = false;
                else if (showAttachmentType == "0" && this.fileDto.AttachmentType == AttachmentType.Upload)
                    this.showLinkAttachmentType = false;
            }
            else {
                if (showAttachmentType == "0")
                    this.showLinkAttachmentType = false;
                else {
                    this.showUploadAttachmentType = false;
                    this.attachmentType = "1";
                }
            }
        }
    }
    ;
    createFile() {
        if (this.validateForm()) {
            if (GlobalFunctions.isEmpty(this.fileDto.Id))
                this.fileDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            this.fileDto.CreatedOn = new Date();
            this.fileDto.AttachmentType = this.attachmentType;
            this.fileDto.StringRepresentation = "";
            this.sessionManager.setBreadcrumbGrammer(this.fileDto);
            this.startSpinner();
            let req = new CreateOrUpdateFileRequest();
            req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
            req.FileDto = this.fileDto;
            this.fileService.createFile(req, this.addFileResponse, this.addFileErrorCallback);
        }
    }
    ;
    validateForm() {
        let validForm = this.form.valid;
        if (this.attachmentType == AttachmentType.Upload) {
            if (GlobalFunctions.isEmpty(this.fileDto) || GlobalFunctions.isEmpty(this.fileDto.Name) || this.files.length <= 0) {
                this.errorMessage = this.translateService.instant('LBL_REQUIRED_UPLOAD');
                validForm = false;
            }
            else
                this.errorMessage = "";
        }
        if (this.attachmentType == AttachmentType.Link) {
            if (GlobalFunctions.isEmpty(this.fileDto) || GlobalFunctions.isEmpty(this.fileDto.Path) || this.fileLinksTags.length <= 0) {
                this.errorMessage = this.translateService.instant('LBL_REQUIRED_LINK');
                validForm = false;
            }
            else
                this.errorMessage = "";
        }
        return validForm;
    }
    addFileResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0 && response.FileDto != null) {
            let newFileDto = response.FileDto;
            this.close(false);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = newFileDto;
            this.sessionManager.selectedEntity.ObjectSource = newFileDto.ObjectSource;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.FILEENTITY}`;
            if (this.editMode) {
                let selectedIndex = 0;
                this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                this.cacheManager.updateDashboardCache(response.FileDto);
                this.sessionManager.addBreadcrumbItems([newFileDto], null, RoutePath.DETAIL_PATH);
            }
            else
                this.sessionManager.addBreadcrumbItems([newFileDto], null, RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_FILE'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_FILE_ENTITY") });
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    ;
    addFileErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ADD_ERROR_MSG"), [this.translateService.instant("LBL_FILE")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_FILE"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    fileRemoved() {
        this.files = new Array();
        this.fileDto.Name = "";
    }
    ;
    onUpload(upload) {
        this.startSpinner();
        this.files = new Array();
        let file = new Object();
        file.Text = upload.name;
        file.NameOnServer = "";
        this.files.push(file);
        this.fileDto.Name = upload.name;
        this.fileDto.CreatedOn = upload.lastModifiedDate;
        this.errorMessage = '';
    }
    onError(response) {
        this.fileDto.Path = response.data;
        this.files.splice(this.files.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(response, this.translateService);
        this.stopSpinner();
    }
    ;
    onSuccess(response) {
        this.fileDto.Path = response[0].fileName;
        this.errorMessage = '';
        this.stopSpinner();
    }
    ;
    openFileLinkResultPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: "fileentity", recordSelection: RecordSelection.Single, autoSearch: true, searchPanelHide: true }).afterClosed().subscribe(selectedEntity => {
            if (selectedEntity != null) {
                this.fileLinksTags = new Array();
                selectedEntity.StringRepresentation = selectedEntity.Title;
                selectedEntity.Text = selectedEntity.StringRepresentation;
                this.fileDto.Path = selectedEntity.Path;
                this.fileLinksTags.push(selectedEntity);
                this.errorMessage = null;
            }
        });
        this.searchService.isSearchFromPopup = true;
    }
    fileLinksRemoved() {
        this.fileLinksTags = new Array();
    }
    ;
    manageLocalGroupPrivilege() {
        DialogHelper.openDialog(this.dialog, ManageLocalGroupPrivilegeComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { localUserGroups: this.localUserGroups, privilegedGroupIds: this.fileDto.ManageLocalGroupPrivilege }).afterClosed().subscribe(privilegedGroupIds => {
            if (!GlobalFunctions.isEmpty(privilegedGroupIds))
                this.fileDto.ManageLocalGroupPrivilege = privilegedGroupIds;
        });
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addFileHeader").height() - $("#addFileFooter").height() + "px";
        $("#addFileContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    ;
    initLocalGroups() {
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.isLocalGroupEnabled = this.localUserGroups.length > 0 ? true : false;
    }
    close(result) {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod) && !GlobalFunctions.isEmpty(this.fileDto))
            this.sessionManager.jkcParentPanel?.parameters?.CallbackMethod(this.fileDto);
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], FileAddEditComponent.prototype, "form", void 0);
__decorate([
    ViewChild('attachmentTypeLink')
], FileAddEditComponent.prototype, "attachmentTypeLink", void 0);
FileAddEditComponent = __decorate([
    Component({
        selector: 'file-add-edit',
        templateUrl: './file-add-edit.component.html',
        styleUrls: ['./file-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], FileAddEditComponent);
export { FileAddEditComponent };
//# sourceMappingURL=file-add-edit.component.js.map