var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from '../../../../components/common/base-search-result.component';
import { OperationType } from '../../../../core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
let EmployeeSearchResultComponent = class EmployeeSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, sessionManager, applicationSettingManager, sortManager, changeDetectorRef, activatedRoute, eventProvider, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "employee";
        try {
            if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
                this.sourceCount = 0;
                this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
                this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
                this.localSearchResultDataService.localSearchResultData.localResult = [];
                this.localSearchResultDataService.localSearchResultData.contentType = "";
            }
            else {
                this.resultCount = 0;
                this.resultList = [];
                this.filteredSearchResult = [];
                this.searchStatusMessage = '';
                this.searchEmployee();
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchEmployee() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.employeeService.search(this.searchStatusQuery, null, null, null, null, this.searchResultFound, this.updateSearchStatus);
    }
};
EmployeeSearchResultComponent = __decorate([
    Component({
        selector: 'employee-search-result',
        templateUrl: './employee-search-result.component.html',
        styleUrls: ['./employee-search-result.component.scss']
    })
], EmployeeSearchResultComponent);
export { EmployeeSearchResultComponent };
//# sourceMappingURL=employee-search-result.component.js.map