var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseRelatedListComponent } from '../../../../components/common/base-related-list.component';
import { OperationType } from '../../../../core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
let EmployeeRelatedListComponent = class EmployeeRelatedListComponent extends BaseRelatedListComponent {
    constructor(activatedRoute, phoneManager, employeeService, translateService, sessionManager, eventProvider, applicationSettingManager, dialogManager, router) {
        super(translateService, activatedRoute, sessionManager, eventProvider, dialogManager, applicationSettingManager, router, phoneManager);
        this.activatedRoute = activatedRoute;
        this.phoneManager = phoneManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogManager = dialogManager;
        this.router = router;
        this.isAvailabilityCdrEnabled = false;
        this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
    }
    ngOnInit() {
        this.isAvailabilityCdrEnabled = this.applicationSettingManager.isAvailabilityCdrEnabled();
        super.ngOnInit();
    }
    ngOnChanges(changes) {
        super.ngOnChanges(changes);
        if (this.relatedResultList?.length > 0)
            this.employeeService.setEmployeeAvailability(this.relatedResultList);
    }
};
EmployeeRelatedListComponent = __decorate([
    Component({
        selector: 'employee-related-list',
        templateUrl: './employee-related-list.component.html',
        styleUrls: ['./employee-related-list.component.scss']
    })
], EmployeeRelatedListComponent);
export { EmployeeRelatedListComponent };
//# sourceMappingURL=employee-related-list.component.js.map