var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { OperationType } from '../../../../../core/enums/common-enums';
import { PhoneState } from '../../../../../core/models/common/phone-state';
import { ContentType } from '../../../../../core/models/jkc-object/jkc-object';
import { PhoneStatusInfo } from '../../../../../core/models/phone/phone-status-info';
import { PhoneStatusDto } from '../../../../../core/models/phone/phone-statusDto';
import { GlobalFunctions } from '../../../../../shared/global-functions';
let PopularNumberPanelComponent = class PopularNumberPanelComponent extends BaseDialogComponent {
    constructor(dialogRef, sessionManager, payLoad, applocationFeatureManager, phoneManager, applicationSettingManager, router, cacheManager, phoneService, translateService, eventProvider) {
        super();
        this.dialogRef = dialogRef;
        this.sessionManager = sessionManager;
        this.payLoad = payLoad;
        this.applocationFeatureManager = applocationFeatureManager;
        this.phoneManager = phoneManager;
        this.applicationSettingManager = applicationSettingManager;
        this.router = router;
        this.cacheManager = cacheManager;
        this.phoneService = phoneService;
        this.translateService = translateService;
        this.eventProvider = eventProvider;
        this.showStatusDropDown = false;
        this.selectedEmployee = null;
        this.phoneState = new PhoneState();
        this.phoneStatusInfo = new PhoneStatusInfo();
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
        this.doubleClick = false;
        this.isParentPopup = true;
        this.timeoutIds = [];
        this.updateStatus = this.updateStatus.bind(this);
    }
    ngOnInit() {
        this.phoneStatusInfo.IsPhoneStatusEnabled = this.applocationFeatureManager.isPhoneStatusEnabled;
        this.phoneState = this.phoneManager.phoneState;
        this.selectedEmployee = this.payLoad.selectedItem;
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    transferCall(phoneNumber, name, picture, transferType, employeeId = null, transferSession = false) {
        this.close(false, null);
        this.phoneManager.transferCall(phoneNumber, name, picture, transferType, employeeId, transferSession);
        if (transferType === false && this.applicationSettingManager.isEmployeeAutoLinkEnabled())
            this.sessionManager.addItemsToDetailViewCacheList(this.selectedEmployee, "EMPLOYEE", true);
    }
    close(result, targetButton = null, emailId = null) {
        let option = new Object();
        option.result = result;
        option.targetButton = targetButton;
        option.emailId = emailId;
        option.selectedEmployee = this.selectedEmployee;
        this.dialogRef.close(option);
    }
    getSelectedEmployeePhoneStatus(employeeId, Extension) {
        if (!this.phoneStatusInfo.IsPhoneStatusEnabled || this.phoneStatusInfo.Status == "waitIndicatorSpinner")
            return;
        this.phoneStatusInfo.Status = "waitIndicatorSpinner";
        this.phoneStatusInfo.Tooltip = "";
        this.phoneStatusInfo.ExtensionFontColor = "";
        const phonestatusDto = new PhoneStatusDto();
        phonestatusDto.EmployeeId = employeeId;
        phonestatusDto.Extension = Extension;
        let phoneStatusArray = [];
        phoneStatusArray.push(phonestatusDto);
        this.phoneService.clearPhoneStatusCallbacks();
        this.phoneService.fetchPhoneStatusRequest(phoneStatusArray);
        this.phoneService.setFetchPhoneStatusCallback(this.updateStatus);
    }
    updateStatus(result) {
        if (result != null) {
            this.phoneStatusInfo = this.phoneService.getPhoneStatusBasedOnResult(result.StatusList[0]);
        }
    }
    placeCall(phoneNumber, name, picture, id = null) {
        this.dialogRef.close();
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    loadSendEmailDialog(emailId) {
        this.close(false, "SEND_EMAIL", emailId);
    }
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
};
__decorate([
    ViewChild('statusDropdown')
], PopularNumberPanelComponent.prototype, "statusDropdown", void 0);
PopularNumberPanelComponent = __decorate([
    Component({
        selector: 'popularnumber-panel',
        templateUrl: './popularnumber-panel.component.html',
        styleUrls: ['./popularnumber-panel.component.scss']
    }),
    __param(2, Inject(MAT_DIALOG_DATA))
], PopularNumberPanelComponent);
export { PopularNumberPanelComponent };
//# sourceMappingURL=popularnumber-panel.component.js.map