var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, HostListener, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { KeyCode, OperationType } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { PhoneState } from '../../../../core/models/common/phone-state';
import { ContentType, TaskDtoSource } from '../../../../core/models/jkc-object/jkc-object';
import { PhoneStatusInfo } from '../../../../core/models/phone/phone-status-info';
import { PhoneStatusDto } from '../../../../core/models/phone/phone-statusDto';
import { GlobalFunctions } from '../../../../shared/global-functions';
let EmployeePanelComponent = class EmployeePanelComponent extends BaseDialogComponent {
    constructor(dialogRef, sessionManager, payLoad, applocationFeatureManager, phoneManager, applicationSettingManager, router, cacheManager, employeeService, phoneService, integrationSettingManager, removeNativeEmployeePipe, employeeSearchFilter, translateService, eventProvider, sortManager) {
        super();
        this.dialogRef = dialogRef;
        this.sessionManager = sessionManager;
        this.payLoad = payLoad;
        this.applocationFeatureManager = applocationFeatureManager;
        this.phoneManager = phoneManager;
        this.applicationSettingManager = applicationSettingManager;
        this.router = router;
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.phoneService = phoneService;
        this.integrationSettingManager = integrationSettingManager;
        this.removeNativeEmployeePipe = removeNativeEmployeePipe;
        this.employeeSearchFilter = employeeSearchFilter;
        this.translateService = translateService;
        this.eventProvider = eventProvider;
        this.sortManager = sortManager;
        this.showStatusDropDown = false;
        this.employees = [];
        this.selectedIndex = 0;
        this.filteredEmployeeList = [];
        this.BindedEmployees = [];
        this.selectedEmployee = null;
        this.phoneState = new PhoneState();
        this.availabilityStatusList = [];
        this.phoneStatusInfo = new PhoneStatusInfo();
        this.isAvailabilityCdrEnabled = false;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
        this.canAddAppointment = false;
        this.canAddCallbacknote = false;
        this.doubleClick = false;
        this.isParentPopup = true;
        this.timeoutIds = [];
        this.completedEmployeesFetchedData = this.completedEmployeesFetchedData.bind(this);
        this.setFilteredEmployeeByAvailabilityCompleted = this.setFilteredEmployeeByAvailabilityCompleted.bind(this);
        this.updateStatus = this.updateStatus.bind(this);
    }
    ngOnInit() {
        this.canAddAppointment = GlobalFunctions.hasRight(GlobalFunctions.toContentType('Task'), OperationType.Add, TaskDtoSource.Appointments);
        this.canAddCallbacknote = GlobalFunctions.hasRight(GlobalFunctions.toContentType('Task'), OperationType.Add, TaskDtoSource.CallbackNotes);
        this.phoneStatusInfo.IsPhoneStatusEnabled = this.applocationFeatureManager.isPhoneStatusEnabled;
        this.phoneState = this.phoneManager.phoneState;
        this.isAvailabilityCdrEnabled = this.applicationSettingManager.isAvailabilityCdrEnabled();
        this.init();
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    init() {
        try {
            this.getEmployees();
            //In case of Native Availability (Availability.CDR) is enabled
            if (this.isAvailabilityCdrEnabled)
                this.prepareAvailabilityStatusList();
            this.timeoutIds.push(setTimeout(() => $('#searchEmployeePanel').focus(), 300));
            if (this.phoneManager.phoneState.IsPhoneFeatureEnabled)
                this.phoneStatusInfo.ExtensionFontColor = 'blueFontColor';
            this.sessionManager.showUIOnTop = false;
        }
        catch (e) {
            console.error(e.message);
        }
    }
    toggleDropDown() {
        if (!this.showStatusDropDown)
            this.showStatusDropDown = true;
        else
            this.showStatusDropDown = false;
    }
    transferCall(phoneNumber, name, picture, transferType, employeeId = null, transferSession = false) {
        this.close(false, null);
        this.phoneManager.transferCall(phoneNumber, name, picture, transferType, employeeId, transferSession);
        if (transferType === false && this.applicationSettingManager.isEmployeeAutoLinkEnabled())
            this.sessionManager.addItemsToDetailViewCacheList(this.selectedEmployee, "EMPLOYEE", true);
    }
    close(result, targetButton = null, emailId = null) {
        let option = new Object();
        option.result = result;
        option.targetButton = targetButton;
        option.emailId = emailId;
        option.selectedEmployee = this.selectedEmployee;
        this.dialogRef.close(option);
        if (result != false && this.payLoad.isSearchSelected == false) {
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = this.selectedEmployee;
            this.sessionManager.selectedEntity.locationUrl = `/${RoutePath.DETAIL_PATH}/${EntityName.EMPLOYEE}`;
            this.sessionManager.addBreadcrumbItems([this.selectedEmployee], null, this.router.url);
            if (this.router.url === this.sessionManager.selectedEntity.locationUrl)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
            else
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
    }
    getEmployees() {
        this.startSpinner();
        this.cacheManager.getEmployeeDataList(this.completedEmployeesFetchedData);
    }
    scrollToSelectedItem() {
        if (this.selectedIndex >= 0) {
            try {
                let scrollIndex = $(this.selectedIndex + 1).offset;
                if (scrollIndex == undefined)
                    return;
                $(this.selectedIndex + 1).parent().parent().parent().scrollTop(scrollIndex.top - 90);
            }
            catch (e) {
                console.error(e.message);
            }
        }
    }
    loadEmployees() {
        if (!this.isEmployeesLoaded && this.employees != null && this.employees.length > 0) {
            const orderedList = this.employees.sort((a, b) => (a.Surname - b.Surname));
            this.employees = orderedList;
            this.employees = this.sortManager.sortEntityBasedOnApplicationSetting('EMPLOYEE', this.employees);
            this.filteredEmployeeList = orderedList;
            const firstSlot = this.employees.slice(0, 15);
            this.employeeService.setEmployeeAvailability(firstSlot);
            this.BindedEmployees = firstSlot;
            GlobalFunctions.remove_duplicates(this.BindedEmployees);
            this.selectedEmployee = orderedList[0];
            this.getSelectedEmployeePhoneStatus(this.selectedEmployee.Id, this.selectedEmployee.ExtensionNumber);
            this.stopSpinner();
            this.isEmployeesLoaded = true;
        }
    }
    getSelectedEmployeePhoneStatus(employeeId, Extension) {
        if (!this.phoneStatusInfo.IsPhoneStatusEnabled || this.phoneStatusInfo.Status == "waitIndicatorSpinner")
            return;
        this.phoneStatusInfo.Status = "waitIndicatorSpinner";
        this.phoneStatusInfo.Tooltip = "";
        this.phoneStatusInfo.ExtensionFontColor = "";
        const phonestatusDto = new PhoneStatusDto();
        phonestatusDto.EmployeeId = employeeId;
        phonestatusDto.Extension = Extension;
        let phoneStatusArray = [];
        phoneStatusArray.push(phonestatusDto);
        this.phoneService.clearPhoneStatusCallbacks();
        this.phoneService.fetchPhoneStatusRequest(phoneStatusArray);
        this.phoneService.setFetchPhoneStatusCallback(this.updateStatus);
    }
    updateStatus(result) {
        if (result != null) {
            this.phoneStatusInfo = this.phoneService.getPhoneStatusBasedOnResult(result.StatusList[0]);
        }
    }
    setFilteredEmployeeByAvailabilityCompleted(employees) {
        this.employees = employees;
        this.loadEmployees();
    }
    changeAvailabilityStatus(status) {
        this.showStatusDropDown = false;
        this.availabilityStatusIndex = status.key;
        if (this.availabilityStatusList.length > 0) {
            for (let i = 0; i < this.availabilityStatusList.length; i++) {
                if (this.availabilityStatusList[i].key == status.key) {
                    this.availabilityStatusColor = this.availabilityStatusList[i].color;
                    this.availabilityStatusText = this.availabilityStatusList[i].value;
                    break;
                }
            }
            this.selectedEmployee = null;
            this.BindedEmployees = [];
            this.isEmployeesLoaded = false;
            this.emptySearchText();
            let allEmployees = this.removeNativeEmployeePipe.transform(this.cacheManager.getEmployeeList(true));
            if (this.availabilityStatusIndex == '-1')
                this.setFilteredEmployeeByAvailabilityCompleted(allEmployees);
            else
                this.employeeService.getAllEmployeeWithAvailability(this.availabilityStatusIndex, "eq", this.setFilteredEmployeeByAvailabilityCompleted);
        }
    }
    prepareAvailabilityStatusList() {
        const availabilitySetting = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Employees_Entities_Employee, "EMPLOYEESAVAILABILITYTATUS");
        this.availabilityStatusList = this.employeeService.getAvailabilityStatusList(availabilitySetting);
        this.availabilityStatusColor = this.availabilityStatusList[0].color;
        this.availabilityStatusText = this.availabilityStatusList[0].value;
    }
    change(query) {
        this.startFilter(query);
    }
    startFilter(query) {
        let popularNumberList = this.cacheManager.getPopularEmployeeList();
        const filteredEmployee = this.employeeSearchFilter.transform(this.employees, query, popularNumberList);
        if (filteredEmployee.length > 0) {
            const sortedList = filteredEmployee.sort((a, b) => (a.Surname - b.Surname));
            this.filteredEmployeeList = sortedList;
            const firstSlot = this.filteredEmployeeList.slice(0, 15);
            this.employeeService.setEmployeeAvailability(firstSlot);
            this.BindedEmployees = firstSlot;
            this.getSelectedEmployeePhoneStatus(this.selectedEmployee?.Id, this.selectedEmployee?.ExtensionNumber);
        }
        else {
            this.selectedEmployee = null;
            this.BindedEmployees = null;
        }
        this.selectedIndex = 0;
        this.scrollToSelectedItem();
        this.select(filteredEmployee[0], false);
    }
    select(employee, loadInDetail) {
        this.selectedEmployee = employee;
        // set loadInDetail to false when opened from Component in case of Handler.
        if (!this.isParentPopup && loadInDetail) {
            if (!GlobalFunctions.isEmpty(this.searchText)) {
                loadInDetail = false;
                this.close(true, null);
            }
        }
        if (!GlobalFunctions.isEmpty(this.selectedEmployee?.IsPopular) && this.selectedEmployee?.IsPopular)
            return;
        this.getSelectedEmployeePhoneStatus(this.selectedEmployee?.Id, this.selectedEmployee?.ExtensionNumber);
        if (!GlobalFunctions.isEmpty(this.searchText)) {
            if (this.searchText.trim().length > 2 && loadInDetail) {
                this.filteredEmployeeList.forEach((resultObject) => resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.EMPLOYEE}`);
                this.sessionManager.addBreadcrumbItems(this.filteredEmployeeList, null, `/${RoutePath.LIST_PATH}/${EntityName.EMPLOYEE}`);
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.EMPLOYEE]);
            }
        }
        if (loadInDetail)
            this.close(true, null);
        else
            $('#searchEmployeePanel').focus();
    }
    itemClicked($index) {
        this.checkDoubleClick($index);
        this.selectedIndex = $index;
    }
    checkDoubleClick($index) {
        if (this.doubleClick) {
            if (this.selectedIndex == $index)
                this.select(this.BindedEmployees[this.selectedIndex], true);
        }
        else {
            this.doubleClick = true;
            this.timeoutIds.push(setTimeout(() => { this.doubleClick = false; }, 300));
        }
    }
    navigate($event) {
        if ($event && this.BindedEmployees?.length > 0) {
            let nextIndex = 0;
            switch ($event.key.toLocaleLowerCase()) {
                case KeyCode.Arrowdown:
                    {
                        nextIndex = this.selectedIndex + 1;
                        if (nextIndex != this.BindedEmployees.length)
                            this.navigateRecord(nextIndex);
                        break;
                    }
                case KeyCode.ArrowUp:
                    {
                        nextIndex = this.selectedIndex - 1;
                        if (nextIndex != -1)
                            this.navigateRecord(nextIndex);
                        break;
                    }
                case KeyCode.Enter:
                    {
                        this.select(this.BindedEmployees[this.selectedIndex], true);
                        break;
                    }
            }
        }
    }
    navigateRecord(nextIndex) {
        this.selectedIndex = nextIndex;
        this.select(this.BindedEmployees[this.selectedIndex], false);
        this.scrollToSelectedItem();
    }
    clearEmployeeValue() {
        this.emptySearchText();
        this.startFilter('');
    }
    emptySearchText() {
        this.searchText = '';
        this.timeoutIds.push(setTimeout(() => $('#searchEmployeePanel').focus(), 5));
    }
    openCreateTask(taskType) {
        this.sessionManager.loadedFromRelatedView = false;
        this.sessionManager.selectedEntity = this.selectedEmployee;
        if (taskType == 'callbacknote')
            this.close(false, "ADD_CALLBACKNOTE");
        else
            this.close(false, "ADD_APPOINTMENT");
    }
    completedEmployeesFetchedData() {
        this.employees = this.removeNativeEmployeePipe.transform(this.cacheManager.getEmployeeList(true));
        if (this.payLoad.isSearchSelected === false) {
            let popularEmployeeList = this.cacheManager.getPopularEmployeeList();
            if (!GlobalFunctions.isEmpty(popularEmployeeList) && popularEmployeeList.length > 0)
                this.employees = this.employees.concat(popularEmployeeList);
        }
        this.loadEmployees();
    }
    getSelectOrMoreText() {
        return this.payLoad.isSearchSelected ? this.translateService.instant('LBL_SELECT') : this.translateService.instant('LBL_MORE');
    }
    placeCall(phoneNumber, name, picture, id = null) {
        this.dialogRef.close();
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    loadSendEmailDialog(emailId) {
        this.close(false, "SEND_EMAIL", emailId);
    }
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
    loadMore() {
        let currentEmployeeList;
        if (GlobalFunctions.isEmpty(this.searchText))
            currentEmployeeList = this.employees;
        else
            currentEmployeeList = this.filteredEmployeeList;
        if (this.BindedEmployees.length < currentEmployeeList.length) {
            let last = this.BindedEmployees.length - 1;
            let nextSlotSize = last + 15;
            if (nextSlotSize > currentEmployeeList.length)
                nextSlotSize = currentEmployeeList.length;
            let nextSlot = currentEmployeeList.slice(last, nextSlotSize);
            this.employeeService.setEmployeeAvailability(nextSlot);
            this.BindedEmployees = this.BindedEmployees.concat(nextSlot);
            GlobalFunctions.remove_duplicates(this.BindedEmployees);
        }
        else {
            console.log("reached limit");
        }
    }
    clickOutsideEvent(event) {
        if (this.statusDropdown?.nativeElement.contains(event.target))
            this.showStatusDropDown = true;
        else
            this.showStatusDropDown = false;
    }
};
__decorate([
    ViewChild('statusDropdown')
], EmployeePanelComponent.prototype, "statusDropdown", void 0);
__decorate([
    HostListener('window:scroll', ['$event'])
], EmployeePanelComponent.prototype, "loadMore", null);
__decorate([
    HostListener('document:click', ['$event'])
], EmployeePanelComponent.prototype, "clickOutsideEvent", null);
EmployeePanelComponent = __decorate([
    Component({
        selector: 'employee-panel',
        templateUrl: './employee-panel.component.html',
        styleUrls: ['./employee-panel.component.scss']
    }),
    __param(2, Inject(MAT_DIALOG_DATA))
], EmployeePanelComponent);
export { EmployeePanelComponent };
//# sourceMappingURL=employee-panel.component.js.map