var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from "@angular/core";
import { cloneDeep } from "lodash";
import { SubSink } from "subsink";
import { PhoneState } from "../../../core/models/common/phone-state";
import { PhoneStatusInfo } from "../../../core/models/phone/phone-status-info";
import { PhoneStatusDto } from "../../../core/models/phone/phone-statusDto";
import { BroadCastEventKeys } from "../../../shared/constants";
import { GlobalFunctions } from "../../../shared/global-functions";
import { BooleanHelper } from "../../../shared/helper/boolean-helper";
import { BaseDialogComponent } from "../../common/base-dialog.component";
let EmployeeCalendarComponent = class EmployeeCalendarComponent extends BaseDialogComponent {
    constructor(phoneManager, phoneService, dialogManager, eventProvider, sessionManager, employeeService, translateService, userSettingManager, systemComponentService, availibilityRuleService) {
        super();
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.availibilityRuleService = availibilityRuleService;
        this.dateJS = Date;
        this.calendarWeekView = BooleanHelper.stringToBoolean(this.userSettingManager.getUserSettingValueByKey("CalendarWeekView"));
        this.calendarContentHeight = 500;
        this.calendarOptions = {
            allDayText: this.translateService.instant("LBL_ALL_DAY"),
            allDaySlot: false,
            contentHeight: this.calendarContentHeight,
            dayHeaders: this.calendarWeekView,
            dayHeaderFormat: 'D/M dddd',
            headerToolbar: false,
            initialView: this.calendarWeekView ? 'timeGridWeek' : 'timeGridDay',
            locale: this.translateService.currentLang,
            plugins: GlobalFunctions.getFullCalendarPlugins(),
            scrollTime: new this.dateJS().toString('HH:mm:ss'),
            slotDuration: '00:15:00',
            slotEventOverlap: false,
            slotLabelFormat: 'HH:mm',
            timeZone: 'local',
            weekends: !this.calendarWeekView
        };
        this.loadingCalendar = false;
        this.employeeId = '';
        this.agendaItems = [];
        this.currentDate = new Date();
        this.enableWorkweek = false;
        this.phoneState = new PhoneState();
        this.phoneStatusInfo = new PhoneStatusInfo();
        this.timeoutIds = [];
        this.subs = new SubSink();
        this._currentAvailability = [];
        this.searchAgendaFound = this.searchAgendaFound.bind(this);
        this.updatePhoneStatus = this.updatePhoneStatus.bind(this);
        this.completedAvailabilityFetchByKey = this.completedAvailabilityFetchByKey.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RESIZE_CSN).subscribe(() => this.timeoutIds.push(setTimeout(() => this.refreshCalendar())));
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TOGGLE_VIEWER_PANEL).subscribe(() => this.timeoutIds.push(setTimeout(() => this.refreshCalendar())));
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TOGGLE_SUGGESTION_PANEL).subscribe(() => this.timeoutIds.push(setTimeout(() => this.refreshCalendar())));
    }
    get currentAvailability() {
        return this._currentAvailability;
    }
    set currentAvailability(currentAvailability) {
        this._currentAvailability = currentAvailability;
        this.refreshCalendar();
    }
    ;
    ngOnInit(selectedEntity) {
        try {
            this.employeeId = selectedEntity.Id;
            this.initCalendarWeekViewCheckBox();
            this.employeeService.setEmployeePicture([selectedEntity]);
            this.timeoutIds.push(setTimeout(() => this.refreshCalendar(false)));
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    initCalendarWeekViewCheckBox() {
        this.enableWorkweek = this.calendarWeekView;
        this.initCalendar();
    }
    ;
    initCalendar(requestedNextDay = null) {
        this.loadingCalendar = true;
        if (requestedNextDay != null) {
            if (requestedNextDay) {
                if (this.enableWorkweek)
                    this.currentDate.setDate(this.currentDate.getDate() + 7);
                else
                    this.currentDate.setDate(this.currentDate.getDate() + 1);
            }
            else {
                if (this.enableWorkweek)
                    this.currentDate.setDate(this.currentDate.getDate() - 7);
                else
                    this.currentDate.setDate(this.currentDate.getDate() - 1);
            }
        }
        if (this.enableWorkweek) {
            let mondayDate = cloneDeep(this.currentDate);
            let fridayDate = cloneDeep(this.currentDate);
            mondayDate.last().monday();
            if (!fridayDate.is().friday())
                fridayDate.next().friday();
            this.employeeService.searchAgenda([this.employeeId], mondayDate, fridayDate, this.searchAgendaFound);
        }
        else
            this.employeeService.searchAgenda([this.employeeId], this.currentDate, null, this.searchAgendaFound);
        GlobalFunctions.updateCalendarWeekView(this.enableWorkweek, this.userSettingManager, this.systemComponentService);
    }
    ;
    refreshCalendar(stopSpinner = true) {
        if (!this.enableWorkweek)
            GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridDay', this.agendaItems, this.currentDate, this.currentAvailability, this.calendarContentHeight, this.translateService, null, null, 15, true);
        else
            GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridWeek', this.agendaItems, this.currentDate, this.currentAvailability, this.calendarContentHeight, this.translateService, null, false, 15, true);
        if (stopSpinner)
            this.loadingCalendar = false;
    }
    searchAgendaFound(result) {
        console.log('Employee->searchAgendaFound:', result);
        if (result?.length > 0 && result[0].AvailabilityCollection?.length > 0) {
            this.agendaItems = result[0].AvailabilityCollection[0].AgendaItems;
            this.currentAvailability = result[0].AvailabilityCollection[0].Availability;
        }
    }
    getSelectedEmployeePhoneStatus(employeeId, Extension) {
        if (!this.phoneStatusInfo.IsPhoneStatusEnabled || this.phoneStatusInfo.Status == "waitIndicatorSpinner")
            return;
        this.phoneStatusInfo.Status = "waitIndicatorSpinner";
        this.phoneStatusInfo.Tooltip = "";
        this.phoneStatusInfo.ExtensionFontColor = "";
        let phonestatusDto = new PhoneStatusDto();
        phonestatusDto.EmployeeId = employeeId;
        phonestatusDto.Extension = Extension;
        let phoneStatusArray = [];
        phoneStatusArray.push(phonestatusDto);
        this.phoneService.clearPhoneStatusCallbacks();
        this.phoneService.fetchPhoneStatusRequest(phoneStatusArray);
        this.phoneService.setFetchPhoneStatusCallback(this.updatePhoneStatus);
    }
    updatePhoneStatus(result) {
        if (result)
            this.phoneStatusInfo = this.phoneService.getPhoneStatusBasedOnResult(result.StatusList[0]);
    }
    completedAvailabilityFetchByKey(valueData) {
        if (valueData && valueData.length > 0)
            this.sessionManager.selectedEntity.AvailabilityStatusInfo = this.availibilityRuleService.getAvailabilityStatusInfo(valueData);
    }
    placeCall(phoneNumber, name, picture, id = null) {
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    loadSendEmailDialog(emailId) {
        GlobalFunctions.loadSendEmailDialog(emailId, this.dialogManager);
    }
};
__decorate([
    ViewChild('calendar')
], EmployeeCalendarComponent.prototype, "calendar", void 0);
EmployeeCalendarComponent = __decorate([
    Component({
        selector: 'base-calendar',
        template: '<span></span>'
    })
], EmployeeCalendarComponent);
export { EmployeeCalendarComponent };
//# sourceMappingURL=employee-calendar-component.js.map