var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { EmployeeCalendarComponent } from 'src/app/components/domain/employee/employee-calendar-component';
import { ContextMenuView, OperationType } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
let EmployeeDetailComponent = class EmployeeDetailComponent extends EmployeeCalendarComponent {
    constructor(translateService, dialogManager, phoneManager, phoneService, applicationFeatureManager, availabilityService, availibilityRuleService, applicationSettingManager, cacheManager, sessionManager, employeeService, userSettingManager, systemComponentService, eventProvider, contextMenuService, integrationSettingManager) {
        super(phoneManager, phoneService, dialogManager, eventProvider, sessionManager, employeeService, translateService, userSettingManager, systemComponentService, availibilityRuleService);
        this.translateService = translateService;
        this.dialogManager = dialogManager;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.availabilityService = availabilityService;
        this.availibilityRuleService = availibilityRuleService;
        this.applicationSettingManager = applicationSettingManager;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.eventProvider = eventProvider;
        this.contextMenuService = contextMenuService;
        this.integrationSettingManager = integrationSettingManager;
        this.addMenuItem = new EventEmitter();
        this.sendRelatedRequest = new EventEmitter();
        this.isAvailabilityCdrEnabled = false;
        this.isExtraInfoEnabled = false;
        this.menu = new Menu();
        this.employeePrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.sessionManager.contextMenu = null;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        try {
            this.phoneState = this.phoneManager.phoneState;
            this.isAvailabilityCdrEnabled = this.applicationSettingManager.isAvailabilityCdrEnabled();
            this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.contextMenuService.loadActionButton(detailEntityType);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial)
                this.sessionManager.selectedEntity = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.Id);
            this.sendRelatedRequest.emit();
            this.menu.addOrUpdateMenuItem(0, "EmployeeDetail", this.translateService.instant("LBL_EMPLOYEE"), false, true);
            this.addMenuItem.emit(this.menu);
            if (this.sessionManager?.selectedEntity?.EmailAddress)
                this.availabilityService.getAvailabilityByKey(this.sessionManager.selectedEntity.EmailAddress.toLowerCase(), this.completedAvailabilityFetchByKey);
            if (this.phoneManager.phoneState.IsPhoneFeatureEnabled)
                this.phoneStatusInfo.ExtensionFontColor = 'blueFontColor';
            if (this.applicationFeatureManager.isPhoneStatusEnabled) {
                this.phoneStatusInfo.IsPhoneStatusEnabled = this.applicationFeatureManager.isPhoneStatusEnabled;
                this.getSelectedEmployeePhoneStatus(this.sessionManager.selectedEntity.Id, this.sessionManager.selectedEntity.ExtensionNumber);
            }
            super.ngOnInit(this.sessionManager.selectedEntity);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    transferCall(phoneNumber, name, picture, transferType, employeeId = null, transferSession = false) {
        this.phoneManager.transferCall(phoneNumber, name, picture, transferType, employeeId, transferSession);
    }
    ;
};
__decorate([
    Input()
], EmployeeDetailComponent.prototype, "relatedFor", void 0);
__decorate([
    Input()
], EmployeeDetailComponent.prototype, "isNormalSizeDetailView", void 0);
__decorate([
    Output()
], EmployeeDetailComponent.prototype, "addMenuItem", void 0);
__decorate([
    Output()
], EmployeeDetailComponent.prototype, "sendRelatedRequest", void 0);
EmployeeDetailComponent = __decorate([
    Component({
        selector: 'employee-detail',
        templateUrl: './employee-detail.component.html',
        styleUrls: ['./employee-detail.component.scss']
    })
], EmployeeDetailComponent);
export { EmployeeDetailComponent };
//# sourceMappingURL=employee-detail.component.js.map