var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { EntityName, RoutePath } from 'src/app/shared/constants';
import { BaseDialogComponent } from '../../../../components/common/base-dialog.component';
import { MessageboxComponent } from '../../../../components/common/messagebox/messagebox.component';
import { OperationType } from '../../../../core/enums/common-enums';
import { EmployeeSkillsDto } from '../../../../core/models/employee/employee-skillsDto';
import { UpdateEmployeeRequest } from '../../../../core/models/employee/update-employee-request';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
let EmployeeAddEditComponent = class EmployeeAddEditComponent extends BaseDialogComponent {
    constructor(sessionManager, translateService, cacheManager, router, dialog, dialogManager, employeeService) {
        super();
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.cacheManager = cacheManager;
        this.router = router;
        this.dialog = dialog;
        this.dialogManager = dialogManager;
        this.employeeService = employeeService;
        this.employeeSkills = new Array();
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        this.isExtraInfoEnabled = GlobalFunctions.hasRight(GlobalFunctions.toContentType("EMPLOYEE"), OperationType.CanViewEmployeeExtraInfo);
        this.title = '';
        this.timeoutIds = [];
        this.updateEmployeeResponse = (response) => {
            this.stopSpinner();
            if (response != null && response.Result === 0 && response.EmployeeDto != null) {
                this.loadUpdatedEmployeeInDetail(response.EmployeeDto);
                this.cacheManager.updateEmployee(response.EmployeeDto);
                this.close(false);
            }
            else {
                const messageInfo = DialogHelper.getMessage(this.translateService.instant('LBL_EMPLOYEE'), this.translateService.instant('LBL_MESSAGE_FAIL_SAVE_EMPLOYEEDETAILS'), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
            }
        };
        this.updateEmployeeErrorCallback = this.updateEmployeeErrorCallback.bind(this);
        this.updateEmployeeResponse = this.updateEmployeeResponse.bind(this);
    }
    ;
    ngOnInit() {
        this.init();
    }
    ;
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ;
    init() {
        try {
            this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_EMPLOYEE").toUpperCase();
            this.timeoutIds.push(setTimeout(() => { this.resize(); }, 300));
            this.loadEmployeeDetails();
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    loadEmployeeDetails() {
        this.employeeDto = jQuery.extend(true, {}, this.sessionManager.selectedEntity);
        if (this.sessionManager.selectedEntity != null) {
            this.employeeDto.Note = this.sessionManager.selectedEntity.Note;
            this.employeeDto.WorkingHours = this.sessionManager.selectedEntity.WorkingHours;
            this.employeeDto.ExtraInfo = this.sessionManager.selectedEntity.ExtraInfo;
            let employeeSkillsString = "";
            if (this.sessionManager.selectedEntity.Skills != null && this.sessionManager.selectedEntity.Skills.length > 0) {
                for (let index = 0; index < this.sessionManager.selectedEntity.Skills.length; index++) {
                    if (this.sessionManager.selectedEntity.Skills[index] !== '') {
                        employeeSkillsString += this.sessionManager.selectedEntity.Skills[index].Name + "\n";
                    }
                }
            }
            this.employeeDto.SkillsString = employeeSkillsString;
        }
    }
    ;
    updateEmployeeDetails() {
        this.startSpinner();
        this.employeeSkill();
        this.sendUpdateEmployeeRequest();
    }
    ;
    employeeSkill() {
        const empSkill = this.employeeDto.SkillsString.split("\n");
        if (empSkill != null && empSkill.length > 0) {
            for (let index = 0; index < empSkill.length; index++) {
                if (empSkill[index] !== '') {
                    let emp = new EmployeeSkillsDto();
                    emp.EmployeeId = this.employeeDto.Id;
                    emp.Name = empSkill[index];
                    emp.Description = emp.Name;
                    this.employeeSkills.push(emp);
                }
            }
        }
    }
    ;
    sendUpdateEmployeeRequest() {
        let req = new UpdateEmployeeRequest();
        req.EmployeeDto = this.employeeDto;
        req.EmployeeDto.Skills = this.employeeSkills;
        req.EmployeeDto.SkillsJson = JSON.stringify(this.employeeSkills);
        this.employeeService.updateEmployeeRequest(req, this.updateEmployeeResponse, this.updateEmployeeErrorCallback);
    }
    ;
    loadUpdatedEmployeeInDetail(newEmployeeDto) {
        if (!GlobalFunctions.isEmpty(newEmployeeDto)) {
            this.sessionManager.selectedEntity = newEmployeeDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.EMPLOYEE}`;
            this.sessionManager.addBreadcrumbItems([newEmployeeDto], null, this.router.url);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
    }
    ;
    updateEmployeeErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_EMPLOYEE")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_EMPLOYEE"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    resize() {
        const windowHeight = window.innerHeight;
        $("#jkcParentPanel").css({ 'max-height': this.sessionManager.jkcParentPanel.parameters.HeightValue });
        const newHeight = $("#jkcParentPanel").height() - $("#createEmployeeHeader").height() - $("#createEmployeeFooter").height() + "px";
        $("#updateEmployeeContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    ;
    close(result) {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
};
EmployeeAddEditComponent = __decorate([
    Component({
        selector: 'employee-add-edit',
        templateUrl: './employee-add-edit.component.html',
        styleUrls: ['./employee-add-edit.component.scss'],
        host: { '(window:resize)': 'resize();' }
    })
], EmployeeAddEditComponent);
export { EmployeeAddEditComponent };
//# sourceMappingURL=employee-add-edit.component.js.map